/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Sql;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XtraServerConfig {
    private Document document = null;
    private Element root = null;
    private ShapeChangeResult result = null;
    private PackageInfo pi = null;
    private int target = 3;
    private boolean printed = false;
    private Element database = null;
    private Element srslist = null;
    private Element featuretypes = null;

    public XtraServerConfig(PackageInfo p, ShapeChangeResult r, int t) throws ShapeChangeAbortException {
        this.pi = p;
        this.result = r;
        this.target = t;
        this.document = this.createDocument();
        this.root = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Configuration");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns", "http://www.interactive-instruments.de/namespaces/XtraServer");
        this.addAttribute(this.document, this.root, "xmlns:gml", "http://www.opengis.net/gml/3.2");
        this.addAttribute(this.document, this.root, "xmlns:gml31", "http://www.opengis.net/gml");
        this.addAttribute(this.document, this.root, "xmlns:ogc", "http://www.opengis.net/ogc");
        this.addAttribute(this.document, this.root, "xmlns:sld", "http://www.opengis.net/sld");
        this.addAttribute(this.document, this.root, "xmlns:wfs", "http://www.opengis.net/wfs");
        this.addAttribute(this.document, this.root, "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.document, this.root, "xmlns:" + this.pi.xmlns(), this.pi.targetNamespace());
        this.addAttribute(this.document, this.root, "xmlns:gco", "http://www.isotc211.org/2005/gco");
        this.addAttribute(this.document, this.root, "xmlns:gmd", "http://www.isotc211.org/2005/gmd");
        this.addAttribute(this.document, this.root, "xmlns:wfsadv", "http://www.adv-online.de/namespaces/adv/gid/wfs");
        this.addAttribute(this.document, this.root, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.addAttribute(this.document, this.root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addAttribute(this.document, this.root, "xsi:schemaLocation", "http://www.interactive-instruments.de/namespaces/XtraServer ./XtraSrvConfig.xsd");
        this.addAttribute(this.document, this.root, "version", "0.4");
        String s = "XtraServer mapping for application schema '" + this.pi.name() + "' created by ShapeChange";
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Name");
        e1.appendChild(this.document.createTextNode(s));
        this.root.appendChild(e1);
        this.database = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Database");
        this.root.appendChild(this.database);
        this.addAttribute(this.document, this.database, "id", this.pi.xmlns());
        s = this.target == 2 ? "OraSDatabase" : (this.target == 3 ? "PGISDatabase" : "FIXME");
        this.addAttribute(this.document, this.database, "type", s);
        Element e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Name");
        e2.appendChild(this.document.createTextNode("Database for application schema '" + this.pi.name() + "'"));
        this.database.appendChild(e2);
        s = this.target == 2 ? "OraSDataImpl" : (this.target == 3 ? "PGISDataImpl" : "FIXME");
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", s);
        this.database.appendChild(e2);
        Element e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "ConnectDatabase");
        this.addAttribute(this.document, e3, "hostaddr", "192.168.231.165");
        this.addAttribute(this.document, e3, "port", "5432");
        this.addAttribute(this.document, e3, "dbname", "aaawfs02");
        this.addAttribute(this.document, e3, "userName", "aaawfs02");
        this.addAttribute(this.document, e3, "password", "aaawfs02");
        this.addAttribute(this.document, e3, "minConnect", "1");
        this.addAttribute(this.document, e3, "maxConnect", "50");
        this.addAttribute(this.document, e3, "initialStatement", "SET TIMEZONE TO UTC");
        e2.appendChild(e3);
        Element e4 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlGenerationSchemaFiles");
        this.addAttribute(this.document, e4, "featureTypeGeneration", "only");
        e2.appendChild(e4);
        Element e5 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Files");
        this.addAttribute(this.document, e5, "gmlVersion", "3.2.1");
        e4.appendChild(e5);
        Element e6 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlApplicationSchemaFile");
        this.addAttribute(this.document, e6, "strictSchemaValidation", "false");
        e6.appendChild(this.document.createTextNode("D:\\XtraServer\\Projekte\\LGN-AAA-WFS\\schema\\NAS\\6.0\\schema\\aaa.xsd"));
        e5.appendChild(e6);
        e6 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlSchema");
        e5.appendChild(e6);
        Element e7 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "File");
        this.addAttribute(this.document, e7, "strictSchemaValidation", "false");
        e7.appendChild(this.document.createTextNode("D:\\XtraServer\\Projekte\\LGN-AAA-WFS\\schema\\NAS\\6.0\\schema\\gml\\3.2.1\\gml.xsd"));
        e6.appendChild(e7);
        e5 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Files");
        this.addAttribute(this.document, e5, "gmlVersion", "3.1.1");
        e4.appendChild(e5);
        e6 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlApplicationSchemaFile");
        this.addAttribute(this.document, e6, "mappedToGmlVersion", "3.2.1");
        e5.appendChild(e6);
        e6 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlSchema");
        e5.appendChild(e6);
        e7 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "File");
        this.addAttribute(this.document, e7, "strictSchemaValidation", "false");
        e7.appendChild(this.document.createTextNode("http://www.interactive-instruments.de/schema/ogc/gml/3.1.1/base/gml.xsd"));
        e6.appendChild(e7);
        e5 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Files");
        this.addAttribute(this.document, e5, "gmlVersion", "2.1.2");
        e4.appendChild(e5);
        e6 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlApplicationSchemaFile");
        this.addAttribute(this.document, e6, "mappedToGmlVersion", "3.2.1");
        e5.appendChild(e6);
        e6 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GmlSchema");
        e5.appendChild(e6);
        e7 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "File");
        this.addAttribute(this.document, e7, "strictSchemaValidation", "false");
        e7.appendChild(this.document.createTextNode("http://www.interactive-instruments.de/schema/ogc/gml/2.1.2/feature.xsd"));
        e6.appendChild(e7);
        e4 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "DatabaseNamespaces");
        e2.appendChild(e4);
        e4 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GeometryExtent");
        e2.appendChild(e4);
        e5 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "NativeSRS");
        this.addAttribute(this.document, e5, "interpolationTolerance", "0.005");
        this.addAttribute(this.document, e5, "scaleFactor", "1");
        this.addAttribute(this.document, e5, "axisOrder", "EN");
        e5.appendChild(this.document.createTextNode("EPSG:25832"));
        e4.appendChild(e5);
        e5 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "BoundingBox");
        this.addAttribute(this.document, e5, "xmin", "338000.0");
        this.addAttribute(this.document, e5, "xmax", "682000.0");
        this.addAttribute(this.document, e5, "ymin", "5675000.0");
        this.addAttribute(this.document, e5, "ymax", "5990000.0");
        e4.appendChild(e5);
        this.srslist = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "SRSList");
        this.addAttribute(this.document, this.srslist, "id", "srslist");
        this.root.appendChild(this.srslist);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "EPSGCode");
        e2.appendChild(this.document.createTextNode("25832"));
        this.srslist.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "EPSGCode");
        e2.appendChild(this.document.createTextNode("4258"));
        this.srslist.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "EPSGCode");
        e2.appendChild(this.document.createTextNode("4326"));
        this.srslist.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "EPSGCode");
        e2.appendChild(this.document.createTextNode("31466"));
        this.srslist.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "EPSGCode");
        e2.appendChild(this.document.createTextNode("31467"));
        this.srslist.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "EPSGCode");
        e2.appendChild(this.document.createTextNode("31468"));
        this.srslist.appendChild(e2);
        e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Service");
        this.addAttribute(this.document, e1, "type", "Service_WFSTR");
        this.addAttribute(this.document, e1, "id", "wfs");
        this.addAttribute(this.document, e1, "postRequestLogging", "false");
        this.root.appendChild(e1);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Name");
        e2.appendChild(this.document.createTextNode("XtraServer AAA-WFS (GeoInfoDok 6.0.0)"));
        e1.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "OnlineResource");
        e2.appendChild(this.document.createTextNode("http://services.interactive-instruments.de/epimeteus/cgi-bin/adv-wfs.exe"));
        e1.appendChild(e2);
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Service_WFSTR");
        e1.appendChild(e2);
        e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "DatabaseRef");
        this.addAttribute(this.document, e3, "idref", this.pi.xmlns());
        e2.appendChild(e3);
        e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Capabilities");
        String c = "<Title>XtraServer Transactional Web Feature Service for access to AAA data in the NAS application schema.</Title>\r\n<Abstract>XtraServer is an OGC/WFS by interactive instruments, Germany.</Abstract>\r\n<Keyword>AAA</Keyword>\r\n<Keyword>AFIS ALKIS ATKIS</Keyword>\r\n<AccessConstraints>LGN</AccessConstraints>\r\n<ProviderName>interactive instruments GmbH</ProviderName>\r\n<ServiceContact>\r\n\t<Name>Clemens Portele</Name>\r\n\t<Position>Managing Director</Position>\r\n\t<Phone>+49 228 9141073</Phone>\r\n\t<FacSimile>+49 228 9141090</FacSimile>\r\n\t<City>Bonn</City>\r\n\t<AdministrativeArea>NRW</AdministrativeArea>\r\n\t<PostalCode>53115</PostalCode>\r\n\t<Country>Germany</Country>\r\n\t<ElectronicMailAddress>portele@interactive-instruments.de</ElectronicMailAddress>\r\n\t<OnlineResource>http://www.interactive-instruments.de/</OnlineResource>\r\n\t<HoursOfService>0900 - 1800 GMT+1, Mon thru Fri</HoursOfService>\r\n</ServiceContact>\r\n<SRSIndicationFormat>\r\n\t<Urn/>\r\n</SRSIndicationFormat>";
        Comment ec = this.document.createComment(c);
        e3.appendChild(ec);
        e2.appendChild(e3);
        e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GetFeature");
        e2.appendChild(e3);
        e4 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "OutputViaTempFile");
        e4.appendChild(this.document.createTextNode("true"));
        e3.appendChild(e4);
        e4 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "XmlTagsInTempFile");
        e4.appendChild(this.document.createTextNode("true"));
        e3.appendChild(e4);
        this.featuretypes = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "FeatureTypes");
        e2.appendChild(this.featuretypes);
        e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "GMLFormattingOptions");
        c = "<Encoding>ISO-8859-1</Encoding>\r\n<Specific gmlVersion='3.2.1'>\r\n<ApplicationSchemaLocation>http://services.interactive-instruments.de/aaa-wfs/schema/NAS/6.0/schema/AAA-Fachschema.xsd</ApplicationSchemaLocation>\r\n<GmlSchemaLocation>http://schemas.opengis.net/gml/3.2.1/gml.xsd</GmlSchemaLocation>\r\n<XLinkSchemaLocation>http://schemas.opengis.net/xlink/1.0.0/xlinks.xsd</XLinkSchemaLocation>\r\n<AdditionalSchema namespace='http://www.opengis.net/wfs'>http://schemas.opengis.net/wfs/1.1.0/wfs.xsd</AdditionalSchema>\r\n<AdditionalSchema namespace='http://www.opengis.net/gml/3.2'>http://schemas.opengis.net/gml/3.2.1/gml.xsd</AdditionalSchema>\r\n<NameOfCollection>gml:FeatureCollection</NameOfCollection>\r\n<NameOfMember>gml:featureMember</NameOfMember>\r\n</Specific>\r\n<Specific gmlVersion='3.1.1'>\r\n<GmlSchemaLocation>http://schemas.opengis.net/gml/3.1.1/base/gml.xsd</GmlSchemaLocation>\r\n<XLinkSchemaLocation>http://schemas.opengis.net/xlink/1.0.0/xlinks.xsd</XLinkSchemaLocation>\r\n<NameOfCollection>gmlx:FeatureCollection</NameOfCollection>\r\n<NameOfMember>gml31:featureMember</NameOfMember>\r\n</Specific>\r\n<IdentifierPattern>$oid$</IdentifierPattern>\r\n<UrnNamespaceForHrefs>\r\n<DefaultUrnNamespace>urn:adv:oid</DefaultUrnNamespace>\r\n</UrnNamespaceForHrefs>\r\n<GenerateLocalHrefs>false</GenerateLocalHrefs>\r\n<ShowDimensionForSRSNames>true</ShowDimensionForSRSNames>\r\n<CoordinatePrecision srsName='urn:ogc:def:crs:EPSG::25832'>3</CoordinatePrecision>\r\n<CoordinatePrecision srsName='urn:ogc:def:crs:EPSG::4258'>12</CoordinatePrecision>\r\n<CoordinatePrecision srsName='urn:ogc:def:crs:EPSG::4326'>12</CoordinatePrecision>\r\n<CoordinatePrecision srsName='urn:ogc:def:crs:EPSG::31466'>3</CoordinatePrecision>\r\n<CoordinatePrecision srsName='urn:ogc:def:crs:EPSG::31467'>3</CoordinatePrecision>\r\n<DefaultNamespace>http://www.adv-online.de/namespaces/adv/gid/6.0</DefaultNamespace>";
        ec = this.document.createComment(c);
        e3.appendChild(ec);
        e2.appendChild(e3);
        e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "WfsSchemaLocation");
        this.addAttribute(this.document, e3, "version", "1.0.0");
        e3.appendChild(this.document.createTextNode("http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd"));
        e2.appendChild(e3);
        e3 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "WfsSchemaLocation");
        this.addAttribute(this.document, e3, "version", "1.1.0");
        e3.appendChild(this.document.createTextNode("http://schemas.opengis.net/wfs/1.1.0/wfs.xsd"));
        e2.appendChild(e3);
    }

    protected Element addFeatureType(ClassInfo ci) {
        Element ex = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "FeatureType");
        this.addAttribute(this.document, ex, "supportedSRSs", "srslist");
        this.addAttribute(this.document, ex, "defaultSRS", "EPSG:25832");
        Element ex2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Name");
        ex2.appendChild(this.document.createTextNode(ci.qname()));
        ex.appendChild(ex2);
        this.featuretypes.appendChild(ex);
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "FeatureType");
        this.database.appendChild(e1);
        Element e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Name");
        e1.appendChild(e2);
        e2.appendChild(this.document.createTextNode(ci.qname()));
        String s = "FIXME";
        if (this.target == 2) {
            s = "OraSFeatureTypeImpl";
        } else if (this.target == 3) {
            s = "PGISFeatureTypeImpl";
        }
        e2 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", s);
        e1.appendChild(e2);
        this.addAttribute(this.document, e2, "logging", "false");
        this.addAttribute(this.document, e2, "useTempTable", "false");
        return e2;
    }

    protected void addOidColProperty(Element ft, String name, String target, String col) {
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Table");
        ft.appendChild(e1);
        this.addAttribute(this.document, e1, "table_name", name);
        this.addAttribute(this.document, e1, "target", target);
        this.addAttribute(this.document, e1, "oid_col", col);
    }

    protected void addOidColFeature(Element ft, String name, String col) {
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Table");
        ft.appendChild(e1);
        this.addAttribute(this.document, e1, "table_name", name);
        this.addAttribute(this.document, e1, "target", "");
        this.addAttribute(this.document, e1, "oid_col", String.valueOf(col) + ":=SEQUENCE(xsv_gen_oid)");
    }

    protected void addValCol(Element ft, String name, String val, String target, String atts) {
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Table");
        ft.appendChild(e1);
        this.addAttribute(this.document, e1, "table_name", name);
        if (val != null) {
            this.addAttribute(this.document, e1, "value", val);
        }
        this.addAttribute(this.document, e1, "target", target);
        if (atts != null) {
            String[] attl = atts.split("\\,");
            int i = 0;
            while (i < attl.length) {
                String[] v = attl[i].split("=");
                this.addAttribute(this.document, e1, v[0], v[1]);
                ++i;
            }
        }
    }

    protected void addConst(Element ft, String name, String val, String target, String map) {
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Table");
        ft.appendChild(e1);
        this.addAttribute(this.document, e1, "table_name", name);
        this.addAttribute(this.document, e1, "valueType", "constant");
        this.addAttribute(this.document, e1, "value", val);
        this.addAttribute(this.document, e1, "target", target);
        if (map != null) {
            this.addAttribute(this.document, e1, "map_targetpath", map);
        }
    }

    protected void addJoin(Element ft, String path, String axis, String target) {
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "Join");
        ft.appendChild(e1);
        this.addAttribute(this.document, e1, "join_path", path);
        this.addAttribute(this.document, e1, "axis", axis);
        this.addAttribute(this.document, e1, "target", target);
    }

    protected void addAssociationTarget(Element ft, String target, String ref) {
        Element e1 = this.document.createElementNS("http://www.interactive-instruments.de/namespaces/XtraServer", "AssociationTarget");
        ft.appendChild(e1);
        this.addAttribute(this.document, e1, "object_ref", ref);
        this.addAttribute(this.document, e1, "target", target);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    public void write(String outputDirectory) {
        if (this.printed) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File file = new File(String.valueOf(outputDirectory) + "/XtraSrvConfig_" + this.pi.xmlns() + ".xml");
            FileWriter outputXML = new FileWriter(file);
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }
}

