<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Strittige Grenzen der neuen Flurstücke selektieren -->
				<wfs:Query typeName="AX_BesondereFlurstuecksgrenze">
					<ogc:Filter>
						<ogc:And>	
							<xsl:for-each select="document('E1.xml')//adv:AX_Fortfuehrungsfall/adv:zeigtAufNeuesFlurstueck">
						        <ogc:Or>
									<xsl:variable name="flurstueck" select="document('E1.xml')//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
									<xsl:choose>
										<xsl:when test="count($flurstueck/adv:position/*/*)>1">
											<!--  Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. --> 
										    <ogc:Or>
												<xsl:for-each select="$flurstueck/adv:position/*">
													<ogc:Contains>
														<ogc:PropertyName>position</ogc:PropertyName> 
														<xsl:copy-of select="."/> 
													</ogc:Contains>
												</xsl:for-each>
									       </ogc:Or>
										</xsl:when>
										<xsl:otherwise>
											<ogc:Contains>
												<ogc:PropertyName>position</ogc:PropertyName> 
												<xsl:copy-of select="$flurstueck/adv:position"/> 
											</ogc:Contains>
										</xsl:otherwise>
									</xsl:choose>
						        </ogc:Or>
							</xsl:for-each>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>artDerFlurstuecksgrenze</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<!-- zeitliche Betrachtung -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
  						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- Tatsächliche Nutzungen der neuen Flurstücke selektieren -->
				<xsl:for-each select="document('E1.xml')//adv:AX_Fortfuehrungsfall/adv:zeigtAufNeuesFlurstueck">
					<xsl:variable name="flurstueck" select="document('E1.xml')//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
					<xsl:call-template name="Query_TN__alle">
					  	<xsl:with-param name="position" select="$flurstueck/adv:position"/> 
					</xsl:call-template>
				</xsl:for-each>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
