/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.profiltool;

import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.UI.Dialog;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import de.interactive_instruments.ShapeChange.UI.StatusReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.SystemUtils;

public class ProfilDialog
extends JFrame
implements ActionListener,
ItemListener,
Dialog,
StatusReader {
    public static final String VERSION_TEXT = "0.1";
    private static final String title = "AAA-Profiltool";
    private static final long serialVersionUID = -2443287559064380497L;
    public static final int STATUS_READY = 1;
    public static final int STATUS_FINISHED = 2;
    private File logfile = null;
    private StatusBar statusBar;
    JLabel appSchemaFieldLabel;
    JLabel modellartFieldLabel;
    JLabel profilFieldLabel;
    JLabel pfadFieldLabel;
    JLabel mdlDirFieldLabel;
    JTextField appSchemaField = null;
    JTextField modellartField = null;
    JTextField profilField = null;
    JTextField pfadField = null;
    JTextField mdlDirField = null;
    private ButtonGroup quelleGroup;
    private ButtonGroup zielGroup;
    private JButton startButton;
    private JButton viewLogButton;
    private JButton exitButton;
    private ConvertThread ct = null;
    private boolean modelTransformed;
    private boolean transformationRunning;
    protected Converter converter = null;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected String eap = null;
    private Model model = null;
    private String modelMsgText = "";
    private boolean saveModelMsgText = false;
    private JComponent newContentPane;
    private boolean blocked = false;
    private String paramProfilClass = "de.adv_online.aaa.profiltool.Profil";

    public ProfilDialog() {
        super(title);
    }

    public ProfilDialog(Converter c, Options o, ShapeChangeResult r, String xmi) throws ShapeChangeAbortException {
        super(title);
        this.initialise(c, o, r, xmi);
    }

    public void initialise(Converter c, Options o, ShapeChangeResult r, String xmi) throws ShapeChangeAbortException {
        try {
            Object[] options;
            int val;
            String msg = "Akzeptieren Sie die in der mit diesem Tool auslieferten Datei 'Lizenzbedingungen zur Nutzung von Softwareskripten.doc' beschrieben Lizenzbedingungen?";
            if (msg != null && (val = JOptionPane.showOptionDialog(null, msg, "Confirmation", 2, 3, null, options = new Object[]{"Ja", "Nein"}, options[1])) == 1) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("Fehler in Dialog: " + e.toString());
        }
        this.options = o;
        File eapFile = new File(xmi);
        try {
            this.eap = eapFile.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            this.eap = "ERROR.eap";
        }
        this.converter = new Converter(this.options, r);
        this.result = r;
        this.modelTransformed = false;
        this.transformationRunning = false;
        StatusBoard.getStatusBoard().registerStatusReader((StatusReader)this);
        this.setDefaultCloseOperation(0);
        this.newContentPane = new JPanel(new BorderLayout());
        this.newContentPane.setOpaque(true);
        this.setContentPane(this.newContentPane);
        this.newContentPane.add(this.createMainTab(), "Center");
        this.statusBar = new StatusBar();
        Box fileBox = Box.createVerticalBox();
        fileBox.add(this.createStartPanel());
        fileBox.add(this.statusBar);
        this.newContentPane.add((Component)fileBox, "South");
        int height = 610;
        int width = 560;
        this.pack();
        Insets fI = this.getInsets();
        this.setSize(width + fI.right + fI.left, height + fI.top + fI.bottom);
        Dimension sD = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((sD.width - width) / 2, (sD.height - height) / 2);
        this.setMinimumSize(new Dimension(width, height));
        WindowAdapter listener = new WindowAdapter(){

            public void windowClosing(WindowEvent w) {
                ProfilDialog.this.closeDialog();
            }
        };
        this.addWindowListener(listener);
    }

    public void blockTransformation(boolean b) {
        this.blocked = b;
        if (b) {
            this.transformationRunning = true;
        } else {
            this.modelTransformed = true;
        }
        this.enableElements();
    }

    public void setVisible(boolean vis) {
        this.enableElements();
        super.setVisible(vis);
    }

    private Component createMainTab() {
        File f;
        String s = this.options.parameter("appSchemaName");
        String appSchemaStr = s != null && s.trim().length() > 0 ? s.trim() : "";
        s = this.options.parameter(this.paramProfilClass, "Modellart");
        String mart = s != null && s.trim().length() > 0 ? s.trim() : "";
        s = this.options.parameter(this.paramProfilClass, "Profil");
        String profil = s != null && s.trim().length() > 0 ? s.trim() : "";
        s = this.options.parameter(this.paramProfilClass, "Quelle");
        String quelle = s != null && s.trim().length() > 0 ? s.trim() : "Neu_Minimal";
        s = this.options.parameter(this.paramProfilClass, "Ziel");
        String ziel = s != null && s.trim().length() > 0 ? s.trim() : "Datei";
        s = this.options.parameter(this.paramProfilClass, "Verzeichnis");
        String pfadStr = s == null || s.trim().length() == 0 ? "" : ((f = new File(s.trim())).exists() ? f.getAbsolutePath() : "");
        String mdlDirStr = this.eap;
        JPanel topPanel = new JPanel();
        JPanel topInnerPanel = new JPanel(new FlowLayout(3, 30, 5));
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 10));
        this.appSchemaField = new JTextField(35);
        this.appSchemaField.setText(appSchemaStr);
        this.appSchemaFieldLabel = new JLabel("Name des zu exportierenden Anwendungsschemas:");
        Box asBox = Box.createVerticalBox();
        asBox.add(this.appSchemaFieldLabel);
        asBox.add(this.appSchemaField);
        this.modellartField = new JTextField(10);
        this.modellartField.setText(mart);
        this.modellartFieldLabel = new JLabel("Modellart:");
        asBox.add(this.modellartFieldLabel);
        asBox.add(this.modellartField);
        this.profilField = new JTextField(10);
        this.profilField.setText(profil);
        this.profilFieldLabel = new JLabel("Profilkennung:");
        asBox.add(this.profilFieldLabel);
        asBox.add(this.profilField);
        topInnerPanel.add(asBox);
        topPanel.add(topInnerPanel);
        Box quelleBox = Box.createVerticalBox();
        JPanel quellePanel = new JPanel(new GridLayout(4, 1));
        this.quelleGroup = new ButtonGroup();
        JRadioButton radioButton = new JRadioButton("3ap-Datei");
        quellePanel.add(radioButton);
        if (quelle.equals("Datei")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Datei");
        this.quelleGroup.add(radioButton);
        radioButton = new JRadioButton("'AAA:Profile' Tagged Values in Modell");
        quellePanel.add(radioButton);
        if (quelle.equals("Modell")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Modell");
        this.quelleGroup.add(radioButton);
        radioButton = new JRadioButton("Neues Minimalprofil erzeugen");
        quellePanel.add(radioButton);
        if (quelle.equals("Neu_Minimal")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Neu_Minimal");
        this.quelleGroup.add(radioButton);
        radioButton = new JRadioButton("Neues Maximalprofil erzeugen");
        quellePanel.add(radioButton);
        if (quelle.equals("Neu_Maximal")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Neu_Maximal");
        this.quelleGroup.add(radioButton);
        quellePanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Quelle der Profildefinition", 1, 2));
        quelleBox.add(quellePanel);
        Box zielBox = Box.createVerticalBox();
        JPanel zielPanel = new JPanel(new GridLayout(4, 1));
        this.zielGroup = new ButtonGroup();
        radioButton = new JRadioButton("3ap-Datei");
        zielPanel.add(radioButton);
        if (ziel.equals("Datei")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Datei");
        this.zielGroup.add(radioButton);
        radioButton = new JRadioButton("'AAA:Profile' Tagged Values in Modell");
        zielPanel.add(radioButton);
        if (ziel.equals("Modell")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Modell");
        this.zielGroup.add(radioButton);
        radioButton = new JRadioButton("Beides");
        zielPanel.add(radioButton);
        if (ziel.equals("DateiModell")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("DateiModell");
        this.zielGroup.add(radioButton);
        radioButton = new JRadioButton("Profil wird aus Modell entfernt");
        zielPanel.add(radioButton);
        if (ziel.equals("Ohne")) {
            radioButton.setSelected(true);
        }
        radioButton.setActionCommand("Ohne");
        this.zielGroup.add(radioButton);
        zielPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Ziel der Profildefinition", 1, 2));
        zielBox.add(zielPanel);
        Box pfadBox = Box.createVerticalBox();
        JPanel pfadInnerPanel = new JPanel();
        Box skBox = Box.createVerticalBox();
        this.pfadFieldLabel = new JLabel("Pfad in dem 3ap-Dateien liegen/geschrieben werden:");
        skBox.add(this.pfadFieldLabel);
        this.pfadField = new JTextField(40);
        this.pfadField.setText(pfadStr);
        skBox.add(this.pfadField);
        this.mdlDirFieldLabel = new JLabel("Pfad zum Modell:");
        skBox.add(this.mdlDirFieldLabel);
        this.mdlDirField = new JTextField(40);
        this.mdlDirField.setText(mdlDirStr);
        skBox.add(this.mdlDirField);
        pfadInnerPanel.add(skBox);
        pfadBox.add(pfadInnerPanel);
        JPanel pfadPanel = new JPanel();
        pfadPanel.add(pfadBox);
        pfadPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Pfadangaben", 1, 2));
        Box fileBox = Box.createVerticalBox();
        fileBox.add(topPanel);
        fileBox.add(quellePanel);
        fileBox.add(zielPanel);
        fileBox.add(pfadPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)fileBox, "North");
        return panel;
    }

    private Component createStartPanel() {
        JPanel startPanel = new JPanel(new FlowLayout(1, 20, 20));
        this.startButton = new JButton("Process EAP");
        this.startButton.setActionCommand("START");
        this.startButton.addActionListener(this);
        startPanel.add(this.startButton);
        this.viewLogButton = new JButton("View Log");
        this.viewLogButton.setActionCommand("LOG");
        this.viewLogButton.addActionListener(this);
        this.viewLogButton.setEnabled(false);
        startPanel.add(this.viewLogButton);
        this.exitButton = new JButton("Exit");
        this.exitButton.setActionCommand("EXIT");
        this.exitButton.addActionListener(this);
        this.exitButton.setEnabled(true);
        startPanel.add(this.exitButton);
        startPanel.setPreferredSize(new Dimension(10, 60));
        return startPanel;
    }

    protected void closeDialogWithError(String errmsg) {
        try {
            errmsg = "The application has encountered a fatal error.\nError message:\n" + errmsg;
            JOptionPane.showMessageDialog(this, errmsg, "Fatal error", 0);
            this.result.addFatalError(errmsg);
            if (this.model != null) {
                this.model.shutdown();
            }
        }
        catch (Exception e) {
            System.out.println("closeDialog - Exception: " + e.toString());
        }
    }

    protected void closeDialog() {
        try {
            String msg = null;
            if (this.transformationRunning) {
                msg = "Eine Profilerzeugung l\u00e4uft derzeit.\n";
            }
            if (msg != null) {
                msg = msg + "Soll die Anwendung beendet werden?";
                Object[] options = new Object[]{"Exit", "Cancel"};
                int val = JOptionPane.showOptionDialog(null, msg, "Confirmation", 2, 3, null, options, options[1]);
                if (val == 1) {
                    return;
                }
            }
            if (this.model != null) {
                this.model.shutdown();
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("closeDialog - Exception: " + e.toString());
        }
    }

    public void threadInitialised() {
    }

    public void threadFinished(String errmsg) {
        if (errmsg != null) {
            this.closeDialogWithError(errmsg);
        }
        if (this.transformationRunning) {
            this.modelTransformed = true;
            this.transformationRunning = false;
            StatusBoard.getStatusBoard().statusChanged(2);
            this.enableElements();
        }
    }

    private synchronized void startTransformation() {
        this.modelTransformed = false;
        this.transformationRunning = true;
        try {
            this.options.loadConfiguration();
            this.options.setParameter("appSchemaName", this.appSchemaField.getText());
            this.options.setParameter(this.paramProfilClass, "Modellart", this.modellartField.getText());
            this.options.setParameter(this.paramProfilClass, "Profil", this.profilField.getText());
            this.options.setParameter(this.paramProfilClass, "Quelle", this.quelleGroup.getSelection().getActionCommand());
            this.options.setParameter(this.paramProfilClass, "Ziel", this.zielGroup.getSelection().getActionCommand());
            this.options.setParameter(this.paramProfilClass, "Verzeichnis", this.pfadField.getText());
            this.options.setParameter("inputFile", this.mdlDirField.getText());
            if (!this.reinitMessageText("model transformation process")) {
                this.transformationRunning = false;
            }
            this.enableElements();
            this.startConvertThread();
        }
        catch (ShapeChangeAbortException ex) {
            this.threadFinished(ex.getMessage());
        }
    }

    public void startConvertThread() {
        this.startConvertThread(false);
    }

    public void startConvertThread(boolean onlyInit) {
        if (this.ct == null) {
            this.ct = new ConvertThread(this.converter, this.options, this.result, this.eap, this);
            this.ct.setOnlyInitialise(onlyInit);
            this.ct.start();
        } else {
            this.ct.setOnlyInitialise(onlyInit);
            this.ct.restart();
        }
    }

    public Model getModel() {
        return this.model;
    }

    public void enableElements() {
        if (this.transformationRunning) {
            JRadioButton b;
            this.appSchemaField.setEnabled(false);
            this.modellartField.setEnabled(false);
            this.profilField.setEnabled(false);
            this.pfadField.setEnabled(false);
            this.mdlDirField.setEnabled(false);
            this.appSchemaFieldLabel.setEnabled(false);
            this.modellartFieldLabel.setEnabled(false);
            this.profilFieldLabel.setEnabled(false);
            this.pfadFieldLabel.setEnabled(false);
            this.mdlDirFieldLabel.setEnabled(false);
            Enumeration<AbstractButton> e = this.quelleGroup.getElements();
            while (e.hasMoreElements()) {
                b = (JRadioButton)e.nextElement();
                if (b == null) continue;
                b.setEnabled(false);
            }
            e = this.zielGroup.getElements();
            while (e.hasMoreElements()) {
                b = (JRadioButton)e.nextElement();
                if (b == null) continue;
                b.setEnabled(false);
            }
            this.startButton.setEnabled(false);
            this.viewLogButton.setEnabled(false);
            this.exitButton.setEnabled(true);
            this.setConfigDirSettings(false);
        } else {
            JRadioButton b;
            this.appSchemaField.setEnabled(true);
            this.modellartField.setEnabled(true);
            this.profilField.setEnabled(true);
            this.pfadField.setEnabled(true);
            this.mdlDirField.setEnabled(true);
            this.appSchemaFieldLabel.setEnabled(true);
            this.modellartFieldLabel.setEnabled(true);
            this.profilFieldLabel.setEnabled(true);
            this.pfadFieldLabel.setEnabled(true);
            this.mdlDirFieldLabel.setEnabled(true);
            Enumeration<AbstractButton> e = this.quelleGroup.getElements();
            while (e.hasMoreElements()) {
                b = (JRadioButton)e.nextElement();
                if (b == null) continue;
                b.setEnabled(true);
            }
            e = this.zielGroup.getElements();
            while (e.hasMoreElements()) {
                b = (JRadioButton)e.nextElement();
                if (b == null) continue;
                b.setEnabled(true);
            }
            if (this.startButton != null) {
                boolean setStart = true;
                if (setStart && !this.blocked) {
                    this.startButton.setEnabled(true);
                    StatusBoard.getStatusBoard().statusChanged(1);
                } else {
                    this.startButton.setEnabled(false);
                    StatusBoard.getStatusBoard().statusChanged(0);
                }
            }
            if (this.viewLogButton != null && this.modelTransformed) {
                this.logfile = new File(this.options.parameter("logFile").replace(".xml", ".html"));
                if (this.logfile != null && this.logfile.canRead()) {
                    this.viewLogButton.setEnabled(true);
                } else {
                    this.logfile = new File(this.options.parameter("logFile"));
                    if (this.logfile != null && this.logfile.canRead()) {
                        this.viewLogButton.setEnabled(true);
                    }
                }
                this.viewLogButton.setEnabled(true);
            }
            if (this.exitButton != null) {
                this.exitButton.setEnabled(true);
            }
            this.setConfigDirSettings(true);
        }
    }

    public boolean reinitMessageText(String action) {
        return true;
    }

    public void showMessageText(String msg) {
        if (this.saveModelMsgText) {
            this.modelMsgText = this.modelMsgText + msg;
        }
    }

    public void actionPerformed(ActionEvent e) {
        block9: {
            if (this.startButton == e.getSource()) {
                this.startTransformation();
            } else if (e.getSource() == this.viewLogButton) {
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(this.logfile);
                        break block9;
                    }
                    if (SystemUtils.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec("cmd /c start " + this.logfile.getPath());
                        break block9;
                    }
                    Runtime.getRuntime().exec("open " + this.logfile.getPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    System.exit(1);
                }
            } else if (e.getSource() == this.exitButton) {
                this.closeDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void setConfigDirSettings(boolean allSelConfig) {
    }

    public void statusChanged(int status) {
        String msg = " ";
        block0 : switch (status) {
            case 1: {
                msg = msg + "Bereit";
                break;
            }
            case 101: {
                msg = msg + "Lesen des Modells: Initialisierung";
                break;
            }
            case 102: {
                msg = msg + "Lesen des Modells: Paketinformationen";
                break;
            }
            case 103: {
                msg = msg + "Lesen des Modells: Objektarten und deren Eigenschaften";
                break;
            }
            case 104: {
                msg = msg + "Lesen des Modells: Konsistenzbedingungen";
                break;
            }
            case 201: {
                switch (this.converter.getCurrentTargetID()) {
                    case 402: {
                        msg = msg + "AAA-Profiltool: Initialisierung der Profilverarbeitung";
                        break block0;
                    }
                }
                msg = null;
                this.statusBar.delText();
                break;
            }
            case 202: {
                switch (this.converter.getCurrentTargetID()) {
                    case 402: {
                        msg = msg + "AAA-Profiltool: Lesen/Erzeugen des Profils";
                        break block0;
                    }
                }
                msg = null;
                this.statusBar.delText();
                break;
            }
            case 203: {
                switch (this.converter.getCurrentTargetID()) {
                    case 402: {
                        msg = msg + "AAA-Profiltool: Schreiben des Profils";
                        break block0;
                    }
                }
                msg = null;
                this.statusBar.delText();
                break;
            }
            case 31: {
                msg = msg + "AAA-Profiltool: Schreiben des Profils als 3ap-Datei";
                break;
            }
            case 32: {
                msg = msg + "AAA-Profiltool: Schreiben des Profils ins Modell";
                break;
            }
            case 33: {
                msg = msg + "AAA-Profiltool: Entfernen des Profils aus dem Modell";
                break;
            }
            default: {
                msg = null;
                this.statusBar.delText();
            }
        }
        if (msg != null) {
            this.statusBar.setText(msg);
        }
    }

    class ConvertThread
    extends Thread {
        protected Converter converter = null;
        protected ShapeChangeResult result = null;
        protected Options options = null;
        protected String eap = null;
        protected ProfilDialog dialog = null;
        protected boolean onlyInitialise;

        ConvertThread(Converter c, Options o, ShapeChangeResult r, String e, ProfilDialog d) {
            this.converter = c;
            this.options = o;
            this.result = r;
            this.eap = e;
            this.dialog = d;
            this.onlyInitialise = false;
        }

        public void setOnlyInitialise(boolean o) {
            this.onlyInitialise = o;
        }

        public void initialise() throws ShapeChangeAbortException {
            if (this.dialog.model != null) {
                this.dialog.model.shutdown();
                this.dialog.model = null;
            }
            this.dialog.saveModelMsgText = true;
            this.dialog.model = (Model)new EADocument(this.result, this.options, this.eap);
            this.dialog.saveModelMsgText = false;
            if (this.onlyInitialise) {
                this.dialog.threadInitialised();
            }
        }

        public synchronized void restart() {
            this.result.init();
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String errmsg = null;
            try {
                try {
                    while (true) {
                        this.initialise();
                        if (this.dialog.model != null && !this.onlyInitialise) {
                            this.converter.convert(this.dialog.model);
                        }
                        this.dialog.threadFinished(null);
                        ConvertThread convertThread = this;
                        synchronized (convertThread) {
                            this.wait();
                            ConvertThread.sleep(100L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.dialog.threadFinished(errmsg);
                    return;
                }
            }
            catch (ShapeChangeAbortException ex) {
                errmsg = ex.getMessage();
                if (errmsg == null) {
                    errmsg = ex.toString();
                }
                if (errmsg != null) return;
                errmsg = "Unknown ShapeChangeAbortException.";
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            finally {
                this.dialog.threadFinished(errmsg);
            }
        }

        public void end() {
            this.restart();
            this.interrupt();
        }
    }

    class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel label;

        public StatusBar() {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(10, 23));
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.label = new JLabel();
            this.add((Component)this.label, "West");
        }

        public void setText(String text) {
            this.label.setText(text);
        }

        public void delText() {
            this.label.setText("");
        }
    }
}

