<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('AX_Benutzungsauftrag.xml')//ogc:Literal"/>
		<xsl:variable name="p4" select="document('E1.xml')//adv:AX_Flurstueck/adv:position/*"/><!-- Hier auf E1.xml bezogen statt wie zuvor bezugslos -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<!-- GeoInfoDok 5.1.1 -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<wfs:Query typeName="AX_Flurstueck">
					<XlinkPropertyPath>gehoertAnteiligZu</XlinkPropertyPath>
					<XlinkPropertyPath>istGebucht/AX_Buchungsstelle/istBestandteilVon</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>flurstueckskennzeichen</ogc:PropertyName>
								<ogc:Literal>
									<xsl:value-of select="$p3"/>
								</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>gehoertAnteiligZu/AX_Flurstueck/flurstueckskennzeichen</ogc:PropertyName>
								<ogc:Literal>
									<xsl:value-of select="$p3"/>
								</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Or>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Namensnummer">
					<XlinkPropertyPath>benennt/AX_Person/hat</XlinkPropertyPath>
				</wfs:Query>
				<wfs:Query typeName="AX_BesondereFlurstuecksgrenze">
					<ogc:Filter>
						<ogc:And>
							<ogc:Intersects>
								<ogc:PropertyName>position</ogc:PropertyName>
								<xsl:copy-of select="$p4"/><!-- Hier stand fälschlicherweise value-of -->
							</ogc:Intersects>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>artDerFlurstuecksgrenze</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_KommunalesGebiet">
					<ogc:Filter>
						<ogc:Intersects>
							<ogc:PropertyName>position</ogc:PropertyName>
							<xsl:copy-of select="$p4"/><!-- Hier stand fälschlicherweise value-of -->
						</ogc:Intersects>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Objekte der weiteren Objektarten. Hinweis: Dies ist natürlich keine realistische Vorgehensweise
				bei Produktionsdatenbeständen. Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Gemarkung"/>
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_KreisRegion"/>
				<wfs:Query typeName="AX_Regierungsbezirk"/>
				<wfs:Query typeName="AX_LagebezeichnungOhneHausnummer"/>
				<wfs:Query typeName="AX_LagebezeichnungMitHausnummer"/>
				<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"/>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
