<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
	xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
	xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- ======================= GeoInfoDok 5.1.1 ==================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1">
			<xsl:choose>
				<xsl:when test="function-available('date:to-string') and function-available('date:new')">
					<xsl:value-of select="date:to-string(date:new())"/>
				</xsl:when>
				<xsl:otherwise>unbekannt</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="p2">
		 	<xsl:call-template name="entschluesseln">
				<xsl:with-param name="codelist">AX_Anlassart_Benutzungsauftrag</xsl:with-param>
				<xsl:with-param name="code" select="document('AX_EinzelnachweisGrundnetzpunkt/AX_Benutzungsauftrag.xml')//adv:art"/><!-- Hier hart verdrahtet, was natürlich entsprechend flexibel zu implementieren ist. -->
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="p3" select="document('Parameter.xml')//param[@name='Landeswappen']"/>
		<xsl:variable name="p4" select="document('Parameter.xml')//param[@name='Dienststellenlogo']"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:variable name="land" select="//adv:AX_Lagefestpunkt[1]/adv:gemeinde/adv:AX_Gemeindekennzeichen/adv:land"/>
		<xsl:variable name="dstnr" select="//adv:AX_Bundesland[adv:schluesselGesamt=$land]/adv:istAmtsbezirkVon/adv:AX_Dienststelle_Schluessel/adv:stelle"/>
		<xsl:variable name="stelle" select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($land,$dstnr) and (adv:stellenart='1100' or adv:stellenart='1800' or adv:stellenart='2200')]"/>
		<xsl:variable name="anschrift" select="//adv:AX_Anschrift[@gml:id=substring-after($stelle/adv:hat/@xlink:href,'urn:adv:oid:')]"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_K_AUSGKOPF_Standard xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1">
			<datumDerAusgabe><xsl:value-of select="$p1"/></datumDerAusgabe>
			<dienststelle><xsl:value-of select="$stelle/adv:bezeichnung"/></dienststelle>
			<anschriftDienststelle>
			 <AX_K_ANSCHRIFT>
			 <strasseHausnummer><xsl:value-of select="$anschrift/adv:strasse"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$anschrift/adv:hausnummer"/>
			</strasseHausnummer>
			<plzOrt><xsl:value-of select="$anschrift/adv:postleitzahlPostzustellung"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$anschrift/adv:ort_Post"/>
			</plzOrt>
			</AX_K_ANSCHRIFT>
			</anschriftDienststelle>
			<artDerAusgabe><xsl:value-of select="$p2"/></artDerAusgabe>
			<enthaeltEWP>
				<AX_Landeswappen>
					<uri><xsl:value-of select="$p3"/></uri>
				</AX_Landeswappen>
			</enthaeltEWP>
			<xsl:if test="$p4">
				<dienststellenlogo>
					<AX_Dienststellenlogo>
						<uri><xsl:value-of select="$p4"/></uri>
					</AX_Dienststellenlogo>
				</dienststellenlogo>
			</xsl:if>
		</AX_K_AUSGKOPF_Standard>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
