<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="wmsurl" select="document('../Parameter.xml')//param[@name='WMS_URL']"/>
		<xsl:variable name="poscrs" select="document('../Parameter.xml')//param[@name='CRS_Position']"/>
		<xsl:variable name="hoehencrs" select="document('../Parameter.xml')//param[@name='CRS_Hoehe']"/>
		<xsl:variable name="lagecrs" select="document('../Parameter.xml')//param[@name='CRS_Lage']"/>
		<xsl:variable name="punkt" select="document('E1.xml')//adv:AX_Referenzstationspunkt"/>
		<xsl:variable name="punktort" select="document('E1.xml')//adv:AX_PunktortAU[adv:koordinatenstatus=1000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<xsl:variable name="skizzen" select="document('E1.xml')//adv:AX_Skizze[adv:skizzenart=1000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<xsl:variable name="lfp" select="document('E1.xml')//adv:AX_Lagefestpunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<xsl:variable name="hfp" select="document('E1.xml')//adv:AX_Hoehenfestpunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_EinzelnachweisReferenzstationspunkt xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<kopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</kopf>
			<punktkennung>
				<xsl:value-of select="$punkt/adv:punktkennung"/>
			</punktkennung>
			<punktvermarkung>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Marke</xsl:with-param>
					<xsl:with-param name="code" select="$punkt/adv:punktvermarkung"/>
				</xsl:call-template>
			</punktvermarkung>
			<name><xsl:value-of select="$punkt/adv:nameLagebeschreibung"/></name>
			<xsl:for-each select="$lfp">
				<punktkennungAlsLFP><xsl:value-of select="adv:punktkennung"/></punktkennungAlsLFP>
			</xsl:for-each>
			<xsl:variable name="k1" select="$punkt/adv:beginn"/>
			<xsl:if test="count($k1)=1">
				<beginn>
					<xsl:choose>
						<xsl:when test="function-available('date:to-string')">
							<!-- xsl:value-of select="date:to-string($k1)"/ --><!-- Wegen Problemen mit date:to-string hier auskommentiert. -->
							<xsl:value-of select="$k1"/>
						</xsl:when>
						<xsl:otherwise>unbekannt</xsl:otherwise>
					</xsl:choose>
				</beginn>
			</xsl:if>
			<xsl:variable name="k2" select="$punkt/adv:ende"/>
			<xsl:if test="count($k2)=1">
				<ende>
					<xsl:choose>
						<xsl:when test="function-available('date:to-string')">
						        <!-- xsl:value-of select="date:to-string($k2)"/ --><!-- Wegen Problemen mit date:to-string hier auskommentiert. -->
							<xsl:value-of select="$k2"/>
						</xsl:when>
						<xsl:otherwise>unbekannt</xsl:otherwise>
					</xsl:choose>
				</ende>
			</xsl:if>
			<xsl:if test="$punkt/adv:offsetL1">
				<offsetL1>
					<xsl:value-of select="$punkt/adv:offsetL1/adv:AX_Offsetkomponenten_Referenzstationspunkt/adv:north"/><xsl:text> m </xsl:text>
					<xsl:value-of select="$punkt/adv:offsetL1/adv:AX_Offsetkomponenten_Referenzstationspunkt/adv:east"/><xsl:text> m </xsl:text>
					<xsl:value-of select="$punkt/adv:offsetL1/adv:AX_Offsetkomponenten_Referenzstationspunkt/adv:height"/><xsl:text> m </xsl:text>
				</offsetL1>
			</xsl:if>
			<xsl:if test="$punkt/adv:offsetL2">
				<offsetL2>
					<xsl:value-of select="$punkt/adv:offsetL2/adv:AX_Offsetkomponenten_Referenzstationspunkt/adv:north"/><xsl:text> m </xsl:text>
					<xsl:value-of select="$punkt/adv:offsetL2/adv:AX_Offsetkomponenten_Referenzstationspunkt/adv:east"/><xsl:text> m </xsl:text>
					<xsl:value-of select="$punkt/adv:offsetL2/adv:AX_Offsetkomponenten_Referenzstationspunkt/adv:height"/><xsl:text> m </xsl:text>
				</offsetL2>
			</xsl:if>
			<uebersichtsgrafik>
				<xsl:value-of select="substring-before($wmsurl,'$$BBOX$$')"/>
				<xsl:call-template name="BboxFuerWMS">
					<xsl:with-param name="punktorte" select="$punktort"/>
				</xsl:call-template>
				<xsl:value-of select="substring-after($wmsurl,'$$BBOX$$')"/>
			</uebersichtsgrafik>
			<xsl:for-each select="$punktort">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName">
						<xsl:if test="contains($poscrs,./adv:position/gml:Point/@srsName)">
							<position>
								<xsl:call-template name="AX_K_Positionssystem">
									<xsl:with-param name="punktort" select="."/>
									<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
								</xsl:call-template>
							</position>
						</xsl:if>
					</xsl:when>
					<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and 
									contains($poscrs,document('E1.xml')//gml:Envelope/@srsName)">
						<position>
							<xsl:call-template name="AX_K_Positionssystem">
								<xsl:with-param name="punktort" select="."/>
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</position>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="$punktort">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName">
						<xsl:if test="contains($lagecrs,./adv:position/gml:Point/@srsName)">
							<lage>
								<xsl:call-template name="AX_K_Lagesystem">
									<xsl:with-param name="punktort" select="."/>
									<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
								</xsl:call-template>
							</lage>
						</xsl:if>
					</xsl:when>
					<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and 
									contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName)">
						<lage>
							<xsl:call-template name="AX_K_Lagesystem">
								<xsl:with-param name="punktort" select="."/>
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</lage>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="$punktort">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName">
						<xsl:if test="contains($hoehencrs,./adv:position/gml:Point/@srsName)">
							<hoehe>
								<xsl:call-template name="AX_K_Hoehensystem">
									<xsl:with-param name="punktort" select="."/>
									<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
								</xsl:call-template>
							</hoehe>
						</xsl:if>
					</xsl:when>
					<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and 
									contains($hoehencrs,document('E1.xml')//gml:Envelope/@srsName)">
						<hoehe>
							<xsl:call-template name="AX_K_Hoehensystem">
								<xsl:with-param name="punktort" select="."/>
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</hoehe>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:variable name="k6" select="$punkt/adv:gnssAntenne/adv:AX_GNSSAntenne/adv:antennenhoehe"/>
			<xsl:if test="count($k6)=1">
				<antennenhoehe><xsl:value-of select="$k6"/></antennenhoehe>
			</xsl:if>
			<xsl:for-each select="$punkt/adv:nutzerspezifischeBemerkungen">
				<bemerkungen><xsl:value-of select="*"/></bemerkungen>
			</xsl:for-each>
			<xsl:for-each select="$skizzen">
				<skizzen><xsl:value-of select="adv:skizzenname"/></skizzen>
			</xsl:for-each>
			<xsl:for-each select="$hfp">
				<punktkennungAlsHFP><xsl:value-of select="adv:punktkennung"/></punktkennungAlsHFP>
			</xsl:for-each>
		</AX_EinzelnachweisReferenzstationspunkt>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
