<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="wmsurl" select="document('../Parameter.xml')//param[@name='WMS_URL']"/>
		<xsl:variable name="poscrs" select="document('../Parameter.xml')//param[@name='CRS_Position']"/>
		<xsl:variable name="hoehencrs" select="document('../Parameter.xml')//param[@name='CRS_Hoehe']"/>
		<xsl:variable name="lagecrs" select="document('../Parameter.xml')//param[@name='CRS_Lage']"/>
		<xsl:variable name="punkt" select="document('E1.xml')//adv:AX_Lagefestpunkt"/>
		<xsl:variable name="punktort" select="document('E1.xml')//adv:AX_PunktortAU[adv:koordinatenstatus=1000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<xsl:variable name="skizzen" select="document('E1.xml')//adv:AX_Skizze[adv:skizzenart=1000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<xsl:variable name="schwere" select="document('E1.xml')//adv:AX_Schwere[adv:schwerestatus=1000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_EinzelnachweisGrundnetzpunkt xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<kopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</kopf>
			<punktkennung>
				<xsl:value-of select="$punkt/adv:punktkennung"/>
			</punktkennung>
			<punktvermarkung>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Marke</xsl:with-param>
					<xsl:with-param name="code" select="$punkt/adv:punktvermarkung"/>
				</xsl:call-template>
			</punktvermarkung>
			<xsl:variable name="k1" select="$punkt/adv:klassifikation/adv:AX_Klassifikation_Lagefestpunkt/adv:ordnung"/>
			<xsl:if test="$k1">
				<klassifikationOrdnung>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Klassifikation_Ordnung_Lagefestpunkt</xsl:with-param>
						<xsl:with-param name="code" select="$k1"/>
					</xsl:call-template>
				</klassifikationOrdnung>
			</xsl:if>
			<xsl:variable name="k2" select="$punkt/adv:klassifikation/adv:AX_Klassifikation_Lagefestpunkt/adv:hierarchiestufe3D"/>
			<xsl:if test="$k2">
				<klassifikationHierarchiestufe>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Klassifikation_Hierarchiestufe3D_Lagefestpunkt</xsl:with-param>
						<xsl:with-param name="code" select="$k2"/>
					</xsl:call-template>
				</klassifikationHierarchiestufe>
			</xsl:if>
			<xsl:variable name="k3" select="$punkt/adv:klassifikation/adv:AX_Klassifikation_Lagefestpunkt/adv:wertigkeit"/>
			<xsl:if test="$k3">
				<klassifikationWertigkeit>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Klassifikation_Wertigkeit_Lagefestpunkt</xsl:with-param>
						<xsl:with-param name="code" select="$k3"/>
					</xsl:call-template>
				</klassifikationWertigkeit>
			</xsl:if>
			<xsl:variable name="k4" select="$punkt/adv:qualitaetsangaben/adv:AX_DQFestpunkt/adv:ueberwachungsdatum"/>
			<xsl:if test="$k4">
				<ueberwachungsdatum>
					<xsl:choose><!-- Sinn von date:to-string ??? Das choose könnte entfallen, vgl. Anmerkung bei auskommentierter Zeile.  -->
						<xsl:when test="function-available('date:to-string')">
							<xsl:value-of select="$k4"/>
							<!-- xsl:value-of select="date:to-string($k4)"/ --><!-- Date-to-string deaktiviert, da es auf Fehlermeldung "no method with 1 arguments" lief. -->
						</xsl:when>
						<xsl:otherwise>unbekannt</xsl:otherwise>
					</xsl:choose>
				</ueberwachungsdatum>
			</xsl:if>
			<xsl:variable name="k5" select="$punkt/adv:gemeinde/adv:AX_Gemeindekennzeichen"/>
			<xsl:if test="$k5">
				<gemeinde><xsl:value-of select="AX_Gemeinde[adv:land=$k5/adv:land and adv:regierungsbezirk=$k5/adv:regierungsbezirk and adv:kreis=$k5/adv:kreis and adv:gemeinde=$k5/adv:gemeinde]/adv:bezeichnung"/></gemeinde>
			</xsl:if>
			<uebersichtsgrafik>
				<xsl:value-of select="substring-before($wmsurl,'$$BBOX$$')"/>
				<xsl:call-template name="BboxFuerWMS">
					<xsl:with-param name="punktorte" select="$punktort"/>
				</xsl:call-template>
				<xsl:value-of select="substring-after($wmsurl,'$$BBOX$$')"/>
			</uebersichtsgrafik>
			<xsl:for-each select="$punktort">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName">
						<xsl:if test="contains($poscrs,./adv:position/gml:Point/@srsName)">
							<position>
								<xsl:call-template name="AX_K_Positionssystem">
									<xsl:with-param name="punktort" select="."/>
									<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
								</xsl:call-template>
							</position>
						</xsl:if>
					</xsl:when>
					<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and contains($poscrs,document('E1.xml')//gml:Envelope/@srsName)">
						<position>
							<xsl:call-template name="AX_K_Positionssystem">
								<xsl:with-param name="punktort" select="."/>
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</position>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="$punktort">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName">
						<xsl:if test="contains($lagecrs,./adv:position/gml:Point/@srsName)">
							<lage>
								<xsl:call-template name="AX_K_Lagesystem">
									<xsl:with-param name="punktort" select="."/>
									<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
								</xsl:call-template>
							</lage>
						</xsl:if>
					</xsl:when>
					<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName)">
						<lage>
							<xsl:call-template name="AX_K_Lagesystem">
								<xsl:with-param name="punktort" select="."/>
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</lage>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="$punktort">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName">
						<xsl:if test="contains($hoehencrs,./adv:position/gml:Point/@srsName)">
							<hoehe>
								<xsl:call-template name="AX_K_Hoehensystem">
									<xsl:with-param name="punktort" select="."/>
									<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
								</xsl:call-template>
							</hoehe>
						</xsl:if>
					</xsl:when>
					<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and contains($hoehencrs,document('E1.xml')//gml:Envelope/@srsName)">
						<hoehe>
							<xsl:call-template name="AX_K_Hoehensystem">
								<xsl:with-param name="punktort" select="."/>
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</hoehe>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:variable name="k6" select="$punkt/adv:pfeilerhoehe/adv:AX_Pfeilerhoehe_Lagefestpunkt"/>
			<xsl:if test="count($k6)=1">
				<pfeilerhoeheMessdatum>
					<xsl:choose><!-- Sinn von date:to-string ??? Das choose könnte entfallen, vgl. Anmerkung bei auskommentierter Zeile.  -->
						<xsl:when test="function-available('date:to-string')">
							<xsl:variable name="k6a" select="$k6/adv:messung"/>
							<xsl:value-of select="$k6a"/>
							<!-- xsl:value-of select="date:to-string($k6a)"/ --><!-- Date-to-string deaktiviert, da es auf Fehlermeldung "no method with 1 arguments" lief. -->
						</xsl:when>
						<xsl:otherwise>unbekannt</xsl:otherwise>
					</xsl:choose>
				</pfeilerhoeheMessdatum>			
				<pfeilerhoeheWert><xsl:value-of select="$k6/adv:abstand"/> mm</pfeilerhoeheWert><!-- ab XPath 2.0: format-number($k6/adv:abstand,'#########') -->
			</xsl:if>
			<xsl:for-each select="$punkt/adv:nutzerspezifischeBemerkungen">
				<bemerkungen><xsl:value-of select="*"/></bemerkungen>
			</xsl:for-each>
			<xsl:for-each select="$skizzen">
				<skizzen><xsl:value-of select="adv:skizzenname"/></skizzen>
			</xsl:for-each>
			<xsl:for-each select="$schwere">
				<schwere>
					<xsl:call-template name="AX_K_Schweresystem">
						<xsl:with-param name="schwere" select="."/>
					</xsl:call-template>
				</schwere>
			</xsl:for-each>
		</AX_EinzelnachweisGrundnetzpunkt>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
