<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart" select="//adv:art"/> 		
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_VergleichendesPunktnummernverzeichnis xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<!-- Die optionale Gebietsangabe (AVP.GKN) von AX_VergleichendesPunktnummernverzeichnis wird wie folgt belegt:
			'Gebietsangabe' enthält den langschriftlichen Namen der Gebiete, für die ein vergleichendes Punktnummernverzeichnis
			angefordert wurde (Kommunales Gebiet, Gemarkung, Gemarkungsteil/Flur, Rechteck). Im Falle des Kommunalen Gebietes
			steht gemeindekennzeichen durch die Einstiegsoption zur Verfügung, bzgl. AX_Gemarkung schluesselGesamt und bzgl. 
			AX_GemarkungsteilFlur schluesselGesamt anhand derer jeweils die langschriftliche Bezeichnung ermittelt werden kann.
			Wird mit 'Rechteck' eingestiegen, so wird gebietsangaben mit "Rechteck mit Eckwerten {Koordinatenwerte}" belegt.
			Als weitere Einstiegsoption ist antragsnummer vorgesehen, bei welcher gebietsangabe unbelegt bleibt. -->
			
			<!-- Schleife über alle vergl. Punktkennungen: Sortierung wird bestimmt über Anlassart -->
			<xsl:variable name="sortcolumn">
				<xsl:choose>
					<!-- Anlassart 2401: 'VPN sortiert nach vorläufige Punktkennung' -->
					<xsl:when test="$anlassart='2401'">
						<xsl:value-of select="'adv:vorlaeufigePunktkennung'"/>
					</xsl:when>
					<!-- sonst sortiert nach endgültiger Punktkennung, also auch Anlassart 2402: 'VPN sortiert nach endgültiger Punktkennung' -->
					<xsl:otherwise>
						<xsl:value-of select="'adv:endgueltigePunktkennung'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:for-each select="document('E1.xml')//adv:AX_PunktkennungVergleichend[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<xsl:sort select="@*[name() = $sortcolumn]"/> <!-- "@{$sortcolumn}" geht leider nicht! -->
				<!-- Wenn es dazu mind. einen Punkt der gewünschten Punktart gibt, dann AX_K_ZEILE. -->
				<xsl:variable name="art" select="adv:art"/>
				<xsl:variable name="punktanzahl">
					<xsl:choose>
						<xsl:when test="$art=1100">
							<!-- Grenzpunkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_Grenzpunkt)"/>
						</xsl:when>
						<xsl:when test="$art=1200">
							<!-- Besondere Gebäudepunkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_BesondererGebaeudepunkt)"/>
						</xsl:when>
						<xsl:when test="$art=1300">
							<!-- Besondere topographische Punkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_BesondererTopographischerPunkt)"/>
						</xsl:when>
						<xsl:when test="$art=1400">
							<!-- Aufnahmepunkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_Aufnahmepunkt)"/>
						</xsl:when>
						<xsl:when test="$art=1500">
							<!-- Sicherungspunkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_Sicherungspunkt)"/>
						</xsl:when>
						<xsl:when test="$art=1600">
							<!-- Sonstige Vermessungspunkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_SonstigerVermessungspunkt)"/>
						</xsl:when>
						<xsl:when test="$art=1700">
							<!-- Besondere Bauwerkspunkte -->
							<xsl:value-of select="count(document('E2.xml')//adv:AX_BesondererBauwerkspunkt)"/>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:if test="$punktanzahl>0">
					<zeile>
						<AX_K_ZEILE>
							<punktart>
								<xsl:choose>
									<xsl:when test="$art=1100">
										<!-- Grenzpunkte -->
										<xsl:value-of select="'GP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "GP" "Grenzpunkt" setzen. -->
									</xsl:when>
									<xsl:when test="$art=1200">
										<!-- Besondere Gebäudepunkte -->
										<xsl:value-of select="'BGP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "BGP" "Besonderer Gebäudepunkt" setzen. --> 
									</xsl:when>
									<xsl:when test="$art=1300">
										<!-- Besondere topographische Punkte -->
										<xsl:value-of select="'BTP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "BTP" "Besonderer topographischer Punkt" setzen. --> 
									</xsl:when>
									<xsl:when test="$art=1400">
										<!-- Aufnahmepunkte -->
										<xsl:value-of select="'AP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "AP" "Aufnahmepunkt" setzen. --> 
									</xsl:when>
									<xsl:when test="$art=1500">
										<!-- Sicherungspunkte -->
										<xsl:value-of select="'SP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "SP" "Sicherungspunkt" setzen. --> 
									</xsl:when>
									<xsl:when test="$art=1600">
										<!-- Sonstige Vermessungspunkte -->
										<xsl:value-of select="'SVP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "SVP" "Sonstiger Vermessungspunkt" setzen. --> 
									</xsl:when>
									<xsl:when test="$art=1700">
										<!-- Besondere Bauwerkspunkte -->
										<xsl:value-of select="'BBP'"/><!-- Falls durch Revision mittlerweile AX_K_ZEILE.punktart statt Datentyp AX_K_ZEILE_Punktart als Codelist nun Datentyp AX_K_ZEILE_Punktart als Enumeration hat, dann hier statt "BBP" "Besonderer Bauwerkspunkt" setzen. --> 
									</xsl:when>
								</xsl:choose>
							</punktart>
							<vorlaeufigePunktkennung><xsl:value-of select="adv:vorlaeufigePunktkennung"/></vorlaeufigePunktkennung>
							<endgueltigePunktkennung><xsl:value-of select="adv:endgueltigePunktkennung"/></endgueltigePunktkennung>
							<antragsnummerDerVermessung><xsl:value-of select="$antragsnummer"/></antragsnummerDerVermessung>
							<entstehung><xsl:value-of select="adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:beginnt"/></entstehung>
						</AX_K_ZEILE>
					</zeile>
				</xsl:if>
			</xsl:for-each>
		</AX_VergleichendesPunktnummernverzeichnis>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
