<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="poscrs" select="document('../Parameter.xml')//param[@name='CRS_Position']"/>
	<xsl:variable name="hoehencrs" select="document('../Parameter.xml')//param[@name='CRS_Hoehe']"/>
	<xsl:variable name="lagecrs" select="document('../Parameter.xml')//param[@name='CRS_Lage']"/>
	<xsl:variable name="streifen" select="document('../Parameter.xml')//param[@name='CRS_StreifenAmtlich']"/>
	<!-- =========================================================== -->
	<!-- Positionsangaben aus Punktorten ermitteln -->
	<!--   aus AX_PunktortAU -->
	<xsl:template name="PunktortAU_Position">
		<xsl:param name="punkt"/>
		<xsl:for-each select="document('E1.xml')//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
			<xsl:call-template name="Punktort_Position">
				<xsl:with-param name="punktort" select="."/> 
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!--   aus AX_PunktortTA -->
	<xsl:template name="PunktortTA_Position">
		<xsl:param name="punkt"/>
		<xsl:for-each select="document('E1.xml')//adv:AX_PunktortTA[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
			<xsl:call-template name="Punktort_Position">
				<xsl:with-param name="punktort" select="."/> 
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!--   aus AX_PunktortAG -->
	<xsl:template name="PunktortAG_Position">
		<xsl:param name="punkt"/>
		<xsl:for-each select="document('E1.xml')//adv:AX_PunktortAG[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
			<xsl:call-template name="Punktort_Position">
				<xsl:with-param name="punktort" select="."/> 
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!--   aus Punktorten die Positionsangaben -->
	<xsl:template name="Punktort_Position">
		<xsl:param name="punktort"/>
		<position>
			<AX_Position>
				<xsl:choose>
					<xsl:when test="$punktort/adv:position/gml:Point/gml:pos/@srsName and contains($poscrs,adv:position/gml:Point/gml:pos/@srsName)">
						<rechtswert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswert>
						<hochwert><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hochwert>
					</xsl:when>
					<xsl:when test="$punktort/adv:position/gml:Point/gml:pos/@srsName and contains($lagecrs,adv:position/gml:Point/gml:pos/@srsName)">
						<rechtswert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswert>
						<hochwert><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></hochwert>
					</xsl:when>
					<xsl:when test="$punktort/adv:position/gml:Point/@srsName and contains($poscrs,adv:position/gml:Point/@srsName)">
						<rechtswert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswert>
						<hochwert><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hochwert>
					</xsl:when>
					<xsl:when test="$punktort/adv:position/gml:Point/@srsName and contains($lagecrs,adv:position/gml:Point/@srsName)">
						<rechtswert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswert>
						<hochwert><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></hochwert>
					</xsl:when>
					<xsl:when test="count($punktort/adv:position/gml:Point/gml:pos/@srsName)=0 and count($punktort/adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($poscrs,document('E1.xml')//gml:Envelope/@srsName)">
						<rechtswert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswert>
						<hochwert><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hochwert>
					</xsl:when>
					<xsl:when test="count($punktort/adv:position/gml:Point/gml:pos/@srsName)=0 and count($punktort/adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName)">
						<rechtswert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswert>
						<hochwert><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></hochwert>
					</xsl:when>
				</xsl:choose>
			</AX_Position>
		</position>
		<xsl:if test="count($punktort/adv:qualitaetsangaben/adv:AX_DQPunktort/adv:herkunft)=1">
			<herkunft><xsl:value-of select="$punktort/adv:qualitaetsangaben/adv:AX_DQPunktort/adv:herkunft"/></herkunft>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Punktliste xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<!-- Aufnahmepunkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Aufnahmepunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>1100</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "1100" Text "Aufnahmepunkt" setzen. -->
						<!-- Ggf. muss man hier landesspez. Regeln einbauen, wie punktnummer aus punktkennung abzuleiten ist. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<vermarkung_Marke>
							<xsl:call-template name="entschluesseln">
  								<xsl:with-param name="codelist">AX_Marke</xsl:with-param> 
  								<xsl:with-param name="code" select="adv:vermarkung_Marke" /> 
  							</xsl:call-template>
  						</vermarkung_Marke>
						<xsl:if test="count(./adv:relativeHoehe)=1">
							<relativeHoehe><xsl:value-of select="adv:relativeHoehe"/></relativeHoehe>
						</xsl:if>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Sicherungspunkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Sicherungspunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>1200</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "1200" Text "Sicherungspunkt" setzen. -->
						<!-- Ggf. muss man hier landesspez. Regeln einbauen, wie punktnummer aus punktkennung abzuleiten ist. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<vermarkung_Marke>
							<xsl:call-template name="entschluesseln">
  								<xsl:with-param name="codelist">AX_Marke</xsl:with-param> 
  								<xsl:with-param name="code" select="adv:vermarkung_Marke" /> 
  							</xsl:call-template>
  						</vermarkung_Marke>
						<xsl:if test="count(./adv:relativeHoehe)=1">
							<relativeHoehe><xsl:value-of select="adv:relativeHoehe"/></relativeHoehe>
						</xsl:if>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Sonstige Vermessungspunkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_SonstigerVermessungspunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>2000</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "2000" Text "Vermessungspunkt" setzen. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<vermarkung_Marke>
							<xsl:call-template name="entschluesseln">
  								<xsl:with-param name="codelist">AX_Marke</xsl:with-param> 
  								<xsl:with-param name="code" select="adv:vermarkung_Marke" /> 
  							</xsl:call-template>
  						</vermarkung_Marke>
						<xsl:if test="count(./adv:relativeHoehe)=1">
							<relativeHoehe><xsl:value-of select="adv:relativeHoehe"/></relativeHoehe>
						</xsl:if>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Besondere Gebäudepunkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_BesondererGebaeudepunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>4000</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "4000" Text "Gebäudepunkt" setzen. -->
						<!-- Ggf. muss man hier landesspez. Regeln einbauen, wie punktnummer aus punktkennung abzuleiten ist. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/>
						</xsl:call-template>
						<xsl:call-template name="PunktortAG_Position">
							<xsl:with-param name="punkt" select="."/>
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Besondere Bauwerkspunkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_BesondererBauwerkspunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>5000</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "5000" Text ">Bauwerkspunkt" setzen. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/>
						</xsl:call-template>
						<xsl:call-template name="PunktortAG_Position">
							<xsl:with-param name="punkt" select="."/>
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Besondere topographische Punkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_BesondererTopographischerPunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>6000</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "6000" Text "Topographischer Punkt" setzen. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Lagefestpunkt -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Lagefestpunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<punkte>
					<AX_K_PUNKTE>
						<punktart>7000</punktart><!-- Falls bei AX_K_PUNKTE.punktart statt Datentyp AX_Punktart_K_PUNKTE als CodeList im Rahmen der Revision mittlerweile AX_Punktart_K_PUNKTE als Enumeration gesetzt ist, dann hier statt "7000" Text "Lagefestpunkt" setzen. -->
						<!-- Ggf. muss man hier landesspez. Regeln einbauen, wie punktnummer aus punktkennung abzuleiten ist. -->
						<punktnummer><xsl:value-of select="adv:punktkennung"/></punktnummer>
						<vermarkung_Marke>
							<xsl:call-template name="entschluesseln">
  								<xsl:with-param name="codelist">AX_Marke</xsl:with-param> 
  								<xsl:with-param name="code" select="adv:punktvermarkung" /> 
  							</xsl:call-template>
  						</vermarkung_Marke>
						<xsl:if test="count(./adv:relativeHoehe)=1">
							<relativeHoehe><xsl:value-of select="adv:relativeHoehe"/></relativeHoehe>
						</xsl:if>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
					</AX_K_PUNKTE>
				</punkte>
			</xsl:for-each>
			<!-- Grenzpunkte, auch indirekt abgemarkte -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Grenzpunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<grenzpunkt>
					<AX_K_GRENZPUNKT>
						<!-- Ggf. muss man hier landesspez. Regeln einbauen, wie punktnummer aus punktkennung abzuleiten ist. -->
						<!-- Falls bei AX_Grenzpunkt keine punktkennung vorhanden, dann mit "-" belegen. -->
						<punktnummer>
							<xsl:choose>
								<xsl:when test="adv:punktkennung=''">-</xsl:when>
								<xsl:otherwise><xsl:value-of select="adv:punktkennung"/></xsl:otherwise>
							</xsl:choose>
						</punktnummer>
						<vermarkung_Marke>
							<xsl:call-template name="entschluesseln">
  								<xsl:with-param name="codelist">AX_Marke</xsl:with-param> 
  								<xsl:with-param name="code" select="adv:punktvermarkung" /> 
  							</xsl:call-template>
  						</vermarkung_Marke>
						<xsl:if test="count(./adv:relativeHoehe)=1">
							<relativeHoehe><xsl:value-of select="adv:relativeHoehe"/></relativeHoehe>
						</xsl:if>
						<xsl:call-template name="PunktortAU_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
						<xsl:call-template name="PunktortTA_Position">
							<xsl:with-param name="punkt" select="."/> 
						</xsl:call-template>
						<xsl:if test="count(./adv:bemerkungZurAbmarkung)=1">
							<bemerkungZurAbmarkung><xsl:value-of select="adv:bemerkungZurAbmarkung"/></bemerkungZurAbmarkung>
						</xsl:if>
						<xsl:if test="count(./adv:zwischenmarke)=1">
							<zwischenmarke><xsl:value-of select="adv:zwischenmarke"/></zwischenmarke>
						</xsl:if>
						<xsl:if test="count(./adv:besonderePunktnummer)=1">
							<besonderePunktnummer><xsl:value-of select="adv:besonderePunktnummer"/></besonderePunktnummer>
						</xsl:if>
						<xsl:if test="count(./adv:ausgesetzteAbmarkung)=1">
							<ausgesetzteAbmarkung><xsl:value-of select="adv:ausgesetzteAbmarkung"/></ausgesetzteAbmarkung>
						</xsl:if>
						<xsl:for-each select="./adv:sonstigeEigenschaft">
							<sonstigeEigenschaft><xsl:value-of select="adv:sonstigeEigenschaft"/></sonstigeEigenschaft>
						</xsl:for-each>
					</AX_K_GRENZPUNKT>
				</grenzpunkt>
			</xsl:for-each>
			<xsl:variable name="system">
				<!--- über alle selektierten AX_PunktortAU und AX_PunktortTA -->
				<xsl:for-each select="document('E1.xml')//adv:AX_PunktortAU[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0] | document('E1.xml')//adv:AX_PunktortTA[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
					<xsl:choose>
						<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and (contains($poscrs,adv:position/gml:Point/gml:pos/@srsName) or contains($lagecrs,adv:position/gml:Point/gml:pos/@srsName) or contains($hoehencrs,adv:position/gml:Point/gml:pos/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="./adv:position/gml:Point/gml:pos/@srsName"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="./adv:position/gml:Point/@srsName and (contains($poscrs,adv:position/gml:Point/@srsName) or contains($lagecrs,adv:position/gml:Point/@srsName) or contains($hoehencrs,adv:position/gml:Point/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and (contains($poscrs,document('E1.xml')//gml:Envelope/@srsName) or contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName) or contains($hoehencrs,document('E1.xml')//gml:Envelope/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:variable>
			<CRS><xsl:value-of select="$system"/></CRS>
			<Koordinatenstatus>1000</Koordinatenstatus>
		</AX_Punktliste>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
