<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<xsl:variable name="filter" select="//ogc:Filter"/>
	<xsl:variable name="anlassart" select="//adv:art"/>
	<!-- =========================================================== -->
	<!-- Filter für AX_Reservierung -->
	<xsl:template name="Reservierung_Filter">
		<xsl:param name="ArtDerReservierung"/>
		<wfs:Query typeName="AX_Reservierung">		
			<ogc:Filter>
				<ogc:And>
					<ogc:PropertyIsEqualTo>				
						<ogc:PropertyName>art</ogc:PropertyName>				
						<ogc:Literal><xsl:value-of select="$ArtDerReservierung"/></ogc:Literal>			
					</ogc:PropertyIsEqualTo>
					<!-- Filter aus node set ohne Root <ogc:Filter> -->
					<xsl:copy-of select="$filter/*"/>
				</ogc:And>
			</ogc:Filter>
		</wfs:Query>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<adv:anforderungsmerkmale>
				<!-- Reservierungen -->
				<xsl:choose>
					<xsl:when test="$anlassart=2300">
						<!-- nur Überschrift, keine Abfrage -->
					</xsl:when>
					<!-- Aus Anlassart die ArtDerReservierung ermitteln und Abfrage bilden -->
					<xsl:when test="$anlassart=2310">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1000"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2311">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1300"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2312">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1400"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2314">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1500"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2315">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1700"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2316">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1800"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2317">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1900"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2318">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="1600"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2320">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="3000"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2331">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="4000"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$anlassart=2332">
						<xsl:call-template name="Reservierung_Filter">
							<xsl:with-param name="ArtDerReservierung" select="5000"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
				<!-- Besorge ausserdem alle Bundesländer, Gemeinden und Katasterämter mit deren Anschrift
					 zur Befüllung des AX_K_AUSGKOPF_Standard. Am einfachsten kann hier der Kopf dadurch gefüllt werden, 
					 indem der erzeugenden Komponente entsprechende Informationen hinterlegt werden.
				     Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
					 Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				     der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_Bundesland"/>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat/AX_Anschrift</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</adv:anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
