/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodelistDictionariesML
implements Target {
    protected final String dlma = "[";
    protected final String dlme = "]";
    protected final String defaultLang = "de";
    protected final String GML_NSABBR = "gml";
    protected final String GMX_NSABBR = "gmx";
    protected final String GMD_NSABBR = "gmd";
    protected final String GCO_NSABBR = "gco";
    protected final String XLINK_NSABBR = "xlink";
    protected String sLangs = null;
    protected String[] langs = null;
    protected ShapeChangeResult result = null;
    private PackageInfo pi = null;
    private Model model = null;
    protected Options options = null;
    private boolean diagnosticsOnly = false;
    private boolean printed = false;
    private final HashMap<String, Document> documentMap = new HashMap();
    private boolean newlineOmit = true;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        String pm = this.options.parameter(this.getClass().getName(), "noNewlineOmit");
        this.newlineOmit = pm == null || !pm.equalsIgnoreCase("true");
        this.sLangs = this.options.parameter(this.getClass().getName(), "languages");
        if (this.sLangs != null) {
            this.langs = this.sLangs.split(" ");
        }
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    @Override
    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (cat != 2 || !ci.asDictionary()) {
            return;
        }
        String tvn = this.options.parameter(this.getClass().getName(), "clPackageName");
        if (tvn != null && tvn.length() > 0 && !tvn.equalsIgnoreCase(ci.pkg().name())) {
            return;
        }
        Document cDocument = this.createDocument();
        this.createDictionary(ci, cDocument);
    }

    private void createDictionary(ClassInfo ci, Document cDocument) {
        Element et = null;
        boolean altLangFound = false;
        HashSet<Element> altExprs = new HashSet<Element>();
        for (String lang : this.langs) {
            Element et3;
            Element et2;
            if (lang.equalsIgnoreCase("de")) continue;
            Element eai = cDocument.createElement("gmx:ClAlternativeExpression");
            Element ea = cDocument.createElement("gmx:alternativeExpression");
            this.addAttribute(cDocument, eai, "gml:id", ci.name() + "_" + lang);
            this.addAttribute(cDocument, eai, "codeSpace", this.createClCodeSpaceContent(ci));
            Element et1 = this.createCodelistDescription(lang, ci, cDocument);
            if (et1 != null) {
                eai.appendChild(et1);
            }
            if ((et2 = this.createCodelistIdentifier(lang, ci, cDocument)) != null) {
                eai.appendChild(et2);
            }
            if ((et3 = this.createCodelistName(lang, ci, cDocument)) != null) {
                eai.appendChild(et3);
            }
            if (et1 == null && et3 == null || et2 == null) continue;
            et = cDocument.createElement("gmx:locale");
            String localeVal = this.options.parameter(this.getClass().getName(), "localeRef_" + lang);
            if (localeVal == null || localeVal.trim().length() == 0) {
                localeVal = "FIXME_MISSING_LOCALE_REF";
                this.result.addError("Configuration entry for locale reference is missing for language '" + lang + "' in class '" + ci.name() + "'");
            }
            this.addAttribute(cDocument, et, "xlink:href", localeVal);
            eai.appendChild(et);
            ea.appendChild(eai);
            altExprs.add(ea);
            altLangFound = true;
        }
        Element ec = null;
        ec = altLangFound ? this.createMlDocumentNamespace(ci.name(), cDocument) : this.createDocumentNamespace(ci.name(), cDocument);
        this.documentMap.put(ci.id(), cDocument);
        et = this.createCodelistDescription("de", ci, cDocument);
        if (et != null) {
            ec.appendChild(et);
        }
        if ((et = this.createCodelistIdentifier("de", ci, cDocument)) != null) {
            ec.appendChild(et);
        }
        if ((et = this.createCodelistName("de", ci, cDocument)) != null) {
            ec.appendChild(et);
        }
        this.createDictionaryProperties(ec, ci, cDocument);
        for (Element ea : altExprs) {
            ec.appendChild(ea);
        }
    }

    protected void createDictionaryProperties(Element ec, ClassInfo ci, Document cDocument) {
        for (PropertyInfo propi : ci.properties().values()) {
            Element e1 = this.createEntry(cDocument, ci, propi, true);
            if (e1 == null) continue;
            ec.appendChild(e1);
        }
        HashSet<String> ts = ci.supertypes();
        Iterator<String> i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.model.classById(i.next());
            if (cix == null) continue;
            for (PropertyInfo propi : cix.properties().values()) {
                Element e1 = this.createEntry(cDocument, ci, propi, true);
                if (e1 == null) continue;
                ec.appendChild(e1);
            }
        }
    }

    protected Element createDocumentNamespace(String gmlid, Document cDocument) {
        Element ec = cDocument.createElementNS(this.options.fullNamespace("gmx"), "gmx:CodeListDictionary");
        cDocument.appendChild(ec);
        this.addDocumentNamespaceAttributes(ec, cDocument);
        this.addAttribute(cDocument, ec, "gml:id", gmlid);
        this.addDocumentSchemaLocAttribute(ec, cDocument);
        return ec;
    }

    protected Element createMlDocumentNamespace(String gmlid, Document cDocument) {
        Element ec = cDocument.createElementNS(this.options.fullNamespace("gmx"), "gmx:ML_CodeListDictionary");
        cDocument.appendChild(ec);
        this.addDocumentNamespaceAttributes(ec, cDocument);
        this.addAttribute(cDocument, ec, "gml:id", gmlid);
        this.addDocumentSchemaLocAttribute(ec, cDocument);
        return ec;
    }

    protected void addDocumentNamespaceAttributes(Element ec, Document cDocument) {
        this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(cDocument, ec, "xmlns:gmx", this.options.fullNamespace("gmx"));
        this.addAttribute(cDocument, ec, "xmlns:gmd", this.options.fullNamespace("gmd"));
        this.addAttribute(cDocument, ec, "xmlns:gco", this.options.fullNamespace("gco"));
        this.addAttribute(cDocument, ec, "xmlns:xlink", this.options.fullNamespace("xlink"));
        this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    protected void addDocumentSchemaLocAttribute(Element ec, Document cDocument) {
        this.addAttribute(cDocument, ec, "xsi:schemaLocation", this.options.fullNamespace("gmx") + " " + this.options.schemaLocationOfNamespace(this.options.fullNamespace("gmx")));
    }

    protected Element createCodelistDescription(String lang, ClassInfo ci, Document cDocument) {
        Element e = null;
        String s = ci.documentation();
        if (s != null) {
            e = cDocument.createElementNS(this.options.GML_NS, "description");
            e.appendChild(cDocument.createTextNode(this.omitNewlineChar(s)));
        }
        return e;
    }

    protected Element createCodelistIdentifier(String lang, ClassInfo ci, Document cDocument) {
        Element e = null;
        if (this.options.gmlVersion.equals("3.2")) {
            e = cDocument.createElement("gml:identifier");
            this.addAttribute(cDocument, e, "codeSpace", this.createClCodeSpaceContent(ci));
            e.appendChild(cDocument.createTextNode(ci.name()));
        } else if (this.options.gmlVersion.equals("3.1")) {
            e = cDocument.createElement("gml:name");
            e.appendChild(cDocument.createTextNode(ci.name()));
        }
        return e;
    }

    protected Element createCodelistName(String lang, ClassInfo ci, Document cDocument) {
        Element e = null;
        e = cDocument.createElement("gml:name");
        e.appendChild(cDocument.createTextNode(ci.name()));
        return e;
    }

    protected Element createEntry(Document lDocument, ClassInfo ci, PropertyInfo propi, boolean local) {
        HashSet<Element> eas = this.createEntryAlternLangCode(lDocument, ci, propi);
        Element e = lDocument.createElement("gmx:codeEntry");
        Element eDef = this.createEntryDefinitionContent(lDocument, ci, propi, eas);
        if (eDef != null) {
            e.appendChild(eDef);
        }
        return e;
    }

    protected HashSet<Element> createEntryAlternLangCode(Document lDocument, ClassInfo ci, PropertyInfo propi) {
        HashSet<Element> eas = null;
        for (String lang : this.langs) {
            Element et3;
            Element et2;
            if (lang.equalsIgnoreCase("de")) continue;
            Element ea = lDocument.createElement("gmx:alternativeExpression");
            Element eai = lDocument.createElement("gmx:CodeAlternativeExpression");
            this.addAttribute(lDocument, eai, "gml:id", this.createEntryIdentifier(lang, ci, propi));
            this.addAttribute(lDocument, eai, "codeSpace", this.createCodesCodeSpaceContent(ci, propi));
            ea.appendChild(eai);
            Element et1 = this.createEntryDescription(lang, lDocument, ci, propi);
            if (et1 != null) {
                eai.appendChild(et1);
            }
            if ((et2 = this.createEntryIdentifier(lang, lDocument, ci, propi)) != null) {
                eai.appendChild(et2);
            }
            if ((et3 = this.createEntryName(lang, lDocument, ci, propi)) != null) {
                eai.appendChild(et3);
            }
            if (et1 == null && et3 == null || et2 == null) continue;
            Element et = lDocument.createElement("gmx:locale");
            this.addAttribute(lDocument, et, "xlink:href", this.options.parameter(this.getClass().getName(), "localeRef_" + lang));
            eai.appendChild(et);
            if (eas == null) {
                eas = new HashSet<Element>();
            }
            eas.add(ea);
        }
        return eas;
    }

    protected Element createEntryDefinitionContent(Document lDocument, ClassInfo ci, PropertyInfo propi, HashSet<Element> eas) {
        Element eDef = this.createEntryDefinition("de", lDocument, ci, propi, eas != null);
        if (eDef != null) {
            Element et = this.createEntryDescription("de", lDocument, ci, propi);
            if (et != null) {
                eDef.appendChild(et);
            }
            if ((et = this.createEntryIdentifier("de", lDocument, ci, propi)) != null) {
                eDef.appendChild(et);
            }
            if ((et = this.createEntryName("de", lDocument, ci, propi)) != null) {
                eDef.appendChild(et);
            }
            if (eas != null) {
                for (Element ea : eas) {
                    eDef.appendChild(ea);
                }
            }
        }
        return eDef;
    }

    protected Element createEntryDefinition(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi, boolean altEntryLangsExist) {
        Element e = altEntryLangsExist ? lDocument.createElement("gmx:ML_CodeDefinition") : lDocument.createElement("gmx:CodeDefinition");
        this.addAttribute(lDocument, e, "gml:id", this.createEntryIdentifier(lang, ci, propi));
        return e;
    }

    protected Element createEntryDescription(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi) {
        Element e = null;
        String s = propi.documentation();
        if (s != null) {
            e = lDocument.createElementNS(this.options.GML_NS, "description");
            e.appendChild(lDocument.createTextNode(this.omitNewlineChar(s)));
        }
        return e;
    }

    protected Element createEntryIdentifier(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi) {
        Element e = null;
        e = this.options.gmlVersion.equals("3.2") ? lDocument.createElement("gml:identifier") : lDocument.createElement("gml:name");
        this.addAttribute(lDocument, e, "codeSpace", this.createClCodeSpaceContent(ci));
        if (propi.initialValue() != null) {
            e.appendChild(lDocument.createTextNode(propi.initialValue()));
        } else {
            e.appendChild(lDocument.createTextNode(propi.name()));
        }
        return e;
    }

    protected Element createEntryName(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi) {
        Element e = null;
        e = lDocument.createElementNS(this.options.GML_NS, "name");
        e.appendChild(lDocument.createTextNode(propi.name()));
        return e;
    }

    protected String createClCodeSpaceContent(ClassInfo ci) {
        String codeSpace = ci.taggedValue("infoURL");
        if (codeSpace == null || codeSpace.trim().length() == 0) {
            codeSpace = this.options.parameter(this.getClass().getName(), "infoURL");
            if (codeSpace == null || codeSpace.trim().length() == 0) {
                codeSpace = ci.pkg().targetNamespace();
            }
            codeSpace = codeSpace + "/" + ci.name();
        }
        return codeSpace;
    }

    protected String createCodesCodeSpaceContent(ClassInfo ci, PropertyInfo propi) {
        String codeSpace = ci.taggedValue("infoURL");
        if (codeSpace == null || codeSpace.trim().length() == 0) {
            codeSpace = this.options.parameter(this.getClass().getName(), "infoURL");
            if (codeSpace == null || codeSpace.trim().length() == 0) {
                codeSpace = ci.pkg().targetNamespace();
            }
            codeSpace = codeSpace + "/" + ci.name();
        }
        return codeSpace;
    }

    protected String createEntryIdentifier(String lang, ClassInfo ci, PropertyInfo propi) {
        String id = "_" + propi.id();
        if (!lang.equalsIgnoreCase("de")) {
            id = id + "_" + lang;
        }
        return id;
    }

    protected String omitNewlineChar(String in) {
        if (this.newlineOmit && in != null) {
            return in.replaceAll("\r\n", " ");
        }
        return in;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        try {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (ClassInfo ci : this.model.classes(this.pi)) {
                File outDir;
                Document cDocument = this.documentMap.get(ci.id());
                if (cDocument == null) continue;
                String dir = this.options.parameter(this.getClass().getName(), "outputDirectory");
                if (dir == null) {
                    dir = this.options.parameter("outputDirectory");
                }
                if (dir == null) {
                    dir = this.options.parameter(".");
                }
                if (!(outDir = new File(dir)).exists()) {
                    outDir.mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(dir + "/" + ci.name() + ".xml");
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)cDocument);
                outputXML.close();
                this.result.addResult(this.getTargetID(), dir, ci.name() + ".xml", ci.qname());
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    @Override
    public int getTargetID() {
        return 8;
    }
}

