/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Options;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShapeChangeResult {
    protected Document document = null;
    protected Element root = null;
    protected Element messages = null;
    protected Element xsdfiles = null;
    protected Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
    protected Options options = null;

    public ShapeChangeResult(Options o) {
        this.options = o;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
            this.root = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "ShapeChangeResult");
            this.document.appendChild(this.root);
            this.root.setAttribute("resultCode", "0");
            this.root.setAttribute("xmlns", "http://www.interactive-instruments.de/ShapeChange/Result");
            this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.root.setAttribute("xsi:schemaLocation", "http://www.interactive-instruments.de/ShapeChange/Result http://www.interactive-instruments.de/ShapeChange/Result/ShapeChangeResult.xsd");
            this.messages = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Messages");
            this.root.appendChild(this.messages);
            this.xsdfiles = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "XSDFiles");
            this.root.appendChild(this.xsdfiles);
        }
        catch (ParserConfigurationException e) {
            System.err.println("Bootstrap Error: XML parser was unable to be configured.");
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bootstrap Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.outputFormat.setProperty("encoding", "ISO-8859-1");
        this.outputFormat.setProperty("indent", "yes");
        this.outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
    }

    private String safe(String s) {
        if (s == null) {
            return "<null>";
        }
        return s;
    }

    public void addDebug(int mnr, String p1, String p2, String p3) {
        this.addDebug(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", this.safe(p3)));
    }

    public void addDebug(int mnr, String p1, String p2) {
        this.addDebug(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addDebug(int mnr, String p1) {
        this.addDebug(this.message(mnr).replace("$1$", p1));
    }

    public void addDebug(int mnr) {
        this.addDebug(this.message(mnr));
    }

    public void addDebug(String m) {
        if (this.document == null || !this.options.reportLevel.equals("DEBUG")) {
            return;
        }
        System.err.println("D " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Debug");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addInfo(int mnr, String p1, String p2, String p3) {
        this.addInfo(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addInfo(int mnr, String p1, String p2) {
        this.addInfo(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addInfo(int mnr, String p1) {
        this.addInfo(this.message(mnr).replace("$1$", p1));
    }

    public void addInfo(int mnr) {
        this.addInfo(this.message(mnr));
    }

    public void addInfo(String m) {
        if (this.document == null || !this.options.reportLevel.equals("DEBUG") && !this.options.reportLevel.equals("INFO")) {
            return;
        }
        System.err.println("I " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Info");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addWarning(int mnr, String p1, String p2, String p3) {
        this.addWarning(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addWarning(int mnr, String p1, String p2) {
        this.addWarning(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addWarning(int mnr, String p1) {
        this.addWarning(this.message(mnr).replace("$1$", p1));
    }

    public void addWarning(int mnr) {
        this.addWarning(this.message(mnr));
    }

    public void addWarning(String m) {
        if (this.document == null || !this.options.reportLevel.equals("DEBUG") && !this.options.reportLevel.equals("INFO") && !this.options.reportLevel.equals("WARNING")) {
            return;
        }
        System.err.println("W " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Warning");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addError(int mnr, String p1, String p2, String p3) {
        this.addError(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addError(int mnr, String p1, String p2) {
        this.addError(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addError(int mnr, String p1) {
        this.addError(this.message(mnr).replace("$1$", p1));
    }

    public void addError(int mnr) {
        this.addError(this.message(mnr));
    }

    public void addError(String m) {
        if (this.document == null) {
            return;
        }
        System.err.println("E " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Error");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addFatalError(int mnr, String p1, String p2, String p3) {
        this.addFatalError(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addFatalError(int mnr, String p1, String p2) {
        this.addFatalError(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addFatalError(int mnr, String p1) {
        this.addFatalError(this.message(mnr).replace("$1$", p1));
    }

    public void addFatalError(int mnr) {
        this.addFatalError(this.message(mnr));
        this.setResultCode(1);
    }

    public void addFatalError(String m) {
        if (this.document == null) {
            return;
        }
        System.err.println("F " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "FatalError");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addXSDFile(String dname, String fname, String ns) {
        if (this.document == null) {
            return;
        }
        Element xsdfile = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "XSDFile");
        this.xsdfiles.appendChild(xsdfile);
        xsdfile.setAttribute("href", String.valueOf(dname) + "/" + fname);
        xsdfile.setAttribute("targetNamespace", ns);
        xsdfile.appendChild(this.document.createTextNode(fname));
    }

    public void setResultCode(int rc) {
        if (this.document == null) {
            return;
        }
        this.root.setAttribute("resultCode", Integer.toString(rc, 10));
    }

    public void toFile(String filename) {
        if (this.document == null) {
            return;
        }
        try {
            FileWriter outputXML = new FileWriter(filename);
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void toWriter(PrintWriter writer) {
        if (this.document == null) {
            return;
        }
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setWriter((Writer)writer);
            serializer.asDOMSerializer().serialize((Node)this.document);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void toOut() {
        if (this.document == null) {
            return;
        }
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setOutputStream((OutputStream)System.out);
            serializer.asDOMSerializer().serialize((Node)this.document);
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public Document asDOM() {
        return this.document;
    }

    protected String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Unable to get a document builder factory.";
            }
            case 2: {
                return "XML Parser was unable to be configured.";
            }
            case 3: {
                return "Invalid XMI file.";
            }
            case 4: {
                return "XMI version must be 1.0, found: $1$.";
            }
            case 5: {
                return "Exactly only element <XMI> expected.";
            }
            case 6: {
                return "Metamodel must be UML, found: $1$.";
            }
            case 7: {
                return "The UML version must be 1.3, found: $1$.";
            }
            case 8: {
                return "Exactly one element <XMI.metamodel> expected.";
            }
            case 9: {
                return "Class $1$ is not associated with a package.";
            }
            case 10: {
                return "Class $1$ in package $2$ is not associated with an XSD document.";
            }
            case 100: {
                return "The package with ID $1$ has no name. The ID is used instead.";
            }
            case 101: {
                return "Application schema $1$ with ID $2$ is not associated with an XML Schema document. A default name is used: $3$.";
            }
            case 102: {
                return "The class with ID $1$ has no name. The ID is used instead.";
            }
            case 1000: {
                return "Testing UML version 1.4.";
            }
            case 10000: {
                return "Added user-defined tagged value '$1$' for element with ID '$2$' with value: $3$.";
            }
            case 10001: {
                return "The package with ID $1$ and name '$2$' was created. Namespace: $3$.";
            }
        }
        return "(Unknown message)";
    }
}

