<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- Anlassart -->
	<xsl:variable name="anlassart"     select="//adv:art"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
			<wfs:Query typeName="AX_Dienststelle"><!-- Hier die Dienststelle + Anschrift für den Standardkopf selektieren, z.B. mittels Info AX_Gemarkung.istAmtsbezirkVon bzgl. katasterführender Behörde. -->
			 <XlinkPropertyPath>hat/AX_Anschrift</XlinkPropertyPath>
			 	<ogc:Filter>
					<ogc:PropertyIsEqualTo>
						<ogc:PropertyName>stellenart</ogc:PropertyName>
						<ogc:Literal>1100</ogc:Literal>
					</ogc:PropertyIsEqualTo>
				</ogc:Filter>
			</wfs:Query>
				<xsl:if test="$anlassart = '2210'">
					<!-- Gemarkung -->
					<wfs:Query typeName="AX_Gemarkung">
						<ogc:Filter>
							<ogc:And>
							 	<xsl:copy-of select="//ogc:Filter/*" /> 
								<!-- zeitliche Betrachtung -->
								<ogc:PropertyIsNull>
									<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
								</ogc:PropertyIsNull>
							</ogc:And>
						</ogc:Filter>					
					</wfs:Query>
					<!--  Besorge ausserdem alle Objekte der weiteren Objektarten. 
					      Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
						  Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
						  der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. --> 
					<!--  Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen der Gemarkung zugreifen. --> 
  					<wfs:Query typeName="AX_Flurstueck" />
  				</xsl:if>
				<xsl:if test="$anlassart = '2220' or $anlassart = '2221'">
					<!-- Gemeinde -->
					<wfs:Query typeName="AX_Kommunales Gebiet">
						<ogc:Filter>
							<ogc:And>
							 	<xsl:copy-of select="//ogc:Filter/*" /> 
								<!-- zeitliche Betrachtung -->
								<ogc:PropertyIsNull>
									<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
								</ogc:PropertyIsNull>
							</ogc:And>
						</ogc:Filter>					
					</wfs:Query>
					<!--  Besorge ausserdem alle Objekte der weiteren Objektarten. 
					      Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
						  Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
						  der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. --> 
					<!--  Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen der Gemeinde zugreifen. --> 
					<wfs:Query typeName="AX_Gemarkung" />
  					<wfs:Query typeName="AX_Flurstueck" />
  				</xsl:if> 
				<xsl:if test="$anlassart = '2230' or $anlassart = '2231'">
					<!-- Landkreis -->
					<wfs:Query typeName="AX_KreisRegion">
						<ogc:Filter>
							<ogc:And>
							 	<xsl:copy-of select="//ogc:Filter/*" /> 
								<!-- zeitliche Betrachtung -->
								<ogc:PropertyIsNull>
									<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
								</ogc:PropertyIsNull>
							</ogc:And>
						</ogc:Filter>					
					</wfs:Query>
					<!--  Besorge ausserdem alle Objekte der weiteren Objektarten. 
						  Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
						  Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
						  der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. --> 
					<!--  Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen des Landkreises zugreifen. --> 
					<wfs:Query typeName="AX_KommunalesGebiet" />
					<wfs:Query typeName="AX_Gemarkung" />
  					<wfs:Query typeName="AX_Flurstueck" />
  				</xsl:if> 
				<xsl:if test="$anlassart = '2240' or $anlassart = '2241'">
					<!-- Regierungsbezirk -->
					<wfs:Query typeName="AX_Regierungsbezirk">
						<ogc:Filter>
							<ogc:And>
							 	<xsl:copy-of select="//ogc:Filter/*" /> 
								<!-- zeitliche Betrachtung -->
								<ogc:PropertyIsNull>
									<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
								</ogc:PropertyIsNull>
							</ogc:And>
						</ogc:Filter>					
					</wfs:Query>
					<!--  Besorge ausserdem alle Objekte der weiteren Objektarten. 
						  Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
						  Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
						  der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. --> 
					<!--  Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen des Regierungsbezirks zugreifen. --> 
					<wfs:Query typeName="AX_KreisRegion" />
					<wfs:Query typeName="AX_KommunalesGebiet" />
					<wfs:Query typeName="AX_Gemarkung" />
  					<wfs:Query typeName="AX_Flurstueck" />
  				</xsl:if> 
				<xsl:if test="$anlassart = '2250' or $anlassart = '2251'">
					<!-- Bundesland -->
					<wfs:Query typeName="AX_Bundesland">
						<ogc:Filter>
							<ogc:And>
							 	<xsl:copy-of select="//ogc:Filter/*" /> 
								<!-- zeitliche Betrachtung -->
								<ogc:PropertyIsNull>
									<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
								</ogc:PropertyIsNull>
							</ogc:And>
						</ogc:Filter>					
					</wfs:Query>
					<!--  Besorge ausserdem alle Objekte der weiteren Objektarten. 
						  Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
						  Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
						  der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. --> 
					<!--  Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen des Bundeslandes zugreifen. --> 
					<wfs:Query typeName="AX_Regierungsbezirk" />
					<wfs:Query typeName="AX_KreisRegion" />
					<wfs:Query typeName="AX_KommunalesGebiet" />
					<wfs:Query typeName="AX_Gemarkung" />
  					<wfs:Query typeName="AX_Flurstueck" />
  				</xsl:if> 
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
