/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredNumber
implements Comparable<StructuredNumber> {
    public int[] components = null;

    public StructuredNumber(String sn) {
        String[] cmp = sn.split("\\.");
        this.components = new int[cmp.length];
        for (int i = 0; i < cmp.length; ++i) {
            try {
                this.components[i] = new Integer(cmp[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.components[i] = 0;
            }
        }
    }

    public StructuredNumber(int n) {
        this.components = new int[1];
        this.components[0] = n;
    }

    @Override
    public int compareTo(StructuredNumber sn) {
        int diff;
        int lth = this.components.length;
        int lsn = sn.components.length;
        int len = lth <= lsn ? lth : lsn;
        for (int i = 0; i < len; ++i) {
            diff = this.components[i] - sn.components[i];
            if (diff == 0) continue;
            return diff;
        }
        diff = lth - lsn;
        return diff;
    }

    public String getString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.components.length - 1; ++i) {
            sb.append(this.components[i] + ".");
        }
        sb.append(this.components[this.components.length - 1]);
        return sb.toString();
    }

    public StructuredNumber createCopyWithSuffix(int number) {
        return new StructuredNumber(this.getString() + "." + number);
    }

    public StructuredNumber createCopy() {
        return new StructuredNumber(this.getString());
    }

    public boolean equals(StructuredNumber sn) {
        if (sn == null) {
            return false;
        }
        if (this.components.length != sn.components.length) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == sn.components[i]) continue;
            result = false;
            break;
        }
        return result;
    }

    public String toString() {
        return this.getString();
    }
}

