<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml"
		xmlns:wfs="http://www.opengis.net/wfs"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
	
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('AX_Benutzungsauftrag.xml')//adv:formatangabe"/>
		<xsl:variable name="re1" select="substring-before(normalize-space(document('E1.xml')//gml:Envelope/gml:pos[1]),' ')"/><!-- Bezug von zuvor 'unklar' auf E1.xml gesetzt und aus Pfad "*" entfernt. -->
		<xsl:variable name="ho1" select="substring-after(normalize-space(document('E1.xml')//gml:Envelope/gml:pos[1]),' ')"/><!-- Bezug von zuvor 'unklar' auf E1.xml gesetzt und aus Pfad "*" entfernt. -->
		<xsl:variable name="re2" select="substring-before(normalize-space(document('E1.xml')//gml:Envelope/gml:pos[2]),' ')"/><!-- Bezug von zuvor 'unklar' auf E1.xml gesetzt und aus Pfad "*" entfernt. -->
		<xsl:variable name="ho2" select="substring-after(normalize-space(document('E1.xml')//gml:Envelope/gml:pos[2]),' ')"/><!-- Bezug von zuvor 'unklar' auf E1.xml gesetzt und aus Pfad "*" entfernt. -->
		<xsl:variable name="bboxAndDLKM">
			<ogc:And>
				<ogc:PropertyIsEqualTo>
					<ogc:PropertyName>modellart/AA_Modellart/advStandardModell</ogc:PropertyName>
					<ogc:Literal>DLKM</ogc:Literal>
				</ogc:PropertyIsEqualTo>
				<xsl:choose>
					<xsl:when test="$p3='DINA4 Hoch'"><!-- Hier stand vorher 1000, was DINA4 Hoch bedeutete. -->
						<ogc:BBOX xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml">
							<ogc:PropertyName>position</ogc:PropertyName>
							<gml:Envelope><!-- Formatierung der Envelope-Koordinaten sollte auf drei Nachkommastellen erfolgen. -->
								<gml:pos>
									<xsl:value-of select="(number($re1)+number($re2)) div 2 - 90"/><xsl:text> </xsl:text><!-- Hier fehlte der Abstand zw. den Koord. -->
									<xsl:value-of select="(number($ho1) +number ($ho2)) div 2 - 110"/>
								</gml:pos>
								<gml:pos>
									<xsl:value-of select="(number($re1)+number($re2)) div 2 + 90"/><xsl:text> </xsl:text><!-- Hier fehlte der Abstand zw. den Koord. -->
									<xsl:value-of select="(number ($ho1)+number ($ho2)) div 2 + 110"/>
								</gml:pos>
							</gml:Envelope>
						</ogc:BBOX>
					</xsl:when>
					<xsl:when test="$p3='DINA3 Quer'"><!-- Hier stand vorher 4000, was DINA3 Quer bedeutete. Problem: CharacterString in GID 5.1 bei FolgeVa.Formatangabe. -->
						<ogc:BBOX xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml">
							<ogc:PropertyName>position</ogc:PropertyName>
							<gml:Envelope><!-- Formatierung der Envelope-Koordinaten sollte auf drei Nachkommastellen erfolgen. -->
								<gml:pos>
									<xsl:value-of select="(number($re1)+number($re2)) div 2 - 190"/><xsl:text> </xsl:text><!-- Hier fehlte der Abstand zw. den Koord. -->
									<xsl:value-of select="(number($ho1) +number ($ho2)) div 2 - 110"/>
								</gml:pos>
								<gml:pos>
									<xsl:value-of select="(number($re1)+number($re2)) div 2 + 190"/><xsl:text> </xsl:text><!-- Hier fehlte der Abstand zw. den Koord. -->
									<xsl:value-of select="(number ($ho1)+number ($ho2)) div 2 + 110"/>
								</gml:pos>
							</gml:Envelope>
						</ogc:BBOX>
					</xsl:when>
				</xsl:choose>
			</ogc:And>
		</xsl:variable>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Selektion der relevanten Objekte -->
				<wfs:Query typeName="AX_Flurstueck">
					<XlinkPropertyPath>weistAuf/AX_LagebezeichnungMitHausnummer</XlinkPropertyPath>
					<XlinkPropertyPath>zeigtAuf/AX_LagebezeichnungOhneHausnummer</XlinkPropertyPath>
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/><!-- Hier statt value-of copy-of. Auch bei den weiteren. -->
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_BesondereFlurstuecksgrenze">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_PunktortTA">
					<ogc:Filter>
							<xsl:copy-of select="$bboxAndDLKM"/>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kartendarstellung</ogc:PropertyName>
								<ogc:Literal>true</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<!-- An AX_PunktortTA hängt immer ein Grenzpunkt, daher konnte hier weitere Filterbedingung 'Not PropertyIsNull auf istTeilVon/AX_Grenzpunkt/abmarkung' entfallen. -->
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_PunktortAU">
					<XlinkPropertyPath>istTeilVon</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<xsl:copy-of select="$bboxAndDLKM"/>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>kartendarstellung</ogc:PropertyName>
								<ogc:Literal>true</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:Or>
								<ogc:Not>
									<ogc:PropertyIsNull>
										<ogc:PropertyName>istTeilVon/AX_Aufnahmepunkt/vermarkung_Marke</ogc:PropertyName>
									</ogc:PropertyIsNull>
								</ogc:Not>
								<ogc:Not>
									<ogc:PropertyIsNull>
										<ogc:PropertyName>istTeilVon/AX_Grenzpunkt/abmarkung_Marke</ogc:PropertyName>
									</ogc:PropertyIsNull>
								</ogc:Not>
							</ogc:Or>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Gebaeude">
					<XlinkPropertyPath>zeigtAuf/AX_LagebezeichnungMitHausnummer</XlinkPropertyPath>
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Hafenbecken">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_StehendesGewaesser">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Meer">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Fliessgewaesser">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Wohnbauflaeche">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_IndustrieUndGewerbeflaeche">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Halde">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Bergbaubetrieb">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_TagebauGrubeSteinbruch">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_FlaecheBesondererFunktionalerPraegung">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_SportFreizeitUndErholungsflaeche">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Friedhof">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_FlaecheGemischterNutzung">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Landwirtschaft">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Wald">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Gehoelz">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Heide">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Moor">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Sumpf">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_UnlandVegetationsloseFlaeche">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Strassenverkehr">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Platz">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Weg">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Bahnverkehr">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Flugverkehr">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Schiffsverkehr">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_BauRaumOderBodenordnungsrecht">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_KlassifizierungNachStrassenrecht">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_KlassifizierungNachWasserrecht">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<!-- Neu: Hier auch KommunalesGebiet, weil gemeinde kreis regierungsbezirk in AX_Liegenschaftskarte benötigt werden. -->
				<wfs:Query typeName="AX_KommunalesGebiet">
					<ogc:Filter>
					 <ogc:Intersects>
					   <ogc:PropertyName>position</ogc:PropertyName>
					   <xsl:copy-of select="document('E1.xml')//adv:AX_Flurstueck/adv:position/*"/>
					   </ogc:Intersects>
					</ogc:Filter>
				</wfs:Query>
				<xsl:variable name="anlass" select="document('AX_Benutzungsauftrag.xml')//adv:art"/>
				<xsl:if test="$anlass='0120'"><!-- Liegenschaftskarte mit Bodenschätzung -->
				<wfs:Query typeName="AX_Bodenschaetzung">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_MusterLandesmusterUndVergleichsstueck">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_GrablochDerBodenschaetzung">
					<ogc:Filter>
						<xsl:copy-of select="$bboxAndDLKM"/>
					</ogc:Filter>
				</wfs:Query>
				</xsl:if>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
