/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xml.serializer.utils.XMLChar;

public abstract class ClassInfoImpl
extends InfoImpl
implements ClassInfo {
    protected int category = -1;
    protected int processed = 0;

    public String nsabr() {
        PackageInfo pi = this.pkg();
        if (pi != null) {
            return pi.xmlns();
        }
        return null;
    }

    public String ns() {
        PackageInfo pi = this.pkg();
        if (pi != null) {
            return pi.targetNamespace();
        }
        return null;
    }

    public String encodingRule(String platform) {
        String s = this.taggedValue(platform + "EncodingRule");
        if (s == null || s.isEmpty()) {
            PackageInfo pi = this.pkg();
            s = pi != null ? pi.encodingRule(platform) : super.encodingRule(platform);
        }
        if (s != null) {
            s = s.toLowerCase().trim();
        }
        return s;
    }

    public String xmlSchemaType() {
        return this.taggedValue("xmlSchemaType");
    }

    public boolean includeByValuePropertyType() {
        String s = this.taggedValue("byValuePropertyType");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean includePropertyType() {
        String s = this.taggedValue("noPropertyType");
        return s == null || !s.toLowerCase().equals("true");
    }

    public boolean isCollection() {
        String s = this.taggedValue("isCollection");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean asDictionary() {
        if (this.category() != 2) {
            return false;
        }
        String s = this.taggedValue("asDictionary");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean asDictionaryGml33() {
        if (this.category() != 2) {
            return false;
        }
        String s = this.taggedValue("asDictionary");
        return s == null || !s.toLowerCase().equals("false");
    }

    public boolean asGroup() {
        String s = this.taggedValue("gmlAsGroup");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean asCharacterString() {
        String s = this.taggedValue("gmlAsCharacterString");
        return s != null && s.toLowerCase().equals("true");
    }

    private boolean isMixin() {
        String tv;
        return this.matches("rule-xsd-cls-mixin-classes") && (tv = this.taggedValue("gmlMixin")) != null && tv.equals("true");
    }

    public void establishCategory() throws ShapeChangeAbortException {
        String s = this.stereotype().toLowerCase();
        if (s.equals("enumeration")) {
            this.category = 3;
        } else if (s.equals("codelist")) {
            this.category = 2;
        } else if (s.equals("schluesseltabelle") && this.matches("rule-xsd-cls-okstra-schluesseltabelle")) {
            this.category = 11;
        } else if (s.equals("fachid") && this.matches("rule-xsd-cls-okstra-fid")) {
            this.category = 12;
        } else if (s.equals("datatype")) {
            this.category = 5;
            if (this.isMixin()) {
                this.category = 4;
            }
        } else if (s.equals("union")) {
            this.category = 8;
        } else if (s.equals("featureconcept")) {
            this.category = 13;
        } else if (s.equals("attributeconcept")) {
            this.category = 14;
        } else if (s.equals("valueconcept")) {
            this.category = 15;
        } else if (s.equals("interface") && this.matches("rule-xsd-cls-mixin-classes")) {
            this.category = 4;
        } else if (s.equals("basictype") && this.matches("rule-xsd-cls-basictype")) {
            this.category = 7;
        } else if (s.equals("adeelement") && this.matches("rule-xsd-cls-adeelement")) {
            this.category = 1;
        } else if (s.equals("featuretype")) {
            this.category = 1;
            if (this.isMixin()) {
                this.category = 4;
            }
        } else if (s.equals("")) {
            this.category = 6;
            if (this.isMixin()) {
                this.category = 4;
            }
        } else if (s.equals("type")) {
            this.category = 6;
            if (this.isMixin() || this.isAbstract() && this.matches("rule-xsd-cls-mixin-classes")) {
                this.category = 4;
            }
        } else {
            this.result().addInfo(null, 11, this.name(), this.stereotype(), this.encodingRule("xsd"));
            this.category = -1;
        }
    }

    public int category() {
        return this.category;
    }

    public void fixIfCategoryIsUnknown() {
        if (this.category == -1 && this.supertypes() != null) {
            if (this.isAbstract() && this.checkSupertypes(4)) {
                this.category = 4;
            } else if (this.checkSupertypes(6)) {
                this.category = 6;
            } else if (this.checkSupertypes(1)) {
                this.category = 1;
            } else if (this.checkSupertypes(5)) {
                this.category = 5;
            } else {
                this.result().addWarning(null, 104, this.name());
            }
        }
    }

    public boolean inSchema(PackageInfo pi) {
        String ns1 = null;
        String ns2 = null;
        PackageInfo pi2 = this.pkg();
        if (pi2 != null) {
            ns1 = pi2.targetNamespace();
        }
        if (pi != null) {
            ns2 = pi.targetNamespace();
        }
        if (ns1 == null || ns2 == null) {
            return false;
        }
        return ns1.equals(ns2);
    }

    public String qname() {
        PackageInfo pi = this.pkg();
        if (pi != null) {
            return pi.xmlns() + ":" + this.name();
        }
        return this.name();
    }

    public boolean processed(int t) {
        return (this.processed & t) == t;
    }

    public void processed(int t, boolean p) {
        this.processed = p ? (this.processed |= t) : (this.processed &= ~t);
    }

    public boolean checkSupertypes(int cat) {
        HashSet<String> ts = this.supertypes();
        if (ts == null) {
            this.result().addDebug(null, 10003, this.name(), "" + cat, "TRUE");
            return true;
        }
        boolean res = true;
        Iterator<String> i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.model().classById(i.next());
            if (cix == null) continue;
            if (cix.category() == -1) {
                res = res && cix.checkSupertypes(cat);
            } else if (cix.category() != 4 && cix.category() != cat) {
                res = false;
            }
            if (res) continue;
            this.result().addDebug(null, 10003, this.name(), "" + cat, "FALSE");
            return res;
        }
        if (res) {
            this.result().addDebug(null, 10003, this.name(), "" + cat, "TRUE");
        } else {
            this.result().addDebug(null, 10003, this.name(), "" + cat, "FALSE");
        }
        return res;
    }

    private void checkForBasicType(ClassInfoImpl cibase, String rule) {
        if (this.category() == 7) {
            if (cibase != this) {
                cibase.category = 7;
            }
            return;
        }
        MapEntry me = this.options().baseMapEntry(this.name(), rule);
        if (me != null && !me.p2.equals("complex/complex")) {
            this.result().addDebug(this.qname() + " (" + this.category + ") is a basic type.");
            if (cibase != this) {
                cibase.category = 7;
            }
            return;
        }
        for (String cid : this.supertypes()) {
            ClassInfo cix = this.model().classById(cid);
            if (cix == null) continue;
            ((ClassInfoImpl)cix).checkForBasicType(cibase, rule);
        }
    }

    private void identifyBasicTypes() {
        if (this.category == 5 || this.category == 6 || this.category == 4) {
            this.checkForBasicType(this, this.encodingRule("xsd"));
        }
    }

    public boolean isSubtype(ClassInfo ci) {
        if (this == ci) {
            return true;
        }
        HashSet<String> idsuper = this.supertypes();
        for (String sid : idsuper) {
            ClassInfo sci = this.model().classById(sid);
            if (sci == null) continue;
            return sci.isSubtype(ci);
        }
        return false;
    }

    public boolean isKindOf(String supertype) {
        HashSet<String> st = this.supertypes();
        if (st != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                ClassInfo sti = this.model().classById(i.next());
                if (sti.name().equals(supertype)) {
                    return true;
                }
                if (!sti.isKindOf(supertype)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean suppressed() {
        String supval = this.taggedValue("suppress");
        if (supval != null && supval.equalsIgnoreCase("true")) {
            return true;
        }
        return this.stereotype().equalsIgnoreCase("adeelement");
    }

    public ClassInfo unsuppressedSupertype(boolean permitAbstract) {
        for (ClassInfo sci = this; sci != null; sci = sci.baseClass()) {
            if (sci.suppressed() || !permitAbstract && sci.isAbstract()) continue;
            return sci;
        }
        return null;
    }

    public boolean hasConstraint(String name) {
        Vector<Constraint> vc = this.constraints();
        for (Constraint c : vc) {
            if (!c.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String fullName() {
        return this.pkg().fullName() + "::" + this.name();
    }

    private void checkOverloading(ClassInfo cicurr) {
        HashSet<String> st;
        if (cicurr == null) {
            return;
        }
        this.result().addDebug(null, 10004, this.name(), cicurr.name());
        if (cicurr != this) {
            for (PropertyInfo aicurr : cicurr.properties().values()) {
                for (PropertyInfo ai : this.properties().values()) {
                    ShapeChangeResult.MessageContext mc;
                    if (aicurr == null || ai == null || !ai.name().equals(aicurr.name())) continue;
                    if (ai.cardinality().minOccurs < aicurr.cardinality().minOccurs && (mc = this.result().addError(null, 105, ai.name(), this.name(), cicurr.name())) != null) {
                        mc.addDetail(null, 400, "Package", this.pkg().fullName());
                    }
                    if (ai.cardinality().maxOccurs > aicurr.cardinality().maxOccurs && (mc = this.result().addError(null, 106, ai.name(), this.name(), cicurr.name())) != null) {
                        mc.addDetail(null, 400, "Package", this.pkg().fullName());
                    }
                    if (ai instanceof PropertyInfoImpl) {
                        ((PropertyInfoImpl)ai).restriction = true;
                    }
                    this.result().addInfo(null, 1002, ai.name(), this.name(), cicurr.name());
                }
            }
        }
        if ((st = cicurr.supertypes()) != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                this.checkOverloading(this.model().classById(i.next()));
            }
        }
    }

    public void postprocessAfterLoadingAndValidate() {
        String s;
        ShapeChangeResult.MessageContext mc;
        if (this.postprocessed) {
            return;
        }
        super.postprocessAfterLoadingAndValidate();
        if (this.pkg() == null && (mc = this.result().addError(null, 9, this.name())) != null) {
            mc.addDetail(null, 400, "Class", this.fullName());
        }
        if (this.matches("rule-xsd-cls-union-direct") && this.category == 8 && this.hasNilReason() && this.properties().size() == 2) {
            this.category = 9;
        }
        if (this.matches("rule-xsd-cls-unknown-as-object") && this.category == -1) {
            this.category = 6;
            mc = this.result().addInfo(null, 1004, this.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", this.fullName());
            }
        }
        this.fixIfCategoryIsUnknown();
        this.identifyBasicTypes();
        if (this.category() == 1 || this.category() == 6 || this.category() == 5 || this.category() == 8 && !this.asGroup()) {
            this.checkOverloading(this);
        }
        if (this.matches("req-xsd-cls-ncname") && !XMLChar.isValidNCName((String)(s = this.name())) && (mc = this.result().addError(null, 149, "class", s)) != null) {
            mc.addDetail(null, 400, "Class", this.fullName());
        }
        if (this.matches("req-xsd-cls-mixin-supertypes") && this.category() == 4 && !this.checkSupertypes(4) && (mc = this.result().addError(null, 115, this.name())) != null) {
            mc.addDetail(null, 400, "Class", this.fullName());
        }
        if (this.suppressed()) {
            if (this.matches("req-xsd-cls-suppress-supertype") && this.unsuppressedSupertype(false) == null && !this.stereotype().equalsIgnoreCase("adeelement") && (mc = this.result().addError(null, 142, this.name())) != null) {
                mc.addDetail(null, 400, "Class", this.fullName());
            }
            if (this.matches("req-xsd-cls-suppress-subtype")) {
                ShapeChangeResult.MessageContext mc2;
                boolean found = false;
                ClassInfo cix = null;
                for (String s0 : this.subtypes()) {
                    cix = this.model().classById(s0);
                    if (cix == null || cix.suppressed()) continue;
                    found = true;
                    break;
                }
                if (found && (mc2 = this.result().addError(null, 143, this.name(), cix.name())) != null) {
                    mc2.addDetail(null, 400, "Class", this.fullName());
                }
            }
            if (this.matches("req-xsd-cls-suppress-no-properties") && !this.properties().isEmpty() && !this.stereotype().equalsIgnoreCase("adeelement") && (mc = this.result().addError(null, 144, this.name())) != null) {
                mc.addDetail(null, 400, "Class", this.fullName());
            }
        }
        switch (this.category()) {
            case 3: {
                ShapeChangeResult.MessageContext mc3;
                HashSet<String> sc;
                if (!this.matches("req-xsd-cls-enum-no-supertypes") || (sc = this.supertypes()) == null || sc.size() <= 0 || (mc3 = this.result().addError(null, 125, this.name())) == null) break;
                mc3.addDetail(null, 400, "Class", this.fullName());
                break;
            }
            case 2: {
                HashSet<String> sc;
                ShapeChangeResult.MessageContext mc3;
                if (this.matches("req-xsd-cls-codelist-no-supertypes") && (sc = this.supertypes()) != null && sc.size() > 0 && (mc3 = this.result().addError(null, 127, this.name())) != null) {
                    mc3.addDetail(null, 400, "Class", this.fullName());
                }
                if (this.matches("req-xsd-cls-codelist-asDictionary-true")) {
                    s = this.taggedValue("asDictionary");
                    if (s == null || s.isEmpty()) {
                        mc = this.result().addWarning(null, 200, "asDictionary", this.name());
                        if (mc != null) {
                            mc.addDetail(null, 400, "Class", this.fullName());
                        }
                    } else if (!s.equalsIgnoreCase("true") && (mc = this.result().addError(null, 201, "asDictionary", this.name(), s)) != null) {
                        mc.addDetail(null, 400, "Class", this.fullName());
                    }
                }
                s = this.taggedValue("vocabulary");
                String s2 = this.taggedValue("extensibility");
                if (this.matches("req-xsd-cls-codelist-extensibility-values") && s2 != null && !s2.isEmpty() && !s2.equalsIgnoreCase("any") && !s2.equalsIgnoreCase("narrower") && (mc = this.result().addError(null, 201, "extensibility", this.name(), s2)) != null) {
                    mc.addDetail(null, 400, "Class", this.fullName());
                }
                if (!this.matches("req-xsd-cls-codelist-extensibility-vocabulary") || s2 == null || !s2.equalsIgnoreCase("narrower") || s != null && !s.isEmpty() || (mc = this.result().addError(null, 201, "extensibility", this.name(), s2)) == null) break;
                mc.addDetail(null, 400, "Class", this.fullName());
                break;
            }
            case 5: 
            case 8: {
                if (!this.matches("req-xsd-cls-datatype-noPropertyType")) break;
                s = this.taggedValue("noPropertyType");
                if (s == null || s.isEmpty()) {
                    mc = this.result().addWarning(null, 200, "noPropertyType", this.name());
                    if (mc == null) break;
                    mc.addDetail(null, 400, "Class", this.fullName());
                    break;
                }
                if (s.equalsIgnoreCase("false") || (mc = this.result().addError(null, 201, "noPropertyType", this.name(), s)) == null) break;
                mc.addDetail(null, 400, "Class", this.fullName());
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: {
                if (this.matches("req-xsd-cls-objecttype-noPropertyType")) {
                    s = this.taggedValue("noPropertyType");
                    if (s == null || s.isEmpty()) {
                        mc = this.result().addWarning(null, 200, "noPropertyType", this.name());
                        if (mc != null) {
                            mc.addDetail(null, 400, "Class", this.fullName());
                        }
                    } else if (!s.equalsIgnoreCase("false") && (mc = this.result().addError(null, 201, "noPropertyType", this.name(), s)) != null) {
                        mc.addDetail(null, 400, "Class", this.fullName());
                    }
                }
                if (!this.matches("req-xsd-cls-objecttype-byValuePropertyType")) break;
                s = this.taggedValue("byValuePropertyType");
                if (s == null || s.isEmpty()) {
                    mc = this.result().addWarning(null, 200, "byValuePropertyType", this.name());
                    if (mc == null) break;
                    mc.addDetail(null, 400, "Class", this.fullName());
                    break;
                }
                if (s.equalsIgnoreCase("false") || (mc = this.result().addError(null, 201, "byValuePropertyType", this.name(), s)) == null) break;
                mc.addDetail(null, 400, "Class", this.fullName());
            }
        }
        if (this.matches("req-xsd-cls-generalization-consistent") && (this.category() == 5 || this.category() == 1 || this.category() == 6)) {
            int count = 0;
            for (String cid : this.supertypes()) {
                ShapeChangeResult.MessageContext mc4;
                ClassInfo ci = this.model().classById(cid);
                if (ci == null) {
                    ShapeChangeResult.MessageContext mc5 = this.result().addError(null, 161, "Class", cid);
                    if (mc5 == null) continue;
                    mc5.addDetail(null, 400, "Class", this.fullName());
                    continue;
                }
                int cat = ci.category();
                if (cat == this.category()) {
                    if (++count != 2 || (mc4 = this.result().addError(null, 109, this.name())) == null) continue;
                    mc4.addDetail(null, 400, "Class", this.fullName());
                    continue;
                }
                if (cat == 4 && this.matches("rule-xsd-cls-mixin-classes") || (mc4 = this.result().addError(null, 108, this.name())) == null) continue;
                mc4.addDetail(null, 400, "Class", this.fullName());
            }
        }
        if (this.matches("req-all-all-documentation")) {
            s = this.documentation();
            if (!s.contains("-- Name --") && (mc = this.result().addError(null, 152, this.name(), "-- Name --")) != null) {
                mc.addDetail(null, 400, "Class", this.fullName());
            }
            if (!s.contains("-- Definition --") && (mc = this.result().addError(null, 152, this.name(), "-- Definition --")) != null) {
                mc.addDetail(null, 400, "Class", this.fullName());
            }
        }
        this.postprocessed = true;
    }
}

