/*
 * Decompiled with CFR 0.152.
 */
package us.mitre.ShapeChange.Model.GSIP;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.lang.SystemUtils;
import us.mitre.ShapeChange.Model.GSIP.AssociationInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.ClassInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.OclConstraintGSIP;
import us.mitre.ShapeChange.Model.GSIP.PackageInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.PropertyInfoGSIP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSIPDocument
extends ModelImpl
implements Model {
    public static final int STATUS_GSIPDOCUMENT_INITSTART = 101;
    public static final int STATUS_GSIPDOCUMENT_READMODEL = 102;
    public static final int STATUS_GSIPDOCUMENT_ESTABLISHCLASSES = 103;
    public static final int STATUS_GSIPDOCUMENT_READCONSTRAINTS = 104;
    public static final String OPTIONS_GSIPDOCUMENT_ENUMLITERALORDERPARAMNAME = "gsipEnumLiteralOrderBy";
    public Options options = null;
    public ShapeChangeResult result = null;
    protected final String characterEncoding = "Windows-1252";
    protected String enumLiteralSortType = "alpha";
    protected boolean suppressAssociationNames = false;
    protected boolean suppressAttributes = false;
    protected boolean suppressDatatypes = false;
    protected String kmlReferenceType = "alternate";
    protected Connection mdbConnection;
    static String[] gsipTags = new String[]{"kmlStyleUrl", "kmlReference", "asQueryResource", "fddQueryResource"};
    static String[] allGsipTags = new String[]{"mdbPK", "name", "documentation", "description", "note", "primaryCode", "secondaryCode", "codeList", "xsdDocument", "xsdEncodingRule", "kmlReference", "kmlStyleUrl", "kmlName", "kmlTimeSpanBegin", "kmlTimeSpanEnd", "kmlTimeStamp", "targetNamespace", "xmlns", "version", "gmlProfileSchema", "generationDateTime", "oclExpressions", "schPatterns", "constraints", "noPropertyType", "byValuePropertyType", "isCollection", "xmlSchemaType", "length", "lexical", "structureSpecification", "rangeMinimum", "rangeMaximum", "gmlAsGroup", "asDictionary", "enumComplete", "sequenceNumber", "inlineOrByReference", "isMetadata", "gmlImplementedByNilReason", "xsdAsAttribute", "valueMetadata", "Modified", "Identifier", "CreatorName", "CreatorPhone", "CreatorEmail", "PublisherName", "PublisherPhone", "PublisherEmail", "TopicCategories", "Views", "SubjectOther", "TopicCategoriesNamespace", "ViewsNamespace", "SubjectOtherNamespace", "ICISM_classification", "ICISM_ownerProducer", "ICISM_SCIcontrols", "ICISM_SARIdentifier", "ICISM_disseminationControls", "ICISM_FGIsourceOpen", "ICISM_FGIsourceProtected", "ICISM_releasableTo", "ICISM_nonICmarkings", "ICISM_classifiedBy", "ICISM_classificationReason", "ICISM_derivedFrom", "ICISM_declassDate", "ICISM_declassEvent", "ICISM_declassException", "ICISM_typeOfExemptedSource", "ICISM_dateOfExemptedSource", "ICISM_declassManualReview", "suppress", "codeList", "codeListValuePattern", "codeListRepresentation", "uomResourceURI", "uomResourceValuePattern", "uomResourceRepresentation", "physicalQuantity", "recommendedMeasure", "noncomparableMeasure"};
    HashMap<String, ClassInfoGSIP> fClassById = new HashMap(500);
    HashMap<String, ClassInfoGSIP> fClassByName = new HashMap(500);
    HashMap<String, PackageInfoGSIP> fPackageById = new HashMap(100);
    HashMap<String, AssociationInfoGSIP> fAssociationById = new HashMap(100);

    @Override
    public String normalizeTaggedValue(String tag) {
        if (this.allowedTags == null) {
            this.allowedTags = new HashSet(70);
            for (String s : gmlTags) {
                this.allowedTags.add(s);
            }
            for (String s : shapeChangeTags) {
                this.allowedTags.add(s);
            }
            for (String s : allGsipTags) {
                this.allowedTags.add(s);
            }
            for (String s : this.options.parameter("representTaggedValues").split("\\,")) {
                this.allowedTags.add(s);
            }
            for (String s : this.options.parameter("addTaggedValues").split("\\,")) {
                this.allowedTags.add(s);
            }
        }
        if (this.allowedTags.contains(tag)) {
            return tag;
        }
        if (tag.equals("xmlNamespace")) {
            return "targetNamespace";
        }
        if (tag.equals("xmlNamespaceAbbreviation")) {
            return "xmlns";
        }
        if (tag.equals("xsdName")) {
            return "xsdDocument";
        }
        if (tag.equals("asGroup")) {
            return "gmlAsGroup";
        }
        if (tag.equals("implementedByNilReason")) {
            return "gmlImplementedByNilReason";
        }
        if (tag.equals("nsgAlphaCode") || tag.equals("alphaCode")) {
            return "primaryCode";
        }
        if (tag.equals("dfddAlphaCode") || tag.equals("dfddCode") || tag.equals("schemaCode") || tag.equals("packageCode")) {
            return "secondaryCode";
        }
        if (tag.equals("gmlAsDictionary")) {
            return "asDictionary";
        }
        if (tag.equals("gmlNoPropertyType")) {
            return "noPropertyType";
        }
        if (tag.equals("gmlByValuePropertyType")) {
            return "byValuePropertyType";
        }
        if (tag.equals("gmlIsCollection")) {
            return "isCollection";
        }
        if (tag.equals("gmlIsMetadata")) {
            return "isMetadata";
        }
        if (tag.equalsIgnoreCase("gmlInlineOrByReference")) {
            return "inlineOrByReference";
        }
        if (tag.equals("xsdSuppress")) {
            return "suppress";
        }
        if (tag.equals("measure")) {
            return "recommendedMeasure";
        }
        return null;
    }

    public GSIPDocument() {
    }

    public GSIPDocument(ShapeChangeResult r, Options o, String mdbFileName) throws ShapeChangeAbortException {
        this.initialise(r, o, mdbFileName);
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String mdbFileName) throws ShapeChangeAbortException {
        String orderField;
        this.options = o;
        this.result = r;
        this.enumLiteralSortType = this.options.parameter(OPTIONS_GSIPDOCUMENT_ENUMLITERALORDERPARAMNAME);
        if (this.enumLiteralSortType != null && this.enumLiteralSortType.equalsIgnoreCase("alpha")) {
            orderField = "nsgAlphaCode";
        } else if (this.enumLiteralSortType != null && this.enumLiteralSortType.equalsIgnoreCase("integer")) {
            orderField = "dfddCode";
        } else {
            this.result.addWarning(null, 140, "enumeration literal ordering", this.enumLiteralSortType + ". Defaulting to alphabetical.");
            orderField = "nsgAlphaCode";
        }
        if (this.options.parameter("gsipSuppressDatatypes") != null && this.options.parameter("gsipSuppressDatatypes").equalsIgnoreCase("true")) {
            this.suppressDatatypes = true;
        }
        if (this.options.parameter("gsipSuppressAttributes") != null && this.options.parameter("gsipSuppressAttributes").equalsIgnoreCase("true")) {
            this.suppressAttributes = true;
        }
        this.kmlReferenceType = this.options.parameter("kmlReferenceType");
        if (this.kmlReferenceType == null || !this.kmlReferenceType.equalsIgnoreCase("alternate") && !this.kmlReferenceType.equalsIgnoreCase("standard") && !this.kmlReferenceType.equalsIgnoreCase("fdd")) {
            this.kmlReferenceType = "alternate";
        }
        File mdbFile = new File(mdbFileName);
        boolean ex = true;
        if (!mdbFile.exists()) {
            ex = false;
            if (!mdbFileName.toLowerCase().endsWith(".mdb")) {
                mdbFileName = mdbFileName + ".mdb";
                mdbFile = new File(mdbFileName);
                ex = mdbFile.exists();
            }
        }
        if (!ex) {
            r.addFatalError(null, 41, mdbFileName);
            throw new ShapeChangeAbortException();
        }
        String absname = mdbFile.getAbsolutePath();
        try {
            this.mdbConnection = this.openMDB(absname);
        }
        catch (SQLException e) {
            String errormsg = e.getMessage();
            r.addFatalError(null, 40, errormsg, mdbFileName);
            throw new ShapeChangeAbortException();
        }
        StatusBoard.getStatusBoard().statusChanged(102);
        try {
            ResultSet rstInherit;
            String strSQLInherit;
            Statement stmtInherit;
            try {
                this.createViewTables();
            }
            catch (SQLException e) {
                this.destroyViewTables();
                this.createViewTables();
            }
            Statement stmt = this.mdbConnection.createStatement();
            String sqlStr = "SELECT * FROM T_Schema ORDER BY applicationSchema DESC";
            ResultSet rstSchemas = stmt.executeQuery(sqlStr);
            ResultSetDynaClass schemasDyna = new ResultSetDynaClass(rstSchemas, false);
            for (DynaBean schemaRow : schemasDyna) {
                Map m = BeanUtils.describe((Object)schemaRow);
                HashMap<String, Object> schemaProperties = new HashMap<String, Object>(m);
                String schemaMdbUniqueId = (String)schemaProperties.get("itemIdentifier_PK");
                String schemaName = (String)schemaProperties.get("name");
                String xmlns = (String)schemaProperties.get("xmlns");
                if (xmlns != null) {
                    schemaProperties.put("subjectOther", xmlns.toUpperCase());
                }
                Statement stmtTemp = this.mdbConnection.createStatement();
                String sqlStrTemp = "SELECT DISTINCT alphaCode FROM TEMP_404_VIEWS WHERE schemaID = " + schemaMdbUniqueId + " ORDER BY alphaCode ASC";
                ResultSet rstTemp = stmtTemp.executeQuery(sqlStrTemp);
                StringBuffer viewSB = new StringBuffer();
                while (rstTemp.next()) {
                    viewSB.append(rstTemp.getString("alphaCode") + " ");
                }
                schemaProperties.put("views", viewSB.toString());
                rstTemp.close();
                sqlStrTemp = "SELECT DISTINCT tblISOTopicCategoryCode.name FROM tblISOTopicCategoryCode INNER JOIN (TEMP_404_VIEWS INNER JOIN T_InfoViewTopic ON TEMP_404_VIEWS.viewID = T_InfoViewTopic.view_FK) ON tblISOTopicCategoryCode.code = T_InfoViewTopic.topicCode WHERE TEMP_404_VIEWS.schemaID = " + schemaMdbUniqueId + " " + "ORDER BY tblISOTopicCategoryCode.name ASC";
                ResultSet rstTopicCategories = stmtTemp.executeQuery(sqlStrTemp);
                StringBuffer topicCatSB = new StringBuffer();
                while (rstTopicCategories.next()) {
                    topicCatSB.append(rstTopicCategories.getString("name") + " ");
                }
                schemaProperties.put("topicCategories", topicCatSB.toString());
                rstTopicCategories.close();
                stmtTemp.close();
                PackageInfoGSIP si = new PackageInfoGSIP(this, null, schemaProperties, true);
                this.fPackageById.put(schemaMdbUniqueId, si);
            }
            rstSchemas.close();
            stmt.close();
            String strSQLBundles = "SELECT T_SchemaPackage.*, T_Schema.name As schemaName FROM T_Schema INNER JOIN T_SchemaPackage ON T_Schema.itemIdentifier_PK = T_SchemaPackage.parentPackageID_FK AND (T_Schema.itemIdentifier_PK = T_SchemaPackage.schemaIdentifier_FK) ORDER BY T_SchemaPackage.itemIdentifier_PK";
            Statement stmtBundles = this.mdbConnection.createStatement();
            ResultSet rstBundles = stmtBundles.executeQuery(strSQLBundles);
            ResultSetDynaClass bundlesDyna = new ResultSetDynaClass(rstBundles, false);
            for (DynaBean bundleRow : bundlesDyna) {
                Map m = BeanUtils.describe((Object)bundleRow);
                HashMap<String, Object> bundleProperties = new HashMap<String, Object>(m);
                String bundleParentSchemaId = (String)bundleProperties.get("schemaIdentifier_FK");
                String bundleMdbUniqueId = (String)bundleProperties.get("itemIdentifier_PK");
                String bundleName = (String)bundleProperties.get("name");
                PackageInfoGSIP parentSchema = this.fPackageById.get(bundleParentSchemaId);
                PackageInfoGSIP bundle = new PackageInfoGSIP(this, parentSchema, bundleProperties, false);
                this.fPackageById.put(bundleMdbUniqueId, bundle);
                Statement stmtLeafPackages = this.mdbConnection.createStatement();
                String strSQLLeafPackages = "SELECT * FROM T_SchemaPackage where parentPackageID_FK = " + bundleMdbUniqueId + " " + "ORDER BY itemIdentifier_PK";
                ResultSet rstLeafPackages = stmtLeafPackages.executeQuery(strSQLLeafPackages);
                ResultSetDynaClass leavesDyna = new ResultSetDynaClass(rstLeafPackages, false);
                for (DynaBean leafRow : leavesDyna) {
                    Map m2 = BeanUtils.describe((Object)leafRow);
                    HashMap<String, Object> leafProperties = new HashMap<String, Object>(m2);
                    String leafMdbUniqueId = (String)leafProperties.get("itemIdentifier_PK");
                    String leafName = (String)leafProperties.get("name");
                    PackageInfoGSIP leaf = new PackageInfoGSIP(this, bundle, leafProperties);
                    this.fPackageById.put(leafMdbUniqueId, leaf);
                }
                rstLeafPackages.close();
                stmtLeafPackages.close();
            }
            rstBundles.close();
            stmtBundles.close();
            Set<String> keySet = this.fPackageById.keySet();
            for (String currPackageId : keySet) {
                PackageInfoGSIP currPackage = this.fPackageById.get(currPackageId);
                HashSet<String> supplierIds = new HashSet<String>();
                Statement stmtPackageDependencies = this.mdbConnection.createStatement();
                String strSQLPackageDependencies = "SELECT * FROM T_SchemaPackageDependency WHERE dependentPackageID_FK = " + currPackageId + " ORDER BY P_uniqueID";
                ResultSet rstPackageDependencies = stmtPackageDependencies.executeQuery(strSQLPackageDependencies);
                while (rstPackageDependencies.next()) {
                    String supplierPackageId = rstPackageDependencies.getString("dependsOnPackageID_FK");
                    if (supplierIds.contains(supplierPackageId)) continue;
                    supplierIds.add(supplierPackageId);
                }
                rstPackageDependencies.close();
                stmtPackageDependencies.close();
                currPackage.supplierIds = supplierIds;
            }
            Statement stmtDatatypes = this.mdbConnection.createStatement();
            String strSQLDatatypes = this.suppressDatatypes ? "SELECT * FROM T_InfoDatatype WHERE nsgAlphaCode = 'CharacterString'" : "SELECT * FROM T_InfoDatatype ORDER BY nsgAlphaCode";
            ResultSet rstDatatypes = stmtDatatypes.executeQuery(strSQLDatatypes);
            ResultSetDynaClass datatypesDyna = new ResultSetDynaClass(rstDatatypes, false);
            for (DynaBean dtRow : datatypesDyna) {
                Map m3 = BeanUtils.describe((Object)dtRow);
                HashMap<String, Object> dtProperties = new HashMap<String, Object>(m3);
                String datatypeMdbUniqueId = (String)dtProperties.get("itemIdentifier_PK");
                String packageId = (String)dtProperties.get("packageIdentifier_FK");
                PackageInfoGSIP parentPackage = this.fPackageById.get(packageId);
                ClassInfoGSIP dataType = new ClassInfoGSIP(this, parentPackage, dtProperties);
                this.fClassById.put(datatypeMdbUniqueId, dataType);
                this.fClassByName.put(dataType.name(), dataType);
            }
            rstDatatypes.close();
            stmtDatatypes.close();
            if (!this.suppressDatatypes) {
                ClassInfoGSIP listedValueDatatype = null;
                Statement stmtListedValues = this.mdbConnection.createStatement();
                String strSQLListedValues = "SELECT * FROM T_InfoDatatypeListedValue ORDER BY infoDatatype_FK, " + orderField + " ASC";
                ResultSet rstListedValues = stmtListedValues.executeQuery(strSQLListedValues);
                ResultSetDynaClass listedValuesDyna = new ResultSetDynaClass(rstListedValues, false);
                for (DynaBean listedValueRow : listedValuesDyna) {
                    Map m = BeanUtils.describe((Object)listedValueRow);
                    HashMap<String, Object> listedValueProperties = new HashMap<String, Object>(m);
                    String datatypeId = (String)listedValueProperties.get("infoDatatype_FK");
                    if (listedValueDatatype == null || !listedValueDatatype.gsipClassId.equalsIgnoreCase(datatypeId)) {
                        listedValueDatatype = this.fClassById.get(datatypeId);
                    }
                    PropertyInfoGSIP property = new PropertyInfoGSIP(this, listedValueDatatype, listedValueProperties, true);
                }
                rstListedValues.close();
                stmtListedValues.close();
            }
            Statement stmtEntities = this.mdbConnection.createStatement();
            String strSQLEntities = "SELECT * FROM T_InfoEntityType ORDER BY nsgAlphaCode";
            ResultSet rstEntities = stmtEntities.executeQuery(strSQLEntities);
            ResultSetDynaClass entitiesDyna = new ResultSetDynaClass(rstEntities, false);
            for (DynaBean entityRow : entitiesDyna) {
                Map m3 = BeanUtils.describe((Object)entityRow);
                HashMap<String, Object> entityProperties = new HashMap<String, Object>(m3);
                String entityMdbUniqueId = (String)entityProperties.get("itemIdentifier_PK");
                String entityName = (String)entityProperties.get("nsgAlphaCode");
                String packageId = (String)entityProperties.get("packageIdentifier_FK");
                String strSQLViews = "SELECT DISTINCT alphaCode FROM TEMP_404_VIEWS WHERE itemID = " + entityMdbUniqueId + " AND isEntity = True " + "ORDER BY alphaCode ASC";
                Statement stmtViews = this.mdbConnection.createStatement();
                ResultSet rstViews = stmtViews.executeQuery(strSQLViews);
                StringBuffer viewSB = new StringBuffer();
                while (rstViews.next()) {
                    viewSB.append(rstViews.getString("alphaCode") + " ");
                }
                entityProperties.put("views", viewSB.toString());
                rstViews.close();
                stmtViews.close();
                String strSQLTopicCategories = "SELECT DISTINCT tblISOTopicCategoryCode.name FROM tblISOTopicCategoryCode INNER JOIN (TEMP_404_VIEWS INNER JOIN T_InfoViewTopic ON TEMP_404_VIEWS.viewID = T_InfoViewTopic.view_FK) ON tblISOTopicCategoryCode.code = T_InfoViewTopic.topicCode WHERE TEMP_404_VIEWS.itemID = " + entityMdbUniqueId + " AND TEMP_404_VIEWS.isEntity = True " + "ORDER BY tblISOTopicCategoryCode.name ASC";
                Statement stmtTopicCategories = this.mdbConnection.createStatement();
                ResultSet rstTopicCategories = stmtTopicCategories.executeQuery(strSQLTopicCategories);
                StringBuffer topicCatSB = new StringBuffer();
                while (rstTopicCategories.next()) {
                    topicCatSB.append(rstTopicCategories.getString("name") + " ");
                }
                entityProperties.put("topicCategories", topicCatSB.toString());
                rstTopicCategories.close();
                stmtTopicCategories.close();
                PackageInfoGSIP parentPackage = this.fPackageById.get(packageId);
                ClassInfoGSIP entity = new ClassInfoGSIP(this, parentPackage, entityProperties);
                this.fClassById.put(entityMdbUniqueId, entity);
                this.fClassByName.put(entityName, entity);
            }
            rstEntities.close();
            stmtEntities.close();
            ClassInfoGSIP subClass = null;
            if (!this.suppressDatatypes) {
                stmtInherit = this.mdbConnection.createStatement();
                strSQLInherit = "SELECT * FROM T_InfoDatatypeInheritRelation ORDER BY datatypeSubType_FK";
                rstInherit = stmtInherit.executeQuery(strSQLInherit);
                while (rstInherit.next()) {
                    String superClassId;
                    ClassInfoGSIP superClass;
                    String subClassId = rstInherit.getString("datatypeSubType_FK");
                    if (subClass == null || !subClass.gsipClassId.equalsIgnoreCase(subClassId)) {
                        subClass = this.fClassById.get(subClassId);
                    }
                    if ((superClass = this.fClassById.get(superClassId = rstInherit.getString("datatypeSuperType_FK"))) == null) continue;
                    if (superClass.subclassInfoSet == null) {
                        superClass.subclassInfoSet = new HashSet();
                    }
                    superClass.subclassInfoSet.add(subClass);
                    if (++subClass.numBaseClasses == 1) {
                        subClass.baseclassInfo = superClass;
                        continue;
                    }
                    if (subClass.baseclassInfoSet == null) {
                        subClass.baseclassInfoSet = new HashSet();
                        subClass.baseclassInfoSet.add(subClass.baseclassInfo);
                        subClass.baseclassInfo = null;
                    }
                    subClass.baseclassInfoSet.add(superClass);
                }
                rstInherit.close();
                stmtInherit.close();
            }
            stmtInherit = this.mdbConnection.createStatement();
            strSQLInherit = "SELECT * FROM T_InfoInheritRelation ORDER BY entitySubType_FK";
            rstInherit = stmtInherit.executeQuery(strSQLInherit);
            ClassInfoGSIP entitySubClass = null;
            while (rstInherit.next()) {
                String entitySuperClassId;
                ClassInfoGSIP entitySuperClass;
                String entitySubClassId = rstInherit.getString("entitySubType_FK");
                if (entitySubClass == null || !entitySubClass.gsipClassId.equalsIgnoreCase(entitySubClassId)) {
                    entitySubClass = this.fClassById.get(entitySubClassId);
                }
                if ((entitySuperClass = this.fClassById.get(entitySuperClassId = rstInherit.getString("entitySuperType_FK"))) == null) continue;
                if (entitySuperClass.subclassInfoSet == null) {
                    entitySuperClass.subclassInfoSet = new HashSet();
                }
                entitySuperClass.subclassInfoSet.add(entitySubClass);
                if (++entitySubClass.numBaseClasses == 1) {
                    entitySubClass.baseclassInfo = entitySuperClass;
                    continue;
                }
                if (entitySubClass.baseclassInfoSet == null) {
                    entitySubClass.baseclassInfoSet = new HashSet();
                    entitySubClass.baseclassInfoSet.add(entitySubClass.baseclassInfo);
                    entitySubClass.baseclassInfo = null;
                }
                entitySubClass.baseclassInfoSet.add(entitySuperClass);
            }
            rstInherit.close();
            stmtInherit.close();
            if (!this.suppressAttributes && !this.suppressDatatypes) {
                Statement stmtDtElements = this.mdbConnection.createStatement();
                String strSQLDtElements = "SELECT * FROM T_InfoDatatypeElement ORDER BY infoDatatype_FK";
                ResultSet rstDtElements = stmtDtElements.executeQuery(strSQLDtElements);
                ClassInfoGSIP datatypeClass = null;
                ResultSetDynaClass dtElemDyna = new ResultSetDynaClass(rstDtElements, false);
                for (DynaBean dtElemRow : dtElemDyna) {
                    Map m2 = BeanUtils.describe((Object)dtElemRow);
                    HashMap<String, Object> dtElemProperties = new HashMap<String, Object>(m2);
                    String datatypeId = (String)dtElemProperties.get("infoDatatype_FK");
                    if (datatypeClass == null || !datatypeClass.gsipClassId.equalsIgnoreCase(datatypeId)) {
                        datatypeClass = this.fClassById.get(datatypeId);
                    }
                    PropertyInfoGSIP property = new PropertyInfoGSIP(this, datatypeClass, dtElemProperties);
                }
                rstDtElements.close();
                stmtDtElements.close();
                Statement stmtAttributes = this.mdbConnection.createStatement();
                String strSQLAttributes = "SELECT * FROM T_InfoAttribute ORDER BY infoEntity_FK";
                ResultSet rstAttributes = stmtAttributes.executeQuery(strSQLAttributes);
                ClassInfoGSIP entityClass = null;
                ResultSetDynaClass attDyna = new ResultSetDynaClass(rstAttributes, false);
                for (DynaBean attRow : attDyna) {
                    Map m2 = BeanUtils.describe((Object)attRow);
                    HashMap<String, Object> attProperties = new HashMap<String, Object>(m2);
                    String entityId = (String)attProperties.get("infoEntity_FK");
                    if (entityClass == null || !entityClass.gsipClassId.equalsIgnoreCase(entityId)) {
                        entityClass = this.fClassById.get(entityId);
                    }
                    PropertyInfoGSIP property = new PropertyInfoGSIP(this, entityClass, attProperties);
                }
                rstAttributes.close();
                stmtAttributes.close();
            }
            Statement stmtAssociations = this.mdbConnection.createStatement();
            String strSQLAssociations = "SELECT * FROM T_InfoEntityAssociation ORDER BY nsgAlphaCode";
            ResultSet rstAssociations = stmtAssociations.executeQuery(strSQLAssociations);
            ResultSetDynaClass assocDyna = new ResultSetDynaClass(rstAssociations, false);
            for (DynaBean assocRow : assocDyna) {
                String strSQLAssocRoles;
                Map m = BeanUtils.describe((Object)assocRow);
                HashMap<String, Object> assocProperties = new HashMap<String, Object>(m);
                String assocId = (String)assocProperties.get("itemIdentifier_PK");
                String assocName = (String)assocProperties.get("name");
                Statement stmtAssocRoles = this.mdbConnection.createStatement(1004, 1007);
                ResultSet rstAssocRoles = stmtAssocRoles.executeQuery(strSQLAssocRoles = "SELECT * FROM T_InfoAssociationRole WHERE infoEntityAssocId_FK = " + assocId + " ORDER BY entityIsOwner ASC");
                if (rstAssocRoles == null || !rstAssocRoles.absolute(2) || rstAssocRoles.absolute(3)) {
                    this.result.addWarning(null, 103, assocName, assocId, "(unknown)");
                } else {
                    rstAssocRoles.beforeFirst();
                    ResultSetDynaClass rolesDyna = new ResultSetDynaClass(rstAssocRoles, false);
                    Iterator roleRows = rolesDyna.iterator();
                    DynaBean supplierRow = (DynaBean)roleRows.next();
                    Map mSupplier = BeanUtils.describe((Object)supplierRow);
                    HashMap<String, Object> supplierRoleProperties = new HashMap<String, Object>(mSupplier);
                    DynaBean clientRow = (DynaBean)roleRows.next();
                    Map mClient = BeanUtils.describe((Object)clientRow);
                    HashMap<String, Object> clientRoleProperties = new HashMap<String, Object>(mClient);
                    String supplierRoleId = (String)supplierRoleProperties.get("itemIdentifier_PK");
                    String clientRoleId = (String)clientRoleProperties.get("itemIdentifier_PK");
                    AssociationInfoGSIP ai = new AssociationInfoGSIP(this, assocProperties, supplierRoleProperties, clientRoleProperties);
                    this.fAssociationById.put(assocId, ai);
                }
                rstAssocRoles.close();
                stmtAssocRoles.close();
            }
            rstAssociations.close();
            stmtAssociations.close();
            String check = this.options.parameter("checkingConstraints");
            if (check == null || !check.equalsIgnoreCase("disabled")) {
                Statement stmtConstraints = this.mdbConnection.createStatement();
                String strSQLConstraints = "SELECT * FROM T_InfoConstraint ORDER BY infoClass_FK, sequenceNumber";
                ResultSet rstConstraints = stmtConstraints.executeQuery(strSQLConstraints);
                ResultSetDynaClass constDyna = new ResultSetDynaClass(rstConstraints, false);
                for (DynaBean constRow : constDyna) {
                    Map m = BeanUtils.describe((Object)constRow);
                    HashMap<String, Object> constProperties = new HashMap<String, Object>(m);
                    String constId = (String)constProperties.get("itemIdentifier_PK");
                    String classId = (String)constProperties.get("infoClass_FK");
                    String constItemId = (String)constProperties.get("infoItem_FK");
                    ClassInfoGSIP ci = this.fClassById.get(classId);
                    if (ci != null) {
                        OclConstraintGSIP constraint = new OclConstraintGSIP(this, ci, constProperties);
                        if (constraint.syntaxTree() == null) continue;
                        ci.addConstraint(constraint);
                        continue;
                    }
                    this.result.addWarning(null, 1011, constId, classId);
                }
                rstConstraints.close();
                stmtConstraints.close();
            }
            this.destroyViewTables();
            HashSet<PackageInfo> schemas = this.schemas("");
            for (PackageInfo pi : schemas) {
                this.options.addSchemaLocation(pi.targetNamespace(), pi.xsdDocument());
            }
        }
        catch (Exception e) {
            String errormsg = e.toString();
            this.result.addFatalError(null, 42, errormsg, mdbFileName);
            throw new ShapeChangeAbortException();
        }
    }

    private Connection openMDB(String fileString) throws SQLException {
        StringBuffer databaseURL;
        if (SystemUtils.IS_OS_WINDOWS_7 && System.getProperty("sun.arch.data.model").equals("64")) {
            databaseURL = new StringBuffer("jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb, *.accdb);DBQ=");
            databaseURL.append(fileString);
        } else {
            databaseURL = new StringBuffer("jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=");
            databaseURL.append(fileString);
            databaseURL.append(";DriverID=22;READONLY=false}");
        }
        Connection con = DriverManager.getConnection(databaseURL.toString(), "", "");
        return con;
    }

    @Override
    public String characterEncoding() {
        return "Windows-1252";
    }

    @Override
    public ClassInfo classById(String id) {
        return this.fClassById.get(id);
    }

    @Override
    public ClassInfo classByName(String nam) {
        return this.fClassByName.get(nam);
    }

    @Override
    public HashSet<ClassInfo> classes(PackageInfo pi) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        for (Map.Entry<String, ClassInfoGSIP> entry : this.fClassById.entrySet()) {
            ClassInfo ci = entry.getValue();
            if (ci == null) continue;
            if (pi == null) {
                res.add(ci);
                continue;
            }
            if (!ci.inSchema(pi)) continue;
            res.add(ci);
        }
        return res;
    }

    @Override
    public PackageInfo packageById(String id) {
        return this.fPackageById.get(id);
    }

    @Override
    public HashSet<PackageInfo> schemas(String name) {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        for (PackageInfoGSIP pi : this.fPackageById.values()) {
            if (!pi.isSchema()) continue;
            if (name != null && !name.equals("")) {
                if (pi.name().equals(name)) {
                    res.add(pi);
                    continue;
                }
                if (name.equals(pi.taggedValue("name"))) {
                    res.add(pi);
                    continue;
                }
                if (!name.equals(pi.taggedValue("primaryCode"))) continue;
                res.add(pi);
                continue;
            }
            res.add(pi);
        }
        return res;
    }

    @Override
    public void shutdown() {
        if (this.mdbConnection != null) {
            try {
                this.mdbConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.mdbConnection = null;
        }
    }

    @Override
    public int type() {
        return 3;
    }

    private void createViewTables() throws SQLException {
        Statement stmt = this.mdbConnection.createStatement();
        stmt.execute("ALTER TABLE T_SchemaPackage ADD schemaIdentifier_FK Long");
        stmt.execute("UPDATE T_Schema INNER JOIN T_SchemaPackage ON T_Schema.itemIdentifier_PK = T_SchemaPackage.parentPackageID_FK SET T_SchemaPackage.schemaIdentifier_FK = T_Schema.itemIdentifier_PK");
        stmt.execute("UPDATE T_SchemaPackage INNER JOIN T_SchemaPackage AS T_SchemaPackage_1 ON T_SchemaPackage.parentPackageID_FK = T_SchemaPackage_1.itemIdentifier_PK SET T_SchemaPackage.schemaIdentifier_FK = T_SchemaPackage_1.schemaIdentifier_FK WHERE (((T_SchemaPackage_1.schemaIdentifier_FK) Is Not Null))");
        stmt.execute("UPDATE T_SchemaPackage INNER JOIN T_SchemaPackage AS T_SchemaPackage_1 ON T_SchemaPackage.parentPackageID_FK = T_SchemaPackage_1.itemIdentifier_PK SET T_SchemaPackage.schemaIdentifier_FK = T_SchemaPackage_1.schemaIdentifier_FK WHERE (((T_SchemaPackage_1.schemaIdentifier_FK) Is Not Null))");
        stmt.execute("CREATE TABLE TEMP_404_VIEWS (viewID integer, viewCode text, alphaCode text, itemID integer, schemaID integer, isEntity bit);");
        stmt.execute("INSERT INTO TEMP_404_VIEWS (viewID, viewCode, alphaCode, itemID, schemaID, isEntity ) SELECT T_InfoView.itemIdentifier_PK, T_InfoView.viewCode, T_InfoView.alphaCode, T_InfoEntityType.itemIdentifier_PK, T_Schema.itemIdentifier_PK, True FROM T_InfoView INNER JOIN ((T_Schema INNER JOIN (T_SchemaPackage INNER JOIN T_InfoEntityType ON T_SchemaPackage.itemIdentifier_PK = T_InfoEntityType.packageIdentifier_FK) ON T_Schema.itemIdentifier_PK = T_SchemaPackage.schemaIdentifier_FK) INNER JOIN T_InfoEntityView ON T_InfoEntityType.itemIdentifier_PK = T_InfoEntityView.infoEntity_FK) ON T_InfoView.itemIdentifier_PK = T_InfoEntityView.view_FK");
        stmt.execute("INSERT INTO TEMP_404_VIEWS (viewID, viewCode, alphaCode, itemID, schemaID, isEntity ) SELECT T_InfoView.itemIdentifier_PK, T_InfoView.viewCode, T_InfoView.alphaCode, T_InfoDatatype.itemIdentifier_PK, T_Schema.itemIdentifier_PK, False FROM T_InfoView INNER JOIN ((T_Schema INNER JOIN (T_SchemaPackage INNER JOIN T_InfoDatatype ON T_SchemaPackage.itemIdentifier_PK = T_InfoDatatype.packageIdentifier_FK) ON T_Schema.itemIdentifier_PK = T_SchemaPackage.schemaIdentifier_FK) INNER JOIN T_InfoDatatypeView ON T_InfoDatatype.itemIdentifier_PK = T_InfoDatatypeView.infoDatatype_FK) ON T_InfoView.itemIdentifier_PK = T_InfoDatatypeView.view_FK ");
        stmt.close();
    }

    private void destroyViewTables() {
        try {
            Statement stmt = this.mdbConnection.createStatement();
            try {
                stmt.execute("DROP TABLE TEMP_404_VIEWS;");
            }
            catch (SQLException q) {
                // empty catch block
            }
            try {
                stmt.execute("ALTER TABLE T_SchemaPackage DROP COLUMN schemaIdentifier_FK");
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static String getDescriptionString(String name, String definition, String description) {
        StringBuffer descriptionStringBuf = new StringBuffer();
        if (definition != null && definition.length() > 0) {
            descriptionStringBuf.append(definition);
        } else {
            descriptionStringBuf.append("<definition missing>");
        }
        if (description != null && description.length() > 0) {
            descriptionStringBuf.append(" [desc] " + description);
        }
        return descriptionStringBuf.toString();
    }

    protected static String getDocumentationString(String name, String definition, String description, String note) {
        StringBuffer documentationStringBuf = new StringBuffer();
        if (name != null && name.length() > 0) {
            documentationStringBuf.append(name);
        } else {
            documentationStringBuf.append("<name missing>");
        }
        if (definition != null && definition.length() > 0) {
            documentationStringBuf.append(": " + definition);
        }
        if (description != null && description.length() > 0) {
            documentationStringBuf.append(" [desc] " + description);
        }
        if (note != null && note.length() > 0) {
            documentationStringBuf.append(" [note] " + note);
        }
        return documentationStringBuf.toString();
    }
}

