/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashSet;

public abstract class ModelImpl
implements Model {
    protected boolean postprocessed = false;
    protected static String[] gmlTags = new String[]{"targetNamespace", "xmlns", "version", "xsdDocument", "gmlProfileSchema", "sequenceNumber", "noPropertyType", "byValuePropertyType", "isCollection", "asDictionary", "inlineOrByReference", "isMetadata", "defaultCodeSpace", "xmlSchemaType", "documentation", "resourceURI", "codeList"};
    protected static String[] jsonTags = new String[]{"jsonBaseURI", "jsonLayerTableURI", "jsonDirectory"};
    protected static String[] shapeChangeTags = new String[]{"xsdEncodingRule", "xsdAsAttribute", "xsdDerivation", "gmlAsGroup", "length", "maxLength", "base", "rangeMinimum", "rangeMaximum", "default", "nilReasonAllowed", "gmlImplementedByNilReason", "primaryCode", "secondaryCode", "oclExpressions", "schPatterns", "unitMeasure", "voidable", "description", "infoURL", "alias", "gmlAsCharacterString", "gmlMixin", "nillable", "suppress", "codeList", "codeListValuePattern", "codeListRepresentation", "uomResourceURI", "uomResourceValuePattern", "uomResourceRepresentation", "physicalQuantity", "recommendedMeasure", "noncomparableMeasure", "asXMLAttribute", "soft-typed", "parent", "AAA:Kennung", "AAA:Datum", "AAA:Organisation", "AAA:Modellart", "AAA:Profile", "AAA:Grunddatenbestand", "AAA:Nutzungsart", "AAA:Nutzungsartkennung", "AAA:objektbildend", "AAA:Themen", "AAA:Revisionsnummer", "reverseRoleNAS", "allowedTypesNAS"};
    HashSet<String> xsdDocNames;
    HashSet<String> classNames;
    protected HashSet<String> allowedTags = null;

    public void postprocessAfterLoadingAndValidate() {
        if (this.postprocessed) {
            return;
        }
        this.xsdDocNames = new HashSet();
        this.classNames = new HashSet();
        Options options = this.options();
        for (PackageInfo pi : this.schemas("")) {
            if (options.skipSchema(null, pi)) continue;
            this.classNames.clear();
            this.postprocessPackage(pi, true);
        }
        this.postprocessed = true;
    }

    private void postprocessPackage(PackageInfo pi, boolean processClasses) {
        String xsdDocName;
        if (pi == null) {
            return;
        }
        pi.postprocessAfterLoadingAndValidate();
        if (pi.matches("req-xsd-pkg-xsdDocument-unique") && (xsdDocName = pi.xsdDocument()) != null && !xsdDocName.trim().isEmpty()) {
            if (this.xsdDocNames.contains(xsdDocName)) {
                ShapeChangeResult.MessageContext mc = this.result().addError(null, 162, xsdDocName);
                if (mc != null) {
                    mc.addDetail(null, 400, "Package", pi.fullName());
                }
            } else {
                this.xsdDocNames.add(xsdDocName);
            }
        }
        if (processClasses) {
            for (ClassInfo ci : this.classes(pi)) {
                this.postprocessClass(ci);
            }
        }
        for (PackageInfo pi2 : pi.containedPackages()) {
            if (pi2.isSchema()) continue;
            this.postprocessPackage(pi2, false);
        }
    }

    private void postprocessClass(ClassInfo ci) {
        if (ci == null) {
            return;
        }
        ci.postprocessAfterLoadingAndValidate();
        if (ci.matches("req-xsd-cls-name-unique")) {
            String className = ci.name();
            if (this.classNames.contains(className)) {
                ShapeChangeResult.MessageContext mc = this.result().addError(null, 163, className, ci.pkg().targetNamespace());
                if (mc != null) {
                    mc.addDetail(null, 400, "Package", ci.fullName());
                }
            } else {
                this.classNames.add(className);
            }
        }
        if (ci.category() != 7 && ci.category() != 3 && ci.category() != 2) {
            for (PropertyInfo propi : ci.properties().values()) {
                this.postprocessProperty(propi);
            }
        }
    }

    private void postprocessProperty(PropertyInfo propi) {
        if (propi == null) {
            return;
        }
        propi.postprocessAfterLoadingAndValidate();
        if (!propi.isAttribute()) {
            this.postprocessAssociation(propi.association());
        }
    }

    private void postprocessAssociation(AssociationInfo ai) {
        if (ai == null) {
            return;
        }
        ai.postprocessAfterLoadingAndValidate();
    }

    public String normalizeTaggedValue(String tag) {
        if (this.allowedTags == null) {
            this.allowedTags = new HashSet(70);
            for (String s : gmlTags) {
                this.allowedTags.add(s);
            }
            for (String s : jsonTags) {
                this.allowedTags.add(s);
            }
            for (String s : shapeChangeTags) {
                this.allowedTags.add(s);
            }
            for (String s : this.options().parameter("representTaggedValues").split("\\,")) {
                this.allowedTags.add(s);
            }
            for (String s : this.options().parameter("addTaggedValues").split("\\,")) {
                this.allowedTags.add(s);
            }
        }
        if (tag.startsWith("RationalRose$UGAS:")) {
            tag = tag.substring(18);
        } else if (tag.startsWith("RationalRose$ShapeChange:")) {
            tag = tag.substring(25);
        } else if (tag.startsWith("RationalRose$")) {
            tag = tag.substring(13);
        }
        if (this.allowedTags.contains(tag)) {
            return tag;
        }
        if (tag.equals("xmlNamespace")) {
            return "targetNamespace";
        }
        if (tag.equals("xmlNamespaceAbbreviation")) {
            return "xmlns";
        }
        if (tag.equals("xsdName")) {
            return "xsdDocument";
        }
        if (tag.equals("asGroup")) {
            return "gmlAsGroup";
        }
        if (tag.equals("implementedByNilReason")) {
            return "gmlImplementedByNilReason";
        }
        return null;
    }
}

