/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.OperationInfoImpl;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.sparx.Collection;
import org.sparx.Method;
import org.sparx.MethodTag;
import org.sparx.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationInfoEA
extends OperationInfoImpl
implements OperationInfo {
    protected EADocument document = null;
    protected ClassInfoEA classInfo = null;
    protected String eaOperationId = null;
    protected String eaName = null;
    protected Type typeInfo = new Type();
    protected ClassInfoEA typeClassInfo = null;
    protected Method eaMethod = null;
    protected HashSet<String> stereotypesCache = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected Collection<Parameter> eaParametersCache = null;

    public OperationInfoEA(EADocument doc, ClassInfoEA ci, Method meth) {
        this.document = doc;
        this.classInfo = ci;
        this.eaMethod = meth;
        this.eaOperationId = ci.id();
        this.eaOperationId = this.eaOperationId + "_M";
        this.eaOperationId = this.eaOperationId + String.valueOf(this.eaMethod.GetMethodID());
        this.eaName = this.eaMethod.GetName();
        if (this.eaName != null) {
            this.eaName = this.eaName.trim();
        }
    }

    private void validateParametersCache() {
        if (this.eaParametersCache == null) {
            this.eaParametersCache = this.eaMethod.GetParameters();
        }
    }

    @Override
    public int parameterCount() {
        this.validateParametersCache();
        if (this.eaParametersCache == null) {
            return 0;
        }
        return this.eaParametersCache.GetCount() + 1;
    }

    @Override
    public TreeMap<Integer, String> parameterNames() {
        this.validateParametersCache();
        int count = 0;
        TreeMap<Integer, String> parms = new TreeMap<Integer, String>();
        if (this.eaParametersCache != null) {
            for (Parameter p : this.eaParametersCache) {
                String name = p.GetName();
                parms.put(++count, name);
            }
            parms.put(++count, "__RETURN__");
        }
        return parms;
    }

    @Override
    public TreeMap<Integer, String> parameterTypes() {
        this.validateParametersCache();
        int count = 0;
        TreeMap<Integer, String> parms = new TreeMap<Integer, String>();
        if (this.eaParametersCache != null) {
            for (Parameter p : this.eaParametersCache) {
                String type = p.GetType();
                parms.put(++count, type);
            }
            String ret = this.eaMethod.GetReturnType();
            parms.put(++count, ret);
        }
        return parms;
    }

    @Override
    public String id() {
        return this.eaOperationId;
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public String name() {
        return this.eaName;
    }

    @Override
    public String aliasName() {
        String a = super.aliasName();
        if (a == null || a.length() == 0) {
            this.aliasName = a = this.eaMethod.GetStyle();
        }
        return a;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaMethod.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            for (String stereotype : stereotypes) {
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st == null) continue;
                for (String s : Options.propertyStereotypes) {
                    if (!st.toLowerCase().equals(s)) continue;
                    this.stereotypesCache.add(s);
                }
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> i$ = this.stereotypesCache.iterator();
        if (i$.hasNext()) {
            String st = i$.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    private void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaMethod.GetTaggedValues();
            short ntvs = tvs.GetCount();
            this.taggedValuesCache = new HashMap(ntvs);
            for (MethodTag tv : tvs) {
                String t = tv.GetName();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = tv.GetValue();
                if (v.equals("<memo>")) {
                    v = tv.GetNotes();
                }
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }
}

