/**
 * AAA-Modellarttool
 *
 * The class in this file implements the ShapeChange Target interface to 
 * generate and load the 3AM files.
 *
 * (c) 2009-2012 Arbeitsgemeinschaft der Vermessungsverwaltungen der 
 * Länder der Bundesrepublik Deutschland (AdV)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact:
 * interactive instruments GmbH
 * Trierer Strasse 70-72
 * 53115 Bonn
 * Germany
 */

package de.adv_online.aaa.modellarttool;

import java.io.FileNotFoundException;
import java.io.FileReader;

import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Target.Target;

/**
 * @author Clemens Portele (portele <at> interactive-instruments <dot> de)
 *
 */
public class Modellart implements Target {

	public static final int TARGET_AAA_Modellarttool = 404;
	public static final int STATUS_WRITE_3AM = 31;
	public static final int STATUS_WRITE_MODEL = 32;
	public static final int STATUS_CLEAN_MODEL = 33;
	
	private PackageInfo pi = null;
	private Model model = null;
	private Options options = null;
	private ShapeChangeResult result = null;

	private String outputDirectory = null;
	private ModellartRep theMArt = null;
	private String quelle = null;
	private String ziel = null;
	private boolean error = false;
	
	public int getTargetID() {
		return TARGET_AAA_Modellarttool;
	}

	// FIXME New diagnostics-only flag is to be considered
	public void initialise(PackageInfo p, Model m, Options o,
			ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
		pi = p;
		model = m;
		options = o;
		result = r;
		
		String mart = "FIXME";

		if (!options.gmlVersion.equals("3.2")) {
			result.addError(null, 110, pi.name());
			return;
		}

		outputDirectory = options.parameter(this.getClass().getName(),"Verzeichnis");
		if (outputDirectory==null)
			outputDirectory = options.parameter("directory");
		if (outputDirectory==null)
			outputDirectory = options.parameter(".");

		String s = options.parameter(this.getClass().getName(),"Modellart");
		if (s!=null)
			mart = s.trim();
		
		s = options.parameter(this.getClass().getName(),"Quelle");
		if (s!=null)
			quelle = s.trim();
		
		s = options.parameter(this.getClass().getName(),"Ziel");
		if (s!=null)
			ziel = s.trim();

		if (ziel==null) {
			result.addError("Der Parameter 'Ziel' fehlt. Die Ausführung des Modellarttools wird abgebrochen");
			error = true;		
		} else if (quelle==null) {
			result.addError("Der Parameter 'Quelle' fehlt. Die Ausführung des Modellarttools wird abgebrochen");
			error = true;
		} else if (quelle.equals("Datei")) {
			try {
				theMArt = new ModellartRep(p, m, o, r, new FileReader(outputDirectory+"/"+mart+".3am"));
			} catch (FileNotFoundException e) {
				result.addError("Die 3am-Datei wurde nicht gefunden. Die Ausführung des Modellarttools wird abgebrochen");
				error = true;
			}
		} else if (quelle.equals("Modell")) {
			theMArt = new ModellartRep(p, m, o, r, mart );
		} else {
			result.addError("Der Parameter 'Quelle' hat den unbekannten Wert '"+quelle+"'. Die Ausführung des Modellarttools wird abgebrochen");
			error = true;
		}
	}
	
	public void process(ClassInfo ci) {}

	public void write() {
		if (error)
			return;

		if (ziel.equals("DateiModell")) {
			theMArt.writeToFile(outputDirectory+"/"+theMArt.name()+"__export.3am");
			theMArt.writeToModel();
			result.addResult(getTargetID(), outputDirectory, theMArt.name()+"__export.3am", options.parameter(this.getClass().getName(),"modellarten"));
		} else if (ziel.equals("Modell")) {
			theMArt.writeToModel();
		} else if (ziel.equals("Datei")) {
			theMArt.writeToFile(outputDirectory+"/"+theMArt.name()+"__export.3am");
			result.addResult(getTargetID(), outputDirectory, theMArt.name()+"__export.3am", options.parameter(this.getClass().getName(),"modellarten"));
		} else if (ziel.equals("Ohne")) {
			theMArt.clearInModel();
		} else {
			result.addError("Der Parameter 'Ziel' hat den unbekannten Wert '"+ziel+"'. Die Ausführung des Modellarttools wird abgebrochen");
			error = true;
		}
	}
}