﻿<?xml version="1.0" encoding="iso-8859-1"?>
<!-- (c) 2001-2010 interactive instruments GmbH, Bonn -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html" encoding="iso-8859-1"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master page-width="21cm" page-height="29.7cm" master-name="FC" margin-top="10mm" margin-bottom="5mm" margin-right="10mm" margin-left="25mm">
					<fo:region-body margin-bottom="20mm" margin-top="40mm"/>
					<fo:region-before region-name="xsl-region-before" extent="40mm"/>
					<fo:region-after region-name="xsl-region-after" extent="15mm"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="A4">
					<fo:repeatable-page-master-reference master-reference="FC"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block height="15mm" text-align="start" font-size="12pt" font-family="serif" border-style="solid" border-after-width="0.5pt" padding="2mm">
						<fo:table table-layout="fixed" inline-progression-dimension.optimum="1pt">
							<fo:table-column column-width="1in" border-style="none"/>
							<fo:table-column column-width="135mm" border-style="none"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block text-align="left">
											<fo:external-graphic content-height="0.6in" src="logo.bmp"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block text-align="center" font-size="8pt" font-weight="bold" line-height="26pt">ESDIN</fo:block>
										<fo:block text-align="center" font-size="14pt" font-weight="bold" line-height="22pt">Feature Catalogue <xsl:value-of select="FeatureCatalogue/name"/></fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block height="10mm" text-align-last="justify" font-size="10pt" font-family="serif" border-style="solid" border-before-width="0pt" padding="2mm">
						XXX
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block text-align="center" font-size="9pt" font-family="serif" line-height="20pt"><fo:leader leader-pattern="space" leader-length="100%"/></fo:block>
					<fo:block text-align="center" font-size="9pt" font-family="serif" line-height="20pt">Page <fo:page-number/>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block text-align="start" start-indent="0cm" font-size="10pt" font-family="serif" font-weight="bold" line-height="16pt">Version:</fo:block>
					<fo:block text-align="start" start-indent="1cm" font-size="10pt" font-family="serif" line-height="16pt"><xsl:value-of select="FeatureCatalogue/versionNumber"/></fo:block>
					<fo:block text-align="start" start-indent="0cm" font-size="10pt" font-family="serif" font-weight="bold" line-height="16pt">Date:</fo:block>
					<fo:block text-align="start" start-indent="1cm" font-size="10pt" font-family="serif" line-height="16pt"><xsl:value-of select="FeatureCatalogue/versionDate"/></fo:block>
					<fo:block text-align="start" start-indent="0cm" font-size="10pt" font-family="serif" font-weight="bold" line-height="16pt">Scope:</fo:block>
					<fo:block text-align="start" start-indent="1cm" font-size="10pt" font-family="serif" line-height="16pt"><xsl:value-of select="FeatureCatalogue/scope"/></fo:block>
					<fo:block text-align="start" start-indent="0cm" font-size="10pt" font-family="serif" font-weight="bold" line-height="16pt">Responsible organisation:</fo:block>
					<fo:block text-align="start" start-indent="1cm" font-size="10pt" font-family="serif" line-height="16pt"><xsl:value-of select="FeatureCatalogue/producer"/></fo:block>
					
					<fo:block id="overview">
					<fo:block text-align="start" start-indent="0cm" font-size="14pt" font-family="serif" font-weight="bold" line-height="16pt">Table of contents</fo:block>
					</fo:block>
					
<fo:table border="0.5pt solid black"
          text-align="start"
          border-spacing="3pt">
  <fo:table-column column-width="10cm"/>
  <fo:table-column column-width="4cm"/>
  <fo:table-header>
    <fo:table-row>
      <fo:table-cell background-color="silver">
        <fo:block text-align="start" font-weight="bold">
          Name
        </fo:block>
      </fo:table-cell>
      <fo:table-cell background-color="silver">
        <fo:block text-align="start" font-weight="bold">
          Type
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
  </fo:table-header>
  <fo:table-body>
  
      <xsl:for-each select="FeatureCatalogue/Package|FeatureCatalogue/ApplicationSchema">
        <xsl:sort select="./code"/>
        <xsl:sort select="./name"/>
        <xsl:variable name="package" select="." />

        <xsl:variable name="nftx" select="count(/FeatureCatalogue/FeatureType/package[attribute::idref=$package/@id])" />
        <xsl:if test="$nftx >= 0">

    <fo:table-row>
      <fo:table-cell background-color="silver">
        <fo:block text-align="start" font-weight="bold">
          Items:
        </fo:block>
      </fo:table-cell>
      <fo:table-cell padding="6pt" border="0.5pt solid black">
        <fo:block> 1 : 1 </fo:block>
      </fo:table-cell>
      <fo:table-cell padding="6pt" border="0.5pt solid black">
        <fo:block> 1 : 2 </fo:block>
      </fo:table-cell>
    </fo:table-row>
    <fo:table-row>
      <fo:table-cell padding="6pt" border="0.5pt solid black">
        <fo:block> 2 : 1 </fo:block>
      </fo:table-cell>
      <fo:table-cell padding="6pt" border="0.5pt solid black">
        <fo:block> 2 : 2 </fo:block>
      </fo:table-cell>
    </fo:table-row>
    
  </fo:table-body>
</fo:table>
      				

    <fo:table-row>
      <fo:table-cell background-color="silver">
        <fo:block text-align="start" font-weight="bold">
          Items:
        </fo:block>

          <TR>
            <TD bgcolor="#F0F0F0">
            <xsl:choose>
            	<xsl:when test="parent">
              <b>
			<xsl:text>Package: </xsl:text>
		 <a>                  
               <xsl:attribute name="href">#<xsl:value-of select="@id"/></xsl:attribute>
               <xsl:value-of select="name"/>
              </a>
              </b>
              <br/>
			<xsl:text>Parent: </xsl:text>
		 <a>                  
               <xsl:attribute name="href">#<xsl:value-of select="parent"/></xsl:attribute>
               <xsl:value-of select="name"/>
              </a>
            	</xsl:when>
            	<xsl:otherwise>
              <b>
			<xsl:text>Application Schema: </xsl:text>
		 <a>                  
               <xsl:attribute name="href">#<xsl:value-of select="@id"/></xsl:attribute>
               <xsl:value-of select="name"/>
              </a>
              </b>
            	</xsl:otherwise>
            </xsl:choose>
            </TD>
          </TR>
          <xsl:for-each select="/FeatureCatalogue/FeatureType/package[attribute::idref=$package/@id]">
            <xsl:sort select="../code"/>
		        <xsl:sort select="../name"/>
            <xsl:variable name="featuretype" select=".." />
             <TR>
              <TD bgcolor="#F0F0F0">
                      <a>                  
                        <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                        <xsl:value-of select="$featuretype/name"/>
                      </a>
              	<xsl:if test="$featuretype/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featuretype/lastChange"/></b></font></small></xsl:if>
                    </TD>
                    <td bgcolor="#F0F0F0">
                        <xsl:value-of select="$featuretype/type"/>
                    </td>
                    </TR>
          </xsl:for-each>
        </DIV>	
		  </xsl:if>
      </xsl:for-each>
    </TABLE>
				
					<xsl:for-each select="FC_FeatureCatalogue/AC_FeatureType/nutzungsartkennung|FC_FeatureCatalogue/FC_Value/nutzungsartkennung">
						<xsl:sort select="."/>
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template match="nutzungsartkennung">
		<xsl:variable name="nkn" select="."/>
		<xsl:variable name="nk">
			<xsl:value-of select="$nkn"/>
			<xsl:text> </xsl:text>
			<xsl:choose>
				<xsl:when test="count(following-sibling::nutzungsart)=1">
					<xsl:value-of select="following-sibling::nutzungsart[1]"/>
				</xsl:when>
				<xsl:when test="count(preceding-sibling::label)=1">
					<xsl:value-of select="preceding-sibling::label[1]"/>
				</xsl:when>
				<xsl:otherwise>(Bezeichnung fehlt)</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nkn mod 1000 = 0">
				<fo:block text-align="start" start-indent="0cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:when>
			<xsl:when test="$nkn mod 100 = 0">
				<fo:block text-align="start" start-indent="1cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:when>
			<xsl:when test="$nkn mod 10 = 0">
				<fo:block text-align="start" start-indent="2cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:block text-align="start" start-indent="3cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>



    

    <xsl:for-each select="FeatureCatalogue/Package|FeatureCatalogue/ApplicationSchema">
    <xsl:sort select="./code"/>
    <xsl:sort select="./name"/>
    <xsl:variable name="package" select="." />
    <xsl:variable name="nftx" select="count(/FeatureCatalogue/FeatureType/package[attribute::idref=$package/@id])" />
    <xsl:if test="$nftx >= 0">
      <HR/> 
      <H2>
        <A>
          <xsl:attribute name="name">
            <xsl:value-of select="@id"/>
          </xsl:attribute>
		<xsl:choose>
			<xsl:when test="count($package/parent)=1"><xsl:text>Package: </xsl:text></xsl:when>
			<xsl:otherwise><xsl:text>Application Schema: </xsl:text></xsl:otherwise>
		</xsl:choose>
          <xsl:value-of select="name"/>
        </A>
      </H2>
      <DIV>
            <xsl:if test="definition">
              <p><b>Definition</b></p>  
              <xsl:for-each select="definition"> 
                <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
              </xsl:for-each>
          </xsl:if>
            <xsl:if test="description">
              <p><b>Description</b></p>  
              <xsl:for-each select="description"> 
                <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
              </xsl:for-each>
          </xsl:if>
          <xsl:if test="versionNumber">
		    <P><b>Version:</b></P> 
		    <P STYLE="margin-left:20px"><xsl:value-of select="versionNumber"/></P>
          </xsl:if>
          <xsl:if test="versionDate">
		    <P><b>Date:</b></P>
		    <P STYLE="margin-left:20px"><xsl:value-of select="versionDate"/></P>
          </xsl:if>
          <xsl:if test="producer">
		    <P><b>Responsible organisation:</b></P>
		    <P STYLE="margin-left:20px"><xsl:value-of select="producer"/></P>
          </xsl:if>
      </DIV>
      <DIV>
        <xsl:variable name="nft2" select="count(diagram)" />
          <xsl:if test="$nft2 >= 1">
           <P><b><a>
            <xsl:attribute name="href"><xsl:value-of select="diagram/@src"/></xsl:attribute>
            Diagramm
           </a></b></P>
          </xsl:if>
      </DIV>
      <table>
        <tr>
          <td width="100%">
            <p align="right">
              <small>
                <a href="#overview">back to overview</a>
              </small>
            </p>
          </td>
          <td>
            <BR/>
          </td>
        </tr>
      </table>
      <xsl:for-each select="/FeatureCatalogue/FeatureType/package[attribute::idref=$package/@id]">
        <xsl:sort select="../code"/>
        <xsl:variable name="featuretype" select=".." />
              <BR/>
                <a> 
                  <xsl:attribute name="name">
                    <xsl:value-of select="$featuretype/@id"/>
                  </xsl:attribute>
                  <TABLE>
                    <TR>
                      <TD width="100%" bgcolor="#D0D0D0">
                        <big><b>
                         <xsl:variable name="nft2" select="count($featuretype/type)" />
                         <xsl:if test="$nft2 = 1">
                           <xsl:value-of select="$featuretype/type"/>: 
                         </xsl:if>
                         <xsl:value-of select="$featuretype/name"/>
                        </b></big>
              	<xsl:if test="$featuretype/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featuretype/lastChange"/></b></font></small></xsl:if>
                      </TD>
                      <td>
     					      <br/>
                      </td>
                    </TR>
                  </TABLE>
                </a>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/definition)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Definition:</b></P>
                      <xsl:for-each select="$featuretype/definition"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/description)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Description:</b></P>
                      <xsl:for-each select="$featuretype/description"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/code)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Code:</b></P>
                      <xsl:for-each select="$featuretype/code"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/subtypeOf)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Subtype of:</b></P>
                      <xsl:for-each select="$featuretype/subtypeOf">
                        <xsl:variable name="st" select="." />
                        <xsl:variable name="nft2" select="count(/child::FeatureCatalogue/child::FeatureType[child::name=$st])" />
                       	<xsl:choose>
                          <xsl:when test="./@idref">
                               <P STYLE="margin-left:20px">
                                 <a>                  
                                 <xsl:attribute name="href">#<xsl:value-of select="./@idref"/></xsl:attribute>
                                 <xsl:value-of select="$st"/>
                                 </a>
                               </P>
								  </xsl:when>
                          <xsl:when test="count(/child::FeatureCatalogue/child::FeatureType[child::name=$st]) = 0">
                             <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
								  </xsl:when>
                          <xsl:otherwise>
                             <xsl:for-each select="/FeatureCatalogue/FeatureType[child::name=$st]">
                               <P STYLE="margin-left:20px">
                                 <a>                  
                                 <xsl:attribute name="href">#<xsl:value-of select="./@id"/></xsl:attribute>
                                 <xsl:value-of select="$st"/>
                                 </a>
              	<xsl:if test="./lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="./lastChange"/></b></font></small></xsl:if>
                               </P>
                             </xsl:for-each>
                           </xsl:otherwise>
                       	 </xsl:choose>
                      </xsl:for-each>
                    </xsl:if>
                </DIV>
					 <DIV>
                  <xsl:variable name="nft" select="count(/FeatureCatalogue/FeatureAttribute[attribute::id=$featuretype/characterizedBy/@idref])" />
   
                    <P><b>Attributes:</b></P>
                    <xsl:choose>
                    <xsl:when test="$nft >= 1">
                        <UL>  
                          <xsl:for-each select="/FeatureCatalogue/FeatureAttribute[attribute::id=$featuretype/characterizedBy/@idref]">
                          <xsl:variable name="featureAtt" select="." />
                            
                                  <LI>
                                    <a>                  
                                      <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureAtt/@id"/></xsl:attribute>
                                      <xsl:value-of select="$featureAtt/name"/><xsl:if test="count($featureAtt/grunddatenbestand) >= 1"> (Grunddatenbestand)</xsl:if>
                                    </a>
              	<xsl:if test="$featuretype/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featuretype/lastChange"/></b></font></small></xsl:if>
                                  </LI>
                            
                          </xsl:for-each>
                        </UL>
						  </xsl:when>
						  <xsl:otherwise>
						    <P STYLE="margin-left:20px">none</P>
						  </xsl:otherwise>
						  </xsl:choose>

                </DIV>

                <DIV>
                  <xsl:variable name="nft" select="count(/FeatureCatalogue/RelationshipRole[attribute::id=$featuretype/characterizedBy/@idref])" />
                  
                    <P><b>Relations:</b></P>  
                    <xsl:choose>
                    <xsl:when test="$nft >= 1">
                        <UL>  
                        <xsl:for-each select="/FeatureCatalogue/RelationshipRole[attribute::id=$featuretype/characterizedBy/@idref]">
                          <xsl:variable name="featureRel" select="." />
                               <LI>
                                 <a>                  
                                    <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureRel/@id"/></xsl:attribute>
                                    <xsl:value-of select="$featureRel/name"/><xsl:if test="count($featureRel/grunddatenbestand) >= 1"> (Grunddatenbestand)</xsl:if>
                                  </a>
              	<xsl:if test="$featureRel/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featureRel/lastChange"/></b></font></small></xsl:if>
                               </LI>
                        </xsl:for-each>
                      </UL>
						  </xsl:when>
						  <xsl:otherwise>
						    <P STYLE="margin-left:20px">none</P>
						  </xsl:otherwise>
						  </xsl:choose>

				    </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count(/FeatureCatalogue/FeatureOperation[attribute::id=$featuretype/characterizedBy/@idref])" />
                  
                    <P><b>Operations:</b></P>  
                    <xsl:choose>
                    <xsl:when test="$nft >= 1">
                        <UL> 
                          <xsl:for-each select="/FeatureCatalogue/FeatureOperation[attribute::id=$featuretype/characterizedBy/@idref]">
                            <xsl:variable name="featureOpr" select="." />
                                 <LI>
                                   <a>                  
                                      <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureOpr/@id"/></xsl:attribute>
                                      <xsl:value-of select="$featureOpr/name"/>
                                    </a>
              	<xsl:if test="$featureOpr/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featureOpr/lastChange"/></b></font></small></xsl:if>
                                 </LI>
                          </xsl:for-each>
                        </UL>
						  </xsl:when>
						  <xsl:otherwise>
						    <P STYLE="margin-left:20px">none</P>
						  </xsl:otherwise>
						  </xsl:choose>

                </DIV>
                  
                  <DIV>
                    <xsl:variable name="nft" select="count($featuretype/note)" />
                      
                        <xsl:if test="$nft >= 1">
                          <b>Constraints:</b><br/> 
                          <table>
                           <tr>
                            <td width="20">
                             <BR/>
                            </td>
                            <td>
                             <xsl:for-each select="$featuretype/note">
                              <PRE> 
                              <xsl:value-of select="."/>
                              </PRE>
                             </xsl:for-each>
                            </td>
                           </tr>
                          </table>
                      </xsl:if>
                    
                  </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/diagram)" />
                  
                    <xsl:if test="$nft >= 1">
                      <xsl:for-each select="$featuretype/diagram">
	                    	<P><b><a>
                          <xsl:attribute name="href"><xsl:value-of select="./@src"/></xsl:attribute>
				Diagramm (<xsl:value-of select="./@src"/>)
   	                   </a></b></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                  <table>
                    <tr>
                      <td width="100%">
                        <p align="right">
                          <small>
                            <A>
                              <xsl:attribute name="href">#<xsl:value-of select="$package/@id"/></xsl:attribute>
                              back to package:
                              <xsl:value-of select="$package/name"/>
                            </A>
                          </small>
                        </p>
                      </td>
                      <td>
                        <BR/>
                      </td>
                    </tr>
                  </table>
                <DIV>
                  <xsl:for-each select="/FeatureCatalogue/FeatureAttribute[attribute::id=$featuretype/characterizedBy/@idref]">
                    <xsl:variable name="featureAtt" select="." />
                          <A> 
                            <xsl:attribute name="name">
                              <xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureAtt/@id"/>
                            </xsl:attribute>
                            <table>
                              <tr>
                                <td width="100%" bgcolor="#F0F0F0">
                                <b>
                                  Attribute: 
                                  <xsl:value-of select="$featureAtt/name"/>
                                </b>
              	<xsl:if test="$featureAtt/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featureAtt/lastChange"/></b></font></small></xsl:if>
                                </td>
                                <td>
										    <br/>
                                </td>
                              </tr>
                            </table>
                          </A>
                          <BR/>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/definition)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Definition:</b></P>

                                <xsl:for-each select="$featureAtt/definition"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>

                              </xsl:if>
                            
								  </DIV>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/description)+count($featureAtt/voidable)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Description:</b></P>

                                <xsl:for-each select="$featureAtt/description"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>

                                <xsl:if test="count($featureAtt/voidable) > 0">
                                  <P STYLE="margin-left:20px">This attribute is voidable.</P>
                               </xsl:if>

                              </xsl:if>
                            
								  </DIV>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/code)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Kennung:</b></P>

                                <xsl:for-each select="$featureAtt/code"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>

                              </xsl:if>
                            
								  </DIV>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/cardinality)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Multiplicity:</b></P>
                                <xsl:for-each select="$featureAtt/cardinality"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                              </xsl:if>
                            
								  </DIV>
                          <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/ValueDataType)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Value type:</b></P>
                                <xsl:for-each select="$featureAtt/ValueDataType"> 

                                  <xsl:variable name="dt" select="." />
                                  <xsl:variable name="nft2" select="count(/child::FeatureCatalogue/child::FeatureType[attribute::id=$dt/@idref])" />
                                  	<xsl:choose>
                                    <xsl:when test="$nft2 = 0">
                                     <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
												</xsl:when>
                                    <xsl:otherwise>
                                     <xsl:for-each select="/FeatureCatalogue/FeatureType">
                                      
                                       <xsl:if test=" @id = $dt/@idref">
                                        <P STYLE="margin-left:20px"><a>                  
                                         <xsl:attribute name="href">#<xsl:value-of select="$dt/@idref"/></xsl:attribute>
                                         <xsl:value-of select="$dt"/>
              	<xsl:if test="./lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="./lastChange"/></b></font></small></xsl:if>
                                        </a></P>
                                       </xsl:if>
                                     
                                    </xsl:for-each>
                                   </xsl:otherwise>
                                	</xsl:choose>
											 
                              
                                </xsl:for-each>
                              </xsl:if>
                            
                          
                            <xsl:if test=" $featureAtt/ValueDomainType = 1">
                              <P><b>Values:</b></P>
                              <TABLE>
                                <TR>
                                 <td width="20">
                                  <BR/>
                                 </td>
                                 <td><b>Label</b></td>
                                 <td><b>Code</b></td>
                                </TR>
                                <xsl:for-each select="/FeatureCatalogue/Value[attribute::id=$featureAtt/enumeratedBy/@idref]">
                                <xsl:variable name="fcvalue" select="." />
                                        <TR>
                                          <td width="20">
                                            <BR/>
                                          </td>
                                          <TD valign="top"><xsl:value-of select="$fcvalue/label"/>              	
                                          
              	<xsl:if test="$fcvalue/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$fcvalue/lastChange"/></b></font></small></xsl:if>
<xsl:if test="count($fcvalue/definition)>0"><table><tr><td width="20">&#160;</td><td><small><xsl:value-of select="$fcvalue/definition"/></small></td></tr></table></xsl:if></TD>
                                          <TD valign="top"><xsl:value-of select="$fcvalue/code"/></TD>
                                        </TR>
                                </xsl:for-each>
                              </TABLE>
                            </xsl:if>
                          
								  </DIV>
                            <table>
                              <tr>
                                <td width="100%">
                                  <p align="right">
                                    <small>
                                      <A>
                                        <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                                        back to:
                                        <xsl:value-of select="$featuretype/name"/>
                                      </A>
                                    </small>
                                  </p>
                                </td>
                                <td>
                                  <BR/>
                                </td>
                              </tr>
                            </table>
                  </xsl:for-each>
                </DIV>
                <DIV>
                  <xsl:for-each select="/FeatureCatalogue/RelationshipRole[attribute::id=$featuretype/characterizedBy/@idref]">
                  <xsl:variable name="featureRel" select="." />
                          <A> 
                            <xsl:attribute name="name">
                              <xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureRel/@id"/>
                            </xsl:attribute>
                            <table>
                              <tr>
                                <td width="100%" bgcolor="#F0F0F0">
                                <b>
                                  Relation: 
                                  <xsl:value-of select="$featureRel/name"/>
                                </b>
              	<xsl:if test="$featureRel/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featureRel/lastChange"/></b></font></small></xsl:if>
                                </td>
										  <td>
										    <br/>
                                </td>
                              </tr>
                            </table>
                          </A>
                          <BR/> 
                          <DIV>
                                <xsl:for-each select="/FeatureCatalogue/FeatureRelationship[attribute::id=$featureRel/relation/@idref]">
                                  
            				                  <xsl:if test="definition">
				                                <P><b>Definition:</b></P>
            					                    <xsl:for-each select="definition"> 
					                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
               					                 </xsl:for-each>
	                                      </xsl:if>
            				                  <xsl:if test="description">
				                                <P><b>Description:</b></P>
            					                    <xsl:for-each select="description"> 
					                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
               					                 </xsl:for-each>
	                                      </xsl:if>
                                 
  	                            </xsl:for-each>
								  </DIV>
                          <DIV>
                            
                              <xsl:if test="$featureRel/definition">
				                                <P><b>Definition:</b></P>
                                <xsl:for-each select="$featureRel/definition"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                              </xsl:if>

                              <xsl:if test="count($featureRel/description)+count($featureRel/voidable) > 0">
				                                <P><b>Description:</b></P>
                                <xsl:for-each select="$featureRel/description"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                                <xsl:if test="count($featureRel/voidable) > 0">
                                  <P STYLE="margin-left:20px">This relation is voidable.</P>
                               </xsl:if>
                              </xsl:if>

                            
								  </DIV>
                          <DIV>
                          <xsl:variable name="nft" select="count($featureRel/code)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Kennung:</b></P>
                                <xsl:for-each select="$featureRel/code"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                              </xsl:if>
                            
								  </DIV>
                          <P><b>Multiplicity:</b></P>
                          <table>
                            <tr>
                              <td width="20">
                                <BR/>
                              </td>
                              <td>
                                <xsl:value-of select="$featureRel/cardinality"/>
                                
                                  <xsl:if test="$featureRel/orderIndicator = 1">
                                    (geordnet)
                                  </xsl:if>
                                
                              </td>
                            </tr>
                          </table>
                          <P><b>Target feature type:</b></P>
                          <UL>
                            <xsl:for-each select="$featureRel/FeatureTypeIncluded">
                              <xsl:variable name="ftinc" select="." />
                              <LI>
                                  <xsl:variable name="nft" select="count(/child::FeatureCatalogue/child::FeatureType[attribute::id=$ftinc/@idref])" />
                                  	<xsl:choose>
                                    <xsl:when test="$nft = 0">
                                      <xsl:value-of select="$ftinc/@name"/>
												</xsl:when>
                                    <xsl:otherwise>
                                     <xsl:for-each select="/FeatureCatalogue/FeatureType[attribute::id=$ftinc/@idref]">
                                      
                                        <a>                  
                                         <xsl:attribute name="href">#<xsl:value-of select="$ftinc/@idref"/></xsl:attribute>
                                         <xsl:value-of select="$ftinc/@name"/>
                                        </a>
              	<xsl:if test="./lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="./lastChange"/></b></font></small></xsl:if>
                                     
                                    </xsl:for-each>
                                   </xsl:otherwise>
                                   </xsl:choose>
											 
                              </LI>  
                            <xsl:for-each select="$featureRel/InverseRole">
                              <xsl:variable name="ir" select="." />
                                  <xsl:for-each select="/FeatureCatalogue/RelationshipRole[attribute::id=$ir/@idref]">
                                    
      		                          <BR/>inverse relationship role to  
            		                    <a>
                                        <xsl:attribute name="href">#<xsl:value-of select="$ftinc/@idref"/>-<xsl:value-of select="@id"/></xsl:attribute>
                                        <xsl:value-of select="name"/>
		                                </a>   
              	<xsl:if test="./lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="./lastChange"/></b></font></small></xsl:if>
                                    
                                  </xsl:for-each>
                            </xsl:for-each>
                            </xsl:for-each>
                          </UL>
                          <table>
                            <tr>
                              <td width="100%">
                                <p align="right">
                                  <small>
                                    <A>
                                      <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                                      back to:
                                      <xsl:value-of select="$featuretype/name"/>
                                    </A>
                                  </small>
                                </p>
                              </td>
                              <td>
                                <BR/>
                              </td>
                            </tr>
                          </table>
                  </xsl:for-each>
                </DIV>
                <DIV>
                  <xsl:for-each select="/FeatureCatalogue/FeatureOperation[attribute::id=$featuretype/characterizedBy/@idref]">
                    <xsl:variable name="featureOpr" select="." />
                          <A> 
                            <xsl:attribute name="name">
                              <xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureOpr/@id"/>
                            </xsl:attribute>
                            <table>
                              <tr>
                                <td width="100%" bgcolor="#F0F0F0">
                                <b>
                                  Operation: 
                                  <xsl:value-of select="$featureOpr/name"/>
                                </b>
              	<xsl:if test="$featureOpr/lastChange"><xsl:text> </xsl:text><small><font color="red"><b>Changed: <xsl:value-of select="$featureOpr/lastChange"/></b></font></small></xsl:if>
                                </td>
                                <td>
                                  <BR/>
                                </td>
                              </tr>
                            </table>
                          </A>
                          
                            <xsl:if test="$featureOpr/definition">
                              <P><b>Definition:</b></P>
                              <xsl:for-each select="$featureOpr/definition"> 
                                <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                              </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$featureOpr/description">
                              <P><b>Description:</b></P>
                              <xsl:for-each select="$featureOpr/description"> 
                                <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                              </xsl:for-each>
                            </xsl:if>
                          
                            <table>
                              <tr>
                                <td width="100%">
                                  <p align="right">
                                    <small>
                                      <A>
                                        <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                                        back to:
                                        <xsl:value-of select="$featuretype/name"/>
                                      </A>
                                    </small>
                                  </p>
                                </td>
                                <td>
                                  <BR/>
                                </td>
                              </tr>
                            </table>
                  </xsl:for-each>
                </DIV> 
          
      </xsl:for-each>
     </xsl:if>
    </xsl:for-each>
  </body>
</html>
</xsl:template>
</xsl:stylesheet>
