/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Ocl.Token;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class Lexer {
    private Scanner inScan;
    private short serialNumber = 0;
    private boolean atStart = true;
    private Token eotToken = null;
    private short lineno = 0;
    private short baseOffset = 0;
    private Stack<Token> unfetchStack = new Stack();
    private Stack<Token> recordingStack = new Stack();
    private int checkpointCount = 0;
    private int commentStack = 0;
    private static String scanRegex = "\\s*((--.*)|(/\\*\\s*)|([a-zA-Z_]\\w*)|((?:\\d+\\.\\d*|\\d*\\.\\d+)(?:[eE][+-]?\\d+)?|\\d+[eE][+-]?\\d+)|(\\d+)|('(?:[^']|'')*')|\\(|\\)|\\[|\\]|\\{|\\}|=|<>|<=|>=|<|>|->|\\.\\+|-|\\*|/|\\||,|;|::|:|\\S)\\s*";
    private static String scanRegexComment = "((.*\\*/)|(.*/\\*)|(.*))";
    private static Pattern scanPattern = Pattern.compile(scanRegex, 8);
    private static Pattern scanPatternComment = Pattern.compile(scanRegexComment, 8);
    private static Pattern doubleQuotes = Pattern.compile("''");

    public Lexer(Readable inStream) {
        this.inScan = new Scanner(inStream);
    }

    public Token fetchToken() {
        Token token = this.fetchTokenProper();
        if (this.checkpointCount > 0) {
            this.recordingStack.push(token);
        }
        return token;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Token fetchTokenProper() {
        if (!this.unfetchStack.isEmpty()) {
            return this.unfetchStack.pop();
        }
        if (this.atStart) {
            this.atStart = false;
            if (!this.inScan.hasNextLine()) {
                this.eotToken = new Token.Operator(this.serialNumber, Token.Type.END_OF_TEXT);
                this.eotToken.setSourceReference((short)0, (short)0, (short)0);
            }
        }
        if (this.eotToken != null) {
            return this.eotToken;
        }
        Object var1_1 = null;
        short end = -1;
        String comment = "";
        do {
            Pattern pattern;
            String line;
            if ((line = this.inScan.findInLine(pattern = this.commentStack == 0 ? scanPattern : scanPatternComment)) != null) {
                void var1_13;
                short start;
                block25: {
                    MatchResult match = this.inScan.match();
                    line = match.group(1);
                    start = (short)match.start(1);
                    end = (short)(match.end(1) - 1);
                    if (this.commentStack > 0) {
                        if (match.end(2) - match.start(2) > 0) {
                            if (--this.commentStack == 0) {
                                short s = this.serialNumber;
                                this.serialNumber = (short)(s + 1);
                                Token.Comment comment2 = new Token.Comment(s, comment + line);
                                comment = "";
                                break block25;
                            } else {
                                comment = comment + line;
                                continue;
                            }
                        }
                        if (match.end(3) - match.start(3) > 0) {
                            ++this.commentStack;
                            comment = comment + line;
                            continue;
                        }
                        short s = this.serialNumber;
                        this.serialNumber = (short)(s + 1);
                        Token.Comment comment3 = new Token.Comment(s, comment + line);
                        comment = "";
                    } else {
                        Object var1_5 = null;
                        Token.Type type = Token.getTypeFromLexicalString(line);
                        if (type != null) {
                            short s = this.serialNumber;
                            this.serialNumber = (short)(s + 1);
                            Token.Operator operator = new Token.Operator(s, type);
                        } else if (match.end(2) - match.start(2) > 0) {
                            short s = this.serialNumber;
                            this.serialNumber = (short)(s + 1);
                            Token.Comment comment4 = new Token.Comment(s, line);
                        } else {
                            if (match.end(3) - match.start(3) > 0) {
                                ++this.commentStack;
                                comment = line;
                                continue;
                            }
                            if (match.end(4) - match.start(4) > 0) {
                                short s = this.serialNumber;
                                this.serialNumber = (short)(s + 1);
                                Token.Identifier identifier = new Token.Identifier(s, line);
                            } else if (match.end(5) - match.start(5) > 0) {
                                short s = this.serialNumber;
                                this.serialNumber = (short)(s + 1);
                                Token.Number number = new Token.Number(s, line, false);
                            } else if (match.end(6) - match.start(6) > 0) {
                                short s = this.serialNumber;
                                this.serialNumber = (short)(s + 1);
                                Token.Number number = new Token.Number(s, line, true);
                            } else if (match.end(7) - match.start(7) > 0) {
                                line = line.substring(1, line.length() - 1);
                                short s = this.serialNumber;
                                this.serialNumber = (short)(s + 1);
                                Token.Text text = new Token.Text(s, doubleQuotes.matcher(line).replaceAll("'"));
                            } else {
                                short s = this.serialNumber;
                                this.serialNumber = (short)(s + 1);
                                Token.Illegal illegal = new Token.Illegal(s, line);
                            }
                        }
                    }
                }
                var1_13.setSourceReference(this.lineno, start, end);
                return var1_13;
            }
            if (!this.inScan.hasNextLine()) continue;
            this.inScan.nextLine();
            this.baseOffset = (short)this.inScan.match().end();
            this.lineno = (short)(this.lineno + 1);
            end = -1;
        } while (this.inScan.hasNextLine());
        this.eotToken = new Token.Operator(this.serialNumber, Token.Type.END_OF_TEXT);
        this.eotToken.setSourceReference(this.lineno, (short)(end + 1), (short)(end + 1));
        return this.eotToken;
    }

    public void unfetchToken(Token token) {
        assert (this.checkpointCount <= 0 || !this.recordingStack.isEmpty() && this.recordingStack.peek() == token) : "Token recording stack is out of sync.";
        if (this.checkpointCount > 0) {
            this.recordingStack.pop();
        }
        this.unfetchStack.push(token);
    }

    public Checkpoint captureState() {
        Checkpoint chp = new Checkpoint();
        chp.checkpoint_index = this.recordingStack.size();
        ++this.checkpointCount;
        return chp;
    }

    public void releaseState(Checkpoint chp) {
        --this.checkpointCount;
        assert (this.checkpointCount >= 0) : "Lexer checkpointing out of balance.";
        if (this.checkpointCount == 0) {
            this.recordingStack.clear();
        }
    }

    public void restoreState(Checkpoint chp) {
        for (int i = this.recordingStack.size(); i > chp.checkpoint_index; --i) {
            this.unfetchToken(this.recordingStack.peek());
        }
        --this.checkpointCount;
    }

    public static class Checkpoint {
        private int checkpoint_index;
    }
}

