<?xml version="1.0" encoding="UTF-8"?>
<!-- Suchbegriffe für Fragen zur GID 5.1 -->
<!-- Anlassart 0701 Bestandsnachweis Grunddatenbestand fehlt noch in CL AX_Anlassart_Benutzungsauftrag. --><!-- 05.04.2006: Änderung wird veranlasst. --> 
<!-- AX_FestlegungSonstigeORF.besondereFunktionForst muß noch Kardinalität 0..1 bekommen --><!-- 05.04.2006: Änderung wird veranlasst. -->
<!-- Hier fehlte vorher ./ -->
<!-- Erweitert für AFIS: xmlns:date -->

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1"
	xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA"
	xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
	xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
		  
	<!-- ==================================================== -->
	<!-- !!!! AFIS-Ergänzungen !!!! -->
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Positionssystem">
		<xsl:param name="punktort"/>
		<xsl:param name="crs"/>
		<xsl:variable name="streifen" select="document('Parameter.xml')//param[@name='CRS_StreifenAmtlich']"/>
		<AX_K_Positionssystem xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:call-template name="messjahrUndGenauigkeitsstufe">
				<xsl:with-param name="punktort" select="$punktort"/>
			</xsl:call-template>
			<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space($punktort/adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
			<northOderYWert><xsl:value-of select="substring-before(substring-after(normalize-space($punktort/adv:position/gml:Point/gml:pos),' '),' ')"/></northOderYWert>
			<hoeheOderZWert><xsl:value-of select="substring-after(substring-after(normalize-space($punktort/adv:position/gml:Point/gml:pos),' '),' ')"/></hoeheOderZWert>
			<xsl:call-template name="system">
				<xsl:with-param name="crs" select="$crs"/>
			</xsl:call-template>
		</AX_K_Positionssystem>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Lagesystem">
		<xsl:param name="punktort"/>
		<xsl:param name="crs"/>
		<xsl:variable name="streifen" select="document('Parameter.xml')//param[@name='CRS_StreifenAmtlich']"/>
		<AX_K_Lagesystem xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:call-template name="messjahrUndGenauigkeitsstufe">
				<xsl:with-param name="punktort" select="$punktort"/>
			</xsl:call-template>
			<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space($punktort/adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
			<hochwertOderNorth><xsl:value-of select="substring-after(normalize-space($punktort/adv:position/gml:Point/gml:pos),' ')"/></hochwertOderNorth>
			<xsl:call-template name="system">
				<xsl:with-param name="crs" select="$crs"/>
			</xsl:call-template>
		</AX_K_Lagesystem>
	</xsl:template>
	<xsl:template name="AX_K_Hoehensystem">
		<xsl:param name="punktort"/>
		<xsl:param name="crs"/>
		<AX_K_Hoehensystem xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:call-template name="messjahrUndGenauigkeitsstufe">
				<xsl:with-param name="punktort" select="$punktort"/>
			</xsl:call-template>
			<hoehe><xsl:value-of select="normalize-space($punktort/adv:position/gml:Point/gml:pos)"/></hoehe>
			<xsl:call-template name="system">
				<xsl:with-param name="crs" select="$crs"/>
			</xsl:call-template>
		</AX_K_Hoehensystem>
	</xsl:template>
	<xsl:template name="AX_K_Schweresystem">
		<xsl:param name="schwere"/>
		<AX_K_Schweresystem xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:call-template name="messjahrUndGenauigkeitsstufeSchwere">
				<xsl:with-param name="schwere" select="$schwere"/>
			</xsl:call-template>
			<schwere><xsl:value-of select="normalize-space($schwere/adv:schwerewert)"/></schwere>
			<system>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Schweresystem_Schwere</xsl:with-param>
					<xsl:with-param name="code" select="$schwere/adv:schweresystem"/>
				</xsl:call-template>
			</system>
		</AX_K_Schweresystem>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="messjahrUndGenauigkeitsstufe">
		<xsl:param name="punktort"/>
		<messjahr xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:choose>
				<xsl:when test="function-available('date:to-string')">
					<xsl:variable name="dt" select="$punktort/adv:qualitaetsangaben/adv:AX_DQPunktort/adv:herkunft/adv:LI_Lineage/adv:ProcessStep/adv:LI_ProcessStep[adv:description='Erhebung']/adv:dateTime"/>
					<!-- xsl:value-of select="substring(date:to-string($dt),1,4)"/ --><!-- Originalzeile -->
					<xsl:value-of select="substring($dt,1,4)"/><!-- Function date:to-string machte Probleme, daher hier gelöscht. -->
				</xsl:when>
				<xsl:otherwise>unbekannt</xsl:otherwise>
			</xsl:choose>
		</messjahr>
		<xsl:if test="count($punktort/adv:qualitaetsangaben/adv:AX_DQPunktort/adv:genauigkeitsstufe)=1">
			<genauigkeitsstufe xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Genauigkeitsstufe_Punktort</xsl:with-param>
					<xsl:with-param name="code" select="$punktort/adv:qualitaetsangaben/adv:AX_DQPunktort/adv:genauigkeitsstufe"/>
				</xsl:call-template>
			</genauigkeitsstufe>
		</xsl:if>
</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="messjahrUndGenauigkeitsstufeSchwere">
		<xsl:param name="schwere"/>
		<messjahr xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:choose>
				<xsl:when test="function-available('date:to-string')">
					<!-- xsl:value-of select="substring(date:to-string($schwere/adv:qualitaetsangaben/adv:AX_DQSchwere/adv:bestimmungsdatum),1,4)"/ --><!-- Originalzeile -->
					<xsl:value-of select="substring($schwere/adv:qualitaetsangaben/adv:AX_DQSchwere/adv:bestimmungsdatum,1,4)"/><!-- Function date:to-string machte Probleme, daher hier gelöscht. -->
				</xsl:when>
				<xsl:otherwise>unbekannt</xsl:otherwise>
			</xsl:choose>
		</messjahr>
		<xsl:if test="count($schwere/adv:qualitaetsangaben/adv:AX_DQSchwere/adv:genauigkeitsstufe)=1">
			<genauigkeitsstufe xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Genauigkeitsstufe_Schwere</xsl:with-param>
					<xsl:with-param name="code" select="$schwere/adv:qualitaetsangaben/adv:AX_DQSchwere/adv:genauigkeitsstufe"/>
				</xsl:call-template>
			</genauigkeitsstufe>
		</xsl:if>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="system">
		<xsl:param name="crs"/>
		<system xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1"><xsl:value-of select="substring-after($crs,'urn:adv:crs:')"/></system>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="BboxFuerWMS">
		<xsl:param name="punktorte"/>
		<xsl:variable name="poscrs" select="document('Parameter.xml')//param[@name='CRS_Position']"/>
		<xsl:variable name="lagecrs" select="document('Parameter.xml')//param[@name='CRS_Lage']"/>
			<!-- es kann nur einen passenden Punktort geben, ansonsten liegt ein Fehler vor --><!-- Hier gab es zum Teil Probleme mit mehrfachem Durchlauf von Schleifen, was uns nicht erklärlich war, denn es wurde nur ein Punktort übergeben. -->
			<xsl:for-each select="$punktorte">
				<xsl:choose>
					<xsl:when test="./adv:position/gml:Point/@srsName and contains($poscrs,./adv:position/gml:Point/@srsName)">
						<xsl:variable name="re" select="substring-before(normalize-space(./adv:position/gml:Point/gml:pos),' ')"/>
						<xsl:variable name="ho" select="substring-before(substring-after(normalize-space(./adv:position/gml:Point/gml:pos),' '),' ')"/><!-- In pos können auch drei Werte auftauchen, daher hier dieser Ausdruck. -->
					  <xsl:value-of select="number($re)-1000"/>,<xsl:value-of select="number($ho)-1000"/>,<xsl:value-of select="number($re)+1000"/>,<xsl:value-of select="number($ho)+1000"/>
					</xsl:when>
					<xsl:when test="count(./adv:position/gml:Point/@srsName)=0 and document('AX_EinzelnachweisGrundnetzpunkt/E1.xml')//gml:Envelope/@srsName and contains($poscrs,document('AX_EinzelnachweisGrundnetzpunkt/E1.xml')//gml:Envelope/@srsName)"><!-- Hier fest verdrahtet. Implementierung muß natürlich flexibel sein. -->
					        <xsl:variable name="re" select="substring-before(normalize-space(./adv:position/gml:Point/gml:pos),' ')"/>
						<xsl:variable name="ho" select="substring-before(substring-after(normalize-space(./adv:position/gml:Point/gml:pos),' '),' ')"/>
					  <xsl:value-of select="number($re)-1000"/>,<xsl:value-of select="number($ho)-1000"/>,<xsl:value-of select="number($re)+1000"/>,<xsl:value-of select="number($ho)+1000"/>
					</xsl:when>
					<xsl:when test="./adv:position/gml:Point/@srsName and contains($lagecrs,./adv:position/gml:Point/@srsName)">
							<xsl:variable name="re" select="substring-before(normalize-space(./adv:position/gml:Point/gml:pos),' ')"/>
							<xsl:variable name="ho" select="substring-after(normalize-space(./adv:position/gml:Point/gml:pos),' ')"/>
						  <xsl:value-of select="number($re)-1000"/>,<xsl:value-of select="number($ho)-1000"/>,<xsl:value-of select="number($re)+1000"/>,<xsl:value-of select="number($ho)+1000"/>
					</xsl:when>
					<xsl:when test="count(./adv:position/gml:Point/@srsName)=0 and document('AX_EinzelnachweisGrundnetzpunkt/E1.xml')//gml:Envelope/@srsName and contains($lagecrs,document('AX_EinzelnachweisGrundnetzpunkt/E1.xml')//gml:Envelope/@srsName)"><!-- Hier fest verdrahtet. Implementierung muß natürlich flexibel sein. -->
						<xsl:variable name="re" select="substring-before(normalize-space(./adv:position/gml:Point/gml:pos),' ')"/>
						<xsl:variable name="ho" select="substring-after(normalize-space(./adv:position/gml:Point/gml:pos),' ')"/>
					  <xsl:value-of select="number($re)-1000"/>,<xsl:value-of select="number($ho)-1000"/>,<xsl:value-of select="number($re)+1000"/>,<xsl:value-of select="number($ho)+1000"/>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
	</xsl:template>
	<!-- ==================================================== -->	
	<!-- !!!! Ende AFIS-Ergänzungen !!!! -->
	<!-- ==================================================== -->
	
	<!-- ====================== GeoInfoDok 5.1 ============================== -->
	<xsl:template name="entschluesseln"> <!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="codelist"/>
		<xsl:param name="code"/>
		<xsl:variable name="oid"><xsl:value-of select="$codelist"/>_<xsl:value-of select="$code"/></xsl:variable>
		<xsl:value-of select="document('CodeLists.xml')//gml:Definition[@gml:id=$oid]/gml:description"/>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template match="@*|*|text()" mode="copy-it"> <!-- Auf GeoInfoDok 5.1 -->
		<xsl:copy>
			<xsl:apply-templates select="@*|*|text()" mode="copy-it"/>
		</xsl:copy>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Buchungsblattbezirk-Objekte verfügbar -->
	<xsl:template match="adv:AX_Buchungsblatt" mode="bezeichnungBezirk">
		<xsl:variable name="land" select="adv:buchungsblattbezirk/adv:AX_Buchungsblattbezirk_Schluessel/adv:land"/>
		<xsl:variable name="beznr" select="adv:buchungsblattbezirk/adv:AX_Buchungsblattbezirk_Schluessel/adv:bezirk"/>
		<xsl:variable name="bezirk" select="//adv:AX_Buchungsblattbezirk[adv:schluesselGesamt=concat($land,$beznr)]"/>
		<xsl:value-of select="$bezirk/bezeichnung"/>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Buchungsblattbezirk- und AX_Dienststelle-Objekte verfügbar -->
	<xsl:template match="adv:AX_Buchungsblatt" mode="bezeichnungDienststelle">
		<xsl:variable name="land" select="adv:buchungsblattbezirk/adv:AX_Buchungsblattbezirk_Schluessel/adv:land"/>
		<xsl:variable name="beznr" select="adv:buchungsblattbezirk/adv:AX_Buchungsblattbezirk_Schluessel/adv:bezirk"/>
		<xsl:variable name="bezirk" select="//adv:AX_Buchungsblattbezirk[adv:schluesselGesamt=concat($land,$beznr)]"/>
		<xsl:variable name="dstnr" select="$bezirk/adv:gehoertZu/adv:AX_Dienststelle_Schluessel/adv:stelle"/>
		<xsl:variable name="stelle" select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($land,$dstnr)]"/>
		<xsl:value-of select="$stelle/bezeichnung"/>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template match="adv:AX_Buchungsblatt" mode="blattart">
		<xsl:call-template name="entschluesseln">
			<xsl:with-param name="codelist">AX_Blattart_Buchungsblatt</xsl:with-param>
			<xsl:with-param name="code" select="adv:blattart"/>
		</xsl:call-template>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template match="adv:AX_Buchungsstelle" mode="buchungsart">
		<xsl:call-template name="entschluesseln">
			<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
			<xsl:with-param name="code" select="adv:buchungsart"/>
		</xsl:call-template>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Person- und AX_Anschrift-Objekte verfügbar.  Auf GeoInfoDok 5.1 -->
	<xsl:template match="adv:AX_Namensnummer" mode="AX_K_PERS1">
		<AX_K_PERS1 xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<namensnummer>
				<AX_Namensnummer_K_PERS1>
					<laufendeNummer><xsl:value-of select="adv:laufendeNummerNachDIN1421"/></laufendeNummer>
					<xsl:if test="count(adv:nummer)>0">
						<nummer><xsl:value-of select="adv:nummer"/></nummer>
					</xsl:if>
				</AX_Namensnummer_K_PERS1>
			</namensnummer>
			<xsl:if test="count(adv:anteil)>0">
				<xsl:apply-templates select="adv:anteil" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count(adv:artDerRechtsgemeinschaft)>0">
				<xsl:apply-templates select="adv:artDerRechtsgemeinschaft" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count(adv:beschriebDerRechtsgemeinschaft)>0">
				<xsl:apply-templates select="adv:beschriebDerRechtsgemeinschaft" mode="copy-it"/>
			</xsl:if>
			<xsl:variable name="namnr" select="."/>
			<!-- Entweder ist das Kontextobjekt eine Namensnummer i.S.v. einer Rechtsgemeinschaft oder -->
			<!-- eine Namensnummer, die mit genau einer Person verknüpft ist. -->
			<xsl:variable name="person" select="//adv:AX_Person[@gml:id=substring-after($namnr/adv:benennt/@xlink:href,'urn:adv:oid:')]"/>
			<xsl:if test="count($person/adv:nachnameOderFirma)>0">
				<xsl:apply-templates select="$person/adv:nachnameOderFirma" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($person/adv:vorname)>0">
				<xsl:apply-templates select="$person/adv:vorname" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($person/adv:namensbestandteil)>0">
				<xsl:apply-templates select="$person/adv:namensbestandteil" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($person/adv:akademischerGrad)>0">
				<xsl:apply-templates select="$person/adv:akademischerGrad" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($person/adv:geburtsname)>0">
				<xsl:apply-templates select="$person/adv:geburtsname" mode="copy-it"/>
			</xsl:if>
			<xsl:variable name="anschrift" select="//adv:AX_Anschrift[@gml:id=substring-after($person/adv:hat/@xlink:href,'urn:adv:oid:')]"/>
			<xsl:if test="count($anschrift/adv:bestimmungsland)>0">
				<xsl:apply-templates select="$anschrift/adv:bestimmungsland" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($anschrift/adv:ort_Post)>0">
				<xsl:apply-templates select="$anschrift/adv:ort_Post" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($anschrift/adv:postleitzahlPostzustellung)>0">
				<xsl:apply-templates select="$anschrift/adv:postleitzahlPostzustellung" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($anschrift/adv:ortsteil)>0">
				<xsl:apply-templates select="$anschrift/adv:ortsteil" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($anschrift/adv:strasse)>0">
				<xsl:apply-templates select="$anschrift/adv:strasse" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="count($anschrift/adv:hausnummer)>0">
				<xsl:apply-templates select="$anschrift/adv:hausnummer" mode="copy-it"/>
			</xsl:if>
		</AX_K_PERS1>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Buchungsblattbezirk- und AX_Dienststelle-Objekte verfügbar. Auf GeoInfoDok 5.1 -->
	<xsl:template name="AX_Buchung">
		<xsl:param name="blatt"/>
		<xsl:param name="lfdNr"/>
		<xsl:variable name="land" select="$blatt/adv:buchungsblattbezirk/adv:AX_Buchungsblattbezirk_Schluessel/adv:land"/>
		<xsl:variable name="beznr" select="$blatt/adv:buchungsblattbezirk/adv:AX_Buchungsblattbezirk_Schluessel/adv:bezirk"/>
		<xsl:variable name="bezirk" select="//adv:AX_Buchungsblattbezirk[adv:schluesselGesamt=concat($land,$beznr)]"/>
		<xsl:variable name="dstnr" select="$bezirk/adv:gehoertZu/adv:AX_Dienststelle_Schluessel/adv:stelle"/>
		<xsl:variable name="dstelle" select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($land,$dstnr)]"/>
		<AX_Buchung xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:if test="count($dstelle)>0">
				<amtsgericht><xsl:value-of select="$dstelle/adv:bezeichnung"/></amtsgericht>
			</xsl:if>
			<xsl:if test="count($bezirk)>0">
				<buchungsblattbezirk><xsl:value-of select="$bezirk/adv:bezeichnung"/></buchungsblattbezirk>
			</xsl:if>
			<buchungsblattnummer><xsl:value-of select="$blatt/adv:buchungsblattnummerMitBuchstabenerweiterung"/></buchungsblattnummer>
			<xsl:if test="count($lfdNr)=1 and string-length($lfdNr)>0">
				<laufendeNummerDerBuchungsstelle><xsl:value-of select="$lfdNr"/></laufendeNummerDerBuchungsstelle>
			</xsl:if>
			<blattart><xsl:apply-templates select="$blatt" mode="blattart"/></blattart>
		</AX_Buchung>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Buchungsblattbezirk- und AX_Dienststelle-Objekte verfügbar -->
	<xsl:template name="AX_K_BUCHUNGSANGABEN">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="blatt"/>
		<xsl:param name="lfdNr"/>
		<xsl:param name="bart"/>
		<AX_K_BUCHUNGSANGABEN xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<buchung>
				<xsl:call-template name="AX_Buchung">
					<xsl:with-param name="blatt" select="$blatt"/>
					<xsl:with-param name="lfdNr" select="$lfdNr"/>
				</xsl:call-template>
			</buchung>
			<buchungsart>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
					<xsl:with-param name="code" select="$bart"/>
				</xsl:call-template>
			</buchungsart>
		</AX_K_BUCHUNGSANGABEN>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Person, AX_Anschrift, AX_Buchungsblattbezirk und AX_Dienststelle-Objekte verfügbar -->
	<xsl:template name="AX_K_Eigentum_Anlieger">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="blatt"/>
		<xsl:param name="lfdNr"/>
		<xsl:param name="bart"/>
		<xsl:param name="eigentuemer"/>
		<AX_K_Eigentum_Anlieger xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<buchung>
				<xsl:call-template name="AX_Buchung">
					<xsl:with-param name="blatt" select="$blatt"/>
					<xsl:with-param name="lfdNr" select="$lfdNr"/>
				</xsl:call-template>
			</buchung>
			<buchungsart>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
					<xsl:with-param name="code" select="$bart"/>
				</xsl:call-template>
			</buchungsart>
			<eigentuemer>
				<xsl:for-each select="$eigentuemer">
					<xsl:apply-templates select="." mode="AX_K_PERS1"/>
				</xsl:for-each>
			</eigentuemer>
		</AX_K_Eigentum_Anlieger>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_LagebezeichnungKatalogeintrag-Objekte verfügbar -->
	<xsl:template name="AX_K_LBEZ">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="lage"/>
		<AX_K_LBEZ xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<lagebezeichnung>
				<AX_K_LBEZ_Lagebezeichnung>
					<xsl:choose>
						<xsl:when test="count($lage/adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt)=1">
							<lagebezeichnung><xsl:value-of select="$lage/adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt"/></lagebezeichnung>
						</xsl:when>
						<xsl:when test="count($lage/adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt)=1">
							<xsl:variable name="lbez" select="$lage/adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung"/>
							<lagebezeichnung><xsl:value-of select="//adv:AX_LagebezeichnungKatalogeintrag[adv:schluesselGesamt=concat($lbez/adv:land,$lbez/adv:regierungsbezirk,$lbez/adv:kreis,$lbez/adv:gemeinde,$lbez/adv:lage)]/adv:bezeichnung"/></lagebezeichnung>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="count($lage/adv:hausnummer)=1">
						<xsl:apply-templates select="$lage/adv:hausnummer" mode="copy-it"/>
					</xsl:if>
					<xsl:if test="count($lage/adv:ortsteil)=1">
						<xsl:apply-templates select="$lage/adv:ortsteil" mode="copy-it"/>
					</xsl:if>
				</AX_K_LBEZ_Lagebezeichnung>
			</lagebezeichnung>
		</AX_K_LBEZ>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Lage, AX_LagebezeichnungKatalogeintrag-Objekte verfügbar (Katalogeinträge, Lagen in AX_K_GEBAEUDE_E1.xml) -->
	<xsl:template name="AX_K_GEBAEUDE">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="gebaeude"/>
		<AX_K_GEBAEUDE xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:for-each select="document('AX_K_GEBAEUDE_E1.xml')//adv:AX_LagebezeichnungMitHausnummer[@gml:id=substring-after($gebaeude/adv:zeigtAuf/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<AX_Lagebezeichnung_K_GEBAEUDE>
						<xsl:choose>
							<xsl:when test="count(./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt)=1"><!-- Hier fehlte vorher ./ -->
								<lagebezeichnung><xsl:value-of select="./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt"/></lagebezeichnung><!-- Hier fehlte vorher ./ -->
							</xsl:when>
							<xsl:when test="count(./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="lbez" select="./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung"/><!-- Hier fehlte vorher ./ -->
								<lagebezeichnung><xsl:value-of select="document('AX_K_GEBAEUDE_E1.xml')//adv:AX_LagebezeichnungKatalogeintrag[adv:schluesselGesamt=concat($lbez/adv:land,$lbez/adv:regierungsbezirk,$lbez/adv:kreis,$lbez/adv:gemeinde,$lbez/adv:lage)]/adv:bezeichnung"/></lagebezeichnung>
							</xsl:when>
						</xsl:choose>
						<nummer><xsl:value-of select="./adv:hausnummer"/></nummer><!-- Hier fehlte vorher ./ -->
						<xsl:if test="count(./adv:ortsteil)=1"><!-- Hier fehlte vorher ./ -->
							<xsl:apply-templates select="./adv:ortsteil" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						</xsl:if>
					</AX_Lagebezeichnung_K_GEBAEUDE>
				</lagebezeichnung>
			</xsl:for-each>
                        <xsl:for-each select="document('AX_K_GEBAEUDE_E1.xml')//adv:AX_LagebezeichnungMitPseudonummer[@gml:id=substring-after($gebaeude/adv:hat/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<AX_Lagebezeichnung_K_GEBAEUDE>
						<xsl:choose>
							<xsl:when test="count(./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt)=1"><!-- Hier fehlte vorher ./ -->
								<lagebezeichnung><xsl:value-of select="./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt"/></lagebezeichnung><!-- Hier fehlte vorher ./ -->
							</xsl:when>
							<xsl:when test="count(./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="lbez" select="./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung"/><!-- Hier fehlte vorher ./ -->
								<lagebezeichnung><xsl:value-of select="document('AX_K_GEBAEUDE_E1.xml')//adv:AX_LagebezeichnungKatalogeintrag[adv:schluesselGesamt=concat($lbez/adv:land,$lbez/adv:regierungsbezirk,$lbez/adv:kreis,$lbez/adv:gemeinde,$lbez/adv:lage)]/adv:bezeichnung"/></lagebezeichnung>
							</xsl:when>
						</xsl:choose>
						<nummer><xsl:value-of select="./adv:hausnummer"/></nummer><!-- Hier fehlte vorher ./ -->
						<xsl:if test="count(./adv:laufendeNummer)=1">
							<xsl:apply-templates select="./adv:laufendeNummer" mode="copy-it"/>
						</xsl:if>
						<xsl:if test="count(./adv:ortsteil)=1"><!-- Hier fehlte vorher ./ -->
							<xsl:apply-templates select="./adv:ortsteil" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						</xsl:if>
					</AX_Lagebezeichnung_K_GEBAEUDE>
				</lagebezeichnung>
			</xsl:for-each>			
			<xsl:for-each select="$gebaeude/adv:name">
				<gebaeudename><xsl:value-of select="."/></gebaeudename>
			</xsl:for-each>
			<gebaeudefunktion>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Gebaeudefunktion</xsl:with-param>
					<xsl:with-param name="code" select="$gebaeude/adv:gebaeudefunktion"/>
				</xsl:call-template>
			</gebaeudefunktion>
		</AX_K_GEBAEUDE>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- SRS Anfang AX_K_Gebaeude_Grunddatenbestand -->
	<!-- Voraussetzung: alle AX_Lage, AX_LagebezeichnungKatalogeintrag-Objekte verfügbar (Katalogeinträge, Lagen in AX_K_GEBAEUDE_E1.xml) -->
	<xsl:template name="AX_K_GEBAEUDE_Grunddatenbestand">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="gebaeude"/>
		<AX_K_GEBAEUDE xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:for-each select="document('AX_K_GEBAEUDE_E1.xml')//adv:AX_LagebezeichnungMitHausnummer[@gml:id=substring-after($gebaeude/adv:zeigtAuf/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<AX_Lagebezeichnung_K_GEBAEUDE>
						<xsl:choose>
							<xsl:when test="count(./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt)=1"><!-- Hier fehlte vorher ./ -->
								<lagebezeichnung><xsl:value-of select="./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:unverschluesselt"/></lagebezeichnung><!-- Hier fehlte vorher ./ -->
							</xsl:when>
							<xsl:when test="count(./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="lbez" select="./adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung"/><!-- Hier fehlte vorher ./ -->
								<lagebezeichnung><xsl:value-of select="document('AX_K_GEBAEUDE_E1.xml')//adv:AX_LagebezeichnungKatalogeintrag[adv:schluesselGesamt=concat($lbez/adv:land,$lbez/adv:regierungsbezirk,$lbez/adv:kreis,$lbez/adv:gemeinde,$lbez/adv:lage)]/adv:bezeichnung"/></lagebezeichnung>
							</xsl:when>
						</xsl:choose>
						<nummer><xsl:value-of select="./adv:hausnummer"/></nummer><!-- Hier fehlte vorher ./ -->
						<xsl:if test="count(./adv:ortsteil)=1"><!-- Hier fehlte vorher ./ -->
							<xsl:apply-templates select="./adv:ortsteil" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						</xsl:if>
					</AX_Lagebezeichnung_K_GEBAEUDE>
				</lagebezeichnung>
			</xsl:for-each>
			<!-- AX_LagebezeichnungMitPseudonummer gehört nicht zum Grunddatenbestand und ist hier entfallen! -->
			<!-- Daher Änderung bei AX_K_GEBAEUDE.lagebezeichnung von [1..*] auf [0..*]. --><!-- 05.04.2006: Änderung wird veranlaßt. -->
			<gebaeudefunktion>
			<xsl:variable name="gebaeudefunktion" select="substring($gebaeude/adv:funktion,1,1)" />
				<xsl:choose>
				<xsl:when test="$gebaeudefunktion = '1'">
				Wohnen
				</xsl:when>
				<xsl:when test="$gebaeudefunktion = '2'">
				Wirtschaft oder Gewerbe
				</xsl:when>
				<xsl:when test="$gebaeudefunktion = '3'">
				Gemeinwesen
				</xsl:when>
				</xsl:choose>
			</gebaeudefunktion>
		</AX_K_GEBAEUDE>
	</xsl:template>
	<!-- ==================================================== -->	
	<!-- SRS Ende AX_K_Gebaeude_Grunddatenbestand -->
	
	<!-- Voraussetzung: alle AX_Lage, AX_LagebezeichnungKatalogeintrag, AX_Gebaeude-Objekte im Gebiet verfügbar (Katalogeinträge, Lagen und Gebaeude in AX_K_GEBAEUDE_E1.xml) -->
	<xsl:template name="AX_K_GEBAEUDE__alle">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="flurstueck"/>
		<!-- SRS neu -->
		<xsl:param name="anlass"/>
		<!-- Ende SRS neu -->
		<xsl:for-each select="document('AX_K_GEBAEUDE_E1.xml')//AX_Gebaeude[ext:intersects(adv:position,$flurstueck/adv:position)]">
			<gebaeude>
			
			<!-- SRS neu -->
			<xsl:choose>
			<xsl:when test="($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700')">
		   <!-- Alles  länderspezfische Ausgaben! 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis -->
			<!-- Ende SRS neu -->
			        <xsl:call-template name="AX_K_GEBAEUDE">
					<xsl:with-param name="gebaeude" select="."/>
				</xsl:call-template>
			<!-- SRS neu -->	
			</xsl:when>
			<xsl:when test="($anlass='0511') or ($anlass='0521') or ($anlass='0551') or ($anlass='0561') or ($anlass='0601') or ($anlass='0701')">
		   <!-- Alles Grunddatenbestand 0511=Flurstücksnachweis -->
		   <!-- 0521=Flurstücksnachweis mit Bodenschätzung, 0551=F&Enachweis, 0561=F&Enachweis mit Bodenschätzung, 0601=Grundstücksnachweis -->
		   <!-- 0701=Bestandsnachweis -->
			       <xsl:call-template name="AX_K_GEBAEUDE_Grunddatenbestand">
					<xsl:with-param name="gebaeude" select="."/>
 			       </xsl:call-template>
			
			</xsl:when>
			</xsl:choose>
			<!-- Ende SRS neu -->
			
			</gebaeude>
		</xsl:for-each>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle öffentlich-rechtlichen Festlegungen und Dienststellen in dem Gebiet verfügbar (in AX_K_ORF_E1.xml, die Dienststellen im Eingangsdokument) -->
	<xsl:template name="AX_K_ORF">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="flurstueck"/>
		<!-- SRS neu -->
		<xsl:param name="anlass"/>
		<!-- Ende SRS neu -->
		
		<AX_K_ORF xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:if test="function-available('ext:intersects')">
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_KlassifizierungNachStrassenrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<!-- SRS neu -->
					<xsl:choose>
					 <xsl:when test = "($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700')">
		   <!-- Alles  länderspezfische Ausgaben! 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis -->
					<!-- Ende SRS neu -->
					<festlegungOSW>
						<AX_FestlegungOSW>
							<klassifizierung>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_KlassifizierungNachStrassenrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</klassifizierung>
							<xsl:if test="count(./adv:bezeichnung)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:apply-templates select="./adv:bezeichnung" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungOSW>
					</festlegungOSW>
					
					<!-- SRS neu -->
					</xsl:when>
					<xsl:when test = "($anlass='0511') or ($anlass='0521') or ($anlass='0551') or ($anlass='0561') or ($anlass='0601') or ($anlass='0701')">
		   <!-- Alles Grunddatenbestand 0511=Flurstücksnachweis -->
		   <!-- 0521=Flurstücksnachweis mit Bodenschätzung, 0551=F&Enachweis, 0561=F&Enachweis mit Bodenschätzung, 0601=Grundstücksnachweis -->
		   <!-- 0701=Bestandsnachweis -->
		                        <xsl:choose>
		                          <xsl:when test = "./adv:artDerFestlegung = '1110' or ./adv:artDerFestlegung = '1120' or ./adv:artDerFestlegung = '1130' or ./adv:artDerFestlegung = '1140' or ./adv:artDerFestlegung = '1150' or ./adv:artDerFestlegung = '1180'"><!-- Hier fehlte vorher ./ -->
       					   <festlegungOSW>
						<AX_FestlegungOSW>
							<klassifizierung>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_KlassifizierungNachStrassenrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</klassifizierung>
							<xsl:if test="count(./adv:bezeichnung)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:apply-templates select="./adv:bezeichnung" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungOSW>
					   </festlegungOSW>
					  </xsl:when>
					 </xsl:choose> 
					</xsl:when>
					</xsl:choose>
					<!-- Ende SRS neu -->
				</xsl:for-each>
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_KlassifizierungNachWasserrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<!-- SRS neu -->
					<xsl:choose>
					 <xsl:when test = "($anlass='0110') or ($anlass='0120') or ($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700')">
		   <!-- Alles  länderspezfische Ausgaben! 0110=Liegenschaftskarte,0120=Liegenschaftskarte mit Bodenschätzung, 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis -->
					<!-- Ende SRS neu -->
					<festlegungOSW>
						<AX_FestlegungOSW>
							<klassifizierung>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_KlassifizierungNachWasserrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</klassifizierung>
							<xsl:if test="count(./adv:bezeichnung)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:apply-templates select="./adv:bezeichnung" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungOSW>
					</festlegungOSW>
					<!-- SRS neu -->
					</xsl:when>
					<xsl:when test = "($anlass='0111') or ($anlass='0121') or ($anlass='0511') or ($anlass='0521') or ($anlass='0551') or ($anlass='0561') or ($anlass='0601') or ($anlass='0701')">
		   <!-- Alles Grunddatenbestand 0111=Liegenschaftskarte,0121=Liegenschaftskarte mit Bodenschätzung, 0511=Flurstücksnachweis -->
		   <!-- 0521=Flurstücksnachweis mit Bodenschätzung, 0551=F&Enachweis, 0561=F&Enachweis mit Bodenschätzung, 0601=Grundstücksnachweis -->
		   <!-- 0701=Bestandsnachweis -->
		                        <xsl:choose>
		                          <xsl:when test = "./adv:artDerFestlegung = '1310' or ./adv:artDerFestlegung = '1320' or ./adv:artDerFestlegung = '1330' or ./adv:artDerFestlegung = '1340'"><!-- Hier fehlte vorher ./ -->
					<festlegungOSW>
						<AX_FestlegungOSW>
							<klassifizierung>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_KlassifizierungNachWasserrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</klassifizierung>
							<xsl:if test="count(./adv:bezeichnung)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:apply-templates select="./adv:bezeichnung" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungOSW>
					</festlegungOSW>
					  </xsl:when>
					 </xsl:choose> 
					</xsl:when>
					</xsl:choose>
					<!-- Ende SRS neu -->
				</xsl:for-each>
				
					<!-- SRS neu Ausschluss Schutzzone, Denkmalschutzrecht, AndereFestlegungNach Strassen/Wasserrecht NaturUmweltOderBodenschutzrecht -->
					<xsl:choose>
					 <xsl:when test = "($anlass='0110') or ($anlass='0120') or ($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700')">
		   <!-- Alles  länderspezfische Ausgaben! 0110=Liegenschaftskarte,0120=Liegenschaftskarte mit Bodenschätzung, 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis -->
					<!-- Ende SRS neu -->
				
				
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_Schutzzone[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<xsl:variable name="zone" select="."/>
					<xsl:variable name="orf1" select="document('AX_K_ORF_E1.xml')//adv:AX_SchutzgebietNachNaturUmweltOderBodenschutzrecht[@gml:id=substring-after($zone/adv:istTeilVon/@xlink:href,'urn:adv:oid:')]"/>
					<xsl:variable name="orf2" select="document('AX_K_ORF_E1.xml')//adv:AX_SchutzgebietNachWasserrecht[@gml:id=substring-after($zone/adv:istTeilVon/@xlink:href,'urn:adv:oid:')]"/>
					<festlegungSchutzgebietMitZoneneinteilung>
						<AX_FestlegungOSZ>
							<xsl:choose>
								<xsl:when test="count($orf1)=1">
									<art>
										<xsl:call-template name="entschluesseln">
											<xsl:with-param name="codelist">AX_ArtDerFestlegung_SchutzgebietNachNaturUmweltOderBodenschutzrecht</xsl:with-param>
											<xsl:with-param name="code" select="$orf1/adv:artDerFestlegung"/>
										</xsl:call-template>
									</art>
								</xsl:when>
								<xsl:when test="count($orf2)=1">
									<art>
										<xsl:call-template name="entschluesseln">
											<xsl:with-param name="codelist">AX_ArtDerFestlegung_SchutzgebietNachWasserrecht</xsl:with-param>
											<xsl:with-param name="code" select="$orf2/adv:artDerFestlegung"/>
										</xsl:call-template>
									</art>
								</xsl:when>
							</xsl:choose>
							<zone>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_Zone_Schutzzone</xsl:with-param>
									<xsl:with-param name="code" select="$zone/adv:zone"/>
								</xsl:call-template>
							</zone>
							<xsl:choose>
								<xsl:when test="count($orf1/adv:name)=1">
									<name><xsl:value-of select="$orf1/adv:name"/></name>
								</xsl:when>
								<xsl:when test="count($orf2/adv:name)=1">
									<name><xsl:value-of select="$orf2/adv:name"/></name>
								</xsl:when>
							</xsl:choose>
						</AX_FestlegungOSZ>
					</festlegungSchutzgebietMitZoneneinteilung>
				</xsl:for-each>
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_Denkmalschutzrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_Denkmalschutzrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
							<!-- AX_FestlegungSonstigeORF.besondereFunktionForst muß noch Kardinalität 0..1 bekommen -->
							<xsl:if test="count(./adv:name)=1"><!-- Hier fehlte vorher ./ -->
								<name><xsl:value-of select="./adv:name"/></name><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
				</xsl:for-each>
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_AndereFestlegungNachStrassenrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_AndereFestlegungNachStrassenrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
				</xsl:for-each>
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_AndereFestlegungNachWasserrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_AndereFestlegungNachWasserrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
				</xsl:for-each>
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_NaturUmweltOderBodenschutzrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_NaturUmweltOderBodenschutzrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
							<xsl:if test="count(./adv:name)=1"><!-- Hier fehlte vorher ./ -->
								<name><xsl:value-of select="./adv:name"/></name><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
				</xsl:for-each>
				
				<!-- SRS neu zu: Ausschluss Schutzzone, Denkmalschutzrecht, AndereFestlegungNach Strassen/Wasserrecht NaturUmweltOderBodenschutzrecht-->
				</xsl:when>
				</xsl:choose>
				<!-- Ende SRS neu -->
				
				
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_BauRaumOderBodenordnungsrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<!-- SRS neu -->
					<xsl:choose>
					 <xsl:when test = "($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700')">
		   <!-- Alles  länderspezfische Ausgaben! 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis -->
					<!-- Ende SRS neu -->

					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_BauRaumOderBodenordnungsrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
							<xsl:if test="count(./adv:ausfuehrendeStelle)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="dstelle" select="./adv:ausfuehrendeStelle/adv:AX_Dienststelle_Schluessel"/><!-- Hier fehlte vorher ./ -->
								<ausfuehrendeStelle>
									<xsl:value-of select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($dstelle/adv:land,$dstelle/adv:stelle)]/adv:bezeichnung"/>
								</ausfuehrendeStelle>
							</xsl:if>
							<xsl:if test="count(./adv:name)=1"><!-- Hier fehlte vorher ./ -->
								<name><xsl:value-of select="./adv:name"/></name><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>

					<!-- SRS neu -->
					</xsl:when>
					<xsl:when test = "($anlass='0511') or ($anlass='0521') or ($anlass='0551') or ($anlass='0561') or ($anlass='0601') or ($anlass='0701')">
		   <!-- Alles Grunddatenbestand 0511=Flurstücksnachweis -->
		   <!-- 0521=Flurstücksnachweis mit Bodenschätzung, 0551=F&Enachweis, 0561=F&Enachweis mit Bodenschätzung, 0601=Grundstücksnachweis -->
		   <!-- 0701=Bestandsnachweis -->
		                        <xsl:choose>
		                          <xsl:when test = "./adv:artDerFestlegung = '1750' or ./adv:artDerFestlegung = '1840' or ./adv:artDerFestlegung = '2100'"><!-- Hier fehlte vorher ./ -->

					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_BauRaumOderBodenordnungsrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
							<xsl:if test="count(./adv:ausfuehrendeStelle)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="dstelle" select="./adv:ausfuehrendeStelle/adv:AX_Dienststelle_Schluessel"/><!-- Hier fehlte vorher ./ -->
								<ausfuehrendeStelle>
									<xsl:value-of select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($dstelle/adv:land,$dstelle/adv:stelle)]/adv:bezeichnung"/>
								</ausfuehrendeStelle>
							</xsl:if>
							<xsl:if test="count(./adv:name)=1"><!-- Hier fehlte vorher ./ -->
								<name><xsl:value-of select="./adv:name"/></name><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
					  </xsl:when>
					 </xsl:choose> 
					</xsl:when>
					</xsl:choose>
					<!-- Ende SRS neu -->
				</xsl:for-each>
				
					<!-- SRS neu Ausschluss Forstrecht, SonstigesRecht -->
					<xsl:choose>
					 <xsl:when test = "($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700')">
		   <!-- Alles  länderspezfische Ausgaben! 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis -->
					<!-- Ende SRS neu -->
				
					<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_Forstrecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_Forstrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
							<xsl:if test="count(./adv:besondereFunktion)=1"><!-- Hier fehlte vorher ./ -->
							<besondereFunktionForst>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_BesondereFunktion_Forstrecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:besondereFunktion"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</besondereFunktionForst>
							</xsl:if>
							<xsl:if test="count(./adv:ausfuehrendeStelle)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="dstelle" select="./adv:ausfuehrendeStelle/adv:AX_Dienststelle_Schluessel"/><!-- Hier fehlte vorher ./ -->
								<ausfuehrendeStelle>
									<xsl:value-of select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($dstelle/adv:land,$dstelle/adv:stelle)]/adv:bezeichnung"/>
								</ausfuehrendeStelle>
							</xsl:if>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
				</xsl:for-each>
				<xsl:for-each select="document('AX_K_ORF_E1.xml')//adv:AX_SonstigesRecht[ext:intersects(adv:position,$flurstueck/adv:position)]">
					<festlegungSonstigeORF>
						<AX_FestlegungSonstigeORF>
							<art>
								<xsl:call-template name="entschluesseln">
									<xsl:with-param name="codelist">AX_ArtDerFestlegung_SonstigesRecht</xsl:with-param>
									<xsl:with-param name="code" select="./adv:artDerFestlegung"/><!-- Hier fehlte vorher ./ -->
								</xsl:call-template>
							</art>
							<xsl:if test="count(./adv:ausfuehrendeStelle)=1"><!-- Hier fehlte vorher ./ -->
								<xsl:variable name="dstelle" select="./adv:ausfuehrendeStelle/adv:AX_Dienststelle_Schluessel"/><!-- Hier fehlte vorher ./ -->
								<ausfuehrendeStelle>
									<xsl:value-of select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($dstelle/adv:land,$dstelle/adv:stelle)]/adv:bezeichnung"/>
								</ausfuehrendeStelle>
							</xsl:if>
							<xsl:if test="count(./adv:name)=1"><!-- Hier fehlte vorher ./ -->
								<name><xsl:value-of select="./adv:name"/></name><!-- Hier fehlte vorher ./ -->
							</xsl:if>
						</AX_FestlegungSonstigeORF>
					</festlegungSonstigeORF>
				</xsl:for-each>
				
				<!-- SRS neu zu: Ausschluss Forstrecht, SonstigesRecht -->
				</xsl:when>
				</xsl:choose>
				<!-- Ende SRS neu -->
			</xsl:if>
		</AX_K_ORF>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="summiereTeilflaechen">
		<xsl:param name="tn"/>
		<xsl:param name="flurstuecksflaeche"/>
		<xsl:param name="korrekturfaktor"/>
		<xsl:choose>
			<xsl:when test="$tn">
				<xsl:variable name="rec_res">
					<xsl:call-template name="summiereTeilflaechen">
						<xsl:with-param name="tn" select="$tn[position()>1]"/>
						<xsl:with-param name="flurstuecksflaeche" select="$flurstuecksflaeche"/>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="flaeche" select="$tn[1]/adv:position"/>
				<xsl:variable name="res">
					<xsl:choose>
						<xsl:when test="function-available('ext:berechneSchnittflaeche')">
							<xsl:value-of select="$korrekturfaktor * ext:berechneSchnittflaeche($flurstuecksflaeche,$flaeche)"/>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:value-of select="number($res) + $rec_res"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="0"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_NTN">
		<xsl:param name="flurstueck"/>
		<xsl:param name="tn"/>
		<xsl:param name="nutzung"/>
		<xsl:param name="weitereNutzungsangaben"/>
		<xsl:param name="zuscl"/>
		<xsl:param name="korrekturfaktor"/>
		<AX_K_NTN xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<abschnittTN>
				<AX_AbschnittTN>
					<abschnittsflaecheTN>
						<xsl:call-template name="summiereTeilflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecksflaeche" select="$flurstueck/adv:position"/>
							<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
						</xsl:call-template>
					</abschnittsflaecheTN>
					<nutzung><xsl:value-of select="$nutzung"/></nutzung>
					<xsl:if test="count($tn/adv:name)=1"><!-- Hier war es bezugslos. Hinzugefügt wurde daher $tn/ -->
						<name><xsl:value-of select="$tn/adv:name"/></name><!-- Möglicherweise wird modellseitig hier statt CharacterString AX_Lagebezeichnung stehen. Dessen Inhalt wäre ggf. zunächst zu entschlüsseln und dann hier zu verwendeen. -->
					</xsl:if>
					<xsl:if test="count($tn/adv:zweitname)=1"><!-- Hier war es bezugslos. Hinzugefügt wurde daher $tn/ -->
						<zweitname><xsl:value-of select="$tn/adv:zweitname"/></zweitname>
					</xsl:if>
					<xsl:if test="count($tn/adv:zustand)=1"><!-- Hier war es bezugslos. Hinzugefügt wurde daher $tn/ -->
						<zustand>
							<xsl:call-template name="entschluesseln">
								<xsl:with-param name="codelist"><xsl:value-of select="$zuscl"/></xsl:with-param>
								<xsl:with-param name="code" select="$tn/adv:zustand"/><!-- Hier war es bezugslos. Hinzugefügt wurde daher $tn/ -->
							</xsl:call-template>
						</zustand>
					</xsl:if>
					<xsl:if test="$weitereNutzungsangaben">
						<zweitname><xsl:value-of select="$weitereNutzungsangaben"/></zweitname>
					</xsl:if>
				</AX_AbschnittTN>
			</abschnittTN>
		</AX_K_NTN>
	</xsl:template>
	<!-- ==================================================== -->
	
	<!-- SRS neu -->
	<!-- ==================================================== -->
		<xsl:template name="AX_K_NTN_Grunddatenbestand">
		<!-- Auf GeoInfoDok 5.1 -->
			<xsl:param name="flurstueck"/>
			<xsl:param name="tn"/>
			<xsl:param name="nutzung"/>
			<xsl:param name="korrekturfaktor"/>
			<AX_K_NTN xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
				<abschnittTN>
					<AX_AbschnittTN>
						<abschnittsflaecheTN>
							<xsl:call-template name="summiereTeilflaechen">
								<xsl:with-param name="tn" select="$tn"/>
								<xsl:with-param name="flurstuecksflaeche" select="$flurstueck/adv:position"/>
								<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
							</xsl:call-template>
						</abschnittsflaecheTN>
						<nutzung><xsl:value-of select="$nutzung"/></nutzung>
						<!-- Hinweis: name, zweitname, zustand, weitereNutzungsangaben sind kein Grunddatenbestand.  -->
					</AX_AbschnittTN>
				</abschnittTN>
			</AX_K_NTN>
		</xsl:template>
	<!-- ==================================================== -->
	<!-- SRS Ende neu -->
	
	<!-- Voraussetzung: alle tatsächlichen Nutzungen in dem Gebiet verfügbar (in AX_K_NTN_E1.xml) -->
	<xsl:template name="AX_K_NTN__alle">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="flurstueck"/>
		<!-- SRS neu -->
		<!-- Aufrufe müssen angepaßt werden... -->
		<xsl:param name="anlass"/>
		<!-- SRS neu -->
		<xsl:variable name="korrekturfaktor">
			<xsl:choose>
				<xsl:when test="function-available('ext:berechneFlaeche')">
					<xsl:value-of select="$flurstueck/adv:amtlicheFlaeche div ext:berechneFlaeche($flurstueck/adv:position)"/>
				</xsl:when>
				<xsl:otherwise>1.0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- SRS neu -->
		<xsl:choose>
		   <xsl:when test="($anlass='0510') or ($anlass='0520') or ($anlass='0550') or ($anlass='0560') or ($anlass='0600') or ($anlass='0700') or ($anlass='1210') or ($anlass='1211') or ($anlass='1220') or ($anlass='1230')">
		   <!-- Alles  länderspezfische Ausgaben! 0510=Flurstücksnachweis -->
		   <!-- 0520=Flurstücksnachweis mit Bodenschätzung, 0550=F&Enachweis, 0560=F&Enachweis mit Bodenschätzung, 0600=Grundstücksnachweis -->
		   <!-- 0700=Bestandsnachweis, 1210=FN automatisch bei FF, 1211=FN nachträglich angefordert, 1220=FM Eigent., 1230=FM Finanzverw. -->
		   <!-- 1210, 1211, 1220 und 1230 werden nicht grunddatenbestandsreduziert benötigt, daher nur hier.-->
		<!-- SRS Ende neu -->
		
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Wohnbauflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Wohnbaufläche</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Wohnbauflaeche</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_IndustrieUndGewerbeflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_IndustrieUndGewerbeflaeche</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_IndustrieUndGewerbeflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/><!-- Hier Bezug auf selektierte TN gesetzt, weil vorher bezugslos. Nicht 1 zu 1 so umsetzen sondern durch Zwischenvariable sollte man in der Implementierung erneutes Verschneiden vermeiden. Bei restlichen TNs analog.-->
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_IndustrieUndGewerbeflaeche</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Halde[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Lagergut bei Halde</xsl:with-param>
				<xsl:with-param name="weitereNutzungsangaben">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Lagergut_Halde</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Halde[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:lagergut"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Halde</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Bergbaubetrieb[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Abbaugut bei Bergbaubetrieb</xsl:with-param>
				<xsl:with-param name="weitereNutzungsangaben">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Abbaugut_Bergbaubetrieb</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Bergbaubetrieb[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:abbaugut"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Bergbaubetrieb</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_TagebauGrubeSteinbruch[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Abbaugut bei Tagebau, Grube, Steinbruch</xsl:with-param>
				<xsl:with-param name="weitereNutzungsangaben">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Abbaugut_TagebauGrubeSteinbruch</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_TagebauGrubeSteinbruch[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:abbaugut"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_TagebauGrubeSteinbruch</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_FlaecheGemischterNutzung[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_FlaecheGemischterNutzung</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_FlaecheGemischterNutzung[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_FlaecheGemischterNutzung</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_FlaecheBesondererFunktionalerPraegung[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_FlaecheBesondererFunktionalerPraegung</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_FlaecheBesondererFunktionalerPraegung[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_FlaecheBesondererFunktionalerPraegung</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_SportFreizeitUndErholungsflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_SportFreizeitUndErholungsflaeche</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_SportFreizeitUndErholungsflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_SportFreizeitUndErholungsflaeche</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Friedhof[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Friedhof</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Friedhof[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Friedhof</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Strassenverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Strassenverkehr</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Strassenverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Strassenverkehr</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Weg[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Weg</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Weg[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Platz[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Platz</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Platz[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Bahnverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Bahnverkehr</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Bahnverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Bahnverkehr</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Flugverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Flugverkehr</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Flugverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Flugverkehr</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Schiffsverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Schiffsverkehr</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Schiffsverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Schiffsverkehr</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Landwirtschaft[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Vegetationsmerkmal_Landwirtschaft</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Landwirtschaft[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:vegetationsmerkmal"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Wald[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Vegetationsmerkmal_Wald</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Wald[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:vegetationsmerkmal"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Gehoelz[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Vegetationsmerkmal_Gehoelz</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Gehoelz[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:vegetationsmerkmal"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Moor[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Moor</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Heide[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Heide</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Sumpf[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Sumpf</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_UnlandVegetationsloseFlaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">Oberflächenmaterial bei Unland / Vegetationslose Fläche</xsl:with-param>
				<xsl:with-param name="weitereNutzungsangaben">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Oberflaechenmaterial_UnlandVegetationsloseFlaeche</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_UnlandVegetationsloseFlaeche[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:oberflaechenmaterial"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Fliessgewaesser[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Fliessgewaesser</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Fliessgewaesser[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="zuscl">AX_Zustand_Fliessgewaesser</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Hafenbecken[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Hafenbecken</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Hafenbecken[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_StehendesGewaesser[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_StehendesGewaesser</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_StehendesGewaesser[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		<tatsaechlicheNutzung>
			<xsl:call-template name="AX_K_NTN">
				<xsl:with-param name="flurstueck" select="$flurstueck"/>
				<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Meer[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:with-param name="nutzung">
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Funktion_Meer</xsl:with-param>
						<xsl:with-param name="code" select="document('AX_K_NTN_E1.xml')//adv:AX_Meer[ext:intersects(adv:position,$flurstueck/adv:position)]/adv:funktion"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
			</xsl:call-template>
		</tatsaechlicheNutzung>
		
		<!-- SRS neu -->
		</xsl:when> <!-- Ende länderspezf. Anlässe -->
		<xsl:when test="($anlass='0511') or ($anlass='0521') or ($anlass='0551') or ($anlass='0561') or ($anlass='0601') or ($anlass='0701')">
		   <!-- Alles Grunddatenbestand 0511=Flurstücksnachweis -->
		   <!-- 0521=Flurstücksnachweis mit Bodenschätzung, 0551=F&Enachweis, 0561=F&Enachweis mit Bodenschätzung, 0601=Grundstücksnachweis -->
		   <!-- 0701=Bestandsnachweis -->

				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Wohnbauflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Wohnbaufläche</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:variable name="nutz" select="document('AX_K_NTN_E1.xml')//adv:AX_IndustrieUndGewerbeflaeche/adv:funktion[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
					<xsl:choose>
				        <xsl:when test="($nutz/adv:funktion = '1700') or ($nutz/adv:funktion ='1701') or ($nutz/adv:funktion ='1710') or ($nutz/adv:funktion ='1720') or ($nutz/adv:funktion ='1730') or ($nutz/adv:funktion ='1740') or ($nutz/adv:funktion ='1750') or ($nutz/adv:funktion ='1760') or ($nutz/adv:funktion ='1770') or ($nutz/adv:funktion ='1780') or ($nutz/adv:funktion ='1790')">
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_IndustrieUndGewerbeflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Industrie und Gewerbe</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_IndustrieUndGewerbeflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Industrie- und Gewerbefläche</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
					</xsl:otherwise>
					</xsl:choose>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Halde[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Lagergut, Halde</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Bergbaubetrieb[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Bergbaubetrieb</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_TagebauGrubeSteinbruch[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Tagebau, Grube, Steinbruch</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_FlaecheGemischterNutzung[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Fläche gemischter Nutzung</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_FlaecheBesondererFunktionalerPraegung[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Fläche besonderer funktionaler Prägung</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
				<xsl:variable name="nutz" select="document('AX_K_NTN_E1.xml')//adv:AX_SportFreizeitUndErholungsflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:choose>
                                <xsl:when test="($nutz/adv:funktion = '4400') or ($nutz/adv:funktion ='4410') or ($nutz/adv:funktion ='4420') or ($nutz/adv:funktion ='4430') or ($nutz/adv:funktion ='4431') or ($nutz/adv:funktion ='4440') or ($nutz/adv:funktion ='4450') or ($nutz/adv:funktion ='4460') or ($nutz/adv:funktion ='4470')">
				<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_SportFreizeitUndErholungsflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Grünanlage</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
				</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_SportFreizeitUndErholungsflaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Sport-, Freizeit- und Erholungsfläche</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
				</xsl:call-template>
				</xsl:otherwise>
				</xsl:choose>					
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Friedhof[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Friedhof</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Strassenverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Strassenverkehr</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Weg[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Weg</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Platz[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Platz</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Bahnverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Bahnverkehr</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Flugverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Flugverkehr</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Schiffsverkehr[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Schiffsverkehr</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Landwirtschaft[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Landwirtschaft</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Wald[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Wald</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Gehoelz[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Gehölz</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Moor[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Moor</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Heide[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Heide</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Sumpf[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Sumpf</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_UnlandVegetationsloseFlaeche[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Unland / Vegetationslose Fläche</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Fliessgewaesser[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Fliessgewaesser</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Hafenbecken[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Hafenbecken</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_StehendesGewaesser[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">StehendesGewaesser</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
				<tatsaechlicheNutzung> <!-- Anlassart Grunddatenbestand -->
					<xsl:call-template name="AX_K_NTN_Grunddatenbestand">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
						<xsl:with-param name="tn" select="document('AX_K_NTN_E1.xml')//adv:AX_Meer[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
						<xsl:with-param name="nutzung">Meer</xsl:with-param>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</tatsaechlicheNutzung>
		</xsl:when> <!-- Ende Anlassart 47-11 -->
		<!-- M.E. brauchen wir kein otherwise -->
		</xsl:choose>
		<!-- SRS Ende neu -->
		
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_FLURSTUECK2">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="flurstueck"/>
		<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
		<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
		<xsl:variable name="gemarkung" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
		<AX_K_FLURSTUECK2 xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:if test="function-available('ext:intersects')">
				<xsl:variable name="kommunalesGebiet" select="//AX_KommunalesGebiet[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:variable name="regbez" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:regierungsbezirk"/>
				<xsl:variable name="kreis" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:kreis"/>
				<xsl:variable name="gemeinde" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:gemeinde"/>
				<regierungsbezirk><xsl:value-of select="//adv:AX_Regierungsbezirk[adv:schluesselGesamt=concat($land,$regbez)]/adv:bezeichnung"/></regierungsbezirk>
				<kreis><xsl:value-of select="//adv:AX_KreisRegion[adv:schluesselGesamt=concat($land,$regbez,$kreis)]/adv:bezeichnung"/></kreis>
				<gemeinde><xsl:value-of select="//adv:AX_Gemeinde[adv:schluesselGesamt=concat($land,$regbez,$kreis,$gemeinde)]/adv:bezeichnung"/></gemeinde>
			</xsl:if>
			<gemarkungsname><xsl:value-of select="$gemarkung/adv:bezeichnung"/></gemarkungsname>
			<xsl:apply-templates select="$flurstueck/adv:flurstuecksnummer" mode="copy-it"/>
			<xsl:if test="count($flurstueck/adv:flurnummer)=1">
				<xsl:apply-templates select="$flurstueck/adv:flurnummer" mode="copy-it"/>
			</xsl:if>
			<xsl:apply-templates select="$flurstueck/adv:amtlicheFlaeche" mode="copy-it"/>
			<xsl:for-each select="//adv:AX_LagebezeichnungOhneHausnummer[@gml:id=substring-after($flurstueck/adv:zeigtAuf/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<xsl:call-template name="AX_K_LBEZ">
						<xsl:with-param name="lage" select="."/>
					</xsl:call-template>
				</lagebezeichnung>
			</xsl:for-each>
			<xsl:for-each select="//adv:AX_LagebezeichnungMitHausnummer[@gml:id=substring-after($flurstueck/adv:weistAuf/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<xsl:call-template name="AX_K_LBEZ">
						<xsl:with-param name="lage" select="."/>
					</xsl:call-template>
				</lagebezeichnung>
			</xsl:for-each>
			<xsl:if test="function-available('ext:intersects')">
				<xsl:call-template name="AX_K_NTN__alle">
					<xsl:with-param name="flurstueck" select="$flurstueck"/>
					<!-- SRS neu -->
					<xsl:with-param name="anlass" select="document('AX_Benutzungsauftrag.xml')//adv:art"/>
					<!-- Ende SRS neu -->					
				</xsl:call-template>
				<abschnitteORF>
					<xsl:call-template name="AX_K_ORF">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
					<!-- SRS neu -->
					<xsl:with-param name="anlass" select="document('AX_Benutzungsauftrag.xml')//adv:art"/>
					<!-- Ende SRS neu -->					
					</xsl:call-template>
				</abschnitteORF>
				<xsl:call-template name="AX_K_GEBAEUDE__alle">
					<xsl:with-param name="flurstueck" select="$flurstueck"/>
					<!-- SRS neu -->
					<xsl:with-param name="anlass" select="document('AX_Benutzungsauftrag.xml')//adv:art"/>
					<!-- Ende SRS neu -->
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="function-available('ext:intersects')">
			 <xsl:if test="boolean(//AX_BesondereFlurstuecksgrenze[ext:intersects(adv:position,$flurstueck/adv:position) and adv:artDerFlurstuecksgrenze='1000'])">
			  <strittigeGrenze>true</strittigeGrenze>
			 </xsl:if> 
			</xsl:if>
			<xsl:for-each select="//AX_Flurstueck[./@gml:id=substring-after(//AX_Flurstueck/adv:gehoertAnteiligZu/@xlink:href,'urn:adv:oid:')]">
			<anliegervermerk>
					<AX_K_Anliegervermerk>
						<xsl:variable name="land2" select="./adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/><!-- Hier fehlte vorher ./ -->
						<xsl:variable name="gemnr2" select="./adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/><!-- Hier fehlte vorher ./ -->
						<gemarkungsname><xsl:value-of select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land2,$gemnr2)]/adv:bezeichnung"/></gemarkungsname>
						<xsl:apply-templates select="./adv:flurstuecksnummer" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						<xsl:if test="count(./adv:flurnummer)=1"><!-- Hier fehlte vorher ./ -->
							<xsl:apply-templates select="./adv:flurnummer" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						</xsl:if>
					</AX_K_Anliegervermerk>
			</anliegervermerk>  
			</xsl:for-each>		
		</AX_K_FLURSTUECK2>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_FLURSTUECK1">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="flurstueck"/>
		<xsl:param name="mitBuchangaben"/>
		<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
		<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
		<xsl:variable name="gemarkung" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
		<AX_K_FLURSTUECK1 xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<xsl:if test="function-available('ext:intersects')">
				<xsl:variable name="kommunalesGebiet" select="//AX_KommunalesGebiet[ext:intersects(adv:position,$flurstueck/adv:position)]"/>
				<xsl:variable name="regbez" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:regierungsbezirk"/>
				<xsl:variable name="kreis" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:kreis"/>
				<xsl:variable name="gemeinde" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:gemeinde"/>
				<regierungsbezirk><xsl:value-of select="//adv:AX_Regierungsbezirk[adv:schluesselGesamt=concat($land,$regbez)]/adv:bezeichnung"/></regierungsbezirk>
				<kreis><xsl:value-of select="//adv:AX_KreisRegion[adv:schluesselGesamt=concat($land,$regbez,$kreis)]/adv:bezeichnung"/></kreis>
				<gemeinde><xsl:value-of select="//adv:AX_Gemeinde[adv:schluesselGesamt=concat($land,$regbez,$kreis,$gemeinde)]/adv:bezeichnung"/></gemeinde>
			</xsl:if>
			<xsl:apply-templates select="$flurstueck/adv:amtlicheFlaeche" mode="copy-it"/>
			<xsl:if test="$flurstueck/adv:abweichenderRechtszustand">
				<xsl:apply-templates select="$flurstueck/adv:abweichenderRechtszustand" mode="copy-it"/>
			</xsl:if>
			<xsl:if test="//adv:AX_BesondereFlurstuecksgrenze[adv:artDerFlurstuecksgrenze=1000]">
			<!-- Benötigte besondere Flurstücksgrenzen wurden bereits per AX_K_FLURSTUECK1_Query beschafft -->
				<strittigeGrenze>true</strittigeGrenze>
				       <!-- Entschlüsselung wird hier nicht gebraucht.
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_ArtDerFlurstuecksgrenze_BesondereFlurstuecksgrenze</xsl:with-param> Hier stand zuvor fälschlicherweise AX_Buchungsart_Buchungsstelle
						<xsl:with-param name="code" select="//adv:AX_BesondereFlurstuecksgrenze[1]/adv:artDerFlurstuecksgrenze"/>
					</xsl:call-template> 
				</strittigeGrenze> -->
			</xsl:if>
			<xsl:for-each select="//adv:AX_LagebezeichnungOhneHausnummer[@gml:id=substring-after($flurstueck/adv:zeigtAuf/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<xsl:call-template name="AX_K_LBEZ">
						<xsl:with-param name="lage" select="."/>
					</xsl:call-template>
				</lagebezeichnung>
			</xsl:for-each>
			<xsl:for-each select="//adv:AX_LagebezeichnungMitHausnummer[@gml:id=substring-after($flurstueck/adv:weistAuf/@xlink:href,'urn:adv:oid:')]">
				<lagebezeichnung>
					<xsl:call-template name="AX_K_LBEZ">
						<xsl:with-param name="lage" select="."/>
					</xsl:call-template>
				</lagebezeichnung>
			</xsl:for-each>
			<xsl:if test="function-available('ext:intersects')">
				<abschnitteORF>
					<xsl:call-template name="AX_K_ORF">
						<xsl:with-param name="flurstueck" select="$flurstueck"/>
					<!-- SRS neu -->
					<xsl:with-param name="anlass" select="document('AX_Benutzungsauftrag.xml')//adv:art"/>
					<!-- Ende SRS neu -->					
					</xsl:call-template>
				</abschnitteORF>
				<xsl:call-template name="AX_K_NTN__alle">
					<xsl:with-param name="flurstueck" select="$flurstueck"/>
					<!-- SRS neu -->
					<xsl:with-param name="anlass" select="document('AX_Benutzungsauftrag.xml')//adv:art"/>
					<!-- Ende SRS neu -->					
				</xsl:call-template>
			</xsl:if>
			<xsl:for-each select="//adv:AX_Flurstueck[$flurstueck/@gml:id=substring-after(adv:gehoertAnteiligZu/@xlink:href,'urn:adv:oid:')]"><!-- D.h. für jedes herrschende Flst., weil in $flurstueck hier das dienende steht. -->
				<anliegervermerk>
					<AX_K_Anliegervermerk>
						<xsl:variable name="land2" select="./adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/><!-- Hier fehlte vorher ./ -->
						<xsl:variable name="gemnr2" select="./adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/><!-- Hier fehlte vorher ./ -->
						<gemarkungsname><xsl:value-of select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land2,$gemnr2)]/adv:bezeichnung"/></gemarkungsname>
						<xsl:apply-templates select="./adv:flurstuecksnummer" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						<xsl:if test="count(./adv:flurnummer)=1"><!-- Hier fehlte vorher ./ -->
							<xsl:apply-templates select="./adv:flurnummer" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						</xsl:if>
					</AX_K_Anliegervermerk>
				</anliegervermerk>
			</xsl:for-each>
			<xsl:for-each select="//adv:AX_Flurstueck[@gml:id=substring-after($flurstueck/adv:gehoertAnteiligZu/@xlink:href,'urn:adv:oid:')]"><!-- D.h. für jedes dienende Flst., weil in $flurstueck hier das herrschende steht. -->
				<anlieger>
					<AX_K_Anlieger>
						<xsl:variable name="land2" select="adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
						<xsl:variable name="gemnr2" select="adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
						<gemarkungsname><xsl:value-of select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land2,$gemnr2)]/adv:bezeichnung"/></gemarkungsname>
						<xsl:apply-templates select="./adv:flurstuecksnummer" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						<xsl:if test="count(adv:flurnummer)=1">
							<xsl:apply-templates select="./adv:flurnummer" mode="copy-it"/><!-- Hier fehlte vorher ./ -->
						</xsl:if>
						<xsl:if test="$mitBuchangaben=1">
							<xsl:variable name="flurstueck2" select="."/>
							<xsl:variable name="stelle" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($flurstueck2/adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
							<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
							<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
							<xsl:choose>
								<xsl:when test="$bart='1100' or $bart='5101' or $bart='1200'">
									<buchungsangaben>
										<xsl:call-template name="AX_K_Eigentum_Anlieger">
											<xsl:with-param name="blatt" select="$blatt"/>
											<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
											<xsl:with-param name="bart" select="$bart"/>
											<xsl:with-param name="eigentuemer" select="//adv:Namensnummer[$blatt/@gml:id=substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
										</xsl:call-template>
									</buchungsangaben>
								</xsl:when>
								<xsl:when test="$bart='1101' or $bart='1102'">
									<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart = '1301' or adv:buchungsart = '1302')][1]">
										<xsl:variable name="stelle2" select="."/>
										<xsl:variable name="blatt2" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle2/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
										<buchungsangaben>
											<xsl:call-template name="AX_K_Eigentum_Anlieger">
												<xsl:with-param name="blatt" select="$blatt2"/>
												<xsl:with-param name="lfdNr" select="$stelle2/adv:laufendeNummer"/>
												<xsl:with-param name="bart" select="$stelle2/adv:buchungsart"/>
												<xsl:with-param name="eigentuemer" select="//adv:Namensnummer[$blatt2/@gml:id=substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
											</xsl:call-template>
										</buchungsangaben>
									</xsl:for-each>
									<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart = '1401' or adv:buchungsart = '1402')][1]">
										<xsl:variable name="stellei" select="."/>
										<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle2/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart = '1501' or adv:buchungsart = '1502')][1]">
											<xsl:variable name="stelle2" select="."/>
											<xsl:variable name="blatt2" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle2/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
											<buchungsangaben>
												<xsl:call-template name="AX_K_Eigentum_Anlieger">
													<xsl:with-param name="blatt" select="$blatt2"/>
													<xsl:with-param name="lfdNr" select="$stelle2/adv:laufendeNummer"/>
													<xsl:with-param name="bart" select="$stelle2/adv:buchungsart"/>
													<xsl:with-param name="eigentuemer" select="//adv:Namensnummer[$blatt2/@gml:id=substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
												</xsl:call-template>
											</buchungsangaben>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
						</xsl:if>
					</AX_K_Anlieger>
				</anlieger>
			</xsl:for-each>
		</AX_K_FLURSTUECK1>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_Recht__fiktiv">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelleFiktiv"/>
		<xsl:param name="stelle"/>
		<xsl:param name="bart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<grundstuecksgleicheRechte xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<AX_Recht>
				<buchung>
					<xsl:call-template name="AX_Buchung">
						<xsl:with-param name="blatt" select="$blatt"/>
						<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
					</xsl:call-template>
				</buchung>
				<buchungsart>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
						<xsl:with-param name="code" select="$bart"/>
					</xsl:call-template>
				</buchungsart>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<anteil>
						<xsl:apply-templates select="$stelle/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</anteil>
				</xsl:if>
				<xsl:if test="count($stelleFiktiv/adv:anteil)=1">
					<aufgeteilterAnteil>
						<xsl:apply-templates select="$stelleFiktiv/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</aufgeteilterAnteil>
				</xsl:if>
				<xsl:for-each select="//adv:AX_Namensnummer[substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')=$blatt/@gml:id]">
					<rechtsinhaber>
						<xsl:apply-templates select="." mode="AX_K_PERS1"/>
					</rechtsinhaber>
				</xsl:for-each>
			</AX_Recht>
		</grundstuecksgleicheRechte>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_Recht__einfach">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<grundstuecksgleicheRechte xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<AX_Recht>
				<buchung>
					<xsl:call-template name="AX_Buchung">
						<xsl:with-param name="blatt" select="$blatt"/>
						<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
					</xsl:call-template>
				</buchung>
				<buchungsart>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
						<xsl:with-param name="code" select="$bart"/>
					</xsl:call-template>
				</buchungsart>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<anteil>
						<xsl:apply-templates select="$stelle/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</anteil>
				</xsl:if>
				<xsl:for-each select="//adv:AX_Namensnummer[substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')=$blatt/@gml:id]">
					<rechtsinhaber>
						<xsl:apply-templates select="." mode="AX_K_PERS1"/>
					</rechtsinhaber>
				</xsl:for-each>
			</AX_Recht>
		</grundstuecksgleicheRechte>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Namensnummer-, AX_Person-, AX_Anschrift-, AX_Buchungsblattbezirk- und AX_Dienststelle-Objekte verfügbar -->
	<xsl:template name="AX_Recht">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:param name="bart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<xsl:choose>
			<xsl:when test="$bart='1100' or $bart='5101' or $bart='5200' or $bart='5201' or $bart='5202' or $bart='5203' or $bart='1200'">
				<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:')]">
					<xsl:call-template name="AX_Recht">
						<xsl:with-param name="stelle" select="."/>
						<xsl:with-param name="bart" select="./adv:buchungsart"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$bart='2101' or $bart='2102' or $bart='2103' or $bart='1303'">
				<xsl:call-template name="AX_Recht__einfach">
					<xsl:with-param name="stelle" select="."/>
				</xsl:call-template>
				<xsl:if test="$bart='2101'">
					<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:')]">
						<xsl:call-template name="AX_Recht">
							<xsl:with-param name="stelle" select="."/>
							<xsl:with-param name="bart" select="./adv:buchungsart"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$bart='2201' or $bart='2202' or $bart='2203' or $bart='2205'">
				<xsl:choose>
					<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2301' or adv:buchungsart='2302' or adv:buchungsart='2303' or adv:buchungsart='2305')])>0">
						<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2301' or adv:buchungsart='2302' or adv:buchungsart='2303' or adv:buchungsart='2305')]">
							<xsl:call-template name="AX_Recht__fiktiv">
								<xsl:with-param name="stelleFiktiv" select="$stelle"/>
								<xsl:with-param name="stelle" select="."/>
								<xsl:with-param name="bart" select="$stelle/adv:buchungsart"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2401' or adv:buchungsart='2402' or adv:buchungsart='2403' or adv:buchungsart='2405')])>0">
						<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2401' or adv:buchungsart='2402' or adv:buchungsart='2403' or adv:buchungsart='2405')]">
							<xsl:call-template name="AX_Recht">
								<xsl:with-param name="stelle" select="."/>
								<xsl:with-param name="bart" select="./adv:buchungsart"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$bart='2401' or $bart='2402' or $bart='2403' or $bart='2405' or $bart='1403'">
				<xsl:choose>
					<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2501' or adv:buchungsart='2502' or adv:buchungsart='2503' or adv:buchungsart='2505' or adv:buchungsart='1503')])>0">
						<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2501' or adv:buchungsart='2502' or adv:buchungsart='2503' or adv:buchungsart='2505' or adv:buchungsart='1503')]">
							<xsl:call-template name="AX_Recht__fiktiv">
								<xsl:with-param name="stelleFiktiv" select="$stelle"/>
								<xsl:with-param name="stelle" select="."/>
								<xsl:with-param name="bart" select="$bart"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Buchungsangaben_HD__einfach">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:variable name="stelleDienend" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1102']"/>
		<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[$stelleDienend/@gml:id=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
		<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
		<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
		<xsl:variable name="gemarkung" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
		<herrschendDienend xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<AX_K_Buchungsangaben_HD>
				<gemarkungsname><xsl:value-of select="$gemarkung/adv:bezeichnung"/></gemarkungsname>
				<xsl:apply-templates select="$flurstueck/adv:flurstuecksnummer" mode="copy-it"/>
				<xsl:if test="count($flurstueck/adv:flurnummer)=1">
					<xsl:apply-templates select="$flurstueck/adv:flurnummer" mode="copy-it"/>
				</xsl:if>
				<xsl:if test="count($stelle/adv:laufendeNummer)=1">
					<laufendeNummerDerBuchungsstelle><xsl:value-of select="$stelle/adv:laufendeNummer"/></laufendeNummerDerBuchungsstelle>
				</xsl:if>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<Anteil>
						<xsl:apply-templates select="$stelle/adv:anteil/adv:AX_Anteil" mode="copy-it"/>				
					</Anteil>
				</xsl:if>
			</AX_K_Buchungsangaben_HD>
		</herrschendDienend>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Buchungsangaben_HD__aufgeteilt">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:variable name="stelleFiktiv" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1402']"/>
		<xsl:variable name="stelleDienend" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelleFiktiv/adv:an/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1102']"/>
		<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[$stelleDienend/@gml:id=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
		<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
		<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
		<xsl:variable name="gemarkung" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
		<herrschendDienend xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<AX_K_Buchungsangaben_HD>
				<gemarkungsname><xsl:value-of select="$gemarkung/adv:bezeichnung"/></gemarkungsname>
				<xsl:apply-templates select="$flurstueck/adv:flurstuecksnummer" mode="copy-it"/>
				<xsl:if test="count($flurstueck/adv:flurnummer)=1">
					<xsl:apply-templates select="$flurstueck/adv:flurnummer" mode="copy-it"/>
				</xsl:if>
				<xsl:if test="count($stelle/adv:laufendeNummer)=1">
					<laufendeNummerDerBuchungsstelle><xsl:value-of select="$stelle/adv:laufendeNummer"/></laufendeNummerDerBuchungsstelle>
				</xsl:if>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<xsl:apply-templates select="$stelle/adv:anteil" mode="copy-it"/>
				</xsl:if>
				<xsl:if test="count($stelleFiktiv/adv:anteil)=1"><!-- Hier $stelle auf $stelleFiktiv verbessert. -->
					<aufgeteilterAnteil>
						<xsl:apply-templates select="$stelleFiktiv/adv:anteil" mode="copy-it"/><!-- Hier stand vorher als XPath: "$stelleFiktiv/adv:anteil/adv:AX_Anteil" -->
					</aufgeteilterAnteil>
				</xsl:if>
			</AX_K_Buchungsangaben_HD>
		</herrschendDienend>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Buchungsangaben_HD__dienend">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:choose>
			<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:zu/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1302'])>0">
				<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:zu/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1302']">
					<xsl:call-template name="AX_K_Buchungsangaben_HD__einfach">
						<xsl:with-param name="stelle" select="."/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:zu/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1502'])>0">
				<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:zu/@xlink:href,'urn:adv:oid:') and adv:buchungsart='1502']">
					<xsl:call-template name="AX_K_Buchungsangaben_HD__aufgeteilt">
						<xsl:with-param name="stelle" select="."/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Buchungsangaben_HD__herrschend">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
		<xsl:if test="$bart='1302' or $bart='1502'">
		<xsl:variable name="buchungsstelle_herrschend" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:zu/@xlink:href,'urn:adv:oid:')]"/>
		<xsl:choose>
		  <xsl:when test="$buchungsstelle_herrschend/adv:buchungsart = '1100'">
		        <xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[$buchungssstelle_herrschend/@gml:id=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
			<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
			<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
			<xsl:variable name="gemarkung" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
			<herrschendDienend xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
				<AX_K_Buchungsangaben_HD>
					<gemarkungsname><xsl:value-of select="$gemarkung/adv:bezeichnung"/></gemarkungsname>
					<xsl:apply-templates select="$flurstueck/adv:flurstuecksnummer" mode="copy-it"/>
					<xsl:if test="count($flurstueck/adv:flurnummer)=1">
						<xsl:apply-templates select="$flurstueck/adv:flurnummer" mode="copy-it"/>
					</xsl:if>
					<laufendeNummerDerBuchungsstelle><xsl:value-of select="$stelle/adv:laufendeNummer"/></laufendeNummerDerBuchungsstelle>
				</AX_K_Buchungsangaben_HD>
			</herrschendDienend>
		  </xsl:when>
		  <xsl:when test="$buchungsstelle_herrschend/adv:buchungsart = '1301'">
		        <xsl:variable name="flurstueck2" select="//adv:AX_Flurstueck[substring-after($buchungssstelle_herrschend/adv:an/@xlink:href,'urn:adv:oid:')=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
			<xsl:variable name="land2" select="$flurstueck2/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
			<xsl:variable name="gemnr2" select="$flurstueck2/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
			<xsl:variable name="gemarkung2" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land2,$gemnr2)]"/>
			<herrschendDienend xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
				<AX_K_Buchungsangaben_HD>
					<gemarkungsname><xsl:value-of select="$gemarkung2/adv:bezeichnung"/></gemarkungsname>
					<xsl:apply-templates select="$flurstueck2/adv:flurstuecksnummer" mode="copy-it"/>
					<xsl:if test="count($flurstueck2/adv:flurnummer)=1">
						<xsl:apply-templates select="$flurstueck2/adv:flurnummer" mode="copy-it"/>
					</xsl:if>
					<laufendeNummerDerBuchungsstelle><xsl:value-of select="$stelle/adv:laufendeNummer"/></laufendeNummerDerBuchungsstelle>
				</AX_K_Buchungsangaben_HD>
			</herrschendDienend>
		  </xsl:when>
		  <xsl:when test="$buchungsstelle_herrschend/adv:buchungsart = '1501'">
		        <xsl:variable name="flurstueck3" select="//adv:AX_Flurstueck[substring-after($buchungssstelle_herrschend/adv:an/AX_Buchungsstelle/adv:an/@xlink:href,'urn:adv:oid:')=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
			<xsl:variable name="land3" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
			<xsl:variable name="gemnr3" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
			<xsl:variable name="gemarkung3" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land3,$gemnr3)]"/>
			<herrschendDienend xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
				<AX_K_Buchungsangaben_HD>
					<gemarkungsname><xsl:value-of select="$gemarkung3/adv:bezeichnung"/></gemarkungsname>
					<xsl:apply-templates select="$flurstueck3/adv:flurstuecksnummer" mode="copy-it"/>
					<xsl:if test="count($flurstueck3/adv:flurnummer)=1">
						<xsl:apply-templates select="$flurstueck3/adv:flurnummer" mode="copy-it"/>
					</xsl:if>
					<laufendeNummerDerBuchungsstelle><xsl:value-of select="$stelle/adv:laufendeNummer"/></laufendeNummerDerBuchungsstelle>
				</AX_K_Buchungsangaben_HD>
			</herrschendDienend>
		  </xsl:when>		  
		</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Flurstueck, AX_Buchungsstelle, AX_Gemarkung-Objekte verfügbar -->
	<xsl:template name="AX_K_Buchungsangaben_HD">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
		<xsl:choose>
			<xsl:when test="$bart='1100' or $bart='5101' or $bart='5200' or $bart='5201' or $bart='5202' or $bart='5203' or $bart='1301' or $bart='1501'">
			<!-- Nur die so gebuchten Flurstücke können dienende Miteigentumsanteile haben. -->
				<xsl:call-template name="AX_K_Buchungsangaben_HD__dienend">
					<xsl:with-param name="stelle" select="."/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$bart='1302' or $bart='1502'">
				<xsl:call-template name="AX_K_Buchungsangaben_HD__herrschend">
					<xsl:with-param name="stelle" select="."/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Eigentum__sonstige">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:param name="bart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<AX_K_Eigentum xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1"> <!-- Statt dem Auskommentierten diese Klammer hinzugefügt. -->		
		<!-- grundstuecksgleicheRechte xmlns="http://www.adv-online.de/namespaces/adv/gid/3.0">
			<AX_Recht --><!-- Auskommentiert, da hier falsch. Richtig bei Template AX_Recht -->
				<buchung>
					<xsl:call-template name="AX_Buchung">
						<xsl:with-param name="blatt" select="$blatt"/>
						<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
					</xsl:call-template>
				</buchung>
				<buchungsart>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
						<xsl:with-param name="code" select="$bart"/>
					</xsl:call-template>
				</buchungsart>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<anteil>
						<xsl:apply-templates select="$stelle/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</anteil>
				</xsl:if>
				<xsl:if test="count($stelle/adv:nummerImAufteilungsplan)=1">
					<xsl:apply-templates select="$stelle/adv:nummerImAufteilungsplan" mode="copy-it"/>
				</xsl:if>
				<xsl:if test="count($stelle/adv:beschreibungDesSondereigentums)=1">
					<xsl:apply-templates select="$stelle/adv:beschreibungDesSondereigentums" mode="copy-it"/>
				</xsl:if>
				<xsl:call-template name="AX_K_Buchungsangaben_HD">
					<xsl:with-param name="stelle" select="$stelle"/>
				</xsl:call-template>
				<xsl:for-each select="//adv:AX_Namensnummer[substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')=$blatt/@gml:id]">
					<eigentuemer>
						<xsl:apply-templates select="." mode="AX_K_PERS1"/>
					</eigentuemer>
				</xsl:for-each>
			<!-- /AX_Recht>
		</grundstuecksgleicheRechte --><!-- Auskommentiert, da hier falsch. Richtig bei Template AX_Recht -->
		</AX_K_Eigentum> <!-- Statt dem Auskommentierten diese Klammer hinzugefügt. -->
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Eigentum__fiktiv">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelleFiktiv"/>
		<xsl:param name="stelle"/>
		<xsl:param name="bart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<AX_K_Eigentum xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1"> <!-- Statt dem Auskommentierten diese Klammer hinzugefügt. -->
		<!-- grundstuecksgleicheRechte xmlns="http://www.adv-online.de/namespaces/adv/gid/3.0">
			<AX_Recht --><!-- Auskommentiert, da hier falsch. Richtig bei Template AX_Recht -->
				<buchung>
					<xsl:call-template name="AX_Buchung">
						<xsl:with-param name="blatt" select="$blatt"/>
						<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
					</xsl:call-template>
				</buchung>
				<buchungsart>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
						<xsl:with-param name="code" select="$bart"/>
					</xsl:call-template>
				</buchungsart>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<anteil>
						<xsl:apply-templates select="$stelle/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</anteil>
				</xsl:if>
				<xsl:if test="count($stelleFiktiv/adv:anteil)=1">
					<aufgeteilterAnteil>
						<xsl:apply-templates select="$stelleFiktiv/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</aufgeteilterAnteil>
				</xsl:if>
				<xsl:if test="count($stelle/adv:nummerImAufteilungsplan)=1">
					<xsl:apply-templates select="$stelle/adv:nummerImAufteilungsplan" mode="copy-it"/>
				</xsl:if>
				<xsl:if test="count($stelle/adv:beschreibungDesSondereigentums)=1">
					<xsl:apply-templates select="$stelle/adv:beschreibungDesSondereigentums" mode="copy-it"/>
				</xsl:if>
				<xsl:call-template name="AX_K_Buchungsangaben_HD">
					<xsl:with-param name="stelle" select="$stelle"/>
				</xsl:call-template>
				<xsl:for-each select="//adv:AX_Namensnummer[substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')=$blatt/@gml:id]">
					<eigentuemer>
						<xsl:apply-templates select="." mode="AX_K_PERS1"/>
					</eigentuemer>
				</xsl:for-each>
			<!-- /AX_Recht>
		</grundstuecksgleicheRechte --><!-- Auskommentiert, da hier falsch. Richtig bei Template AX_Recht -->
		</AX_K_Eigentum><!-- Statt dem Auskommentierten diese Klammer hinzugefügt. -->
	</xsl:template>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_Eigentum__einfach">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<AX_K_Eigentum xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1"><!-- Statt dem Auskommentierten diese Klammer hinzugefügt. -->
		<!-- grundstuecksgleicheRechte xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1">
			<AX_Recht --><!-- Auskommentiert, da hier falsch. Richtig bei Template AX_Recht -->
				<buchung>
					<xsl:call-template name="AX_Buchung">
						<xsl:with-param name="blatt" select="$blatt"/>
						<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
					</xsl:call-template>
				</buchung>
				<buchungsart>
					<xsl:call-template name="entschluesseln">
						<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
						<xsl:with-param name="code" select="$bart"/>
					</xsl:call-template>
				</buchungsart>
				<xsl:if test="count($stelle/adv:anteil)=1">
					<anteil>
						<xsl:apply-templates select="$stelle/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</anteil>
				</xsl:if>
				<xsl:call-template name="AX_K_Buchungsangaben_HD">
					<xsl:with-param name="stelle" select="$stelle"/>
				</xsl:call-template>
				<xsl:for-each select="//adv:AX_Namensnummer[substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')=$blatt/@gml:id]">
					<eigentuemer>
						<xsl:apply-templates select="." mode="AX_K_PERS1"/>
					</eigentuemer>
				</xsl:for-each>
			<!-- /AX_Recht>
		</grundstuecksgleicheRechte --><!-- Auskommentiert, da hier falsch. Richtig bei Template AX_Recht -->
		</AX_K_Eigentum><!-- Statt dem Auskommentierten diese Klammer hinzugefügt. -->
	</xsl:template>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Namensnummer-, AX_Person-, AX_Anschrift-, AX_Buchungsblattbezirk- und AX_Dienststelle-Objekte verfügbar -->
	<xsl:template name="AX_K_Eigentum__alle">
	<!-- Auf GeoInfoDok 5.1 -->
		<xsl:param name="stelle"/>
		<xsl:param name="bart"/>
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
		<xsl:choose>
			<xsl:when test="$bart='1100' or $bart='5101' or $bart='5200' or $bart='5201' or $bart='5202' or $bart='5203' or $bart='1200' or $bart='2101'">
				<xsl:call-template name="AX_K_Eigentum__einfach">
					<xsl:with-param name="stelle" select="$stelle"/> <!-- Im Select stand vorher fälschlicherweise nur ein Punkt ("."), wodurch ein komplettes Dokument übergeben wurde. -->
				</xsl:call-template>
				<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:')]">
					<xsl:call-template name="AX_K_Eigentum__alle">
						<xsl:with-param name="stelle" select="."/>
						<xsl:with-param name="bart" select="./adv:buchungsart"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$bart='2102' or $bart='2103' or $bart='1303'">
				<xsl:call-template name="AX_K_Eigentum__einfach">
					<xsl:with-param name="stelle" select="$stelle"/> <!-- Im Select stand vorher fälschlicherweise nur ein Punkt ("."), wodurch ein komplettes Dokument übergeben wurde. -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$bart='2201' or $bart='2202' or $bart='2203' or $bart='2205'">
				<xsl:choose>
					<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2301' or adv:buchungsart='2302' or adv:buchungsart='2303' or adv:buchungsart='2305')])>0">
						<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2301' or adv:buchungsart='2302' or adv:buchungsart='2303' or adv:buchungsart='2305')]">
							<xsl:call-template name="AX_K_Eigentum__fiktiv">
								<xsl:with-param name="stelleFiktiv" select="$stelle"/>
								<xsl:with-param name="stelle" select="."/>
								<xsl:with-param name="bart" select="$stelle/adv:buchungsart"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2401' or adv:buchungsart='2402' or adv:buchungsart='2403' or adv:buchungsart='2405')])>0">
						<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2401' or adv:buchungsart='2402' or adv:buchungsart='2403' or adv:buchungsart='2405')]">
							<xsl:call-template name="AX_K_Eigentum__alle">
								<xsl:with-param name="stelle" select="."/>
								<xsl:with-param name="bart" select="./adv:buchungsart"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$bart='2401' or $bart='2402' or $bart='2403' or $bart='2405' or $bart='1403'">
				<xsl:choose>
					<xsl:when test="count(//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2501' or adv:buchungsart='2502' or adv:buchungsart='2503' or adv:buchungsart='2505' or adv:buchungsart='1503')])>0">
						<xsl:for-each select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='2501' or adv:buchungsart='2502' or adv:buchungsart='2503' or adv:buchungsart='2505' or adv:buchungsart='1503')]">
							<xsl:call-template name="AX_K_Eigentum__fiktiv">
								<xsl:with-param name="stelleFiktiv" select="$stelle"/>
								<xsl:with-param name="stelle" select="."/>
								<xsl:with-param name="bart" select="$bart"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$bart='1101' or $bart='1102'"><!-- Unklar, wann dies vorkommt. -->
				<xsl:call-template name="AX_K_Eigentum__einfach">
					<xsl:with-param name="stelle" select="$stelle"/> <!-- Im Select stand vorher fälschlicherweise nur ein Punkt ("."), wodurch ein komplettes Dokument übergeben wurde. -->
				</xsl:call-template>
				<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='1301' or adv:buchungsart='1302')]">
					<xsl:call-template name="AX_K_Eigentum__sonstige">
						<xsl:with-param name="stelle" select="."/>
						<xsl:with-param name="bart" select="$bart"/>
					</xsl:call-template>
				</xsl:for-each>
				<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='1401' or adv:buchungsart='1402')]">
					<xsl:variable name="stelle14" select="."/>
					<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle14/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and(adv:buchungsart='1501' or adv:buchungsart='1502')]">
						<xsl:call-template name="AX_K_Eigentum__fiktiv">
							<xsl:with-param name="stelleFiktiv" select="$stelle14"/>
							<xsl:with-param name="stelle" select="."/>
							<xsl:with-param name="bart" select="$bart"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
