<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1 -->

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1"
	xmlns:ogc="http://www.opengis.net/ogc"
	xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" 
	xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- ==================================================== -->
	<xsl:template name="AX_K_BUCHUNGSANGABEN__alle">
		<xsl:param name="stelle"/>
		<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
		<xsl:choose>
			<xsl:when test="$bart='1100' or $bart='5101' or $bart='5200' or $bart='5201' or $bart='5202' or $bart='5203' or $bart='1200'">
				<xsl:call-template name="AX_K_BUCHUNGSANGABEN">
					<xsl:with-param name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
					<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/>
					<xsl:with-param name="bart" select="$bart"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$bart='1101' or $bart='1102'"><!-- Aufgeteilte Buchungen WEG bzw. §3.4 GBO -->
				<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='1301' or adv:buchungsart='1302')]">
					<xsl:variable name="stelle13" select="."/>
					<xsl:call-template name="AX_K_BUCHUNGSANGABEN">
						<xsl:with-param name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle13/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/>
						<xsl:with-param name="lfdNr" select="$stelle13/adv:laufendeNummer"/>
						<xsl:with-param name="bart" select="$bart"/>
					</xsl:call-template>
				</xsl:for-each>
				<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='1401' or adv:buchungsart='1402')]">
					<xsl:variable name="stelle14" select="."/>
					<xsl:for-each select="//adv:AX_Buchungsstelle[$stelle14/@gml:id=substring-after(adv:an/@xlink:href,'urn:adv:oid:') and 	(adv:buchungsart='1501' or adv:buchungsart='1502')]">
						<xsl:variable name="stelle15" select="."/>
						<xsl:call-template name="AX_K_BUCHUNGSANGABEN">
							<xsl:with-param name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle15/adv:istBestandteilVon/	@xlink:href,'urn:adv:oid:')]"/>
							<xsl:with-param name="lfdNr" select="$stelle15/adv:laufendeNummer"/>
							<xsl:with-param name="bart" select="$bart"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=document('AX_Benutzungsauftrag.xml')//ogc:Literal]"/>
		<xsl:call-template name="AX_K_BUCHUNGSANGABEN__alle">
			<xsl:with-param name="stelle" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($flurstueck/adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
		</xsl:call-template>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
