<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->	
	<!-- =========================================================== -->
	<xsl:template name="summiereFlurstuecksflaechen">
		<xsl:param name="tn"/>
		<xsl:param name="flurstuecke"/>
		<xsl:choose>
			<xsl:when test="$tn">
				<xsl:variable name="rec_res">
					<xsl:call-template name="summiereFlurstuecksflaechen">
						<xsl:with-param name="tn" select="$tn"/>
						<xsl:with-param name="flurstuecke" select="$flurstuecke[position()>1]"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- Flächenermittlung vom ersten Flurstück -->
				<xsl:variable name="flur" select="$flurstuecke[1]"/>
				<!-- Korrekturfaktor bestimmen -->
				<xsl:variable name="korrekturfaktor">
					<xsl:choose>
						<xsl:when test="function-available('ext:berechneFlaeche')">
							<xsl:value-of select="$flur/adv:amtlicheflaeche div ext:berechneFlaeche($flur/adv:position)"/>
						</xsl:when>
						<xsl:otherwise>1.0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!-- Flächenermittlung vom Rest -->
				<xsl:variable name="res">
					<xsl:call-template name="summiereTeilflaechen">
						<!-- alle Flurstücke der Gemarkung -->
						<xsl:with-param name="tn" select="$tn"/>
						<xsl:with-param name="flurstuecksflaeche" select="$flur/adv:position"/>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="number($res) + $rec_res"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="0"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	<!-- =========================================================== -->
	<xsl:template name="flaecheTNGD">
		<xsl:param name="schluessel"/>
		<xsl:param name="tn"/>
		<xsl:param name="fkt"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<flaecheTNGD>
				<AX_K_TNFL_all>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<funktionOA><xsl:value-of select="$fkt"/></funktionOA>
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[adv:gemeindezugehoerigkeit = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_TNFL_all>
			</flaecheTNGD>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaechensummeOAGD">
		<xsl:param name="schluessel"/>
		<xsl:param name="tn"/>
		<xsl:param name="fkt"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<flaechensummeOAGD>
				<AX_K_TNGR_all>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<funktionOA><xsl:value-of select="$fkt"/></funktionOA>
					<!-- Gesamtflaeche über jedes Flurstück -->
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[adv:gemeindezugehoerigkeit = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_TNGR_all>
			</flaechensummeOAGD>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaechensummeHGrGD">
		<xsl:param name="schluessel"/>
		<xsl:param name="tn"/>
		<xsl:param name="fkt"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<flaechensummeHGrGD>
				<AX_K_TNHGR_all>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<funktionHGr><xsl:value-of select="$fkt"/></funktionHGr>
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[adv:gemeindezugehoerigkeit = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_TNHGR_all>
			</flaechensummeHGrGD>
		</xsl:if>
	</xsl:template>					
	<!-- =========================================================== -->
	<xsl:template name="naechsteSumme">	
		<!-- Summenbildung für jede Gemeinden: jede Gemeinde hat ein eigenes Ergebnisdokument 'E2_Gemeinde_<Schlüssel>.xml' -->
		<!-- Hinweis: Summenbildung über die Gemarkungen ist z.B. für Bayern nicht richtig, daher Bildung über Flurstücke -->
		<xsl:for-each select="document('E1.xml')//adv:AX_KommunalesGebiet">
			<!-- Sortierung der Ausgabe nach Schlüssel -->
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Schlüssel vermerken -->
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>

			<!-- flaecheTNGD -->
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4101"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Wohnbaufläche" statt "4101" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Wohnbauflaeche"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4102"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Industrie- und Gewerbefläche" statt "4102" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4103"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Halde" statt "4103" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Halde"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4104"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Bergbaubetrieb" statt "4104" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bergbaubetrieb"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4105"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Tagebau, Grube, Steinbruch" statt "4105" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_TagebauGrubeSteinbruch"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4106"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Fläche gemischter Nutzung" statt "4106" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_FlaecheGemischterNutzung"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4107"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Fläche besonderer funktionaler Prägung" statt "4107" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4108"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Sport-, Freizeit und Erholungsfläche" statt "4108" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4109"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Friedhof" statt "4109" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Friedhof"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4201"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Straßenverkehr" statt "4201" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Strassenverkehr"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4206"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Weg" statt "4206" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Weg"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4209"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Platz" statt "4209" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Platz"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4210"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Bahnverkehr" statt "4210" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bahnverkehr"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4215"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Flugverkehr" statt "4215" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Flugverkehr"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4216"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Schiffsverkehr" statt "4216" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Schiffsverkehr"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4301"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Landwirtschaft" statt "4301" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Landwirtschaft"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4302"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Wald" statt "4302" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Wald"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4303"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Gehölz" statt "4303" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Gehoelz"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4304"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Heide" statt "4304" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Heide"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4305"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Moor" statt "4305" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Moor"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4306"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Sumpf" statt "4306" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Sumpf"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4307"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "UnlandVegetationslose Fläche" statt "4307" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4401"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Fließgewässer" statt "4401" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fliessgewaesser"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4405"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Hafenbecken" statt "4405" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Hafenbecken"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4406"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Stehendes Gewässer" statt "4406" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_StehendesGewaesser"/>
			</xsl:call-template >
			<xsl:call-template name="flaecheTNGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4407"/><!-- Falls per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Meer" statt "4407" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Meer"/>
			</xsl:call-template >

			<!-- flaechensummeOAGD -->
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4101"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Wohnbaufläche" statt "4101" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Wohnbauflaeche"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4102"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Industrie- und Gewerbefläche" statt "4102" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche[contains('1700,1701,1710,1720,1730,1740,1750,1760,1770,1780,1790,1400,1410,1420,1430,1440,1450,1460,1470,1480,1490,2500,2501,2502,2510,2520,2521,2522,2530,2531,2532,2540,2550,2551,2552,2560,2561,2562,2570,2571,2572,2580,2581,2582,2600,2601,2602,2610,2611,2612,2620,2621,2622,2623,2630,2640',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4103"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Halde" statt "4103" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Halde"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4104"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Bergbaubetrieb" statt "4104" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bergbaubetrieb"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4105"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Tagebau, Grube, Steinbruch" statt "4105" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_TagebauGrubeSteinbruch"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4106"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Fläche gemischter Nutzung" statt "4106" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_FlaecheGemischterNutzung[contains('2100,2110,2120,2130,2140,2150,2160,2700,2710,2720,2730,6800,7600',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4107"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Fläche besonderer funktionaler Prägung" statt "4107" übergeben. -->
				<!-- Folgende Werte wurden ergänzt, die gemappt werden und zu den Zielwerten passen: 1100,1110,1120,1130,1140,1150,1160,1170,1200,1300,1310,1320 -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung[contains('1100,1110,1120,1130,1140,1150,1160,1170,1200,1300,1310,1320,1500,1510,1520,1530,1540,1550,1560,1570,1600,1800,1810,1820',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4108"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Sport-, Freizeit und Erholungsfläche" statt "4108" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche[contains('4100,4001,4101,4110, 4120,4130,4140,4150,4160,4170,4200,4210,4211,4220,4230,4240,4250,4260,4270,4280,4290,4300,4301,4310,4320,4321,4330,4331,4400,4410,4420,4430,4431,4440,4450,4460,4470',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4109"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Friedhof" statt "4109" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Friedhof[contains('9401,9402,9403,9404',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4201"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Straßenverkehr" statt "4201" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Strassenverkehr[contains('2311,2312,2313,5130',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4206"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Weg" statt "4206" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Weg[contains('5210,5211,5212,5220,5230,5240,5250,5260',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4209"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Platz" statt "4209" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Platz[contains('5130,5310,5320,5330,5340,5350',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4210"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Bahnverkehr" statt "4210" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bahnverkehr[contains('2321,2322',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4215"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Flugverkehr" statt "4215" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Flugverkehr[contains('5501',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4216"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Schiffsverkehr" statt "4216" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Schiffsverkehr[contains('2341,5610,5620,5630,5640',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4301"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Landwirtschaft" statt "4301" übergeben. -->
				<!-- adv:vegetationsmerkmal wird geprüft, 1200 wird auf 2101 gemappt, deshalb mit in der Liste -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Landwirtschaft[contains('1200,1010,1011,1012,1013,1020,1021,1030,1031,1040,1050,1051,1052,2101',adv:vegetationsmerkmal)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4302"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Wald" statt "4302" übergeben. -->
				<!-- adv:vegetationsmerkmal wird geprüft -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Wald[contains('1100,1200,1300,1310,1320',adv:vegetationsmerkmal)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4303"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Gehölz" statt "4303" übergeben. -->
				<!-- adv:vegetationsmerkmal wird geprüft, 1400 wird auf 1401 gemappt, deshalb mit in der Liste -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Gehoelz[contains('1400,1401',adv:vegetationsmerkmal)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4304"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Heide" statt "4304" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Heide"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4305"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Moor" statt "4305" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Moor"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4306"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Sumpf" statt "4306" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Sumpf"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4307"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "UnlandVegetationslose Fläche" statt "4307" übergeben. -->
				<!-- Folgende Werte wurden ergänzt, die gemappt werden und zu den Zielwerten passen: 1000,1100,1110,1120,1200 -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche[contains('1000,1100,1110,1120,1200,4307, 8111, 8112, 8113, 8114, 8115',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4401"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Fließgewässer" statt "4401" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fliessgewaesser[contains('8200,8210,8220,8300,8400,8410,8500',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4405"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Hafenbecken" statt "4405" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Hafenbecken[contains('8810',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4406"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Stehendes Gewässer" statt "4406" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_StehendesGewaesser[contains('8610,8620,8630,8631,8640',adv:funktion)]"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeOAGD">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4407"/><!-- Falls per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Meer" statt "4407" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Meer[contains('8710,8720',adv:funktion)]"/>
			</xsl:call-template >
			
			<!-- flaechensummeHGrGD: nicht optimal, da einzelne Summen schon berechnet worden sind -->
			<xsl:call-template name="flaechensummeHGrGK">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4100"/><!-- Falls per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Siedlung" statt "4100" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Wohnbauflaeche|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Halde|document('E2_Gemeinde_{$schluessel}.xml')/AX_Bergbaubetrieb|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_TagebauGrubeSteinbruch|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_FlaecheGemischterNutzung|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Friedhof"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeHGrGK">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4200"/><!-- Falls per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Verkehr" statt "4200" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Strassenverkehr|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Weg|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Platz|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Bahnverkehr|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Flugverkehr|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Schiffsverkehr"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeHGrGK">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4300"/><!-- Falls per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Vegetation" statt "4300" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Landwirtschaft|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Wald|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Gehoelz|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Heide|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Moor|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Sumpf|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche"/>
			</xsl:call-template >
			<xsl:call-template name="flaechensummeHGrGK">
				<xsl:with-param name="schluessel" select="$schluessel"/>
				<xsl:with-param name="fkt" select="4400"/><!-- Falls per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Gewässer" statt "4400" übergeben. -->
				<xsl:with-param name="tn"  select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fliessgewaesser|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Hafenbecken|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_StehendesGewaesser|
												   document('E2_Gemeinde_{$schluessel}.xml')/AX_Meer"/>
			</xsl:call-template >
			<gesamtflaecheGD>
				<AX_K_FLASU>
					<gebiet>
						<xsl:value-of select="adv:schluesselGesamt"/>
					</gebiet>
					<flaechensumme>
						<xsl:value-of select="adv:amtlicheGemeindeflaeche"/>
					</flaechensumme>
				</AX_K_FLASU>
			</gesamtflaecheGD>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:choose>
			<xsl:when test="$anlassart = '2110'">
				<!-- nur Gemarkungsstatistik: somit hat der vorhergehende Schritt das Endergebnis ermittelt -->
				<xsl:copy-of select="document('A3_Statistik_Gemarkung.xml)/."/>
			</xsl:when>
			<xsl:otherwise>
				<!-- sonst: Muss die vorhergehende Statistik (Gemarkungsstatistik) gelöscht werden? -->
				<xsl:variable name="clear">
					<xsl:choose>
						<xsl:when test="$anlassart = '2121' or $anlassart = '2131' or $anlassart = '2141' or $anlassart = '2151'">
							<!-- komplette Statistik: Gemarkungsstatistik nicht löschen -->
							<xsl:value-of select="''"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- nur höchste Statistik: Gemarkungsstatistik löschen -->
							<xsl:value-of select="'flaecheTNGK,flaechensummeOAGK,flaechensummeHGrGK'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
					<!-- Teile vom vorhergehenden Ergebnis kopieren, ggf. Gemarkungsstatistik löschen -->
					<xsl:for-each select="document('A3_Statistik_Gemarkung.xml)/*/*">
						<xsl:if test="not(contains($clear,name(.)))">
							<xsl:copy-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<!-- Gemeindestatistik bilden -->
					<xsl:call-template name="naechsteSumme"/>
				</AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
