<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Grundstuecksnachweis xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1 NAS-Operationen.xsd">
			<erlaeuterung/>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<kopf>
				<xsl:apply-templates select="document('AX_Buchung.xml')//adv:AX_Buchung" mode="copy-it"/>
			</kopf>
			<xsl:for-each select="document('AX_K_FLURSTUECK2.xml')//adv:AX_K_FLURSTUECK2">
				<flurstueck>
					<xsl:apply-templates select="." mode="copy-it"/>
				</flurstueck>
			</xsl:for-each>
			<xsl:for-each select="document('AX_K_Eigentum.xml')//adv:AX_K_Eigentum">
				<eigentum>
					<xsl:apply-templates select="." mode="copy-it"/>
				</eigentum>
			</xsl:for-each>
			<grundstuecksflaeche>
				<xsl:value-of select="sum(document('E1.xml')//adv:AX_Flurstueck/adv:amtlicheFlaeche)"/>
			</grundstuecksflaeche>
		</AX_Grundstuecksnachweis>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
