<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" 	
	xmlns:gml="http://www.opengis.net/gml/3.2" 
	xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" 
	xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" 
	xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:variable name="p3" select="//ogc:Literal"/>
		<xsl:variable name="p4" select="//adv:koordinatenreferenzsystem"/><!-- Hier noch eingebaut. -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<xsl:if test="count($p4)=1">
				<koordinatenreferenzsystem><xsl:value-of select="$p4"/></koordinatenreferenzsystem>
			</xsl:if>
			<anforderungsmerkmale>
				<wfs:Query typeName="AX_Lagefestpunkt">
					<XlinkPropertyPath>bestehtAus/AX_PunktortAU</XlinkPropertyPath>
					<XlinkPropertyPath>bestehtAus/AX_Skizze</XlinkPropertyPath>
					<XlinkPropertyPath>istIdentischMitSFP/AX_Schwerefestpunkt</XlinkPropertyPath>
					<XlinkPropertyPath>istIdentischMitHFP/AX_Hoehenfestpunkt</XlinkPropertyPath>
					<XlinkPropertyPath>istIdentischMitRSP/AX_Referenzstationspunkt</XlinkPropertyPath>
					<ogc:Filter>
					<ogc:And><!-- Hier noch das And eingebaut. -->
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>punktkennung</ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="$p3"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsNotEqualTo>
							<ogc:PropertyName>klassifikation/AX_Klassifikation_Lagefestpunkt/wertigkeit</ogc:PropertyName>
							<ogc:Literal>3000</ogc:Literal>
						</ogc:PropertyIsNotEqualTo>
						<ogc:PropertyIsNull>
							<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
						</ogc:PropertyIsNull>
					</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Bundesländer, Gemeinden und Katasterämter mit deren Anschrift. -->
				<!-- Dies ist natürlich nicht eins zu eins umzusetzen, sondern ggf. in einem Zwischenschritt aus AX_Festpunkt.gemeinde das Gemeindekennzeichen zu ermitteln und für die Abfragen hier im Anschluß zu verwenden. -->
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_Bundesland"/>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat/AX_Anschrift</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal><!-- Hier statt 1100 ggf. länderspezifisch 1800 oder 2200, je nachdem, wer für die Festpunkte zuständig ist. -->
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</anforderungsmerkmale>
			<profilkennung><xsl:value-of select="$p1"/></profilkennung>
			<antragsnummer><xsl:value-of select="$p2"/></antragsnummer>			
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
