/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Ocl.SourceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;

public class MessageCollection {
    ArrayList<Message> messages = new ArrayList();
    static HashMap<Integer, String> messageTexts = new HashMap();
    static String unknown;

    Checkpoint captureState() {
        Checkpoint chp = new Checkpoint();
        chp.checkpoint_index = this.messages.size();
        return chp;
    }

    void releaseState(Checkpoint chp) {
    }

    void restoreState(Checkpoint chp) {
        this.messages.subList(chp.checkpoint_index, this.messages.size()).clear();
    }

    public Message[] getMessages() {
        Message[] messes = new Message[this.messages.size()];
        messes = this.messages.toArray(messes);
        return messes;
    }

    public int getNumberOfMessages() {
        return this.messages.size();
    }

    static {
        messageTexts.put(0, "System error: Assertion failed [%1%]");
        messageTexts.put(1, "Unrecognized syntax [%1%] encountered and ignored.");
        messageTexts.put(2, "Closing bracket ')' expected preceding %1% token, assumed.");
        messageTexts.put(3, "Identifier, literal or bracketed expression expected preceding %1% token. Invalid assumed.");
        messageTexts.put(4, "Name expected as part of a scoped identifier. Found %1%, ignored.");
        messageTexts.put(5, "Operator %1% expected as part of if-construct. Found %2%, skipping to endif");
        messageTexts.put(6, "End of text encountered while skipping for operator.");
        messageTexts.put(7, "Operator %1% expected as part of let-construct. Found %2%, ignoring construct.");
        messageTexts.put(8, "Complex literal of type %1% not implemented, ignoring construct.");
        messageTexts.put(9, "Opening bracket '(' expected in initializer of %1% literal.");
        messageTexts.put(10, "Closing bracket ')' expected preceding %1% token, assumed.");
        messageTexts.put(11, "Date constructor argument must be string constant complying to ISO8601 syntax.");
        messageTexts.put(12, "End of text encountered while skipping for paired bracket.");
        messageTexts.put(13, "Name expected as mandatory part of variable declaration preceding '%1%' token, ignored.");
        messageTexts.put(14, "Extra tokens following OCL expression ignored, starting with '%1%'.");
        messageTexts.put(15, "Condition keyword (like inv:) expected introducing expression. Found '%1%', ignored.");
        messageTexts.put(16, "Colon ':' missing following condition keyword. Found '%1%'.");
        messageTexts.put(21, "Class named '%1%' not found in model.");
        messageTexts.put(22, "Class named '%1%' not found in package '%2%'.");
        messageTexts.put(23, "Package named '%1%' not found in model.");
        messageTexts.put(24, "Package named '%1%' not found in package '%2%'.");
        messageTexts.put(25, "Right hand side of referencing operation '%1%' must be identifier.");
        messageTexts.put(26, "Attribute named '%1%' not available on class '%2%'.");
        messageTexts.put(27, "Operation named '%1%' (%3% non-collection arguments) not available on class '%2%'.");
        messageTexts.put(28, "Set properties are not available on class 'class'.");
        messageTexts.put(29, "Variable declaration syntax not permitted on non-iterative operation '%1%'.");
        messageTexts.put(30, "Scope of identifier '%1%' does not designate same or super class of '%2%'.");
        messageTexts.put(31, "Excess binding variable declarations on iterator '%1%'.");
        messageTexts.put(32, "Operation named '%1%' (%2% arguments) not available on any implicit variable in scope.");
        messageTexts.put(33, "Value '%1%' not found in Enumeration or Codelist '%2%'.");
        messageTexts.put(34, "Identifier named '%1%' could not be resolved to either a variable, a property on an implicit variable, a class or an enumeration.");
        messageTexts.put(35, "Condition part of if-clause must be of Boolean type.");
        messageTexts.put(36, "Common supertype of type '%1%' of if-part and and type '%2%' of else-part could not be determined.");
        messageTexts.put(37, "Declaration of variable '%1%' in let-construct does not exhibit type information.");
        messageTexts.put(38, "Type name '%1%' in declaration of variable '%2%' does not correspond to any known type.");
        messageTexts.put(39, "Declared type '%1%' and type of initializer '%2%' are not compatible in declaration of variable '%3%'.");
        messageTexts.put(40, "Type implied by context '%1%' and declared type '%2%' are not compatible in declaration of variable '%3%'.");
        messageTexts.put(41, "Type of 'invariant' condition must be 'Boolean', type determined is '%1%'.");
        messageTexts.put(42, "Type of 'derive' or 'init' condition must correspond to the type '%1%' of its context property, type determined is '%2%'.");
        messageTexts.put(43, "Infix operation '%1%' is not available for operand types '%2%' and '%3%'.");
        messageTexts.put(44, "Prefix operation '%1%' is not available for operand of type '%2%'.");
        messageTexts.put(45, "Collection type result is not permitted for an 'invariant' condition.");
        messageTexts.put(46, "A collection type of a 'derive' or 'init' condition result requires a context property, which has a cardinality greater 1.");
        unknown = "System error: Unknown message number %1% encountered.";
    }

    static class Checkpoint {
        private int checkpoint_index;

        Checkpoint() {
        }
    }

    public class Message {
        int messageNo;
        String messageText;
        Severity severity = Severity.ERROR;
        ArrayList<SourceReference> sourceRef = new ArrayList(1);

        Message(Integer messNo) {
            this.messageNo = messNo;
            this.messageText = messageTexts.get(messNo);
            if (this.messageText == null) {
                this.messageText = unknown;
                this.messageNo = 0;
                this.substitute(1, messNo.toString());
            }
            MessageCollection.this.messages.add(this);
            if (this.messageNo == 0) {
                this.severity = Severity.SYSTEMERROR;
            }
        }

        void substitute(Integer pos, String text) {
            String quotedText = Matcher.quoteReplacement(text);
            this.messageText = this.messageText.replaceAll("%" + pos.toString() + "%", quotedText);
        }

        void addSourceReference(SourceReference sourceref) {
            this.sourceRef.add(sourceref);
        }

        void addSourceReferences(SourceReference[] sourcerefs) {
            if (sourcerefs == null) {
                return;
            }
            for (SourceReference sr : sourcerefs) {
                this.addSourceReference(sr);
            }
        }

        public SourceReference[] getSourceReferences() {
            SourceReference[] sr = new SourceReference[this.sourceRef.size()];
            sr = this.sourceRef.toArray(sr);
            return sr;
        }

        void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getMessageText() {
            return this.messageText;
        }

        public String getFormattedSourceReferences(int offLine, int offCol, String[] delims) {
            String sr = "";
            boolean first = true;
            for (SourceReference s : this.sourceRef) {
                int l = s.getLineNumber() + offLine;
                int cf = s.getColumnFrom() + offCol;
                int ct = s.getColumnTo() + offCol;
                if (!first) {
                    sr = sr + (delims.length > 2 ? delims[2] : ",");
                }
                first = false;
                sr = sr + String.valueOf(l) + (delims.length > 0 ? delims[0] : "/");
                sr = sr + String.valueOf(cf);
                if (cf == ct) continue;
                sr = sr + (delims.length > 1 ? delims[1] : ":") + String.valueOf(ct);
            }
            return sr;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR,
        SYSTEMERROR;

    }
}

