/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Ocl_OLD.OclConstraint_OLD;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XsdDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlSchema
implements Target {
    private ShapeChangeResult result = null;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private boolean printed = false;
    private final HashMap<String, XsdDocument> xsdMap = new HashMap();
    private SchematronSchema schDoc = null;
    private boolean schematron = false;
    private int enumStyle = 1;
    private int basicTypeStyle = 1;
    private String outputDirectory;

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r) throws ShapeChangeAbortException {
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.result.addDebug(10012, this.pi.name());
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if ((s = this.options.parameter(this.getClass().getName(), "enumStyle")) != null) {
            if (s.equals("GLOBAL")) {
                this.enumStyle = 1;
            } else if (s.equals("LOCAL")) {
                this.enumStyle = 2;
            } else {
                this.result.addError("Unknown value for xsdEnumStyle: " + s);
            }
        }
        if ((s = this.options.parameter(this.getClass().getName(), "basicTypeStyle")) != null) {
            if (s.equals("GLOBAL")) {
                this.basicTypeStyle = 1;
            } else if (s.equals("LOCAL")) {
                this.basicTypeStyle = 2;
            } else {
                this.result.addError("Unknown value for xsdBasicTypeStyle: " + s);
            }
        }
        if ((s = this.options.parameter(this.getClass().getName(), "schematron")) != null && s.equals("true")) {
            this.schematron = true;
        }
        this.createXSDs(this.pi, null);
        this.processDependecies(this.pi);
        if (this.schematron) {
            this.schDoc = new SchematronSchema(this.model, this.options, this.result, this.pi);
        }
    }

    public void process(ClassInfo ci) {
        Element propertyHook;
        if (ci == null) {
            return;
        }
        if (ci.processed(this.type())) {
            return;
        }
        this.result.addDebug(10014, ci.name());
        int cat = ci.category();
        String rule = ci.encodingRule("xsd");
        if (rule.equals("notEncoded")) {
            return;
        }
        if (cat == -1) {
            cat = 6;
            ci.category(cat);
        }
        if (ci.pkg() == null) {
            this.result.addError(9, ci.name());
            return;
        }
        PackageInfo pi = ci.pkg();
        XsdDocument xsd = this.xsdMap.get(pi.id());
        while (xsd == null) {
            if ((pi = pi.owner()) == null) {
                this.result.addError(10, ci.name(), ci.pkg().name());
                return;
            }
            xsd = this.xsdMap.get(pi.id());
        }
        if (cat == 4 && !ci.checkSupertypes(4)) {
            this.result.addError(115, ci.name());
        }
        ClassInfo cibase = ci.baseClass();
        this.result.addDebug(10016, ci.name(), rule);
        Vector<Constraint> cs = ci.constraints();
        if (cs != null) {
            for (Constraint c : cs) {
                if (c == null || !(c instanceof OclConstraint_OLD) || this.schDoc == null) continue;
                this.schDoc.addAssertion(ci, (OclConstraint_OLD)c);
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                if (!rule.equals("iso19139_2007")) break;
                xsd.pObjectElement(ci, cibase, rule);
                break;
            }
            case 8: {
                if (!rule.equals("iso19136_2007_ShapeChange_1.0_Extensions") && ci.asGroup()) break;
            }
            case 1: 
            case 5: 
            case 6: {
                xsd.pObjectElement(ci, cibase, rule);
            }
        }
        switch (cat) {
            case 3: {
                if (!rule.equals("iso19139_2007") && !rule.equals("iso19136_2007") && !rule.equals("iso19136_2007_INSPIRE_Extensions") && !rule.equals("iso19136_2007_NoGmlBaseTypes") && (!rule.equals("iso19136_2007_ShapeChange_1.0_Extensions") || this.enumStyle != 1)) break;
                xsd.pGlobalEnumeration(ci, rule);
                break;
            }
            case 2: {
                if (!(rule.equals("iso19136_2007") && !ci.asDictionary() || rule.equals("iso19136_2007_INSPIRE_Extensions") && !ci.asDictionary() || rule.equals("iso19136_2007_NoGmlBaseTypes") && !ci.asDictionary()) && (!rule.equals("iso19136_2007_ShapeChange_1.0_Extensions") || this.enumStyle != 1 || ci.asDictionary())) break;
                xsd.pGlobalCodeList(ci);
                break;
            }
            case 8: {
                if (!rule.equals("iso19136_2007_ShapeChange_1.0_Extensions") && ci.asGroup()) break;
            }
            case 1: 
            case 5: 
            case 6: {
                propertyHook = xsd.pComplexType(ci, cibase, rule);
                xsd.processLocalProperties(ci, propertyHook, rule);
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                if (!rule.equals("iso19139_2007")) break;
                xsd.pPropertyTypes(ci, rule);
                break;
            }
            case 8: {
                if (!rule.equals("iso19136_2007_ShapeChange_1.0_Extensions") && ci.asGroup()) break;
            }
            case 1: 
            case 5: 
            case 6: {
                xsd.pPropertyTypes(ci, rule);
                break;
            }
            case 4: {
                if (!rule.equals("iso19136_2007_ShapeChange_1.0_Extensions")) break;
                xsd.pPropertyTypeWithSubtypes(ci);
            }
        }
        switch (cat) {
            case 8: {
                if (!ci.asGroup()) break;
            }
            case 4: {
                propertyHook = xsd.pGroup(ci, cibase);
                xsd.processLocalProperties(ci, propertyHook, rule);
                break;
            }
            case 7: {
                if (this.basicTypeStyle != 1) break;
                xsd.pGlobalBasicType(ci);
            }
        }
        ci.processed(this.type(), true);
    }

    public void write() {
        if (this.printed) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        for (XsdDocument xsd : this.xsdMap.values()) {
            if (xsd.printed()) continue;
            try {
                xsd.printFile(outputFormat);
                this.result.addXSDFile(this.outputDirectory, xsd.name, this.pi.targetNamespace());
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
        if (this.schematron) {
            this.schDoc.write(this.outputDirectory);
        }
        this.printed = true;
    }

    protected boolean createXSDs(PackageInfo pi, XsdDocument xsdcurr) throws ShapeChangeAbortException {
        XsdDocument xsd;
        boolean res = false;
        String xsdDocument = pi.xsdDocument();
        if (xsdDocument != null) {
            try {
                this.result.addDebug(10017, xsdDocument, pi.name());
                xsd = new XsdDocument(pi, this.model, this.options, this.result, xsdDocument);
                res = true;
            }
            catch (ParserConfigurationException e) {
                this.result.addFatalError(2);
                throw new ShapeChangeAbortException();
            }
        } else {
            xsd = xsdcurr;
            if (xsd == null) {
                this.result.addFatalError(15, pi.name());
                throw new ShapeChangeAbortException();
            }
        }
        this.xsdMap.put(pi.id(), xsd);
        try {
            HashSet<PackageInfo> sub = pi.containedPackages();
            for (PackageInfo pix : sub) {
                if (pix.isSchema()) {
                    xsd.addImport(pix.xmlns(), pix.targetNamespace());
                    continue;
                }
                boolean created = this.createXSDs(pix, xsd);
                if (!created) continue;
                xsd.addInclude(this.xsdMap.get(pix.id()));
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
            throw new ShapeChangeAbortException();
        }
        return res;
    }

    protected void processDependecies(PackageInfo pi) throws ShapeChangeAbortException {
        XsdDocument xsd1 = this.xsdMap.get(pi.id());
        for (String pid : pi.supplierIds()) {
            XsdDocument xsd2 = this.xsdMap.get(pid);
            if (xsd2 != null) {
                xsd1.addInclude(xsd2);
                continue;
            }
            PackageInfo pi2 = this.model.packageById(pid);
            if (pi2 == null) continue;
            xsd1.addImport(pi2.xmlns(), pi2.targetNamespace());
        }
        try {
            HashSet<PackageInfo> sub = pi.containedPackages();
            for (PackageInfo pix : sub) {
                if (pix.isSchema()) continue;
                this.processDependecies(pix);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException();
        }
    }

    public int type() {
        return 1;
    }
}

