/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.PackageInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.Xmi10Document;
import de.interactive_instruments.ShapeChange.XsdDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageInfoXmi10
implements PackageInfo {
    protected Element pkg;
    protected Xmi10Document doc;
    protected String id;
    protected XsdDocument gmlASD = null;
    protected boolean processedIncludes = false;
    protected UUID uuid = null;
    protected Document defDocument = null;
    protected Document smDocument = null;

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String s = this.doc.textOfProperty(this.pkg, "Foundation.Core.ModelElement.name");
        if (s == null) {
            s = this.id();
            this.doc.result.addWarning(100, s);
        } else {
            s = s.trim();
        }
        return s;
    }

    @Override
    public String encodingRule(String platform) {
        String s = this.doc.taggedValue(this.id, String.valueOf(platform) + "EncodingRule");
        if (s == null) {
            PackageInfo o = this.owner();
            if (o != null) {
                s = o.encodingRule(platform);
            }
            if (s == null) {
                s = "iso19136_2007";
            }
        }
        return s;
    }

    @Override
    public String targetNamespace() {
        PackageInfo o;
        String s = this.doc.taggedValue(this.id, "targetNamespace");
        if (s == null) {
            s = this.doc.taggedValue(this.id, "xmlNamespace");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.targetNamespace();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    @Override
    public String xmlns() {
        PackageInfo o;
        String s = this.doc.taggedValue(this.id, "xmlns");
        if (s == null) {
            s = this.doc.taggedValue(this.id, "xmlNamespaceAbbreviation");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.xmlns();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    protected String mapPackageNameToFilename(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return String.valueOf(str.toString()) + ".xsd";
    }

    @Override
    public String xsdDocument() {
        String stereotype;
        String s = this.doc.taggedValue(this.id, "xsdDocument");
        if (s == null) {
            s = this.doc.taggedValue(this.id, "xsdName");
        }
        if (s == null && (stereotype = this.doc.fStereotypes.get(this.id)) != null && stereotype.equals("application schema")) {
            s = this.mapPackageNameToFilename(this.name());
            this.doc.result.addWarning(101, this.name(), this.id, s);
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    @Override
    public String gmlProfileSchema() {
        return this.doc.taggedValue(this.id, "gmlProfileSchema");
    }

    @Override
    public String version() {
        String s = this.doc.taggedValue(this.id, "version");
        PackageInfo o = this.owner();
        if (s == null && o != null) {
            s = o.version();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    @Override
    public String documentation() {
        return this.doc.taggedValue(this.id, "documentation");
    }

    @Override
    public PackageInfo owner() {
        String s = this.doc.idOfProperty(this.pkg, "Foundation.Core.ModelElement.namespace");
        if (s.length() == 0) {
            s = this.doc.getOwnerIdAsString(this.pkg);
        }
        return this.doc.fPackages.get(s);
    }

    @Override
    public boolean isAppSchema() {
        String stereotype = this.doc.fStereotypes.get(this.id);
        return stereotype != null && stereotype.equals("application schema");
    }

    @Override
    public boolean isSchema() {
        String s = this.doc.taggedValue(this.id, "targetNamespace");
        if (s == null) {
            s = this.doc.taggedValue(this.id, "xmlNamespace");
        }
        return s != null;
    }

    @Override
    public HashSet<String> supplierIds() {
        HashSet<String> suppliers = new HashSet<String>();
        Vector<String> depids = this.doc.idsOfProperty(this.pkg, "Foundation.Core.ModelElement.clientDependency");
        Iterator<String> i = depids.iterator();
        while (i.hasNext()) {
            Element e = this.doc.getElementById(i.next());
            if (!this.doc.visible(e) && !this.doc.options.eaBugFixPublicPackagesAreMarkedAsPrivate) continue;
            Vector<String> pkgids = this.doc.idsOfProperty(e, "Foundation.Core.Dependency.supplier");
            for (String sid : pkgids) {
                suppliers.add(sid);
            }
        }
        return suppliers;
    }

    public XsdDocument gmlApplicationSchemaDocument() {
        return this.gmlASD;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] tags = tagList.split("\\,");
        int i = 0;
        while (i < tags.length) {
            String s = this.doc.taggedValue(this.id(), tags[i].trim());
            if (s != null) {
                ret.put(tags[i].trim(), s);
            }
            ++i;
        }
        return ret;
    }

    public PackageInfoXmi10(Xmi10Document d, Element e) throws ShapeChangeAbortException {
        this.doc = d;
        this.pkg = e;
        this.id = this.pkg.getAttribute("xmi.id");
        this.uuid = UUID.randomUUID();
        this.doc.fUUIDs.put(this.id, this.uuid);
        this.doc.result.addDebug(10001, this.id, this.name(), this.targetNamespace());
    }

    @Override
    public PackageInfo rootPackage() {
        return this.doc.fPackages.get(this.schemaId());
    }

    @Override
    public String schemaId() {
        if (this.isSchema()) {
            return this.id();
        }
        PackageInfo o = this.owner();
        if (o != null) {
            return o.schemaId();
        }
        return "(null)";
    }

    @Override
    public HashSet<PackageInfo> containedPackages() throws Exception {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        NodeList nl = XPathAPI.selectNodeList((Node)this.doc.document, (String)("//Model_Management.Package[Foundation.Core.ModelElement.namespace/Foundation.Core.Namespace/@xmi.idref='" + this.id() + "']"), (Node)this.doc.document.getDocumentElement());
        int j = 0;
        while (j < nl.getLength()) {
            Element e = (Element)nl.item(j);
            String xid = this.findValue(e, "@xmi.id");
            res.add(this.doc.fPackages.get(xid));
            ++j;
        }
        return res;
    }

    protected String getTextContents(Node node) {
        if (node == null) {
            return "";
        }
        StringBuffer contents = new StringBuffer();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 3) {
                contents.append(childNodes.item(i).getNodeValue());
            }
            ++i;
        }
        return contents.toString();
    }

    public String findValue(Node node, String xql) throws Exception {
        if (xql == null || xql.length() == 0) {
            throw new Exception("findValue called with empty xql statement");
        }
        if (node == null) {
            throw new Exception("findValue called with null node");
        }
        return this.getTextContents(XPathAPI.selectSingleNode((Node)node, (String)xql, (Node)this.doc.document.getDocumentElement()));
    }
}

