/*
 * Decompiled with CFR 0.152.
 */
package org.sparx;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sparx.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference
implements Iterable<String> {
    private long comObject = 0L;

    private native long comAddReference(long var1);

    private native void comDestructor(long var1);

    private native String comGetAt(long var1, short var3);

    private native short comGetCount(long var1);

    private native String comGetLastError(long var1);

    private native long comGetObjectType(long var1);

    private native String comGetType(long var1);

    private native short comRefresh(long var1);

    Reference(long l) {
        this.comObject = l;
    }

    public Reference(Reference reference) {
        this.comObject = this.comAddReference(reference.comObject);
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        if (this.comObject != 0L) {
            this.comDestructor(this.comObject);
            this.comObject = 0L;
        }
    }

    public String GetAt(short s) {
        return this.comGetAt(this.comObject, s);
    }

    long GetComObject() {
        return this.comObject;
    }

    public short GetCount() {
        return this.comGetCount(this.comObject);
    }

    public String GetLastError() {
        return this.comGetLastError(this.comObject);
    }

    public ObjectType GetObjectType() {
        return ObjectType.values()[(int)this.comGetObjectType(this.comObject)];
    }

    public String GetType() {
        return this.comGetType(this.comObject);
    }

    @Override
    public Iterator<String> iterator() {
        return new ReferenceIterator(this);
    }

    public short Refresh() {
        return this.comRefresh(this.comObject);
    }

    static {
        System.loadLibrary("SSJavaCOM");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReferenceIterator
    implements Iterator<String> {
        private Reference m_Reference;
        private short position = (short)-1;

        ReferenceIterator(Reference reference2) {
            this.m_Reference = reference2;
        }

        @Override
        public boolean hasNext() {
            return this.m_Reference.GetCount() > this.position + 1;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.position = (short)(this.position + 1);
            return this.m_Reference.GetAt(this.position);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

