/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.profiltool;

import de.adv_online.aaa.profiltool.ProfilRep;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;

public class Profil
implements Target {
    public static final int TARGET_AAA_Profiltool = 402;
    public static final int STATUS_WRITE_3AP = 31;
    public static final int STATUS_WRITE_MODEL = 32;
    public static final int STATUS_CLEAN_MODEL = 33;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String outputDirectory = null;
    private ProfilRep theProfile = null;
    private String quelle = null;
    private String ziel = null;
    private boolean error = false;

    public int getTargetID() {
        return 402;
    }

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        String mart = "FIXME";
        String profil = "FIXME";
        if (!this.options.gmlVersion.equals("3.2")) {
            this.result.addError(null, 110, this.pi.name());
            return;
        }
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "Verzeichnis");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("directory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Modellart")) != null) {
            mart = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Profil")) != null) {
            profil = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Quelle")) != null) {
            this.quelle = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Ziel")) != null) {
            this.ziel = s.trim();
        }
        if (this.ziel == null) {
            this.result.addError("Der Parameter 'Ziel' fehlt. Die Ausf\u00fchrung des Profiltools wird abgebrochen");
            this.error = true;
        } else if (this.quelle == null) {
            this.result.addError("Der Parameter 'Quelle' fehlt. Die Ausf\u00fchrung des Profiltools wird abgebrochen");
            this.error = true;
        } else if (this.quelle.equals("Datei")) {
            this.theProfile = new ProfilRep(p, m, o, r, this.outputDirectory + "/" + mart + "_" + profil + ".3ap");
        } else if (this.quelle.equals("Modell")) {
            this.theProfile = new ProfilRep(p, m, o, r, mart, profil);
        } else if (this.quelle.equals("Neu_Minimal") || this.quelle.equals("Neu_Maximal")) {
            if (mart.equals("FIXME") || profil.equals("FIXME") || mart.equals("") || profil.equals("")) {
                this.result.addError("Der Parameter 'Modellart' oder 'Profil' fehlt, das Erzeugen eines Profils ist nicht m\u00f6glich. Die Ausf\u00fchrung des Profiltools wird abgebrochen");
                this.error = true;
            } else {
                boolean gdb = false;
                if (this.quelle.equals("Neu_Minimal")) {
                    gdb = true;
                }
                this.theProfile = new ProfilRep(p, m, o, r, mart, profil, gdb);
            }
        } else {
            this.result.addError("Der Parameter 'Quelle' hat den unbekannten Wert '" + this.quelle + "'. Die Ausf\u00fchrung des Profiltools wird abgebrochen");
            this.error = true;
        }
    }

    public void process(ClassInfo ci) {
    }

    public void write() {
        if (this.error) {
            return;
        }
        if (this.ziel.equals("DateiModell")) {
            this.theProfile.writeToFile(this.outputDirectory + "/" + this.theProfile.name() + "__export.3ap");
            this.theProfile.writeToModel();
            this.result.addResult(this.getTargetID(), this.outputDirectory, this.theProfile.name() + "__export.3ap", this.options.parameter(this.getClass().getName(), "modellarten"));
        } else if (this.ziel.equals("Modell")) {
            this.theProfile.writeToModel();
        } else if (this.ziel.equals("Datei")) {
            this.theProfile.writeToFile(this.outputDirectory + "/" + this.theProfile.name() + "__export.3ap");
            this.result.addResult(this.getTargetID(), this.outputDirectory, this.theProfile.name() + "__export.3ap", this.options.parameter(this.getClass().getName(), "modellarten"));
        } else if (this.ziel.equals("Ohne")) {
            this.theProfile.clearInModel();
        } else {
            this.result.addError("Der Parameter 'Ziel' hat den unbekannten Wert '" + this.ziel + "'. Die Ausf\u00fchrung des Profiltools wird abgebrochen");
            this.error = true;
        }
    }
}

