/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.katalogtool;

import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.UI.Dialog;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import de.interactive_instruments.ShapeChange.UI.StatusReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.SystemUtils;

public class KatalogDialog
extends JFrame
implements ActionListener,
ItemListener,
Dialog,
StatusReader {
    public static final String VERSION_TEXT = "0.5";
    private static final String title = "AAA-Katalogtool";
    private static final long serialVersionUID = -2443287559064380497L;
    public static final int STATUS_READY = 1;
    public static final int STATUS_FINISHED = 2;
    private File logfile = null;
    private static final ArrayList<String> targetLabels = new ArrayList();
    private StatusBar statusBar;
    private HashMap<String, TargetGuiElements> targetGuiElems = new HashMap();
    JLabel appSchemaFieldLabel;
    JLabel schemaKennFieldLabel1;
    JLabel schemaKennFieldLabel2;
    JLabel modellartFieldLabel;
    JLabel xsltpfadFieldLabel;
    JLabel outDirFieldLabel;
    JLabel mdlDirFieldLabel;
    JTextField appSchemaField = null;
    JTextField schemaKennField = null;
    private JCheckBox geerbEigBox;
    JTextField modellartField = null;
    private JCheckBox grundDatBox;
    private JCheckBox profEinschrBox;
    private JCheckBox profDateiBox;
    JTextField profileField = null;
    JTextField xsltpfadField = null;
    JTextField outDirField = null;
    JTextField mdlDirField = null;
    private JCheckBox pkgBox;
    JTextField pkgField = null;
    private JButton startButton;
    private JButton viewLogButton;
    private JButton exitButton;
    private ConvertThread ct = null;
    private boolean modelTransformed;
    private boolean transformationRunning;
    protected Converter converter = null;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected String eap = null;
    private Model model = null;
    private String modelMsgText = "";
    private boolean saveModelMsgText = false;
    private JComponent newContentPane;
    private boolean blocked = false;
    private String paramKatalogClass = "de.adv_online.aaa.katalogtool.Katalog";

    public KatalogDialog() {
        super(title);
    }

    public KatalogDialog(Converter c, Options o, ShapeChangeResult r, String xmi) throws ShapeChangeAbortException {
        super(title);
        this.initialise(c, o, r, xmi);
    }

    public void initialise(Converter c, Options o, ShapeChangeResult r, String mdl) throws ShapeChangeAbortException {
        try {
            Object[] options;
            int val;
            String msg = "Akzeptieren Sie die in der mit diesem Tool auslieferten Datei 'Lizenzbedingungen zur Nutzung von Softwareskripten.doc' beschrieben Lizenzbedingungen?";
            if (msg != null && (val = JOptionPane.showOptionDialog(null, msg, "Confirmation", 2, 3, null, options = new Object[]{"Ja", "Nein"}, options[1])) == 1) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("Fehler in Dialog: " + e.toString());
        }
        this.options = o;
        File eapFile = new File(mdl);
        try {
            this.eap = eapFile.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            this.eap = "ERROR.eap";
        }
        this.converter = new Converter(this.options, r);
        this.result = r;
        this.modelTransformed = false;
        this.transformationRunning = false;
        StatusBoard.getStatusBoard().registerStatusReader((StatusReader)this);
        this.setDefaultCloseOperation(0);
        this.newContentPane = new JPanel(new BorderLayout());
        this.newContentPane.setOpaque(true);
        this.setContentPane(this.newContentPane);
        for (String label : targetLabels) {
            try {
                TargetGuiElements t = new TargetGuiElements(this, label);
                this.targetGuiElems.put(label, t);
            }
            catch (Exception e) {
                throw new ShapeChangeAbortException("Fatal error while creating dialog elements for target " + label + ".\nMessage: " + this.eap.toString() + "\nPlease check configuration file.");
            }
        }
        this.newContentPane.add(this.createMainTab(), "Center");
        this.statusBar = new StatusBar();
        Box fileBox = Box.createVerticalBox();
        fileBox.add(this.createStartPanel());
        fileBox.add(this.statusBar);
        this.newContentPane.add((Component)fileBox, "South");
        int height = 720;
        int width = 600;
        this.pack();
        Insets fI = this.getInsets();
        this.setSize(width + fI.right + fI.left, height + fI.top + fI.bottom);
        Dimension sD = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((sD.width - width) / 2, (sD.height - height) / 2);
        this.setMinimumSize(new Dimension(width, height));
        WindowAdapter listener = new WindowAdapter(){

            public void windowClosing(WindowEvent w) {
                KatalogDialog.this.closeDialog();
            }
        };
        this.addWindowListener(listener);
    }

    public void blockTransformation(boolean b) {
        this.blocked = b;
        if (b) {
            this.transformationRunning = true;
        } else {
            this.modelTransformed = true;
        }
        this.enableElements();
    }

    public void setVisible(boolean vis) {
        this.enableElements();
        super.setVisible(vis);
    }

    private Component createMainTab() {
        File f;
        File f2;
        String s = "";
        s = this.options.parameter("appSchemaName");
        String appSchemaStr = s != null && s.trim().length() > 0 ? s.trim() : "";
        s = this.options.parameter(this.paramKatalogClass, "schemakennungen");
        String schemaKennungenStr = s != null && s.trim().length() > 0 ? s.trim() : "*";
        Boolean geerbEigBool = false;
        s = this.options.parameter(this.paramKatalogClass, "geerbteEigenschaften");
        if (s != null && s.equals("true")) {
            geerbEigBool = true;
        }
        String modellartenStr = (s = this.options.parameter(this.paramKatalogClass, "modellarten")) == null || s.trim().length() == 0 ? "" : s.trim();
        Boolean grundDatBool = false;
        s = this.options.parameter(this.paramKatalogClass, "nurGrunddatenbestand");
        if (s != null && s.equals("true")) {
            grundDatBool = true;
        }
        Boolean profEinschrBool = false;
        Boolean profDateiBool = false;
        s = this.options.parameter(this.paramKatalogClass, "profile");
        String profileStr = s == null || s.trim().length() == 0 ? "" : s.trim();
        if (profileStr.length() > 0) {
            profEinschrBool = true;
        }
        if ((s = this.options.parameter(this.paramKatalogClass, "profilquelle")) != null && s.trim().equals("Datei")) {
            profDateiBool = true;
        }
        Boolean pkgBool = false;
        s = this.options.parameter(this.paramKatalogClass, "paket");
        String pkgStr = s == null || s.trim().length() == 0 ? "" : s.trim();
        if (pkgStr.length() > 0) {
            pkgBool = true;
        }
        String xsltPfadStr = (s = this.options.parameter(this.paramKatalogClass, "xsltPfad")) == null || s.trim().length() == 0 ? "" : (s.toLowerCase().startsWith("http://") ? s : ((f2 = new File(s.trim())).exists() ? f2.getAbsolutePath() : ""));
        s = this.options.parameter(this.paramKatalogClass, "Verzeichnis");
        String outDirStr = s == null || s.trim().length() == 0 ? "" : ((f = new File(s.trim())).exists() ? f.getAbsolutePath() : "");
        String mdlDirStr = this.eap;
        JPanel appSchemaPanel = new JPanel();
        JPanel appSchemaInnerPanel = new JPanel(new FlowLayout(3, 30, 5));
        appSchemaPanel.setLayout(new BoxLayout(appSchemaPanel, 0));
        appSchemaPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 10));
        this.appSchemaField = new JTextField(37);
        this.appSchemaField.setText(appSchemaStr);
        this.appSchemaFieldLabel = new JLabel("Name des zu exportierenden Anwendungsschemas:");
        Box asBox = Box.createVerticalBox();
        asBox.add(this.appSchemaFieldLabel);
        asBox.add(this.appSchemaField);
        this.pkgBox = new JCheckBox("Eingeschr\u00e4nkt auf Paket:");
        this.pkgBox.setSelected(pkgBool);
        this.pkgBox.addItemListener(this);
        this.pkgField = new JTextField(37);
        this.pkgField.setText(pkgStr);
        if (pkgStr.length() == 0) {
            this.pkgField.setEnabled(false);
            this.pkgField.setEditable(false);
        }
        asBox.add(this.pkgBox);
        asBox.add(this.pkgField);
        appSchemaInnerPanel.add(asBox);
        appSchemaPanel.add(appSchemaInnerPanel);
        Box outOptBox = Box.createVerticalBox();
        JPanel outOptInnerPanel = new JPanel(new FlowLayout(3, 15, 5));
        Box skBox = Box.createVerticalBox();
        this.schemaKennFieldLabel1 = new JLabel("Liste der zu ber\u00fccksichtigenden Schema-Kennungen");
        skBox.add(this.schemaKennFieldLabel1);
        this.schemaKennFieldLabel2 = new JLabel("(nur Klassen mit diesen Kennungen werden exportiert)");
        skBox.add(this.schemaKennFieldLabel2);
        this.schemaKennField = new JTextField(35);
        this.schemaKennField.setText(schemaKennungenStr);
        skBox.add(this.schemaKennField);
        outOptInnerPanel.add(skBox);
        outOptBox.add(outOptInnerPanel);
        JPanel targetPanel = new JPanel(new FlowLayout(3, 10, 5));
        for (String label : targetLabels) {
            targetPanel.add(this.targetGuiElems.get(label).selBox);
        }
        outOptBox.add(targetPanel);
        JPanel geerbEigPanel = new JPanel(new FlowLayout(3, 10, 5));
        this.geerbEigBox = new JCheckBox("Eigenschaften aus Superklassen auch in abgeleiteten Klassen darstellen");
        this.geerbEigBox.setSelected(geerbEigBool);
        this.geerbEigBox.addItemListener(this);
        geerbEigPanel.add(this.geerbEigBox);
        outOptBox.add(geerbEigPanel);
        JPanel outOptPanel = new JPanel();
        outOptPanel.add(outOptBox);
        outOptPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Ausgabeoptionen", 1, 2));
        Box modProfBox = Box.createVerticalBox();
        JPanel modProfInnerPanel1 = new JPanel(new FlowLayout(3, 15, 5));
        skBox = Box.createVerticalBox();
        this.modellartFieldLabel = new JLabel("Ausgew\u00e4hlte Modellarten:");
        this.modellartField = new JTextField(45);
        this.modellartField.setText(modellartenStr);
        skBox.add(this.modellartFieldLabel);
        skBox.add(this.modellartField);
        modProfInnerPanel1.add(skBox);
        modProfBox.add(modProfInnerPanel1);
        JPanel grundDatPanel = new JPanel(new FlowLayout(3, 10, 8));
        this.grundDatBox = new JCheckBox("Nur Grunddatenbestand exportieren");
        this.grundDatBox.setSelected(grundDatBool);
        this.grundDatBox.addItemListener(this);
        grundDatPanel.add(this.grundDatBox);
        modProfBox.add(grundDatPanel);
        JPanel profPanel = new JPanel(new FlowLayout(3, 10, 5));
        this.profEinschrBox = new JCheckBox("Eingeschr\u00e4nkt auf Profile:");
        this.profEinschrBox.setSelected(profEinschrBool);
        this.profEinschrBox.addItemListener(this);
        profPanel.add(this.profEinschrBox);
        JPanel profPanel2 = new JPanel(new FlowLayout(3, 15, 2));
        this.profileField = new JTextField(45);
        this.profileField.setText(profileStr);
        profPanel2.add(this.profileField);
        JPanel profPanel3 = new JPanel(new FlowLayout(3, 15, 2));
        this.profDateiBox = new JCheckBox("Profile aus 3ap-Datei statt aus dem Modell laden");
        this.profDateiBox.setSelected(profDateiBool);
        this.profDateiBox.addItemListener(this);
        profPanel3.add(this.profDateiBox);
        if (profileStr.length() == 0) {
            this.profileField.setEnabled(false);
            this.profileField.setEditable(false);
            this.profDateiBox.setEnabled(false);
        }
        modProfBox.add(profPanel);
        modProfBox.add(profPanel2);
        modProfBox.add(profPanel3);
        JPanel modProfPanel = new JPanel();
        modProfPanel.add(modProfBox);
        modProfPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Auswahl der Modellarten und Profile", 1, 2));
        Box pfadBox = Box.createVerticalBox();
        JPanel pfadInnerPanel = new JPanel();
        skBox = Box.createVerticalBox();
        this.xsltpfadFieldLabel = new JLabel("Pfad in dem die XSLT-Skripte liegen:");
        skBox.add(this.xsltpfadFieldLabel);
        this.xsltpfadField = new JTextField(45);
        this.xsltpfadField.setText(xsltPfadStr);
        skBox.add(this.xsltpfadField);
        this.outDirFieldLabel = new JLabel("Pfad in den die Kataloge geschrieben werden:");
        skBox.add(this.outDirFieldLabel);
        this.outDirField = new JTextField(45);
        this.outDirField.setText(outDirStr);
        skBox.add(this.outDirField);
        this.mdlDirFieldLabel = new JLabel("Pfad zum Modell:");
        skBox.add(this.mdlDirFieldLabel);
        this.mdlDirField = new JTextField(45);
        this.mdlDirField.setText(mdlDirStr);
        skBox.add(this.mdlDirField);
        pfadInnerPanel.add(skBox);
        pfadBox.add(pfadInnerPanel);
        JPanel pfadPanel = new JPanel();
        pfadPanel.add(pfadBox);
        pfadPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Pfadangaben", 1, 2));
        Box fileBox = Box.createVerticalBox();
        fileBox.add(appSchemaPanel);
        fileBox.add(outOptPanel);
        fileBox.add(modProfPanel);
        fileBox.add(pfadPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)fileBox, "North");
        return panel;
    }

    private Component createStartPanel() {
        JPanel startPanel = new JPanel(new FlowLayout(1, 20, 20));
        this.startButton = new JButton("Process EAP");
        this.startButton.setActionCommand("START");
        this.startButton.addActionListener(this);
        startPanel.add(this.startButton);
        this.viewLogButton = new JButton("View Log");
        this.viewLogButton.setActionCommand("LOG");
        this.viewLogButton.addActionListener(this);
        this.viewLogButton.setEnabled(false);
        startPanel.add(this.viewLogButton);
        this.exitButton = new JButton("Exit");
        this.exitButton.setActionCommand("EXIT");
        this.exitButton.addActionListener(this);
        this.exitButton.setEnabled(true);
        startPanel.add(this.exitButton);
        startPanel.setPreferredSize(new Dimension(10, 60));
        return startPanel;
    }

    protected void closeDialogWithError(String errmsg) {
        try {
            errmsg = "The application has encountered a fatal error.\nError message:\n" + errmsg;
            JOptionPane.showMessageDialog(this, errmsg, "Fatal error", 0);
            this.result.addFatalError(errmsg);
            if (this.model != null) {
                this.model.shutdown();
            }
        }
        catch (Exception e) {
            System.out.println("closeDialog - Exception: " + e.toString());
        }
    }

    protected void closeDialog() {
        try {
            String msg = null;
            if (this.transformationRunning) {
                msg = "Eine Katalogerzeugung l\u00e4uft derzeit.\n";
            }
            if (msg != null) {
                msg = msg + "Soll die Anwendung beendet werden?";
                Object[] options = new Object[]{"Exit", "Cancel"};
                int val = JOptionPane.showOptionDialog(null, msg, "Confirmation", 2, 3, null, options, options[1]);
                if (val == 1) {
                    return;
                }
            }
            if (this.model != null) {
                this.model.shutdown();
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("closeDialog - Exception: " + e.toString());
        }
    }

    public void threadInitialised() {
    }

    public void threadFinished(String errmsg) {
        if (errmsg != null) {
            this.closeDialogWithError(errmsg);
        }
        if (this.transformationRunning) {
            this.modelTransformed = true;
            this.transformationRunning = false;
            StatusBoard.getStatusBoard().statusChanged(2);
            this.enableElements();
        }
    }

    private synchronized void startTransformation() {
        this.modelTransformed = false;
        this.transformationRunning = true;
        try {
            this.options.loadConfiguration();
            String opt = "";
            for (String label : targetLabels) {
                if (!this.targetGuiElems.get(label).selBox.isSelected()) continue;
                opt = opt + label + ",";
            }
            this.options.setParameter(this.paramKatalogClass, "ausgabeformat", opt);
            this.options.setParameter("appSchemaName", this.appSchemaField.getText());
            this.options.setParameter(this.paramKatalogClass, "schemakennungen", this.schemaKennField.getText());
            if (this.geerbEigBox.isSelected()) {
                this.options.setParameter(this.paramKatalogClass, "geerbteEigenschaften", "true");
            } else {
                this.options.setParameter(this.paramKatalogClass, "geerbteEigenschaften", "false");
            }
            this.options.setParameter(this.paramKatalogClass, "modellarten", this.modellartField.getText());
            if (this.grundDatBox.isSelected()) {
                this.options.setParameter(this.paramKatalogClass, "nurGrunddatenbestand", "true");
            } else {
                this.options.setParameter(this.paramKatalogClass, "nurGrunddatenbestand", "false");
            }
            if (this.profEinschrBox.isSelected()) {
                this.options.setParameter(this.paramKatalogClass, "profile", this.profileField.getText());
                if (this.profDateiBox.isSelected()) {
                    this.options.setParameter(this.paramKatalogClass, "profilquelle", "Datei");
                } else {
                    this.options.setParameter(this.paramKatalogClass, "profilquelle", "Modell");
                }
            } else {
                this.options.setParameter(this.paramKatalogClass, "profile", "");
            }
            if (this.pkgBox.isSelected()) {
                this.options.setParameter(this.paramKatalogClass, "paket", this.pkgField.getText());
            } else {
                this.options.setParameter(this.paramKatalogClass, "paket", "");
            }
            this.options.setParameter(this.paramKatalogClass, "xsltPfad", this.xsltpfadField.getText());
            this.options.setParameter(this.paramKatalogClass, "Verzeichnis", this.outDirField.getText());
            this.options.setParameter("inputFile", this.mdlDirField.getText());
            if (!this.reinitMessageText("model transformation process")) {
                this.transformationRunning = false;
            }
            this.enableElements();
            this.startConvertThread();
        }
        catch (ShapeChangeAbortException ex) {
            this.threadFinished(ex.getMessage());
        }
    }

    public void startConvertThread() {
        this.startConvertThread(false);
    }

    public void startConvertThread(boolean onlyInit) {
        if (this.ct == null) {
            this.ct = new ConvertThread(this.converter, this.options, this.result, this.eap, this);
            this.ct.setOnlyInitialise(onlyInit);
            this.ct.start();
        } else {
            this.ct.setOnlyInitialise(onlyInit);
            this.ct.restart();
        }
    }

    public Model getModel() {
        return this.model;
    }

    public void enableElements() {
        if (this.transformationRunning) {
            for (String label : targetLabels) {
                this.targetGuiElems.get(label).selBox.setEnabled(false);
            }
            this.appSchemaField.setEnabled(false);
            this.schemaKennField.setEnabled(false);
            this.geerbEigBox.setEnabled(false);
            this.modellartField.setEnabled(false);
            this.grundDatBox.setEnabled(false);
            this.profEinschrBox.setEnabled(false);
            this.profileField.setEnabled(false);
            this.profDateiBox.setEnabled(false);
            this.pkgBox.setEnabled(false);
            this.pkgField.setEnabled(false);
            this.xsltpfadField.setEnabled(false);
            this.outDirField.setEnabled(false);
            this.mdlDirField.setEnabled(false);
            this.appSchemaFieldLabel.setEnabled(false);
            this.schemaKennFieldLabel1.setEnabled(false);
            this.schemaKennFieldLabel2.setEnabled(false);
            this.modellartFieldLabel.setEnabled(false);
            this.xsltpfadFieldLabel.setEnabled(false);
            this.outDirFieldLabel.setEnabled(false);
            this.mdlDirFieldLabel.setEnabled(false);
            this.startButton.setEnabled(false);
            this.viewLogButton.setEnabled(false);
            this.exitButton.setEnabled(true);
            this.setConfigDirSettings(false);
        } else {
            for (String label : targetLabels) {
                this.targetGuiElems.get(label).selBox.setEnabled(true);
            }
            this.appSchemaField.setEnabled(true);
            this.schemaKennField.setEnabled(true);
            this.geerbEigBox.setEnabled(true);
            this.modellartField.setEnabled(true);
            this.grundDatBox.setEnabled(true);
            this.profEinschrBox.setEnabled(true);
            this.profileField.setEnabled(true);
            this.profDateiBox.setEnabled(true);
            this.pkgBox.setEnabled(true);
            this.pkgField.setEnabled(true);
            this.xsltpfadField.setEnabled(true);
            this.outDirField.setEnabled(true);
            this.mdlDirField.setEnabled(true);
            this.appSchemaFieldLabel.setEnabled(true);
            this.schemaKennFieldLabel1.setEnabled(true);
            this.schemaKennFieldLabel2.setEnabled(true);
            this.modellartFieldLabel.setEnabled(true);
            this.xsltpfadFieldLabel.setEnabled(true);
            this.outDirFieldLabel.setEnabled(true);
            this.mdlDirFieldLabel.setEnabled(true);
            if (this.startButton != null) {
                boolean setStart = false;
                for (String label : targetLabels) {
                    if (this.targetGuiElems.get(label).selBox == null || !this.targetGuiElems.get(label).selBox.isSelected()) continue;
                    setStart = true;
                }
                if (setStart && !this.blocked) {
                    this.startButton.setEnabled(true);
                    StatusBoard.getStatusBoard().statusChanged(1);
                } else {
                    this.startButton.setEnabled(false);
                    StatusBoard.getStatusBoard().statusChanged(0);
                }
            }
            if (this.viewLogButton != null && this.modelTransformed) {
                this.logfile = new File(this.options.parameter("logFile").replace(".xml", ".html"));
                if (this.logfile != null && this.logfile.canRead()) {
                    this.viewLogButton.setEnabled(true);
                } else {
                    this.logfile = new File(this.options.parameter("logFile"));
                    if (this.logfile != null && this.logfile.canRead()) {
                        this.viewLogButton.setEnabled(true);
                    }
                }
                this.viewLogButton.setEnabled(true);
            }
            if (this.exitButton != null) {
                this.exitButton.setEnabled(true);
            }
            this.setConfigDirSettings(true);
        }
    }

    public boolean reinitMessageText(String action) {
        return true;
    }

    public void showMessageText(String msg) {
        if (this.saveModelMsgText) {
            this.modelMsgText = this.modelMsgText + msg;
        }
    }

    public void actionPerformed(ActionEvent e) {
        block9: {
            if (this.startButton == e.getSource()) {
                this.startTransformation();
            } else if (e.getSource() == this.viewLogButton) {
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(this.logfile);
                        break block9;
                    }
                    if (SystemUtils.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec("cmd /c start " + this.logfile.getPath());
                        break block9;
                    }
                    Runtime.getRuntime().exec("open " + this.logfile.getPath());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.exit(1);
                }
            } else if (e.getSource() == this.exitButton) {
                this.closeDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.profEinschrBox) {
            if (this.profEinschrBox != null && !this.profEinschrBox.isSelected() && this.profileField != null) {
                this.profileField.setEnabled(false);
                this.profileField.setEditable(false);
                this.profDateiBox.setEnabled(false);
            } else {
                this.profileField.setEnabled(true);
                this.profileField.setEditable(true);
                this.profDateiBox.setEnabled(true);
            }
        }
        if (e.getSource() == this.pkgBox) {
            if (this.pkgBox != null && !this.pkgBox.isSelected() && this.pkgField != null) {
                this.pkgField.setEnabled(false);
                this.pkgField.setEditable(false);
            } else {
                this.pkgField.setEnabled(true);
                this.pkgField.setEditable(true);
            }
        }
    }

    public void setConfigDirSettings(boolean allSelConfig) {
        for (String label : targetLabels) {
            TargetGuiElements t = this.targetGuiElems.get(label);
            if (t.dirLabel == null || t.dirSelButton == null || t.dirTextField == null || t.selBox == null) continue;
            boolean selConfig = allSelConfig ? t.selBox.isSelected() : false;
            t.dirLabel.setEnabled(selConfig);
            t.dirSelButton.setEnabled(selConfig);
            t.dirTextField.setEnabled(selConfig);
            t.dirTextField.setEditable(selConfig);
        }
    }

    public void statusChanged(int status) {
        String msg = " ";
        block0 : switch (status) {
            case 1: {
                msg = msg + "Ready";
                break;
            }
            case 101: {
                msg = msg + "Lesen des Modells: Initialisierung";
                break;
            }
            case 102: {
                msg = msg + "Lesen des Modells: Paketinformationen";
                break;
            }
            case 103: {
                msg = msg + "Lesen des Modells: Objektarten und deren Eigenschaften";
                break;
            }
            case 104: {
                msg = msg + "Lesen des Modells: Konsistenzbedingungen";
                break;
            }
            case 201: {
                switch (this.converter.getCurrentTargetID()) {
                    case 401: {
                        msg = msg + "AAA-Katalogtool: Initialisierung der Katalogerzeugung";
                        break block0;
                    }
                }
                msg = null;
                this.statusBar.delText();
                break;
            }
            case 202: {
                switch (this.converter.getCurrentTargetID()) {
                    case 401: {
                        msg = msg + "AAA-Katalogtool: Erzeugung des Katalogs";
                        break block0;
                    }
                }
                msg = null;
                this.statusBar.delText();
                break;
            }
            case 203: {
                switch (this.converter.getCurrentTargetID()) {
                    case 401: {
                        msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                        break block0;
                    }
                }
                msg = null;
                this.statusBar.delText();
                break;
            }
            case 24: {
                msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                if (targetLabels == null || targetLabels.size() < 1) break;
                msg = msg + " - " + targetLabels.get(0);
                break;
            }
            case 23: {
                msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                if (targetLabels == null || targetLabels.size() < 2) break;
                msg = msg + " - " + targetLabels.get(1);
                break;
            }
            case 21: {
                msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                if (targetLabels == null || targetLabels.size() < 3) break;
                msg = msg + " - " + targetLabels.get(2);
                break;
            }
            case 22: {
                msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                if (targetLabels == null || targetLabels.size() < 4) break;
                msg = msg + " - " + targetLabels.get(3);
                break;
            }
            case 25: {
                msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                if (targetLabels == null || targetLabels.size() < 5) break;
                msg = msg + " - " + targetLabels.get(4);
                break;
            }
            case 26: {
                msg = msg + "AAA-Katalogtool: Schreiben des Katalogs";
                if (targetLabels == null || targetLabels.size() < 6) break;
                msg = msg + " - " + targetLabels.get(5);
                break;
            }
            default: {
                msg = null;
                this.statusBar.delText();
            }
        }
        if (msg != null) {
            this.statusBar.setText(msg);
        }
    }

    static {
        targetLabels.add("XML");
        targetLabels.add("HTML");
        targetLabels.add("RTF");
        targetLabels.add("Nart-PDF");
        targetLabels.add("GFC");
        targetLabels.add("CSV");
    }

    class TargetGuiElements {
        private JTextField dirTextField;
        private JButton dirSelButton;
        private JLabel dirLabel;
        private JCheckBox selBox = null;
        private KatalogDialog dialog;

        TargetGuiElements(KatalogDialog dlg, String label) {
            this.dialog = dlg;
            this.mkElems(label);
        }

        private void mkElems(String label) {
            this.selBox = new JCheckBox(label);
            this.selBox.addItemListener(this.dialog);
            String opt = KatalogDialog.this.options.parameter(this.dialog.paramKatalogClass, "ausgabeformat");
            if (opt != null && opt.toLowerCase().contains(label.toLowerCase())) {
                this.selBox.setSelected(true);
            }
        }
    }

    class ConvertThread
    extends Thread {
        protected Converter converter = null;
        protected ShapeChangeResult result = null;
        protected Options options = null;
        protected String eap = null;
        protected KatalogDialog dialog = null;
        protected boolean onlyInitialise;

        ConvertThread(Converter c, Options o, ShapeChangeResult r, String e, KatalogDialog d) {
            this.converter = c;
            this.options = o;
            this.result = r;
            this.eap = e;
            this.dialog = d;
            this.onlyInitialise = false;
        }

        public void setOnlyInitialise(boolean o) {
            this.onlyInitialise = o;
        }

        public void initialise() throws ShapeChangeAbortException {
            if (this.dialog.model != null) {
                this.dialog.model.shutdown();
                this.dialog.model = null;
            }
            this.dialog.saveModelMsgText = true;
            this.dialog.model = (Model)new EADocument(this.result, this.options, this.eap);
            this.dialog.saveModelMsgText = false;
            if (this.onlyInitialise) {
                this.dialog.threadInitialised();
            }
        }

        public synchronized void restart() {
            this.result.init();
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String errmsg = null;
            try {
                try {
                    while (true) {
                        this.initialise();
                        if (this.dialog.model != null && !this.onlyInitialise) {
                            this.converter.convert(this.dialog.model);
                        }
                        this.dialog.threadFinished(null);
                        ConvertThread convertThread = this;
                        synchronized (convertThread) {
                            this.wait();
                            ConvertThread.sleep(100L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.dialog.threadFinished(errmsg);
                    return;
                }
            }
            catch (ShapeChangeAbortException ex) {
                errmsg = ex.getMessage();
                if (errmsg == null) {
                    errmsg = ex.toString();
                }
                if (errmsg != null) return;
                errmsg = "Unknown ShapeChangeAbortException.";
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            finally {
                this.dialog.threadFinished(errmsg);
            }
        }

        public void end() {
            this.restart();
            this.interrupt();
        }
    }

    class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JLabel label;

        public StatusBar() {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(10, 23));
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.label = new JLabel();
            this.add((Component)this.label, "West");
        }

        public void setText(String text) {
            this.label.setText(text);
        }

        public void delText() {
            this.label.setText("");
        }
    }
}

