/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPropertyInfo
extends PropertyInfoImpl {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected GenericModel model = null;
    protected String id = null;
    protected String name = null;
    protected String stereotype = null;
    protected HashMap<String, String> taggedValues = null;
    protected boolean isDerived = false;
    protected boolean isAttribute = true;
    protected Type typeInfo = null;
    protected boolean isNavigable = true;
    protected boolean isOrdered = false;
    protected boolean isComposition = false;
    protected boolean isAggregation = false;
    protected Multiplicity cardinality = new Multiplicity("1");
    protected String initialValue = null;
    protected String inlineOrByReference = "inlineOrByReference";
    protected String defaultCodeSpace = "";
    protected boolean isMetadata = false;
    protected PropertyInfo reverseProperty = null;
    protected ClassInfo inClass = null;
    protected StructuredNumber sequenceNumber = null;
    protected boolean implementedByNilReason = false;
    protected boolean voidable = false;
    protected Vector<Constraint> constraints = new Vector();
    protected AssociationInfo association = null;
    protected int categoryOfValue = -1;

    public GenericPropertyInfo(GenericModel model, String id, String name, int categoryOfValue) {
        this.model = model;
        this.options = model.options();
        this.result = model.result();
        this.id = id;
        this.name = name;
        this.categoryOfValue = categoryOfValue;
    }

    @Override
    public boolean isMetadata() {
        return this.isMetadata;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public void setMetadata(boolean isMetadata) {
        this.isMetadata = isMetadata;
    }

    public void setReverseProperty(PropertyInfo reverseProperty) {
        this.reverseProperty = reverseProperty;
    }

    public void setInClass(ClassInfo inClass) {
        this.inClass = inClass;
    }

    public void setImplementedByNilReason(boolean implementedByNilReason) {
        this.implementedByNilReason = implementedByNilReason;
    }

    public void setAssociation(AssociationInfo association) {
        this.association = association;
    }

    public void setCategoryOfValue(int categoryOfValue) {
        this.categoryOfValue = categoryOfValue;
    }

    @Override
    public boolean isDerived() {
        return this.isDerived;
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public Type typeInfo() {
        return this.typeInfo;
    }

    @Override
    public boolean isNavigable() {
        return this.isNavigable;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public boolean isComposition() {
        return this.isComposition;
    }

    @Override
    public boolean isAggregation() {
        return this.isAggregation;
    }

    @Override
    public Multiplicity cardinality() {
        return this.cardinality;
    }

    @Override
    public String initialValue() {
        return this.initialValue;
    }

    @Override
    public String inlineOrByReference() {
        return this.inlineOrByReference;
    }

    @Override
    public String defaultCodeSpace() {
        return this.defaultCodeSpace;
    }

    @Override
    public PropertyInfo reverseProperty() {
        return this.reverseProperty;
    }

    @Override
    public ClassInfo inClass() {
        return this.inClass;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.inClass = (GenericClassInfo)ci;
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public boolean voidable() {
        return this.voidable;
    }

    @Override
    public Vector<Constraint> constraints() {
        return this.constraints;
    }

    @Override
    public AssociationInfo association() {
        return this.association;
    }

    public void setCardinality(Multiplicity cardinality) {
        this.cardinality = cardinality;
    }

    public void setConstraints(Vector<Constraint> constraints) {
        this.constraints = constraints;
    }

    public void setDefaultCodeSpace(String defaultCodeSpace) {
        this.defaultCodeSpace = defaultCodeSpace;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public void setInlineOrByReference(String inlineOrByReference) {
        this.inlineOrByReference = inlineOrByReference;
    }

    public void setAggregation(boolean isAggregation) {
        this.isAggregation = isAggregation;
    }

    public void setComposition(boolean isComposition) {
        this.isComposition = isComposition;
    }

    public void setDerived(boolean isDerived) {
        this.isDerived = isDerived;
    }

    public void setNavigable(boolean isNavigable) {
        this.isNavigable = isNavigable;
    }

    public void setOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public void setSequenceNumber(StructuredNumber sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setTypeInfo(Type typeInfo) {
        this.typeInfo = typeInfo;
    }

    public void setVoidable(boolean voidable) {
        this.voidable = voidable;
    }

    public void setNilReasonAllowed(boolean nilReasonAllowed) {
        this.nilReasonAllowed = nilReasonAllowed;
    }

    public void setRestriction(boolean isRestriction) {
        this.restriction = isRestriction;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }

    @Override
    public String aliasName() {
        return this.aliasName;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Model model() {
        return this.model;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
        this.definition = null;
        this.description = null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModel(GenericModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setResult(ShapeChangeResult result) {
        this.result = result;
    }

    public void setStereotype(String stereotype) {
        this.stereotype = stereotype;
    }

    public void setTaggedValues(HashMap<String, String> taggedValues) {
        this.taggedValues = taggedValues;
    }

    @Override
    public String taggedValue(String tag) {
        return this.taggedValues.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValues;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValues.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public boolean implementedByNilReason() {
        return this.implementedByNilReason;
    }

    @Override
    public int categoryOfValue() {
        if (this.typeInfo != null) {
            ClassInfo ci = this.model().classById(this.typeInfo().id);
            if (ci != null) {
                return ci.category();
            }
            return this.categoryOfValue;
        }
        return this.categoryOfValue;
    }

    public GenericPropertyInfo createCopy(String copyId) {
        GenericPropertyInfo copy = new GenericPropertyInfo(this.model, copyId, this.name, this.categoryOfValue);
        copy.setAliasName(this.aliasName);
        copy.setDocumentation(this.documentation);
        copy.setStereotype(this.stereotype);
        copy.setTaggedValues((HashMap)this.taggedValues.clone());
        copy.setDerived(this.isDerived);
        copy.setAttribute(this.isAttribute);
        Type t = new Type();
        t.id = this.typeInfo.id;
        t.name = this.typeInfo.name;
        copy.setTypeInfo(t);
        copy.setNavigable(this.isNavigable);
        copy.setOrdered(this.isOrdered);
        copy.setComposition(this.isComposition);
        copy.setAggregation(this.isAggregation);
        copy.setCardinality(new Multiplicity(this.cardinality.toString()));
        copy.setInitialValue(this.initialValue);
        copy.setInlineOrByReference(this.inlineOrByReference);
        copy.setDefaultCodeSpace(this.defaultCodeSpace);
        copy.setMetadata(this.isMetadata);
        copy.setReverseProperty(this.reverseProperty);
        copy.setInClass(this.inClass);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.sequenceNumber.components.length - 1; ++i) {
            sb.append(this.sequenceNumber.components[i] + ".");
        }
        sb.append(this.sequenceNumber.components[this.sequenceNumber.components.length - 1]);
        StructuredNumber res = new StructuredNumber(sb.toString());
        copy.setSequenceNumber(res);
        copy.setImplementedByNilReason(this.implementedByNilReason);
        copy.setVoidable(this.voidable);
        copy.setConstraints(this.constraints);
        copy.setAssociation(this.association);
        copy.setRestriction(this.restriction);
        copy.setNilReasonAllowed(this.nilReasonAllowed);
        return copy;
    }

    public String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + this.name + "\n");
        sb.append(indent + indent + "tagged values: ");
        for (String key : this.taggedValues.keySet()) {
            sb.append("(" + key + "," + this.taggedValues.get(key) + ") ");
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

