/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.TaggedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfoEA
extends PackageInfoImpl
implements PackageInfo {
    protected EADocument document = null;
    protected PackageInfoEA parentPI = null;
    protected HashSet<PackageInfoEA> childPI = new HashSet();
    protected HashSet<ClassInfoEA> childCI = new HashSet();
    protected Package eaPackage = null;
    protected int eaPackageId = 0;
    protected Element eaPackageElmt = null;
    protected int eaPackageElmtId = 0;
    protected String eaName = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected HashSet<String> stereotypesCache = null;

    public Package getEaPackageObj() {
        return this.eaPackage;
    }

    public PackageInfoEA(EADocument doc, PackageInfoEA ppi, Package pack, Element packelmt) {
        this.document = doc;
        this.parentPI = ppi;
        if (ppi != null) {
            ppi.childPI.add(this);
        }
        this.eaPackage = pack;
        this.eaPackageId = this.eaPackage.GetPackageID();
        this.eaName = this.eaPackage.GetName();
        this.eaPackageElmt = packelmt;
        if (this.eaPackageElmt != null) {
            this.eaPackageElmtId = this.eaPackageElmt.GetElementID();
        }
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public HashSet<PackageInfo> containedPackages() throws Exception {
        return (HashSet)this.childPI.clone();
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaPackage.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            String[] stringArray = stereotypes;
            int n = stereotypes.length;
            int n2 = 0;
            while (n2 < n) {
                String stereotype = stringArray[n2];
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st != null) {
                    String[] stringArray2 = Options.packageStereotypes;
                    int n3 = Options.packageStereotypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray2[n4];
                        if (st.toLowerCase().equals(s)) {
                            this.stereotypesCache.add(s);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> iterator = this.stereotypesCache.iterator();
        if (iterator.hasNext()) {
            String st = iterator.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    @Override
    public boolean isAppSchema() {
        this.validateStereotypesCache();
        return this.stereotypesCache.contains("application schema");
    }

    @Override
    public PackageInfo owner() {
        return this.parentPI;
    }

    @Override
    public PackageInfo rootPackage() {
        PackageInfoEA pi = this;
        while (pi != null && !pi.isSchema()) {
            pi = pi.parentPI;
        }
        return pi;
    }

    @Override
    public HashSet<String> supplierIds() {
        HashSet<String> res = new HashSet<String>();
        Collection conns = this.eaPackage.GetConnectors();
        for (Connector conn : conns) {
            PackageInfoEA suppPack;
            String suppPackId;
            String type = conn.GetType();
            if (!type.equals("Dependency")) continue;
            int suppId = conn.GetSupplierID();
            String suppIdS = Integer.toString(suppId);
            if (suppId == this.eaPackageElmtId || (suppPackId = (suppPack = this.document.fPackageByElmtId.get(suppIdS)).id()) == null) continue;
            res.add(suppPackId);
        }
        return res;
    }

    @Override
    public String documentation() {
        String s = super.documentation();
        if (s == null || s.length() == 0) {
            s = this.eaPackage.GetNotes();
        }
        return s != null ? s : "";
    }

    @Override
    public String id() {
        return new Integer(this.eaPackageId).toString();
    }

    @Override
    public String name() {
        String s = this.eaName.trim();
        if (s == null || s.equals("")) {
            s = this.id();
            this.document.result.addWarning(100, "package", s);
        }
        return s;
    }

    @Override
    public String aliasName() {
        String a = super.aliasName();
        if (a == null || a.length() == 0) {
            a = this.eaPackage.GetAlias();
        }
        return a;
    }

    private void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = null;
            int ntvs = 0;
            if (this.eaPackageElmt != null) {
                tvs = this.eaPackageElmt.GetTaggedValues();
                ntvs = tvs.GetCount();
            }
            this.taggedValuesCache = new HashMap(ntvs);
            if (tvs != null) {
                for (TaggedValue tv : tvs) {
                    String t = tv.GetName();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    this.taggedValuesCache.put(t, v);
                }
            }
        }
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v != null) {
                res.put(t, v);
            }
            ++n2;
        }
        return res;
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }
}

