/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlDocument {
    protected Document document = null;
    protected String dtd = "";
    protected ShapeChangeResult result = null;

    public XmlDocument(ShapeChangeResult r) {
        this.result = r;
    }

    public XmlDocument(ShapeChangeResult r, String xmlfile) throws ShapeChangeAbortException {
        this.result = r;
        this.open(xmlfile);
    }

    public void open(String xmlfile) throws ShapeChangeAbortException {
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler errorHandler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            builder = factory.newDocumentBuilder();
            errorHandler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(errorHandler);
        }
        catch (FactoryConfigurationError e) {
            this.result.addFatalError(1);
            throw new ShapeChangeAbortException();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(2);
            throw new ShapeChangeAbortException();
        }
        try {
            this.document = builder.parse(xmlfile);
            if (errorHandler.errorsFound()) {
                this.result.addFatalError(3);
                throw new ShapeChangeAbortException();
            }
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
        DocumentType dt = this.document.getDoctype();
        this.dtd = dt == null ? "" : dt.getName();
    }

    public String characterEncoding() {
        String xmlCharacterEncoding = this.document.getXmlEncoding();
        if (xmlCharacterEncoding == null) {
            xmlCharacterEncoding = "UTF-8";
        }
        return xmlCharacterEncoding;
    }

    protected String textValue(Node n) {
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n2 = nl.item(i);
            if (n2.getNodeType() == 3) {
                return n2.getNodeValue();
            }
            ++i;
        }
        return null;
    }
}

