/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Options;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShapeChangeResult {
    protected Document document = null;
    protected Element root = null;
    protected Element messages = null;
    protected Element resultFiles = null;
    protected Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
    protected Options options = null;
    protected HashSet<String> duplicateMessageCheck;

    public ShapeChangeResult(Options o) {
        this.init();
        this.options = o;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
            this.root = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "ShapeChangeResult");
            this.document.appendChild(this.root);
            this.root.setAttribute("resultCode", "0");
            this.root.setAttribute("xmlns:r", "http://www.interactive-instruments.de/ShapeChange/Result");
            this.root.setAttribute("start", new Date().toString());
            String version = "[dev]";
            InputStream stream = this.getClass().getResourceAsStream("/sc.properties");
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                version = properties.getProperty("sc.version");
            }
            this.root.setAttribute("version", version);
            this.messages = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Messages");
            this.root.appendChild(this.messages);
            this.resultFiles = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Results");
            this.root.appendChild(this.resultFiles);
        }
        catch (ParserConfigurationException e) {
            System.err.println("Bootstrap Error: XML parser was unable to be configured.");
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bootstrap Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.outputFormat.setProperty("encoding", "UTF-8");
        this.outputFormat.setProperty("indent", "yes");
        this.outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
    }

    public void init() {
        this.duplicateMessageCheck = new HashSet(50);
    }

    private String safe(String s) {
        if (s == null) {
            return "<null>";
        }
        return s;
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", this.safe(p3)));
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1));
    }

    public MessageContext addDebug(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m);
    }

    public MessageContext addDebug(String m) {
        if (this.document == null || !this.options.parameter("reportLevel").equals("DEBUG")) {
            return null;
        }
        if (m.startsWith("??")) {
            m = m.substring(2);
            if (!this.duplicateMessageCheck.add("D " + m)) {
                return null;
            }
        }
        return new MessageContext(this, "Debug", m);
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1));
    }

    public MessageContext addInfo(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m);
    }

    public MessageContext addInfo(String m) {
        String l = this.options.parameter("reportLevel");
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO")) {
            return null;
        }
        if (m.startsWith("??")) {
            m = m.substring(2);
            if (!this.duplicateMessageCheck.add("I " + m)) {
                return null;
            }
        }
        return new MessageContext(this, "Info", m);
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1));
    }

    public MessageContext addWarning(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m);
    }

    public MessageContext addWarning(String m) {
        String l = this.options.parameter("reportLevel");
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO") && !l.equals("WARNING")) {
            return null;
        }
        if (m.startsWith("??")) {
            m = m.substring(2);
            if (!this.duplicateMessageCheck.add("W " + m)) {
                return null;
            }
        }
        return new MessageContext(this, "Warning", m);
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4, String p5, String p6, String p7) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4).replace("$5$", p5).replace("$6$", p6).replace("$7$", p7));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1));
    }

    public MessageContext addError(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m);
    }

    public MessageContext addError(String m) {
        if (this.document == null) {
            return null;
        }
        if (m.startsWith("??")) {
            m = m.substring(2);
            if (!this.duplicateMessageCheck.add("E " + m)) {
                return null;
            }
        }
        return new MessageContext(this, "Error", m);
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        MessageContext ex = this.addFatalError(m);
        this.setResultCode(1);
        return ex;
    }

    public MessageContext addFatalError(String m) {
        if (this.document == null) {
            return null;
        }
        if (m.startsWith("??")) {
            m = m.substring(2);
            if (!this.duplicateMessageCheck.add("F " + m)) {
                return null;
            }
        }
        return new MessageContext(this, "FatalError", m);
    }

    public void addResult(int targetId, String dname, String fname, String scope) {
        String path;
        if (this.document == null) {
            return;
        }
        Element resfile = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Result");
        this.resultFiles.appendChild(resfile);
        resfile.setAttribute("target", this.options.nameOfTarget(targetId));
        File file = new File(dname + "/" + fname);
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = dname + "/" + fname;
        }
        resfile.setAttribute("href", path);
        if (scope != null) {
            resfile.setAttribute("scope", scope);
        }
        resfile.appendChild(this.document.createTextNode(fname));
    }

    public void setResultCode(int rc) {
        if (this.document == null) {
            return;
        }
        this.root.setAttribute("resultCode", Integer.toString(rc, 10));
    }

    public void toFile(String filename) {
        if (this.document == null) {
            return;
        }
        try {
            this.root.setAttribute("config", this.options.configFile);
            this.root.setAttribute("end", new Date().toString());
            FileWriter outputXML = new FileWriter(filename);
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            String xsltfileName = this.options.parameter("xsltFile");
            if (xsltfileName != null && !xsltfileName.isEmpty()) {
                StreamSource xsltSource;
                if (xsltfileName.toLowerCase().startsWith("http")) {
                    URL url = new URL(xsltfileName);
                    URLConnection urlConnection = url.openConnection();
                    xsltSource = new StreamSource(urlConnection.getInputStream());
                } else {
                    InputStream stream = this.getClass().getResourceAsStream("/xslt/result.xsl");
                    if (stream == null) {
                        File xsltFile = new File(xsltfileName);
                        if (!xsltFile.canRead()) {
                            throw new Exception("Cannot read " + xsltFile.getName());
                        }
                        xsltSource = new StreamSource(xsltFile);
                    } else {
                        xsltSource = new StreamSource(stream);
                    }
                }
                File outHTML = new File(filename.replace(".xml", ".html"));
                if (outHTML.exists()) {
                    outHTML.delete();
                }
                FileWriter outputHTML = new FileWriter(outHTML);
                if (xsltSource != null) {
                    DOMSource xmlSource = new DOMSource(this.document);
                    StreamResult res = new StreamResult(outputHTML);
                    TransformerFactory transFact = TransformerFactory.newInstance();
                    Transformer trans = transFact.newTransformer(xsltSource);
                    trans.transform(xmlSource, res);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public Document asDOM() {
        return this.document;
    }

    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Unable to get a document builder factory.";
            }
            case 2: {
                return "XML Parser was unable to be configured.";
            }
            case 3: {
                return "Invalid XMI file.";
            }
            case 4: {
                return "XMI version must be 1.0, found: '$1$'.";
            }
            case 5: {
                return "Exactly only element <XMI> expected.";
            }
            case 6: {
                return "Metamodel must be UML, found: '$1$'.";
            }
            case 7: {
                return "The UML version must be 1.3, found: '$1$'.";
            }
            case 8: {
                return "Exactly one element <XMI.metamodel> expected.";
            }
            case 9: {
                return "Class '$1$' is not associated with a package.";
            }
            case 10: {
                return "Class '$1$' in package '$2$' is not associated with an XSD document.";
            }
            case 11: {
                return "Stereotype <<$2$>> of class '$1$' is not an allowed value in encoding rule '$3$' and is ignored.";
            }
            case 12: {
                return "No application schema found.";
            }
            case 13: {
                return "Application schema '$1$' not found.";
            }
            case 14: {
                return "No model has been loaded to convert.";
            }
            case 15: {
                return "Package '$1$' not associated with any XML Schema document.";
            }
            case 16: {
                return "The XMI file is not associated with a DTD. The DTD is required for validating and processing the XMI file.";
            }
            case 17: {
                return "Unknown input model type: '$1$'.";
            }
            case 18: {
                return "Unsupported Java version: '$1$'. Java 1.6 or higher required.";
            }
            case 19: {
                return "Model object could not be instaniated: '$1$'.";
            }
            case 20: {
                return "Model object could not be accessed: '$1$'.";
            }
            case 21: {
                return "??Rule name '$1$' is not valid. The rule is ignored.";
            }
            case 22: {
                return "??Reference model '$1$' could not be loaded and is ignored.";
            }
            case 30: {
                return "Enterprise Architect repository named '$2$' cannot be opened. EA message is: '$1$'";
            }
            case 31: {
                return "Enterprise Architect repository file named '$1$' not found";
            }
            case 40: {
                return "Microsoft Access Database named '$2$' cannot be opened. JDBC message is: '$1$'";
            }
            case 41: {
                return "Microsoft Access Database file named '$1$' not found";
            }
            case 42: {
                return "Error reading from Microsoft Access Database '$2$'.  Error message is: '$1$'";
            }
            case 100: {
                return "??The '$1$' with ID '$2$' has no name. The ID is used instead.";
            }
            case 101: {
                return "??Application schema '$1$' with ID '$2$' is not associated with an XML Schema document. A default name is used: '$3$'.";
            }
            case 102: {
                return "";
            }
            case 103: {
                return "??The association with name '$1$' and ID '$2$' does not have 2 connections: $3$ connections. All Roles will be ignored.";
            }
            case 104: {
                return "??The supertypes of class '$1$' are of different categories or the stereotype of the class cannot be determined. This is not supported, the class is ignored.";
            }
            case 105: {
                return "??The restriction of UML attribute '$1$' in class '$2$' is not legal. The lower multiplicity limit is smaller than in the supertype '$3$'.";
            }
            case 106: {
                return "??The restriction of UML attribute '$1$' in class '$2$' is not legal. The upper multiplicity limit is higher than in the supertype '$3$'.";
            }
            case 107: {
                return "??The property '$1$' in class '$2$' has a sequence number that is already in use for another property ($3$) which will be overwritten.";
            }
            case 108: {
                return "??The class '$1$' is modelled as a feature or data type, but has at least one supertype of a different category. The supertype is ignored.";
            }
            case 109: {
                return "??The class '$1$' is modelled as a feature or data type, but has more than one supertype of the same kind. All but one (arbitrary) supertypes are ignored.";
            }
            case 110: {
                return "??A target could not be created for schema '$1$'. This target is supported only for GML versions 3.2 and later.";
            }
            case 111: {
                return "??Missing argument to '$1$' option.";
            }
            case 115: {
                return "??The class '$1$' is modelled as an interface, but has supertypes that are instantiable. The supertype relationships are ignored.";
            }
            case 116: {
                return "Target object element(s) missing in property type for property '$1$'.";
            }
            case 117: {
                return "??No XML Schema type for type '$1$' is defined. Only object and data types are supported.";
            }
            case 119: {
                return "No element for type '$1$' is defined. Only object and data types are represented by elements.";
            }
            case 121: {
                return "Base type '$1$' could not be mapped. Missing base type in complex type '$2$'.";
            }
            case 122: {
                return "The type with the name '$1$' has no tagged value 'base' or valid supertype and cannot be mapped to a basic type.";
            }
            case 123: {
                return "The type with the name '$1$' has no ID and cannot be mapped to a basic type.";
            }
            case 124: {
                return "Failed to create basic type '$1$'.";
            }
            case 125: {
                return "The class '$1$' is an enumeration. Generalization relationships are not supported for these classes. All such relationships are ignored.";
            }
            case 126: {
                return "Failed to create enumeration type '$1$'.";
            }
            case 127: {
                return "The class '$1$' is a codelist. Generalization relationships are not supported for these classes. All such relationships are ignored.";
            }
            case 128: {
                return "The property '$1$' cannot be assigned a type as it is mapped to an XML attribute, but the type has complex content.";
            }
            case 129: {
                return "Union '$1$' as the value type of '$2$' could not be mapped as it does not contain the expected number of exactly one property to be encoded in the application schema.";
            }
            case 130: {
                return "No type can be provided for the property '$1$'.";
            }
            case 131: {
                return "??The type '$2$' of property '$1$' was not found.";
            }
            case 132: {
                return "The class '$1$' is referenced, but is not part of any schema in the model nor is it mapped to a well-known XML Schema type. The class is ignored.";
            }
            case 133: {
                return "One or more errors encountered in OCL constraint in $3$ '$1$' : '$2$' ...";
            }
            case 134: {
                return "Line/column(s) $1$: $2$";
            }
            case 135: {
                return "??The type of property '$1$' was not found by id, only by name (fixed broken type definition).";
            }
            case 136: {
                return "The enumeration element with ID '$1$' in class '$2$' contains an empty string as value.";
            }
            case 137: {
                return "Property with id '$1' and name '$2' has no type.";
            }
            case 138: {
                return "Property with id '$1' and name '$2' has a type with no name.";
            }
            case 139: {
                return "Cannot add properties of type '$1' in schema definitions since the type definition is not part of the model.";
            }
            case 140: {
                return "Unknown value for $1: $2";
            }
            case 141: {
                return "The class '$1$' referenced from class '$2$' is not part of any package nor is it mapped to a well-known XML Schema type. The class is ignored.";
            }
            case 142: {
                return "Class '$1$' cannot be suppressed, as no direct or indirect, non-abstract supertype exists that is not suppressed.";
            }
            case 143: {
                return "Class '$1$' cannot be suppressed, as it has a non-suppressed subtype '$2$'.";
            }
            case 144: {
                return "Class '$1$' cannot be suppressed, as it add at least one property.";
            }
            case 145: {
                return "ADE class '$1$' cannot be suppressed, as it has no supertype.";
            }
            case 146: {
                return "??Schema '$1$' is missing tagged value '$2$'.";
            }
            case 147: {
                return "??Package '$1$' has tagged value '$2$', but is not an application schema.";
            }
            case 148: {
                return "??Property '$2$' of class '$1$' is not a composition, but has a data type as its value: '$3$'.";
            }
            case 149: {
                return "??Name of '$1$' '$2$' includes invalid characters.";
            }
            case 150: {
                return "??Schema '$1$' has dummy tagged value '$2$': '$3$'.";
            }
            case 151: {
                return "??Documentation of schema '$1$' is missing the separator '$2$'.";
            }
            case 152: {
                return "??Documentation of class '$1$' is missing the separator '$2$'.";
            }
            case 153: {
                return "??Documentation of property '$1$' is missing the separator '$2$'.";
            }
            case 154: {
                return "??No rule to name the '$1$' of class '$2$' is configured. Please check the current configuration.";
            }
            case 155: {
                return "??No rule for a choice/sequence/all container for class '$1$' is configured, sequence is used. Please check the current configuration.";
            }
            case 156: {
                return "??Failed to create enumeration type '$1$EnumerationType'.";
            }
            case 157: {
                return "??Class of property '$1$' cannot be determined. The property is ignored.";
            }
            case 158: {
                return "??MapEntry contains empty mapping target. Verify the configuration and look for 'fixme:fixme' in the created schemas.";
            }
            case 159: {
                return "??Package '$1$' has a dependency, but is not an application schema.";
            }
            case 160: {
                return "??Package '$1$' is the supplier of a dependency to package '$2$', but is not an application schema.";
            }
            case 161: {
                return "??$1$ with id '$2$' is referenced, but cannot be found.";
            }
            case 162: {
                return "??XML Schema document name '$1$' is used for more than one schema package.";
            }
            case 163: {
                return "??Class name '$1$' is used more than once in application schema '$2$'.";
            }
            case 164: {
                return "??Rule '$1$' is unknown, but referenced in the ShapeChange source code. This is a system error.";
            }
            case 165: {
                return "Value '$1$' is not allowed for targetParameter 'sortedOutput' in Target '$2$'. Try 'true' (=name), 'name', 'id', 'taggedValue=value' or 'false' (no sorting). 'false' is used.";
            }
            case 166: {
                return "Class '$1$' cannot be mapped to an object element and is not included in the mapping of class '$2$'.";
            }
            case 167: {
                return "XML Schema document name '$1$' does not contain the .xsd file extension.";
            }
            case 200: {
                return "??Tagged value '$1$' missing in class '$2$'.";
            }
            case 201: {
                return "??Tagged value '$1$' has incorrect value '$3$' in class '$2$'.";
            }
            case 202: {
                return "??Tagged value '$1$' missing in property '$2$'.";
            }
            case 203: {
                return "??Tagged value '$1$' has incorrect value '$3$' in property '$2$'.";
            }
            case 204: {
                return "??Outdated tagged value '$1$' used in property '$2$'.";
            }
            case 301: {
                return "File '$1$' is not readable, processing of $2$ is skipped.";
            }
            case 303: {
                return "Warning while transforming '$1$'. Message: $2$";
            }
            case 304: {
                return "Error while transforming '$1$'. Message: $2$";
            }
            case 305: {
                return "Fatal error while transforming '$1$'. Message: $2$";
            }
            case 306: {
                return "XSLFO-File '$1$' does not exist, PDF generation is skipped.";
            }
            case 400: {
                return "Context: $1$ '$2$'";
            }
            case 1000: {
                return "Testing UML version 1.4.";
            }
            case 1001: {
                return "Class '$1$' with ID '$2$' cannot be identified as being part of any package. The package is probably ignored, for example, because it carries an unsupported stereotype. The ID of the missing package is: '$3$'";
            }
            case 1002: {
                return "Restriction of property '$1$' in class '$2$' from supertype '$3$'.";
            }
            case 1003: {
                return "The multiplicity value of '$1$' is neither a number nor a known string. '*' is used instead.";
            }
            case 1004: {
                return "Class '$1$' has an unknown category, an object is assumed.";
            }
            case 1005: {
                return "Stereotype <<$1$>> not supported for UML model elements of type '$2$'.";
            }
            case 1006: {
                return "The $1$ '$2$' will be ignored.";
            }
            case 1007: {
                return "The discriminator for the UML generalization with ID '$1$' is not blank. This genralization is ignored.";
            }
            case 1008: {
                return "Property '$1$' with type of ID '$2$' has hidden labels: '$3$'";
            }
            case 1009: {
                return "The property '$1$' is tagged as a metadata property. This is only possible for properties with complex content.";
            }
            case 1010: {
                return "Support for nilReason attributes was requested in property '$1$'. This is not possible for properties which have a local $2$ as their value.";
            }
            case 1011: {
                return "The constraint '$1$' cannot be associated with a modeling object (ID '$2$').";
            }
            case 1012: {
                return "Application schema found, package name: '$1$', target namespace: '$2$'";
            }
            case 10000: {
                return "Added tagged value '$1$' for element with ID '$2$' with value: '$3$'.";
            }
            case 10001: {
                return "The package with ID '$1$' and name '$2$' was created. Namespace: '$3$'.";
            }
            case 10002: {
                return "The association end with name '$1$' is the reverse property to '$2$'.";
            }
            case 10003: {
                return "Checked class '$1$', category '$2$', result '$3$'";
            }
            case 10004: {
                return "Checking overloading. Class = '$1$'; current class = '$2$'.";
            }
            case 10005: {
                return "Generating GML dictionaries with definitions for application schema '$1$'.";
            }
            case 10006: {
                return "Processing OCL constraint in class '$1$': '$2$'.";
            }
            case 10007: {
                return "Constraint is of type '$1$'.";
            }
            case 10008: {
                return "Target type: '$1$'.";
            }
            case 10009: {
                return "Property: '$1$'.";
            }
            case 10010: {
                return "Value condition: '$1$' '$2$' '$3$'";
            }
            case 10011: {
                return "The operation with ID '$1$' and name '$2$' has the following parameter: '$3$'";
            }
            case 10012: {
                return "Generating XML Schema for application schema '$1$'.";
            }
            case 10013: {
                return "The '$1$' with ID '$2$' and name '$3$' was created.";
            }
            case 10014: {
                return "Processing class '$1$'.";
            }
            case 10015: {
                return "Class '$1$' is a service.";
            }
            case 10016: {
                return "Processing class '$1$', rule '$2$'.";
            }
            case 10017: {
                return "Creating XSD document '$1$' for package '$2$'.";
            }
            case 10018: {
                return "Rose Bug Fix for Duplicate Global Data Types: DataType '$1$' replaced by '$2$'.";
            }
            case 10019: {
                return "Added stereotype '$1$' for element with ID '$2$'.";
            }
            case 10020: {
                return "Application schema found, package name: '$1$'";
            }
            case 10021: {
                return "Import to namespace '$1$' added.";
            }
            case 10022: {
                return "Found: '$1$'";
            }
            case 10023: {
                return "Processing local properties of class '$1$'.";
            }
            case 10024: {
                return "OCL syntax tree: '$1$'";
            }
            case 10025: {
                return "OCL comment: '$1$'";
            }
        }
        return "(Unknown message)";
    }

    public static class MessageContext {
        protected ShapeChangeResult result;
        protected String level;
        protected Element message;

        public MessageContext(ShapeChangeResult result, String level) {
            this.result = result;
            this.level = level;
            this.message = null;
        }

        public MessageContext(ShapeChangeResult result, String level, String mtext) {
            this.result = result;
            this.level = level;
            System.err.println(level.substring(0, 1) + " " + mtext);
            this.message = result.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", level);
            result.messages.appendChild(this.message);
            this.message.setAttribute("message", mtext);
        }

        public void addDetail(String mtext) {
            System.err.println(this.level.substring(0, 1) + " ... " + mtext);
            if (this.message != null) {
                Element detail = this.result.document.createElement("Detail");
                detail.setAttribute("message", mtext);
                this.message.appendChild(detail);
            }
        }

        public void addDetail(MessageSource ms, int mnr, String p1, String p2) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m.replace("$1$", p1).replace("$2$", p2));
        }

        public void addDetail(MessageSource ms, int mnr, String p1) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m.replace("$1$", p1));
        }

        public void addDetail(MessageSource ms, int mnr) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m);
        }
    }
}

