/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.UI;

import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.UI.Dialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.SystemUtils;

public class DefaultDialog
extends JFrame
implements ActionListener,
Dialog {
    private static final long serialVersionUID = 3197452835574541123L;
    private JTextField mdlField;
    private JTextField cfgField;
    private JTextField outField;
    private JTextField asField;
    private JButton mdlButton;
    private JButton cfgButton;
    private JButton outButton;
    private JButton startButton;
    private JButton logButton;
    private JButton exitButton;
    private ButtonGroup reportGroup;
    private ButtonGroup ruleGroup;
    private JCheckBox docCB;
    private JCheckBox visCB;
    private JFileChooser fc = new JFileChooser();
    protected Converter converter = null;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected String mdl = null;
    private File logfile = null;

    public DefaultDialog(Converter c, Options o, ShapeChangeResult r, String m) {
        super("ShapeChange");
        this.initialise(c, o, r, m);
    }

    public void initialise(Converter c, Options o, ShapeChangeResult r, String m) {
        this.converter = c;
        this.options = o;
        this.result = r;
        this.mdl = m;
        this.setDefaultCloseOperation(3);
        JPanel newContentPane = new JPanel(new BorderLayout());
        newContentPane.setOpaque(true);
        this.setContentPane(newContentPane);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Main options", this.createTab1());
        tabbedPane.addTab("Secondary options", this.createTab2());
        newContentPane.add(tabbedPane);
        int height = 480;
        int width = 720;
        this.pack();
        Insets fI = this.getInsets();
        this.setSize(width + fI.right + fI.left, height + fI.top + fI.bottom);
        Dimension sD = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((sD.width - width) / 2, (sD.height - height) / 2);
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
    }

    private Component createTab1() {
        JPanel mdlPanel = new JPanel();
        this.mdlField = new JTextField(40);
        String s = this.options.parameter("inputFile");
        if (s == null) {
            s = "";
        }
        this.mdlField.setText(s);
        mdlPanel.add(this.mdlField);
        this.mdlButton = new JButton("Select File");
        mdlPanel.add(this.mdlButton);
        this.mdlButton.setActionCommand("MDL");
        this.mdlButton.addActionListener(this);
        mdlPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Model file", 1, 2));
        JPanel outPanel = new JPanel();
        this.outField = new JTextField(40);
        s = this.options.parameter("outputDirectory");
        if (s == null) {
            s = ".";
        }
        this.outField.setText(s);
        outPanel.add(this.outField);
        this.outButton = new JButton("Select File");
        outPanel.add(this.outButton);
        this.outButton.setActionCommand("OUT");
        this.outButton.addActionListener(this);
        outPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Output directory", 1, 2));
        JPanel asPanel = new JPanel();
        this.asField = new JTextField(49);
        s = this.options.parameter("appSchemaName");
        if (s == null) {
            s = "";
        }
        this.asField.setText(s);
        asPanel.add(this.asField);
        asPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Application schema name (optional)", 1, 2));
        JPanel startPanel = new JPanel();
        this.startButton = new JButton("Process Model");
        this.startButton.setActionCommand("START");
        this.startButton.addActionListener(this);
        startPanel.add(this.startButton);
        this.logButton = new JButton("View Log");
        this.logButton.setActionCommand("LOG");
        this.logButton.addActionListener(this);
        this.logButton.setEnabled(false);
        startPanel.add(this.logButton);
        this.exitButton = new JButton("Exit");
        this.exitButton.setActionCommand("EXIT");
        this.exitButton.addActionListener(this);
        this.exitButton.setEnabled(true);
        startPanel.add(this.exitButton);
        Box fileBox = Box.createVerticalBox();
        fileBox.add(mdlPanel);
        fileBox.add(asPanel);
        fileBox.add(outPanel);
        fileBox.add(startPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)fileBox, "Center");
        return panel;
    }

    private void addRadioButton(JPanel panel, ButtonGroup group, String label, String value, String parameter) {
        JRadioButton radioButton = new JRadioButton(label, parameter.equalsIgnoreCase(value));
        panel.add(radioButton);
        radioButton.setActionCommand(value);
        group.add(radioButton);
    }

    private JPanel createTab2() {
        JPanel reportPanel = new JPanel(new GridLayout(3, 1));
        this.reportGroup = new ButtonGroup();
        String param = this.options.parameter("reportLevel");
        this.addRadioButton(reportPanel, this.reportGroup, "Error", "ERROR", param);
        this.addRadioButton(reportPanel, this.reportGroup, "Warning", "WARNING", param);
        this.addRadioButton(reportPanel, this.reportGroup, "Info", "INFO", param);
        reportPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Report options", 1, 2));
        JPanel rulePanel = new JPanel(new GridLayout(3, 1));
        this.ruleGroup = new ButtonGroup();
        param = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "defaultEncodingRule");
        this.addRadioButton(rulePanel, this.ruleGroup, "GML 3.2", "iso19136_2007", param);
        this.addRadioButton(rulePanel, this.ruleGroup, "GML 3.3", "gml33", param);
        this.addRadioButton(rulePanel, this.ruleGroup, "ISO/TS 19139", "iso19139_2007", param);
        this.addRadioButton(rulePanel, this.ruleGroup, "GML 3.2 (ShapeChange extensions)", "iso19136_2007_ShapeChange_1.0_extensions", param);
        this.addRadioButton(rulePanel, this.ruleGroup, "GML 3.3 (INSPIRE extensions)", "iso19136_2007_INSPIRE_Extensions", param);
        rulePanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Default encoding rule", 1, 2));
        JPanel otherPanel = new JPanel(new GridLayout(2, 1));
        this.docCB = new JCheckBox("Include documentation", true);
        boolean b = true;
        String s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation");
        if (s != null && s.equals("false")) {
            b = false;
        }
        this.docCB.setSelected(b);
        otherPanel.add(this.docCB);
        this.visCB = new JCheckBox("Ignore visibility");
        b = true;
        s = this.options.parameter("publicOnly");
        if (s != null && s.equals("false")) {
            b = false;
        }
        this.visCB.setSelected(!b);
        otherPanel.add(this.visCB);
        otherPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Other options", 1, 2));
        Box innerBox = Box.createHorizontalBox();
        innerBox.add(reportPanel);
        innerBox.add(otherPanel);
        Box mainBox = Box.createVerticalBox();
        mainBox.add(innerBox);
        mainBox.add(rulePanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)mainBox, "Center");
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        block32: {
            if (this.startButton == e.getSource()) {
                this.mdl = this.mdlField.getText().trim();
                this.startButton.setEnabled(false);
                this.exitButton.setEnabled(false);
                try {
                    this.options.setParameter("inputFile", this.mdl);
                    if (this.mdl.toLowerCase().endsWith(".xmi") || this.mdl.toLowerCase().endsWith(".xml")) {
                        this.options.setParameter("inputModelType", "XMI10");
                    } else if (this.mdl.toLowerCase().endsWith(".eap")) {
                        this.options.setParameter("inputModelType", "EA7");
                    } else if (this.mdl.toLowerCase().endsWith(".mdb")) {
                        this.options.setParameter("inputModelType", "GSIP");
                    }
                    this.options.setParameter("outputDirectory", this.outField.getText());
                    this.options.setParameter("logFile", this.outField.getText() + "/log.xml");
                    this.options.setParameter("appSchemaName", this.asField.getText());
                    this.options.setParameter("reportLevel", this.reportGroup.getSelection().getActionCommand());
                    this.options.setParameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "defaultEncodingRule", this.ruleGroup.getSelection().getActionCommand());
                    if (this.docCB.isSelected()) {
                        this.options.setParameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation", "true");
                    } else {
                        this.options.setParameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation", "false");
                    }
                    if (!this.visCB.isSelected()) {
                        this.options.setParameter("publicOnly", "true");
                    } else {
                        this.options.setParameter("publicOnly", "false");
                    }
                    this.converter.convert();
                }
                catch (ShapeChangeAbortException ex) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this.logfile = new File(this.options.parameter("logFile").replace(".xml", ".html"));
                if (this.logfile != null && this.logfile.canRead()) {
                    this.logButton.setEnabled(true);
                } else {
                    this.logfile = new File(this.options.parameter("logFile"));
                    if (this.logfile != null && this.logfile.canRead()) {
                        this.logButton.setEnabled(true);
                    }
                }
                this.exitButton.setEnabled(true);
            } else if (e.getSource() == this.logButton) {
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(this.logfile);
                        break block32;
                    }
                    if (SystemUtils.IS_OS_WINDOWS) {
                        Runtime.getRuntime().exec("cmd /c start " + this.logfile.getPath());
                        break block32;
                    }
                    Runtime.getRuntime().exec("open " + this.logfile.getPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    System.exit(1);
                }
            } else if (e.getSource() == this.exitButton) {
                System.exit(0);
            } else if (e.getSource() == this.mdlButton) {
                int returnVal = this.fc.showOpenDialog(this);
                if (returnVal == 0) {
                    File file = this.fc.getSelectedFile();
                    this.mdlField.setText(file.getAbsolutePath());
                }
            } else if (e.getSource() == this.cfgButton) {
                int returnVal = this.fc.showOpenDialog(this);
                if (returnVal == 0) {
                    File file = this.fc.getSelectedFile();
                    this.cfgField.setText(file.getAbsolutePath());
                }
            } else if (e.getSource() == this.outButton) {
                this.fc.setFileSelectionMode(1);
                int returnVal = this.fc.showOpenDialog(this);
                if (returnVal == 0) {
                    File file = this.fc.getSelectedFile();
                    this.outField.setText(file.getAbsolutePath());
                }
            }
        }
    }
}

