/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Sql;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Sql.XtraServerConfig;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ddl
implements Target {
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private XtraServerConfig xsrvcfg = null;
    private final HashMap<String, String> ddlMapCreate = new HashMap();
    private final HashMap<String, String> ddlMapDrop = new HashMap();
    private HashSet<String> pnames = new HashSet();
    private int seq;
    private boolean geometryColumn = false;
    private int sqlTarget = 3;
    private boolean sqlSFgeometryColumn = true;
    private boolean sql19107geometryColumn = true;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        String s = this.options.parameter(this.getClass().getName(), "sqlTarget");
        if (s != null) {
            if (s.equals("ORACLE10")) {
                this.sqlTarget = 2;
            } else if (s.equals("POSTGIS")) {
                this.sqlTarget = 3;
            } else {
                this.result.addError("Unknown value for target database: " + s);
            }
        }
        if ((s = this.options.parameter(this.getClass().getName(), "sqlSFgeometryColumn")) != null && s.equals("false")) {
            this.sqlSFgeometryColumn = false;
        }
        if ((s = this.options.parameter(this.getClass().getName(), "sql19107geometryColumn")) != null && s.equals("false")) {
            this.sql19107geometryColumn = false;
        }
        this.xsrvcfg = new XtraServerConfig(p, r, this.sqlTarget);
    }

    @Override
    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (cat != 1) {
            return;
        }
        if (ci.isAbstract()) {
            return;
        }
        this.createTable(ci);
    }

    private String name(String nam) {
        if (nam.equals("A") || nam.equals("ABORT") || nam.equals("ABS") || nam.equals("ABSOLUTE") || nam.equals("ACCESS") || nam.equals("ACTION") || nam.equals("ADA") || nam.equals("ADD") || nam.equals("ADMIN") || nam.equals("AFTER") || nam.equals("AGGREGATE") || nam.equals("ALIAS") || nam.equals("ALL") || nam.equals("ALLOCATE") || nam.equals("ALSO") || nam.equals("ALTER") || nam.equals("ALWAYS") || nam.equals("ANALYSE") || nam.equals("ANALYZE") || nam.equals("AND") || nam.equals("ANY") || nam.equals("ARE") || nam.equals("ARRAY") || nam.equals("AS") || nam.equals("ASC") || nam.equals("ASENSITIVE") || nam.equals("ASSERTION") || nam.equals("ASSIGNMENT") || nam.equals("ASYMMETRIC") || nam.equals("AT") || nam.equals("ATOMIC") || nam.equals("ATTRIBUTE") || nam.equals("ATTRIBUTES") || nam.equals("AUTHORIZATION") || nam.equals("AVG") || nam.equals("BACKWARD") || nam.equals("BEFORE") || nam.equals("BEGIN") || nam.equals("BERNOULLI") || nam.equals("BETWEEN") || nam.equals("BIGINT") || nam.equals("BINARY") || nam.equals("BIT") || nam.equals("BITVAR") || nam.equals("BIT_LENGTH") || nam.equals("BLOB") || nam.equals("BOOLEAN") || nam.equals("BOTH") || nam.equals("BREADTH") || nam.equals("BY") || nam.equals("C") || nam.equals("CACHE") || nam.equals("CALL") || nam.equals("CALLED") || nam.equals("CARDINALITY") || nam.equals("CASCADE") || nam.equals("CASCADED") || nam.equals("CASE") || nam.equals("CAST") || nam.equals("CATALOG") || nam.equals("CATALOG_NAME") || nam.equals("CEIL") || nam.equals("CEILING") || nam.equals("CHAIN") || nam.equals("CHAR") || nam.equals("CHARACTER") || nam.equals("CHARACTERISTICS") || nam.equals("CHARACTERS") || nam.equals("CHARACTER_LENGTH") || nam.equals("CHARACTER_SET_CATALOG") || nam.equals("CHARACTER_SET_NAME") || nam.equals("CHARACTER_SET_SCHEMA") || nam.equals("CHAR_LENGTH") || nam.equals("CHECK") || nam.equals("CHECKED") || nam.equals("CHECKPOINT") || nam.equals("CLASS") || nam.equals("CLASS_ORIGIN") || nam.equals("CLOB") || nam.equals("CLOSE") || nam.equals("CLUSTER") || nam.equals("COALESCE") || nam.equals("COBOL") || nam.equals("COLLATE") || nam.equals("COLLATION") || nam.equals("COLLATION_CATALOG") || nam.equals("COLLATION_NAME") || nam.equals("COLLATION_SCHEMA") || nam.equals("COLLECT") || nam.equals("COLUMN") || nam.equals("COLUMN_NAME") || nam.equals("COMMAND_FUNCTION") || nam.equals("COMMAND_FUNCTION_CODE") || nam.equals("COMMENT") || nam.equals("COMMIT") || nam.equals("COMMITTED") || nam.equals("COMPLETION") || nam.equals("CONDITION") || nam.equals("CONDITION_NUMBER") || nam.equals("CONNECT") || nam.equals("CONNECTION") || nam.equals("CONNECTION_NAME") || nam.equals("CONSTRAINT") || nam.equals("CONSTRAINTS") || nam.equals("CONSTRAINT_CATALOG") || nam.equals("CONSTRAINT_NAME") || nam.equals("CONSTRAINT_SCHEMA") || nam.equals("CONSTRUCTOR") || nam.equals("CONTAINS") || nam.equals("CONTINUE") || nam.equals("CONVERSION") || nam.equals("CONVERT") || nam.equals("COPY") || nam.equals("CORR") || nam.equals("CORRESPONDING") || nam.equals("COUNT") || nam.equals("COVAR_POP") || nam.equals("COVAR_SAMP") || nam.equals("CREATE") || nam.equals("CREATEDB") || nam.equals("CREATEROLE") || nam.equals("CREATEUSER") || nam.equals("CROSS") || nam.equals("CSV") || nam.equals("CUBE") || nam.equals("CUME_DIST") || nam.equals("CURRENT") || nam.equals("CURRENT_DATE") || nam.equals("CURRENT_DEFAULT_TRANSFORM_GROUP") || nam.equals("CURRENT_PATH") || nam.equals("CURRENT_ROLE") || nam.equals("CURRENT_TIME") || nam.equals("CURRENT_TIMESTAMP") || nam.equals("CURRENT_TRANSFORM_GROUP_FOR_TYPE") || nam.equals("CURRENT_USER") || nam.equals("CURSOR") || nam.equals("CURSOR_NAME") || nam.equals("CYCLE") || nam.equals("DATA") || nam.equals("DATABASE") || nam.equals("DATE") || nam.equals("DATETIME_INTERVAL_CODE") || nam.equals("DATETIME_INTERVAL_PRECISION") || nam.equals("DAY") || nam.equals("DEALLOCATE") || nam.equals("DEC") || nam.equals("DECIMAL") || nam.equals("DECLARE") || nam.equals("DEFAULT") || nam.equals("DEFAULTS") || nam.equals("DEFERRABLE") || nam.equals("DEFERRED") || nam.equals("DEFINED") || nam.equals("DEFINER") || nam.equals("DEGREE") || nam.equals("DELETE") || nam.equals("DELIMITER") || nam.equals("DELIMITERS") || nam.equals("DENSE_RANK") || nam.equals("DEPTH") || nam.equals("DEREF") || nam.equals("DERIVED") || nam.equals("DESC") || nam.equals("DESCRIBE") || nam.equals("DESCRIPTOR") || nam.equals("DESTROY") || nam.equals("DESTRUCTOR") || nam.equals("DETERMINISTIC") || nam.equals("DIAGNOSTICS") || nam.equals("DICTIONARY") || nam.equals("DISABLE") || nam.equals("DISCONNECT") || nam.equals("DISPATCH") || nam.equals("DISTINCT") || nam.equals("DO") || nam.equals("DOMAIN") || nam.equals("DOUBLE") || nam.equals("DROP") || nam.equals("DYNAMIC") || nam.equals("DYNAMIC_FUNCTION") || nam.equals("DYNAMIC_FUNCTION_CODE") || nam.equals("EACH") || nam.equals("ELEMENT") || nam.equals("ELSE") || nam.equals("ENABLE") || nam.equals("ENCODING") || nam.equals("ENCRYPTED") || nam.equals("END") || nam.equals("END-EXEC") || nam.equals("EQUALS") || nam.equals("ESCAPE") || nam.equals("EVERY") || nam.equals("EXCEPT") || nam.equals("EXCEPTION") || nam.equals("EXCLUDE") || nam.equals("EXCLUDING") || nam.equals("EXCLUSIVE") || nam.equals("EXEC") || nam.equals("EXECUTE") || nam.equals("EXISTING") || nam.equals("EXISTS") || nam.equals("EXP") || nam.equals("EXPLAIN") || nam.equals("EXTERNAL") || nam.equals("EXTRACT") || nam.equals("FALSE") || nam.equals("FETCH") || nam.equals("FILTER") || nam.equals("FINAL") || nam.equals("FIRST") || nam.equals("FLOAT") || nam.equals("FLOOR") || nam.equals("FOLLOWING") || nam.equals("FOR") || nam.equals("FORCE") || nam.equals("FOREIGN") || nam.equals("FORTRAN") || nam.equals("FORWARD") || nam.equals("FOUND") || nam.equals("FREE") || nam.equals("FREEZE") || nam.equals("FROM") || nam.equals("FULL") || nam.equals("FUNCTION") || nam.equals("FUSION") || nam.equals("G") || nam.equals("GENERAL") || nam.equals("GENERATED") || nam.equals("GET") || nam.equals("GLOBAL") || nam.equals("GO") || nam.equals("GOTO") || nam.equals("GRANT") || nam.equals("GRANTED") || nam.equals("GREATEST") || nam.equals("GROUP") || nam.equals("GROUPING") || nam.equals("HANDLER") || nam.equals("HAVING") || nam.equals("HEADER") || nam.equals("HIERARCHY") || nam.equals("HOLD") || nam.equals("HOST") || nam.equals("HOUR") || nam.equals("IDENTITY") || nam.equals("IGNORE") || nam.equals("ILIKE") || nam.equals("IMMEDIATE") || nam.equals("IMMUTABLE") || nam.equals("IMPLEMENTATION") || nam.equals("IMPLICIT") || nam.equals("IN") || nam.equals("INCLUDING") || nam.equals("INCREMENT") || nam.equals("INDEX") || nam.equals("INDICATOR") || nam.equals("INFIX") || nam.equals("INHERIT") || nam.equals("INHERITS") || nam.equals("INITIALIZE") || nam.equals("INITIALLY") || nam.equals("INNER") || nam.equals("INOUT") || nam.equals("INPUT") || nam.equals("INSENSITIVE") || nam.equals("INSERT") || nam.equals("INSTANCE") || nam.equals("INSTANTIABLE") || nam.equals("INSTEAD") || nam.equals("INT") || nam.equals("INTEGER") || nam.equals("INTERSECT") || nam.equals("INTERSECTION") || nam.equals("INTERVAL") || nam.equals("INTO") || nam.equals("INVOKER") || nam.equals("IS") || nam.equals("ISNULL") || nam.equals("ISOLATION") || nam.equals("ITERATE") || nam.equals("JOIN") || nam.equals("K") || nam.equals("KEY") || nam.equals("KEY_MEMBER") || nam.equals("KEY_TYPE") || nam.equals("LANCOMPILER") || nam.equals("LANGUAGE") || nam.equals("LARGE") || nam.equals("LAST") || nam.equals("LATERAL") || nam.equals("LEADING") || nam.equals("LEAST") || nam.equals("LEFT") || nam.equals("LENGTH") || nam.equals("LESS") || nam.equals("LEVEL") || nam.equals("LIKE") || nam.equals("LIMIT") || nam.equals("LISTEN") || nam.equals("LN") || nam.equals("LOAD") || nam.equals("LOCAL") || nam.equals("LOCALTIME") || nam.equals("LOCALTIMESTAMP") || nam.equals("LOCATION") || nam.equals("LOCATOR") || nam.equals("LOCK") || nam.equals("LOGIN") || nam.equals("LOWER") || nam.equals("M") || nam.equals("MAP") || nam.equals("MATCH") || nam.equals("MATCHED") || nam.equals("MAX") || nam.equals("MAXVALUE") || nam.equals("MEMBER") || nam.equals("MERGE") || nam.equals("MESSAGE_LENGTH") || nam.equals("MESSAGE_OCTET_LENGTH") || nam.equals("MESSAGE_TEXT") || nam.equals("METHOD") || nam.equals("MIN") || nam.equals("MINUTE") || nam.equals("MINVALUE") || nam.equals("MOD") || nam.equals("MODE") || nam.equals("MODIFIES") || nam.equals("MODIFY") || nam.equals("MODULE") || nam.equals("MONTH") || nam.equals("MORE") || nam.equals("MOVE") || nam.equals("MULTISET") || nam.equals("MUMPS") || nam.equals("NAME") || nam.equals("NAMES") || nam.equals("NATIONAL") || nam.equals("NATURAL") || nam.equals("NCHAR") || nam.equals("NCLOB") || nam.equals("NESTING") || nam.equals("NEW") || nam.equals("NEXT") || nam.equals("NO") || nam.equals("NOCREATEDB") || nam.equals("NOCREATEROLE") || nam.equals("NOCREATEUSER") || nam.equals("NOINHERIT") || nam.equals("NOLOGIN") || nam.equals("NONE") || nam.equals("NORMALIZE") || nam.equals("NORMALIZED") || nam.equals("NOSUPERUSER") || nam.equals("NOT") || nam.equals("NOTHING") || nam.equals("NOTIFY") || nam.equals("NOTNULL") || nam.equals("NOWAIT") || nam.equals("NULL") || nam.equals("NULLABLE") || nam.equals("NULLIF") || nam.equals("NULLS") || nam.equals("NUMBER") || nam.equals("NUMERIC") || nam.equals("OBJECT") || nam.equals("OCTETS") || nam.equals("OCTET_LENGTH") || nam.equals("OF") || nam.equals("OFF") || nam.equals("OFFSET") || nam.equals("OIDS") || nam.equals("OLD") || nam.equals("ON") || nam.equals("ONLY") || nam.equals("OPEN") || nam.equals("OPERATION") || nam.equals("OPERATOR") || nam.equals("OPTION") || nam.equals("OPTIONS") || nam.equals("OR") || nam.equals("ORDER") || nam.equals("ORDERING") || nam.equals("ORDINALITY") || nam.equals("OTHERS") || nam.equals("OUT") || nam.equals("OUTER") || nam.equals("OUTPUT") || nam.equals("OVER") || nam.equals("OVERLAPS") || nam.equals("OVERLAY") || nam.equals("OVERRIDING") || nam.equals("OWNER") || nam.equals("PAD") || nam.equals("PARAMETER") || nam.equals("PARAMETERS") || nam.equals("PARAMETER_MODE") || nam.equals("PARAMETER_NAME") || nam.equals("PARAMETER_ORDINAL_POSITION") || nam.equals("PARAMETER_SPECIFIC_CATALOG") || nam.equals("PARAMETER_SPECIFIC_NAME") || nam.equals("PARAMETER_SPECIFIC_SCHEMA") || nam.equals("PARTIAL") || nam.equals("PARTITION") || nam.equals("PASCAL") || nam.equals("PASSWORD") || nam.equals("PATH") || nam.equals("PERCENTILE_CONT") || nam.equals("PERCENTILE_DISC") || nam.equals("PERCENT_RANK") || nam.equals("PLACING") || nam.equals("PLI") || nam.equals("POSITION") || nam.equals("POSTFIX") || nam.equals("POWER") || nam.equals("PRECEDING") || nam.equals("PRECISION") || nam.equals("PREFIX") || nam.equals("PREORDER") || nam.equals("PREPARE") || nam.equals("PREPARED") || nam.equals("PRESERVE") || nam.equals("PRIMARY") || nam.equals("PRIOR") || nam.equals("PRIVILEGES") || nam.equals("PROCEDURAL") || nam.equals("PROCEDURE") || nam.equals("PUBLIC") || nam.equals("QUOTE") || nam.equals("RANGE") || nam.equals("RANK") || nam.equals("READ") || nam.equals("READS") || nam.equals("REAL") || nam.equals("RECHECK") || nam.equals("RECURSIVE") || nam.equals("REF") || nam.equals("REFERENCES") || nam.equals("REFERENCING") || nam.equals("REGR_AVGX") || nam.equals("REGR_AVGY") || nam.equals("REGR_COUNT") || nam.equals("REGR_INTERCEPT") || nam.equals("REGR_R2") || nam.equals("REGR_SLOPE") || nam.equals("REGR_SXX") || nam.equals("REGR_SXY") || nam.equals("REGR_SYY") || nam.equals("REINDEX") || nam.equals("RELATIVE") || nam.equals("RELEASE") || nam.equals("RENAME") || nam.equals("REPEATABLE") || nam.equals("REPLACE") || nam.equals("RESET") || nam.equals("RESTART") || nam.equals("RESTRICT") || nam.equals("RESULT") || nam.equals("RETURN") || nam.equals("RETURNED_CARDINALITY") || nam.equals("RETURNED_LENGTH") || nam.equals("RETURNED_OCTET_LENGTH") || nam.equals("RETURNED_SQLSTATE") || nam.equals("RETURNS") || nam.equals("REVOKE") || nam.equals("RIGHT") || nam.equals("ROLE") || nam.equals("ROLLBACK") || nam.equals("ROLLUP") || nam.equals("ROUTINE") || nam.equals("ROUTINE_CATALOG") || nam.equals("ROUTINE_NAME") || nam.equals("ROUTINE_SCHEMA") || nam.equals("ROW") || nam.equals("ROWS") || nam.equals("ROW_COUNT") || nam.equals("ROW_NUMBER") || nam.equals("RULE") || nam.equals("SAVEPOINT") || nam.equals("SCALE") || nam.equals("SCHEMA") || nam.equals("SCHEMA_NAME") || nam.equals("SCOPE") || nam.equals("SCOPE_CATALOG") || nam.equals("SCOPE_NAME") || nam.equals("SCOPE_SCHEMA") || nam.equals("SCROLL") || nam.equals("SEARCH") || nam.equals("SECOND") || nam.equals("SECTION") || nam.equals("SECURITY") || nam.equals("SELECT") || nam.equals("SELF") || nam.equals("SENSITIVE") || nam.equals("SEQUENCE") || nam.equals("SERIALIZABLE") || nam.equals("SERVER_NAME") || nam.equals("SESSION") || nam.equals("SESSION_USER") || nam.equals("SET") || nam.equals("SETOF") || nam.equals("SETS") || nam.equals("SHARE") || nam.equals("SHOW") || nam.equals("SIMILAR") || nam.equals("SIMPLE") || nam.equals("SIZE") || nam.equals("SMALLINT") || nam.equals("SOME") || nam.equals("SOURCE") || nam.equals("SPACE") || nam.equals("SPECIFIC") || nam.equals("SPECIFICTYPE") || nam.equals("SPECIFIC_NAME") || nam.equals("SQL") || nam.equals("SQLCODE") || nam.equals("SQLERROR") || nam.equals("SQLEXCEPTION") || nam.equals("SQLSTATE") || nam.equals("SQLWARNING") || nam.equals("SQRT") || nam.equals("STABLE") || nam.equals("START") || nam.equals("STATE") || nam.equals("STATEMENT") || nam.equals("STATIC") || nam.equals("STATISTICS") || nam.equals("STDDEV_POP") || nam.equals("STDDEV_SAMP") || nam.equals("STDIN") || nam.equals("STDOUT") || nam.equals("STORAGE") || nam.equals("STRICT") || nam.equals("STRUCTURE") || nam.equals("STYLE") || nam.equals("SUBCLASS_ORIGIN") || nam.equals("SUBLIST") || nam.equals("SUBMULTISET") || nam.equals("SUBSTRING") || nam.equals("SUM") || nam.equals("SUPERUSER") || nam.equals("SYMMETRIC") || nam.equals("SYSID") || nam.equals("SYSTEM") || nam.equals("SYSTEM_USER") || nam.equals("TABLE") || nam.equals("TABLESAMPLE") || nam.equals("TABLESPACE") || nam.equals("TABLE_NAME") || nam.equals("TEMP") || nam.equals("TEMPLATE") || nam.equals("TEMPORARY") || nam.equals("TERMINATE") || nam.equals("THAN") || nam.equals("THEN") || nam.equals("TIES") || nam.equals("TIME") || nam.equals("TIMESTAMP") || nam.equals("TIMEZONE_HOUR") || nam.equals("TIMEZONE_MINUTE") || nam.equals("TO") || nam.equals("TOAST") || nam.equals("TOP_LEVEL_COUNT") || nam.equals("TRAILING") || nam.equals("TRANSACTION") || nam.equals("TRANSACTIONS_COMMITTED") || nam.equals("TRANSACTIONS_ROLLED_BACK") || nam.equals("TRANSACTION_ACTIVE") || nam.equals("TRANSFORM") || nam.equals("TRANSFORMS") || nam.equals("TRANSLATE") || nam.equals("TRANSLATION") || nam.equals("TREAT") || nam.equals("TRIGGER") || nam.equals("TRIGGER_CATALOG") || nam.equals("TRIGGER_NAME") || nam.equals("TRIGGER_SCHEMA") || nam.equals("TRIM") || nam.equals("TRUE") || nam.equals("TRUNCATE") || nam.equals("TRUSTED") || nam.equals("TYPE") || nam.equals("UESCAPE") || nam.equals("UNBOUNDED") || nam.equals("UNCOMMITTED") || nam.equals("UNDER") || nam.equals("UNENCRYPTED") || nam.equals("UNION") || nam.equals("UNIQUE") || nam.equals("UNKNOWN") || nam.equals("UNLISTEN") || nam.equals("UNNAMED") || nam.equals("UNNEST") || nam.equals("UNTIL") || nam.equals("UPDATE") || nam.equals("UPPER") || nam.equals("USAGE") || nam.equals("USER") || nam.equals("USER_DEFINED_TYPE_CATALOG") || nam.equals("USER_DEFINED_TYPE_CODE") || nam.equals("USER_DEFINED_TYPE_NAME") || nam.equals("USER_DEFINED_TYPE_SCHEMA") || nam.equals("USING") || nam.equals("VACUUM") || nam.equals("VALID") || nam.equals("VALIDATOR") || nam.equals("VALUE") || nam.equals("VALUES") || nam.equals("VARCHAR") || nam.equals("VARIABLE") || nam.equals("VARYING") || nam.equals("VAR_POP") || nam.equals("VAR_SAMP") || nam.equals("VERBOSE") || nam.equals("VIEW") || nam.equals("VOLATILE") || nam.equals("WHEN") || nam.equals("WHENEVER") || nam.equals("WHERE") || nam.equals("WIDTH_BUCKET") || nam.equals("WINDOW") || nam.equals("WITH") || nam.equals("WITHIN") || nam.equals("WITHOUT") || nam.equals("WORK") || nam.equals("WRITE") || nam.equals("YEAR") || nam.equals("ZONE")) {
            nam = String.valueOf(nam) + "X";
        }
        if (this.sqlTarget == 3) {
            return nam.toLowerCase();
        }
        if (this.sqlTarget == 2) {
            return nam.toUpperCase();
        }
        return nam.toUpperCase();
    }

    private String tChar(int siz) {
        if (this.sqlTarget == 3) {
            return "character(" + siz + ")";
        }
        if (this.sqlTarget == 2) {
            return "VARCHAR2(" + siz + " CHAR)";
        }
        return "VARCHAR(" + siz + ")";
    }

    private String tVarchar(int siz) {
        if (this.sqlTarget == 3) {
            return "character varying(" + siz + ")";
        }
        if (this.sqlTarget == 2) {
            return "VARCHAR2(" + siz + " CHAR)";
        }
        return "VARCHAR(" + siz + ")";
    }

    private String tIdentifier() {
        if (this.sqlTarget == 3) {
            return "bigint";
        }
        if (this.sqlTarget == 2) {
            return "INTEGER";
        }
        return "INTEGER";
    }

    private String tInteger() {
        if (this.sqlTarget == 3) {
            return "integer";
        }
        if (this.sqlTarget == 2) {
            return "INTEGER";
        }
        return "INTEGER";
    }

    private String tNumeric(int prec, int siz) {
        if (this.sqlTarget == 3) {
            return "numeric(" + prec + "," + siz + ")";
        }
        if (this.sqlTarget == 2) {
            return "NUMERIC(" + prec + "," + siz + ")";
        }
        return "NUMERIC(" + prec + "," + siz + ")";
    }

    private String tBoolean() {
        if (this.sqlTarget == 3) {
            return "boolean";
        }
        if (this.sqlTarget == 2) {
            return "FIXME";
        }
        return "FIXME";
    }

    private String tDate() {
        if (this.sqlTarget == 3) {
            return "date";
        }
        if (this.sqlTarget == 2) {
            return "FIXME";
        }
        return "FIXME";
    }

    private String tDateTime() {
        if (this.sqlTarget == 3) {
            return "timestamp with time zone";
        }
        if (this.sqlTarget == 2) {
            return "FIXME";
        }
        return "FIXME";
    }

    private String tGeometry(String type, boolean simpleFeature) {
        if (this.sqlTarget == 3) {
            if (type.equals("GM_Point")) {
                return "POINT";
            }
            if (type.equals("GM_Curve")) {
                if (simpleFeature) {
                    return "LINESTRING";
                }
                return "GEOMETRYCOLLECTION";
            }
            if (type.equals("GM_Surface")) {
                if (simpleFeature) {
                    return "POLYGON";
                }
                return "GEOMETRYCOLLECTION";
            }
            if (type.equals("GM_MultiPoint")) {
                return "MULTIPOINT";
            }
            if (type.equals("GM_MultiCurve")) {
                if (simpleFeature) {
                    return "MULTILINESTRING";
                }
                return "GEOMETRYCOLLECTION";
            }
            if (type.equals("GM_MultiSurface")) {
                if (simpleFeature) {
                    return "MULTIPOLYGON";
                }
                return "GEOMETRYCOLLECTION";
            }
            if (type.equals("GM_OBJECT")) {
                return "GEOMETRYCOLLECTION";
            }
            return "GEOMETRYCOLLECTION";
        }
        if (this.sqlTarget == 2) {
            return "MDSYS.SDO_GEOMETRY";
        }
        return "FIXME";
    }

    private String cName(ClassInfo ci) {
        String tv = ci.taggedValue("AAA:Kennung");
        if (tv == null) {
            tv = ci.name();
        } else if (!tv.substring(0, 1).matches("[A-Za-z_]")) {
            tv = "O" + tv;
        }
        return this.name(tv);
    }

    private String pName(PropertyInfo propi) {
        String tv = propi.taggedValue("AAA:Kennung");
        if (tv == null) {
            tv = propi.name();
        } else if (!tv.substring(0, 1).matches("[A-Za-z_]")) {
            tv = "P" + tv;
        }
        tv = tv.replace(".", "");
        tv = tv.replace("-", "");
        tv = tv.replace("(", "");
        tv = tv.replace(")", "");
        return this.name(tv);
    }

    private void createTable(ClassInfo ci) {
        String cn = this.cName(ci);
        String dt = "******\r\n\r\n";
        String ct = "CREATE TABLE " + cn + "\r\n" + "(";
        ct = String.valueOf(ct) + "\r\n id bigint NOT NULL PRIMARY KEY,";
        ct = String.valueOf(ct) + "\r\n objid " + this.tChar(16);
        Element ft = this.xsrvcfg.addFeatureType(ci);
        this.xsrvcfg.addOidColFeature(ft, cn, "id");
        this.xsrvcfg.addValCol(ft, cn, "objid", "@gml:id", "map_targetpath=true");
        this.xsrvcfg.addValCol(ft, cn, "'urn:adv:oid:' || $T$.objid", "gml:identifier", "assign=$IGNORE$");
        this.xsrvcfg.addConst(ft, cn, "http://www.adv-online.de/", "gml:identifier/@codeSpace", null);
        this.pnames.clear();
        this.seq = 1;
        this.geometryColumn = false;
        ct = this.createAllProperties(ci, ci, String.valueOf(ct) + "------", ft);
        ct = ct.replace("------", "\r\n);\r\nCREATE UNIQUE INDEX idx_" + cn + "_objid ON " + cn + "(objid);" + "\r\n");
        dt = this.geometryColumn ? dt.replace("******", "SELECT DropGeometryTable(" + cn + ");") : dt.replace("******", "DROP TABLE " + cn + ";");
        ct = String.valueOf(ct) + "COMMIT;\r\n";
        dt = String.valueOf(dt) + "COMMIT;\r\n";
        this.ddlMapCreate.put(ci.id(), ct);
        this.ddlMapDrop.put(ci.id(), dt);
    }

    private String createAllProperties(ClassInfo cibase, ClassInfo cicurr, String ddl, Element ft) {
        HashSet<String> st;
        if (cicurr == null) {
            return ddl;
        }
        if (cicurr.pkg() == null) {
            this.result.addError("Cannot add properties of supertype " + cicurr.name() + " in schema definitions since the type definition is not part of the model.");
        }
        if ((st = cicurr.supertypes()) != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                ddl = this.createAllProperties(cibase, this.model.classById(i.next()), ddl, ft);
            }
        }
        for (PropertyInfo propi : cicurr.properties().values()) {
            ddl = this.createProperty(cibase, cicurr, ddl, ft, propi, propi.qname(), this.cName(cibase), this.pName(propi), false);
        }
        return ddl;
    }

    private HashSet<String> allSubtypes(ClassInfo ci) {
        HashSet<String> ss = new HashSet<String>();
        ss.add(ci.id());
        HashSet<String> st = ci.subtypes();
        if (st != null) {
            for (String s : st) {
                ClassInfo ei = this.model.classById(s);
                if (ei == null || ei.isAbstract()) continue;
                ss.add(s);
                ss.addAll(this.allSubtypes(ei));
            }
        }
        return ss;
    }

    private String createProperty(ClassInfo cibase, ClassInfo cicurr, String ddl, Element ft, PropertyInfo propi, String xpath, String tab, String col, boolean tpath) {
        if (!propi.isNavigable()) {
            return ddl;
        }
        if (propi.restriction()) {
            return ddl;
        }
        String tv = propi.taggedValue("reverseRoleNAS");
        if (tv != null && tv.equals("true")) {
            return ddl;
        }
        Multiplicity m = propi.cardinality();
        ClassInfo ei = this.model.classById(propi.typeInfo().id);
        if (ei == null) {
            this.result.addError("Unknown type of " + cicurr.name() + "." + propi.name() + ": " + propi.typeInfo().name);
            return ddl;
        }
        if (m.maxOccurs < 1) {
            return ddl;
        }
        if (m.maxOccurs == 1) {
            String s = this.processProperty(cibase, cicurr, ddl, ft, propi, ei, xpath, tab, col, tpath);
            if (s == null) {
                this.result.addError("BASICTYPE: Unknown case for " + cicurr.name() + "." + propi.name() + " with type " + propi.typeInfo().name);
                return ddl;
            }
            if (s.equals("--COMPLEXTYPE--")) {
                this.xsrvcfg.addValCol(ft, tab, null, String.valueOf(xpath) + "/" + ei.qname(), null);
                for (PropertyInfo propj : ei.properties().values()) {
                    ddl = this.createProperty(cibase, ei, ddl, ft, propj, String.valueOf(xpath) + "/" + ei.qname() + "/" + propj.qname(), tab, String.valueOf(col) + "__" + this.pName(propj), true);
                }
            } else if (s.equals("--GEOMETRY--")) {
                String cn = this.cName(cibase);
                String pn = this.pName(propi);
                String type = propi.typeInfo().name;
                String post = "";
                if (this.sqlSFgeometryColumn) {
                    post = String.valueOf(post) + "SELECT AddGeometryColumn(\r\n'" + cn + "',";
                    post = String.valueOf(post) + "\r\n'" + pn + "',";
                    post = String.valueOf(post) + "\r\n25832,";
                    post = String.valueOf(post) + "\r\n'" + this.tGeometry(type, true) + "',";
                    post = String.valueOf(post) + "\r\n2);";
                    post = String.valueOf(post) + "\r\nCREATE INDEX idx_" + cn + "_" + pn + " ON " + cn + " USING GIST ( " + pn + " );" + "\r\n";
                }
                if (this.sql19107geometryColumn) {
                    post = String.valueOf(post) + "SELECT AddGeometryColumn(\r\n'" + cn + "',";
                    post = String.valueOf(post) + "\r\n'" + pn + "_surface',";
                    post = String.valueOf(post) + "\r\n25832,";
                    post = String.valueOf(post) + "\r\n'" + this.tGeometry(type, false) + "',";
                    post = String.valueOf(post) + "\r\n2);";
                    post = String.valueOf(post) + "\r\nCREATE INDEX idx_" + cn + "_" + pn + " ON " + cn + " USING GIST ( " + pn + "_surface );" + "\r\n";
                }
                if (this.sqlTarget == 3 && this.sqlSFgeometryColumn && this.sql19107geometryColumn) {
                    if (type.equals("GM_Curve") || type.equals("GM_MultiCurve")) {
                        post = String.valueOf(post) + "DROP TRIGGER IF EXISTS xsv_trg_i_curve2linestring ON " + cn + ";" + "\r\n";
                        post = String.valueOf(post) + "DROP TRIGGER IF EXISTS xsv_trg_u_curve2linestring ON " + cn + ";" + "\r\n";
                        post = String.valueOf(post) + "CREATE TRIGGER xsv_trg_i_curve2linestring BEFORE INSERT ON " + cn + " FOR EACH ROW EXECUTE PROCEDURE xsv_trg_curve2linestring();" + "\r\n";
                        post = String.valueOf(post) + "CREATE TRIGGER xsv_trg_u_curve2linestring BEFORE UPDATE ON " + cn + " FOR EACH ROW EXECUTE PROCEDURE xsv_trg_curve2linestring();" + "\r\n";
                    } else if (type.equals("GM_Surface") || type.equals("GM_MultiSurface")) {
                        post = String.valueOf(post) + "DROP TRIGGER IF EXISTS xsv_trg_i_surface2polygon ON " + cn + ";" + "\r\n";
                        post = String.valueOf(post) + "DROP TRIGGER IF EXISTS xsv_trg_u_surface2polygon ON " + cn + ";" + "\r\n";
                        post = String.valueOf(post) + "CREATE TRIGGER xsv_trg_i_surface2polygon BEFORE INSERT ON " + cn + " FOR EACH ROW EXECUTE PROCEDURE xsv_trg_surface2polygon();" + "\r\n";
                        post = String.valueOf(post) + "CREATE TRIGGER xsv_trg_u_surface2polygon BEFORE UPDATE ON " + cn + " FOR EACH ROW EXECUTE PROCEDURE xsv_trg_surface2polygon();" + "\r\n";
                    }
                }
                if (this.sqlSFgeometryColumn && this.sql19107geometryColumn) {
                    this.xsrvcfg.addValCol(ft, tab, String.valueOf(pn) + "_surface", propi.qname(), "useGeotypes=gml:Surface");
                    this.xsrvcfg.addValCol(ft, tab, pn, propi.qname(), "filter_mapping=true");
                } else if (this.sqlSFgeometryColumn) {
                    this.xsrvcfg.addValCol(ft, tab, pn, propi.qname(), null);
                }
                ddl = String.valueOf(ddl) + post;
            } else {
                ddl = s;
            }
        } else {
            String nt = "CREATE TABLE " + tab + "__" + col + "\r\n" + "(" + "\r\n" + " id bigint NOT NULL PRIMARY KEY," + "\r\n" + " rid " + this.tIdentifier() + "------";
            this.xsrvcfg.addOidColProperty(ft, String.valueOf(tab) + "__" + col, propi.qname(), "id");
            this.xsrvcfg.addValCol(ft, String.valueOf(tab) + "__" + col, null, String.valueOf(xpath) + "/" + ei.qname(), null);
            String s = this.processProperty(cibase, cicurr, nt, ft, propi, ei, xpath, String.valueOf(tab) + "__" + col, col, tpath);
            if (s == null) {
                this.result.addError("BASICTYPE: Unknown case for " + cicurr.name() + "." + propi.name() + " with type " + propi.typeInfo().name);
                return ddl;
            }
            if (s.equals("--COMPLEXTYPE--")) {
                for (PropertyInfo propj : ei.properties().values()) {
                    nt = this.createProperty(cibase, ei, nt, ft, propj, String.valueOf(xpath) + "/" + ei.qname() + "/" + propj.qname(), String.valueOf(tab) + "__" + col, this.pName(propj), false);
                }
                this.xsrvcfg.addJoin(ft, String.valueOf(tab) + "__" + col + "/ref(rid:id)::" + tab, "parent", propi.qname());
            } else {
                nt = s;
                this.xsrvcfg.addJoin(ft, String.valueOf(tab) + "__" + col + "/ref(rid:id)::" + tab, "parent", propi.qname());
            }
            nt = nt.replace("------", "\r\n);\r\n");
            nt = String.valueOf(nt) + "CREATE INDEX fk_" + tab + "__" + col + "_rid ON " + tab + "__" + col + "(rid);" + "\r\n";
            ddl = String.valueOf(nt) + ddl;
        }
        return ddl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processProperty(ClassInfo cibase, ClassInfo cicurr, String ddl, Element ft, PropertyInfo propi, ClassInfo ei, String xpath, String tab, String col, boolean tpath) {
        int cat = ei.category();
        String type = propi.typeInfo().name;
        if (this.pnames.contains(col)) {
            col = String.valueOf(col) + "_" + this.seq++;
        }
        this.pnames.add(col);
        String pfx = ",\r\n " + col + " ";
        if (type.equals("CharacterString") || type.equals("URI")) {
            pfx = String.valueOf(pfx) + this.tVarchar(255);
        } else if (type.equals("Date")) {
            pfx = String.valueOf(pfx) + this.tDate();
        } else if (type.equals("DateTime")) {
            pfx = String.valueOf(pfx) + this.tDateTime();
        } else if (type.equals("Integer")) {
            pfx = String.valueOf(pfx) + this.tInteger();
        } else if (type.equals("Boolean")) {
            pfx = String.valueOf(pfx) + this.tBoolean();
        } else if (type.startsWith("GM_")) {
            this.geometryColumn = true;
            if (this.sqlTarget == 3) return "--GEOMETRY--";
            pfx = String.valueOf(pfx) + this.tGeometry(type, false);
        } else if (type.equals("Real") || type.equals("Decimal")) {
            pfx = String.valueOf(pfx) + this.tNumeric(12, 3);
        } else if (type.equals("Measure") || type.equals("Length") || type.equals("Distance") || type.equals("Area") || type.equals("FIXME") || type.equals("FIXME")) {
            pfx = String.valueOf(pfx) + this.tNumeric(12, 3);
            this.xsrvcfg.addConst(ft, tab, "FIXME", String.valueOf(xpath) + "/@uom", null);
        } else {
            if (cat == 7) {
                return null;
            }
            if (cat == 5 || cat == 8) {
                return "--COMPLEXTYPE--";
            }
            if (cat == 2 || cat == 3) {
                pfx = String.valueOf(pfx) + this.tVarchar(16);
            } else {
                if (cat != 1 && cat != 6) return null;
                pfx = String.valueOf(pfx) + this.tChar(16);
                this.xsrvcfg.addValCol(ft, tab, null, xpath, null);
                this.xsrvcfg.addValCol(ft, tab, "'urn:adv:oid:' || $T$." + col, String.valueOf(xpath) + "/@xlink:href", "assign=" + col);
                this.xsrvcfg.addAssociationTarget(ft, xpath, ei.qname());
                this.xsrvcfg.addJoin(ft, String.valueOf(tab) + "/ref(rid:id)::" + this.cName(cibase), "parent", xpath);
                HashSet<String> ss = this.allSubtypes(ei);
                Iterator<String> k = ss.iterator();
                while (k.hasNext()) {
                    ClassInfo si = this.model.classById(k.next());
                    this.xsrvcfg.addJoin(ft, String.valueOf(this.cName(si)) + "/ref(objid:" + col + ")::" + tab, "parent", String.valueOf(xpath) + "/" + ei.qname());
                }
                return ddl.replace("------", String.valueOf(pfx) + "------");
            }
        }
        if (tab.contains("__")) {
            this.xsrvcfg.addValCol(ft, tab, col, xpath, null);
            return ddl.replace("------", String.valueOf(pfx) + "------");
        } else if (tpath) {
            this.xsrvcfg.addValCol(ft, tab, col, xpath, "map_targetpath=true");
            return ddl.replace("------", String.valueOf(pfx) + "------");
        } else {
            this.xsrvcfg.addValCol(ft, tab, col, xpath, null);
        }
        return ddl.replace("------", String.valueOf(pfx) + "------");
    }

    @Override
    public int type() {
        return 8;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        String outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = this.options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = this.options.parameter(".");
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(outputDirectory) + "/" + this.pi.xmlns() + "_ddlCreate.sql"));
            for (String s : this.ddlMapCreate.values()) {
                out.println(s);
            }
            out.close();
            out = new PrintWriter(new FileWriter(String.valueOf(outputDirectory) + "/" + this.pi.xmlns() + "_ddlDrop.sql"));
            for (String s : this.ddlMapDrop.values()) {
                out.println(s);
            }
            out.close();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.xsrvcfg.write(outputDirectory);
        this.printed = true;
    }
}

