/*
 * Decompiled with CFR 0.152.
 */
package us.mitre.ShapeChange.Model.GSIP;

import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import us.mitre.ShapeChange.Model.GSIP.ClassInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.GSIPDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfoGSIP
extends PackageInfoImpl
implements PackageInfo {
    protected GSIPDocument document = null;
    protected PackageInfoGSIP parentPI = null;
    protected PackageInfoGSIP schema = null;
    protected HashSet<PackageInfoGSIP> childPI = new HashSet();
    protected HashSet<ClassInfoGSIP> childCI = new HashSet();
    protected String gsipName = null;
    protected String gsipPackageId = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected String stereotype = null;
    protected boolean isSchema = false;
    protected HashSet<String> supplierIds = new HashSet();

    private PackageInfoGSIP(GSIPDocument doc, PackageInfoGSIP ppi) {
        this.document = doc;
        this.parentPI = ppi;
        if (ppi != null) {
            ppi.childPI.add(this);
        }
    }

    public PackageInfoGSIP(GSIPDocument doc, PackageInfoGSIP ppi, HashMap<String, Object> properties) {
        this(doc, ppi, properties, false);
    }

    public PackageInfoGSIP(GSIPDocument doc, PackageInfoGSIP ppi, HashMap<String, Object> properties, boolean isSchema) {
        this(doc, ppi);
        this.gsipName = (String)properties.get("name");
        this.gsipPackageId = (String)properties.get("itemIdentifier_PK");
        this.isSchema = isSchema;
        if (isSchema) {
            String isAppSchema = (String)properties.get("applicationSchema");
            if (Boolean.parseBoolean(isAppSchema)) {
                properties.put("umlStereotype", "applicationSchema");
            } else {
                String st = this.document.options.normalizeStereotype("");
                if (st != null) {
                    properties.put("umlStereotype", st);
                } else {
                    properties.put("umlStereotype", "");
                }
            }
            this.schema = this;
        } else {
            String schemaInfo = (String)properties.get("schemaIdentifier_FK");
            this.schema = this.document.fPackageById.get(schemaInfo);
        }
        String st = this.document.options.normalizeStereotype((String)properties.get("umlStereotype"));
        if (st != null) {
            for (String s : Options.packageStereotypes) {
                if (!st.toLowerCase().equals(s)) continue;
                this.stereotype = s;
            }
        }
        if (this.stereotype == null) {
            st = this.document.options.normalizeStereotype("");
            this.stereotype = st != null ? st : "";
        }
        String descriptionString = GSIPDocument.getDescriptionString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"));
        String documentation = GSIPDocument.getDocumentationString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"), (String)properties.get("note"));
        properties.remove("description");
        properties.put("description", descriptionString);
        properties.put("documentation", documentation);
        this.setAndValidateTaggedValues(properties);
    }

    @Override
    public HashSet<PackageInfo> containedPackages() {
        return (HashSet)this.childPI.clone();
    }

    @Override
    public PackageInfo owner() {
        return this.parentPI;
    }

    @Override
    public PackageInfo rootPackage() {
        PackageInfoGSIP pi = this;
        while (pi != null && !pi.isSchema()) {
            pi = pi.parentPI;
        }
        return pi;
    }

    @Override
    public HashSet<String> supplierIds() {
        return (HashSet)this.supplierIds.clone();
    }

    @Override
    public String id() {
        return new Integer(this.gsipPackageId).toString();
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public String name() {
        String s = this.gsipName.trim();
        if (s == null || s.equals("")) {
            s = this.id();
            this.document.result.addWarning(null, 100, "package", s);
        }
        return s;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    private void setAndValidateTaggedValues(HashMap<String, Object> tvs) {
        this.taggedValuesCache = new HashMap(5);
        if (tvs != null) {
            for (Map.Entry<String, Object> e : tvs.entrySet()) {
                String t = e.getKey();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = (String)e.getValue();
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    @Override
    public String taggedValue(String tag) {
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }
}

