/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;

public abstract class PackageInfoImpl
extends InfoImpl
implements PackageInfo {
    public String encodingRule(String platform) {
        String s = this.taggedValue(platform + "EncodingRule");
        if (s == null || s.isEmpty()) {
            PackageInfo o = this.owner();
            if (o != null) {
                s = o.encodingRule(platform);
            }
            if (s == null) {
                s = super.encodingRule(platform);
            }
        }
        if (s != null) {
            s = s.toLowerCase();
        }
        return s;
    }

    public String targetNamespace() {
        PackageInfo o;
        String s = this.options().nsOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("targetNamespace");
        if (s == null) {
            s = this.taggedValue("xmlNamespace");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.targetNamespace();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String xmlns() {
        PackageInfo o;
        String s = this.options().nsabrOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("xmlns");
        if (s == null) {
            s = this.taggedValue("xmlNamespaceAbbreviation");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.xmlns();
        }
        if (s != null) {
            s = s.trim();
            s = s.replace(":", "").replace("/", "");
        }
        return s;
    }

    protected String mapPackageNameToFilename(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block3: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString() + ".xsd";
    }

    public String xsdDocument() {
        String s = this.options().xsdOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("xsdDocument");
        if (s == null) {
            s = this.taggedValue("xsdName");
        }
        if (s == null && this.isAppSchema()) {
            s = this.mapPackageNameToFilename(this.name());
            this.result().addWarning(null, 101, this.name(), this.id(), s);
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String gmlProfileSchema() {
        return this.taggedValue("gmlProfileSchema");
    }

    public String version() {
        String s = this.options().versionOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("version");
        PackageInfo o = this.owner();
        if (s == null && o != null) {
            s = o.version();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public boolean isAppSchema() {
        String stereotype = this.stereotype();
        return stereotype != null && stereotype.equals("application schema");
    }

    public boolean isSchema() {
        String s = this.taggedValue("targetNamespace");
        if (s == null) {
            s = this.taggedValue("xmlNamespace");
        }
        if (s != null) {
            return true;
        }
        return this.options().nsOfPackage(this.name()) != null;
    }

    public String schemaId() {
        if (this.isSchema()) {
            return this.id();
        }
        PackageInfo o = this.owner();
        if (o != null) {
            return o.schemaId();
        }
        return "(null)";
    }

    public String fullName() {
        String qualname = null;
        for (PackageInfo pi = this; pi != null; pi = pi.owner()) {
            qualname = qualname == null ? pi.name() : pi.name() + "::" + qualname;
        }
        return qualname;
    }

    public void postprocessAfterLoadingAndValidate() {
        ShapeChangeResult.MessageContext mc;
        String s;
        if (this.postprocessed) {
            return;
        }
        super.postprocessAfterLoadingAndValidate();
        if (this.matches("req-xsd-pkg-targetNamespace")) {
            s = this.taggedValue("targetNamespace");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addError(null, 146, this.name(), "targetNamespace")) != null) {
                    mc.addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme")) {
                mc = this.result().addError(null, 150, this.name(), "targetNamespace", s);
                if (mc != null) {
                    mc.addDetail(null, 400, "Package", this.fullName());
                }
            } else if (this.matches("req-xsd-pkg-namespace-schema-only") && !this.isAppSchema() && (mc = this.result().addError(null, 147, this.name(), "targetNamespace")) != null) {
                mc.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-xsd-pkg-xmlns") && this.isAppSchema()) {
            s = this.taggedValue("xmlns");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addError(null, 146, this.name(), "xmlns")) != null) {
                    mc.addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme")) {
                mc = this.result().addError(null, 150, this.name(), "xmlns", s);
                if (mc != null) {
                    mc.addDetail(null, 400, "Package", this.fullName());
                }
            } else if (this.matches("req-xsd-pkg-namespace-schema-only") && !this.isAppSchema() && (mc = this.result().addError(null, 147, this.name(), "xmlns")) != null) {
                mc.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-xsd-pkg-xsdDocument") && this.isAppSchema()) {
            s = this.taggedValue("xsdDocument");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addError(null, 146, this.name(), "xsdDocument")) != null) {
                    mc.addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme") && (mc = this.result().addError(null, 150, this.name(), "xsdDocument", s)) != null) {
                mc.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("rec-xsd-pkg-version")) {
            s = this.taggedValue("version");
            if (s == null || s.isEmpty()) {
                if (this.isAppSchema() && (mc = this.result().addWarning(null, 146, this.name(), "version")) != null) {
                    mc.addDetail(null, 400, "Package", this.fullName());
                }
            } else if (s.equalsIgnoreCase("fixme") && (mc = this.result().addWarning(null, 150, this.name(), "version", s)) != null) {
                mc.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-all-all-documentation")) {
            s = this.documentation();
            if (!s.contains("-- Name --") && (mc = this.result().addError(null, 151, this.name(), "-- Name --")) != null) {
                mc.addDetail(null, 400, "Package", this.fullName());
            }
            if (!s.contains("-- Definition --") && (mc = this.result().addError(null, 151, this.name(), "-- Definition --")) != null) {
                mc.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if (this.matches("req-xsd-pkg-dependencies")) {
            for (String pid : this.supplierIds()) {
                ShapeChangeResult.MessageContext mc2;
                PackageInfo pi;
                ShapeChangeResult.MessageContext mc3;
                if (!this.isSchema() && (mc3 = this.result().addError(null, 159, this.name())) != null) {
                    mc3.addDetail(null, 400, "Package", this.fullName());
                }
                if ((pi = this.model().packageById(pid)) == null) {
                    mc2 = this.result().addError(null, 161, "Package", pid);
                    if (mc2 == null) continue;
                    mc2.addDetail(null, 400, "Package", this.fullName());
                    continue;
                }
                if (pi.isSchema() || (mc2 = this.result().addError(null, 160, pi.name(), this.name())) == null) continue;
                mc2.addDetail(null, 400, "Package", this.fullName());
            }
        }
        if ((s = this.xsdDocument()) != null && !s.isEmpty() && !s.endsWith(".xsd") && (mc = this.result().addWarning(null, 167, this.xsdDocument())) != null) {
            mc.addDetail(null, 400, "Package", this.fullName());
        }
        this.postprocessed = true;
    }
}

