/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.ModelDiff;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import name.fraser.neil.plaintext.diff_match_patch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Differ {
    private boolean aaaModel = false;
    private diff_match_patch strDiffer = new diff_match_patch();
    private HashSet<ClassInfo> processed = new HashSet();

    public Differ() {
    }

    public Differ(boolean aaa) {
        this.aaaModel = true;
    }

    private void merge(HashMap<Info, HashSet<DiffElement>> diffs, HashMap<Info, HashSet<DiffElement>> diffs2) {
        for (Map.Entry<Info, HashSet<DiffElement>> me : diffs2.entrySet()) {
            if (diffs.containsKey(me.getKey())) {
                diffs.get(me.getKey()).addAll((Collection<DiffElement>)me.getValue());
                continue;
            }
            diffs.put(me.getKey(), me.getValue());
        }
    }

    public HashMap<Info, HashSet<DiffElement>> diff(PackageInfo curr, PackageInfo ref) {
        HashMap<Info, HashSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        HashSet<PackageInfo> sub = curr.containedPackages();
        Info[] infoArr = new Info[sub.size()];
        sub.toArray(infoArr);
        HashSet<PackageInfo> subRef = ref.containedPackages();
        Info[] infoArrRef = new Info[subRef.size()];
        subRef.toArray(infoArrRef);
        HashMap<Info, HashSet<DiffElement>> diffs2 = this.infoDiffs(curr, DiffElement.ElementType.SUBPACKAGE, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        for (Map.Entry<Info, HashSet<DiffElement>> me : diffs2.entrySet()) {
            if (diffs.containsKey(me.getKey())) {
                diffs.get(me.getKey()).addAll((Collection<DiffElement>)me.getValue());
                continue;
            }
            diffs.put(me.getKey(), me.getValue());
        }
        HashSet<ClassInfo> temp = curr.model().classes(curr);
        HashSet<ClassInfo> cls = new HashSet<ClassInfo>();
        for (ClassInfo ci : temp) {
            if (ci.pkg() != curr) continue;
            cls.add(ci);
        }
        infoArr = new Info[cls.size()];
        cls.toArray(infoArr);
        temp = ref.model().classes(ref);
        HashSet<ClassInfo> clsRef = new HashSet<ClassInfo>();
        for (ClassInfo ci : temp) {
            if (ci.pkg() != ref) continue;
            clsRef.add(ci);
        }
        infoArrRef = new Info[clsRef.size()];
        clsRef.toArray(infoArrRef);
        diffs2 = this.infoDiffs(curr, DiffElement.ElementType.CLASS, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        return diffs;
    }

    public HashMap<Info, HashSet<DiffElement>> diff(ClassInfo curr, ClassInfo ref) {
        if (this.processed.contains(curr)) {
            return new HashMap<Info, HashSet<DiffElement>>();
        }
        HashMap<Info, HashSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        Collection<PropertyInfo> prop = curr.properties().values();
        Info[] infoArr = new Info[prop.size()];
        prop.toArray(infoArr);
        Collection<PropertyInfo> propRef = ref.properties().values();
        Info[] infoArrRef = new Info[propRef.size()];
        propRef.toArray(infoArrRef);
        HashMap<Info, HashSet<DiffElement>> diffs2 = curr.category() == 3 || curr.category() == 2 ? this.infoDiffs(curr, DiffElement.ElementType.ENUM, infoArr, infoArrRef) : this.infoDiffs(curr, DiffElement.ElementType.PROPERTY, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        HashSet<String> cls = curr.supertypes();
        infoArr = new Info[cls.size()];
        int i = 0;
        for (String id : cls) {
            infoArr[i++] = curr.model().classById(id);
        }
        HashSet<String> clsRef = ref.supertypes();
        infoArrRef = new Info[clsRef.size()];
        i = 0;
        for (String id : clsRef) {
            infoArrRef[i++] = ref.model().classById(id);
        }
        diffs2 = this.infoDiffs(curr, DiffElement.ElementType.SUPERTYPE, infoArr, infoArrRef);
        this.merge(diffs, diffs2);
        this.processed.add(curr);
        return diffs;
    }

    public HashMap<Info, HashSet<DiffElement>> diff(PropertyInfo curr, PropertyInfo ref) {
        HashMap<Info, HashSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        DiffElement diff = this.stringDiff(DiffElement.ElementType.MULTIPLICITY, ref.cardinality().toString(), curr.cardinality().toString());
        if (diff != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            diffs.get(curr).add(diff);
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.VALUETYPE, ref.typeInfo().name, curr.typeInfo().name)) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            diffs.get(curr).add(diff);
        }
        return diffs;
    }

    public HashMap<Info, HashSet<DiffElement>> diffEnum(PropertyInfo curr, PropertyInfo ref) {
        HashMap<Info, HashSet<DiffElement>> diffs = this.baseDiff(curr, ref);
        return diffs;
    }

    protected LinkedList<diff_match_patch.Diff> aaaDocumentation(String ref, String curr) {
        boolean found;
        String[] sa = curr.split("-==-");
        String[] saRef = ref.split("-==-");
        LinkedList<diff_match_patch.Diff> strdiffs = this.strDiffer.diff_main(saRef[0], sa[0]);
        boolean heading = false;
        boolean first = true;
        String sRef = null;
        String head = null;
        for (String s1 : sa) {
            if (heading) {
                head = s1;
                found = false;
                for (String s2 : saRef) {
                    if (found) {
                        sRef = s2;
                        break;
                    }
                    if (!s1.equals(s2)) continue;
                    found = true;
                }
            } else if (sRef != null) {
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.EQUAL, "-==-" + head + "-==-"));
                strdiffs.addAll(this.strDiffer.diff_main(sRef, s1));
                sRef = null;
            } else if (!first && !s1.isEmpty()) {
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.EQUAL, "-==-" + head + "-==-"));
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.INSERT, s1));
            }
            heading = !heading;
            first = false;
        }
        heading = false;
        first = true;
        sRef = null;
        head = null;
        for (String s2 : saRef) {
            if (heading) {
                head = s2;
                found = false;
                sRef = null;
                for (String s1 : sa) {
                    if (found) {
                        sRef = s2;
                        break;
                    }
                    if (!s1.equals(s2)) continue;
                    found = true;
                }
            } else if (!first && sRef == null && !s2.isEmpty()) {
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.EQUAL, "-==-" + head + "-==-"));
                strdiffs.add(new diff_match_patch.Diff(diff_match_patch.Operation.DELETE, s2));
            }
            heading = !heading;
            first = false;
        }
        return strdiffs;
    }

    protected DiffElement stringDiff(DiffElement.ElementType type, String ref, String curr) {
        LinkedList<diff_match_patch.Diff> strdiffs = this.aaaModel && type == DiffElement.ElementType.DOCUMENTATION ? this.aaaDocumentation(ref, curr) : this.strDiffer.diff_main(ref, curr);
        this.strDiffer.diff_cleanupEfficiency(strdiffs);
        if (this.strDiffer.diff_levenshtein(strdiffs) == 0) {
            return null;
        }
        DiffElement diff = new DiffElement();
        diff.change = DiffElement.Operation.CHANGE;
        diff.subElementType = type;
        diff.diff = strdiffs;
        return diff;
    }

    protected HashMap<Info, HashSet<DiffElement>> infoDiffs(Info base, DiffElement.ElementType type, Info[] currs, Info[] refs) {
        DiffElement diff;
        String s2;
        String s1;
        boolean eq;
        boolean found;
        HashMap<Info, HashSet<DiffElement>> diffs = new HashMap<Info, HashSet<DiffElement>>();
        for (Info i : currs) {
            found = false;
            for (Info iRef : refs) {
                eq = i.name().equalsIgnoreCase(iRef.name());
                if (type == DiffElement.ElementType.ENUM) {
                    s1 = ((PropertyInfo)i).initialValue();
                    s2 = ((PropertyInfo)iRef).initialValue();
                    if (s1 != null && s2 != null) {
                        eq = s1.equalsIgnoreCase(s2);
                    }
                }
                if (!eq) continue;
                switch (type) {
                    case SUBPACKAGE: {
                        HashMap<Info, HashSet<DiffElement>> diffs2 = this.diff((PackageInfo)i, (PackageInfo)iRef);
                        this.merge(diffs, diffs2);
                        break;
                    }
                    case CLASS: {
                        HashMap<Info, HashSet<DiffElement>> diffs2 = this.diff((ClassInfo)i, (ClassInfo)iRef);
                        this.merge(diffs, diffs2);
                        break;
                    }
                    case PROPERTY: {
                        HashMap<Info, HashSet<DiffElement>> diffs2 = this.diff((PropertyInfo)i, (PropertyInfo)iRef);
                        this.merge(diffs, diffs2);
                        break;
                    }
                    case ENUM: {
                        HashMap<Info, HashSet<DiffElement>> diffs2 = this.diffEnum((PropertyInfo)i, (PropertyInfo)iRef);
                        this.merge(diffs, diffs2);
                    }
                }
                found = true;
                break;
            }
            if (found) continue;
            diff = new DiffElement();
            diff.change = DiffElement.Operation.INSERT;
            diff.subElementType = type;
            diff.subElement = i;
            if (!diffs.containsKey(base)) {
                diffs.put(base, new HashSet());
            }
            diffs.get(base).add(diff);
        }
        for (Info iRef : refs) {
            found = false;
            for (Info i : currs) {
                eq = i.name().equalsIgnoreCase(iRef.name());
                if (type == DiffElement.ElementType.ENUM) {
                    s1 = ((PropertyInfo)i).initialValue();
                    s2 = ((PropertyInfo)iRef).initialValue();
                    if (s1 != null && s2 != null) {
                        eq = s1.equalsIgnoreCase(s2);
                    }
                }
                if (!eq) continue;
                found = true;
                break;
            }
            if (found) continue;
            diff = new DiffElement();
            diff.change = DiffElement.Operation.DELETE;
            diff.subElementType = type;
            diff.subElement = iRef;
            if (!diffs.containsKey(base)) {
                diffs.put(base, new HashSet());
            }
            diffs.get(base).add(diff);
        }
        return diffs;
    }

    private String addConstraints(ClassInfo ci, String doc) {
        for (Constraint ocl : ci.constraints()) {
            String[] sa;
            if (!ocl.contextModelElmt().id().equals(ci.id())) continue;
            doc = doc + "\n\n-==- Konsistenzbedingung ";
            if (!ocl.name().equalsIgnoreCase("alle")) {
                doc = doc + ocl.name() + " ";
            }
            doc = doc + "-==-\n";
            for (String sc : sa = ocl.text().split("/\\*")) {
                if ((sc = sc.trim()).isEmpty()) continue;
                if (sc.contains("*/")) {
                    sc = sc.replaceAll("\\*/.*", "");
                    sc = sc.trim();
                }
                doc = doc + "\n" + sc;
            }
        }
        return doc;
    }

    public HashMap<Info, HashSet<DiffElement>> baseDiff(Info curr, Info ref) {
        String key;
        DiffElement diff;
        HashMap<Info, HashSet<DiffElement>> diffs = new HashMap<Info, HashSet<DiffElement>>();
        if (this.aaaModel && curr instanceof ClassInfo) {
            String currdoc = this.addConstraints((ClassInfo)curr, curr.documentation());
            String refdoc = this.addConstraints((ClassInfo)ref, ref.documentation());
            diff = this.stringDiff(DiffElement.ElementType.DOCUMENTATION, refdoc, currdoc);
        } else {
            diff = this.stringDiff(DiffElement.ElementType.DOCUMENTATION, ref.documentation(), curr.documentation());
        }
        if (diff != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            ((HashSet)diffs.get(curr)).add(diff);
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.NAME, ref.name(), curr.name())) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            ((HashSet)diffs.get(curr)).add(diff);
        }
        if ((diff = this.stringDiff(DiffElement.ElementType.STEREOTYPE, ref.stereotype(), curr.stereotype())) != null) {
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            ((HashSet)diffs.get(curr)).add(diff);
        }
        String taglist = curr.options().parameter("representTaggedValues");
        HashMap<String, String> taggedValues = curr.taggedValues(taglist);
        HashMap<String, String> taggedValuesRef = curr.taggedValues(taglist);
        for (Map.Entry<String, String> entry : taggedValues.entrySet()) {
            key = entry.getKey();
            String val = entry.getValue();
            diff = taggedValuesRef.containsKey(key) ? this.stringDiff(DiffElement.ElementType.TAG, taggedValuesRef.get(key), val) : this.stringDiff(DiffElement.ElementType.TAG, "", val);
            if (diff == null) continue;
            diff.tag = key;
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            diffs.get(curr).add(diff);
        }
        for (Map.Entry<String, String> entry : taggedValuesRef.entrySet()) {
            key = entry.getKey();
            if (taggedValues.containsKey(key) || (diff = this.stringDiff(DiffElement.ElementType.TAG, entry.getValue(), "")) == null) continue;
            diff.tag = key;
            if (!diffs.containsKey(curr)) {
                diffs.put(curr, new HashSet());
            }
            diffs.get(curr).add(diff);
        }
        return diffs;
    }

    public String diff_toString(LinkedList<diff_match_patch.Diff> diffs) {
        StringBuilder res = new StringBuilder();
        for (diff_match_patch.Diff aDiff : diffs) {
            String text = aDiff.text;
            switch (aDiff.operation) {
                case INSERT: {
                    res.append("[[ins]]").append(text).append("[[/ins]]");
                    break;
                }
                case DELETE: {
                    res.append("[[del]]").append(text).append("[[/del]]");
                    break;
                }
                case EQUAL: {
                    res.append(text);
                }
            }
        }
        return res.toString();
    }
}

