/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.nastool;

import de.interactive_instruments.ShapeChange.Model.Transformer;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.File;
import java.util.HashMap;
import org.sparx.Attribute;
import org.sparx.AttributeTag;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;
import org.sparx.RoleTag;
import org.sparx.TaggedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NasTransformer
implements Transformer {
    private Repository rep = null;
    private ShapeChangeResult result = null;
    private HashMap<String, Package> allPackages = new HashMap();
    private HashMap<String, Element> allClasses = new HashMap();
    private HashMap<String, Element> aaaClasses = new HashMap();
    private int SeqNo = 32000;
    private String aaaVersion = "unbekannt";
    private String path = null;

    public void initialise(Options o, ShapeChangeResult r, String repositoryFileName) throws ShapeChangeAbortException {
        this.result = r;
        File repfile = new File(repositoryFileName);
        boolean ex = true;
        if (!repfile.exists()) {
            ex = false;
            if (!repositoryFileName.toLowerCase().endsWith(".eap")) {
                repositoryFileName = repositoryFileName + ".eap";
                repfile = new File(repositoryFileName);
                ex = repfile.exists();
            }
        }
        if (!ex) {
            r.addFatalError(null, 31, repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        String absname = repfile.getAbsolutePath();
        this.rep = new Repository();
        if (!this.rep.OpenFile(absname)) {
            String errormsg = this.rep.GetLastError();
            r.addFatalError(null, 30, errormsg, repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        this.path = o.parameter("transformerTargetPath");
    }

    public void shutdown() {
        this.rep.CloseFile();
        this.rep.Exit();
        this.rep = null;
    }

    public void transform() throws ShapeChangeAbortException {
        this.prepareModel();
        if (!this.aaaVersion.startsWith("6.0")) {
            this.result.addFatalError("Das AAA-Anwendungsschema ist von der falschen Version. Erwartet wurde die Version 6.0, gefunden wurde die Version " + this.aaaVersion);
            throw new ShapeChangeAbortException();
        }
        this.moveClass("CharacterString", "ISO/TC 211");
        this.moveClass("Measure", "ISO/TC 211");
        this.moveClass("CV_DiscretePointCoverage", "ISO/TC 211");
        this.setStereotypeClass("CV_DiscretePointCoverage", "featureType");
        this.moveClass("CV_DiscreteGridPointCoverage", "ISO/TC 211");
        this.setStereotypeClass("CV_DiscreteGridPointCoverage", "featureType");
        this.deletePackage("AAA_Katalog");
        this.deletePackage("AAA Versionierungsschema");
        this.deletePackage("ISO 19103 Conceptual Schema Language");
        this.deletePackage("ISO 19107 Spatial Schema");
        this.deletePackage("ISO 19108 Temporal");
        this.deletePackage("ISO 19109 Rules for Application Schema");
        this.deletePackage("ISO 19110 Feature Cataloging");
        this.deletePackage("ISO 19111 Spatial Referencing by Coordinates");
        this.deletePackage("ISO 19115 Metadata");
        this.deletePackage("ISO 19123 Coverages");
        this.deletePackage("ISO 19136 GML");
        this.deletePackage("Spatial Examples from ISO 19107");
        this.deleteClass("AA_ObjektOhneRaumbezug");
        this.deleteClass("AA_Liniengeometrie");
        this.deleteClass("AA_Flaechengeometrie");
        this.deleteClass("AU_Geometrie");
        this.deleteClass("AG_Geometrie");
        this.deleteClass("AA_Punktgeometrie");
        this.deleteClass("AU_Geometrie_3D");
        this.deleteClass("AA_Punktgeometrie_3D");
        this.deleteClass("AA_MehrfachLinienGeometrie_3D");
        this.deleteClass("AA_MehrfachFlaechenGeometrie_3D");
        this.deleteClass("AA_PunktLinienThema");
        this.deleteClass("TA_TopologieThema_3D");
        this.addAttribute("TA_PointComponent", "position", "GM_Point");
        this.addAttribute("TA_PointComponent_3D", "position", "GM_Point");
        this.addAttribute("TA_CurveComponent", "position", "GM_Curve");
        this.addAttribute("TA_CurveComponent_3D", "position", "GM_Curve");
        this.addAttribute("TA_SurfaceComponent", "position", "GM_Surface");
        this.addAttribute("TA_SurfaceComponent_3D", "position", "GM_Surface");
        this.addAttribute("TA_MultiSurfaceComponent", "position", "GM_Object");
        this.addAttribute("TA_CompositeSolidComponent_3D", "position", "GM_CompositeSolid");
        this.deleteAttribute("AA_Objekt", "identifikator");
        this.changeType("AU_Punkthaufenobjekt", "position", "GM_MultiPoint");
        this.changeType("AU_KontinuierlichesLinienobjekt", "position", "GM_Curve");
        this.changeType("AU_Flaechenobjekt", "position", "GM_Object");
        this.changeType("AG_Flaechenobjekt", "position", "GM_Object");
        this.changeType("AG_Punktobjekt", "position", "GM_Point");
        this.changeType("AU_Objekt", "position", "GM_Object");
        this.changeType("AG_Objekt", "position", "GM_Object");
        this.changeType("AU_GeometrieObjekt_3D", "position", "GM_Object");
        this.changeType("AU_MehrfachLinienObjekt_3D", "position", "GM_Object");
        this.changeType("AU_MehrfachFlaechenObjekt_3D", "position", "GM_Object");
        this.changeType("AU_UmringObjekt_3D", "position", "GM_MultiCurve");
        this.changeType("AU_PunkthaufenObjekt_3D", "position", "GM_MultiPoint");
        this.deleteClass("AX_LI_Lineage_OhneDatenerhebung");
        this.deleteClass("AX_LI_Lineage_MitDatenerhebung");
        this.deleteClass("AX_LI_Lineage_Punktort");
        this.deleteClass("AX_LI_ProcessStep_OhneDatenerhebung");
        this.deleteClass("AX_LI_ProcessStep_MitDatenerhebung");
        this.deleteClass("AX_LI_ProcessStep_Punktort");
        this.deleteClass("AX_LI_Source_MitDatenerhebung");
        this.deleteClass("AX_LI_Source_Punktort");
        this.changeType("AX_DQOhneDatenerhebung", "herkunft", "LI_Lineage");
        this.changeType("AX_DQMitDatenerhebung", "herkunft", "LI_Lineage");
        this.changeType("AX_DQPunktort", "herkunft", "LI_Lineage");
        this.deleteClass("AX_Fortfuehrung");
        this.deleteClass("AX_Datenbank");
        this.deleteClass("AX_Operation_Datenbank");
        this.deleteClass("AX_TemporaererBereich");
        this.deleteClass("AX_NeuesObjekt");
        this.deleteClass("AX_GeloeschtesObjekt");
        this.deleteClass("AX_AktualisiertesObjekt");
        this.deleteClass("AX_Fortfuehrungsobjekt");
        this.deleteRole("AA_Objekt", "antrag");
        this.deleteRole("TA_MultiSurfaceComponent", "masche");
        this.deleteRole("TA_CompositeSolidComponent_3D", "koerper");
        this.addAttribute("AA_Antrag", "art", "GenericName");
        this.addAttribute("AA_Projektsteuerung", "art", "GenericName");
        this.addAttribute("AA_Vorgang", "art", "GenericName");
        this.addAttribute("AA_Aktivitaet", "art", "GenericName");
        this.deleteClass("AA_Antragsart");
        this.deleteClass("AA_Projektsteuerungsart");
        this.deleteClass("AA_Vorgangsart");
        this.deleteClass("AA_Aktivitaetsart");
        this.deleteClass("AA_Projektsteuerungskatalog");
        this.deleteClass("AA_AktivitaetInVorgang");
        this.deleteClass("AA_VorgangInProzess");
        this.deleteClass("AA_Dokumentationsbedarf");
        this.deleteClass("AA_DurchfuehrungAktivitaet");
        this.deleteClass("AA_ProzesszuordnungAktivitaet");
        this.deleteAttribute("AA_PMO", "ausdehnung");
        this.deleteAttribute("AD_PunktCoverage", "geometrie");
        this.deleteAttribute("AD_PunktCoverage", "werte");
        this.deleteClass("AD_ReferenzierbaresGitter");
        this.deleteClass("AD_Wertematrix");
        this.changeType("DCP", "HTTP", "URI");
        this.changeType("DCP", "email", "URI");
        this.changeType("AX_Schwereanomalie_Schwere", "wert", "Measure");
        this.deleteClass("Acceleration");
        this.deleteClass("AA_UUID");
        this.changeType("ExceptionFortfuehrung", "bereitsGesperrteObjekte", "URI");
        this.changeType("ExceptionFortfuehrung", "nichtMehrAktuelleObjekte", "URI");
        this.changeType("AX_Sperrauftrag", "uuidListe", "URI");
        this.changeType("AX_Entsperrauftrag", "uuidListe", "URI");
        this.changeType("ExceptionAAAEntsperren", "uuidListe", "URI");
        this.changeType("ExceptionAAAFortfuehrungOderSperrung", "bereitsGesperrteObjekte", "URI");
        this.changeType("ExceptionAAAFortfuehrungOderSperrung", "nichtMehrAktuelleObjekte", "URI");
        for (Element e : this.aaaClasses.values()) {
            String n = e.GetName();
            String st = e.GetStereotype().toLowerCase();
            if (st.equals("enumeration") && (n.startsWith("AX_LI") || n.startsWith("AX_DQ"))) {
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "xsdEncodingRule", "iso19139_2007");
            } else if (n.equals("AX_Datenerhebung") || n.equals("AX_Datenerhebung_Punktort")) {
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "xsdEncodingRule", "iso19139_2007");
            } else {
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "xsdEncodingRule", "iso19136_2007");
            }
            if (st.equals("featuretype")) {
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "noPropertyType", "true");
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "byValuePropertyType", "false");
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "isCollection", "false");
            } else if (st.equals("datatype") || st.equals("union")) {
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "noPropertyType", "false");
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "byValuePropertyType", "false");
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "isCollection", "false");
            } else if (st.equals("codelist")) {
                this.setTaggedValue((Collection<TaggedValue>)e.GetTaggedValues(), "asDictionary", "true");
            }
            this.deleteMethods(e);
            boolean cont = true;
            Collection c = e.GetConnectors();
            block1: while (cont) {
                cont = false;
                for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                    ConnectorEnd ei2;
                    ConnectorEnd ei1;
                    Element e2;
                    Connector ei = (Connector)c.GetAt(i);
                    String s = ei.GetType();
                    if (!s.equals("Association") && !s.equals("Aggregation")) continue;
                    if (ei.GetClientID() == 0 || ei.GetSupplierID() == 0) {
                        c.Delete(i);
                        if (!e.Update()) {
                            this.result.addError("Fehler beim L\u00f6schen von h\u00e4ngender Relation in '" + e.GetName() + "': " + e.GetLastError());
                        } else {
                            this.result.addDebug("H\u00e4ngende Relation in '" + e.GetName() + "' gel\u00f6scht.");
                        }
                        c.Refresh();
                        cont = true;
                        continue block1;
                    }
                    if (ei.GetClientID() == e.GetElementID()) {
                        if (ei.GetSupplierID() == e.GetElementID()) {
                            e2 = e;
                            if (ei.GetSupplierEnd().GetNavigable().equals("Navigable")) {
                                ei1 = ei.GetSupplierEnd();
                                ei2 = ei.GetClientEnd();
                            } else {
                                ei1 = ei.GetClientEnd();
                                ei2 = ei.GetSupplierEnd();
                            }
                        } else {
                            e2 = this.rep.GetElementByID(ei.GetSupplierID());
                            ei1 = ei.GetClientEnd();
                            ei2 = ei.GetSupplierEnd();
                        }
                    } else {
                        e2 = this.rep.GetElementByID(ei.GetClientID());
                        ei1 = ei.GetSupplierEnd();
                        ei2 = ei.GetClientEnd();
                    }
                    s = e2.GetStereotype().toLowerCase();
                    if (!s.equals("featuretype") && !s.equals("") && !s.equals("type")) continue;
                    this.setTaggedValueRole((Collection<RoleTag>)ei2.GetTaggedValues(), "inlineOrByReference", "byReference", true);
                    if (ei2.GetNavigable().equals("Navigable")) continue;
                    this.setTaggedValueRole((Collection<RoleTag>)ei2.GetTaggedValues(), "reverseRoleNAS", "true", true);
                    String mul = ei2.GetCardinality();
                    if (mul.contains("1..")) {
                        mul = mul.replace("1..", "0..");
                    } else if (mul.contains("2..")) {
                        mul = mul.replace("2..", "0..");
                    } else if (!mul.contains("..")) {
                        mul = "0.." + mul;
                    } else if (!mul.contains("0..")) {
                        this.result.addError("Fehler beim Aktualisieren von inverser Rolle in '" + e.GetName() + "' zu '" + e2.GetName() + "': Multiplizit\u00e4t '" + mul + "' nicht erkannt.");
                    }
                    ei2.SetCardinality(mul);
                    ei2.SetNavigable("Navigable");
                    if (ei2.GetRole().equals("")) {
                        ei2.SetRole("inversZu_" + ei1.GetRole());
                        this.setTaggedValueRole((Collection<RoleTag>)ei2.GetTaggedValues(), "sequenceNumber", new Integer(this.SeqNo++).toString(), false);
                        ei2.GetTaggedValues().Refresh();
                    }
                    if (!ei2.Update()) {
                        this.result.addError("Fehler beim Aktualisieren von inverser Rolle in '" + e.GetName() + "' zu '" + e2.GetName() + "': " + ei2.GetLastError());
                    } else {
                        this.result.addDebug("Inverse Rolle in '" + e.GetName() + "' zu '" + e2.GetName() + "' aktualisiert.");
                    }
                    e.GetConnectors().Refresh();
                }
            }
        }
        for (Element e : this.aaaClasses.values()) {
            String st = e.GetStereotype().toLowerCase();
            if (!st.equals("type")) continue;
            this.copyDown(e);
        }
        this.deleteClass("AP_GPO");
        this.deleteClass("AP_TPO");
        this.deleteClass("AX_Katalogeintrag");
        this.deleteClass("AX_BauwerkeEinrichtungenUndSonstigeAngaben");
        this.deleteClass("AX_Punktort");
        this.deleteClass("AX_Flurstueck_Kerndaten");
        this.deleteClass("AA_Objektliste");
        this.deleteClass("AX_Auftrag");
        this.deleteClass("AX_Ergebnis");
        this.deleteClass("AX_AuftragEinrichtungOderFortfuerung");
        Element e1 = this.aaaClasses.get("AA_Objekt");
        if (e1 == null) {
            this.result.addError("Klasse 'AA_Objekt' nicht gefunden");
        } else {
            Element e2 = this.aaaClasses.get("AA_PMO");
            if (e2 == null) {
                this.result.addError("Klasse 'AA_PMO' nicht gefunden");
            } else {
                Element e3 = this.aaaClasses.get("AD_PunktCoverage");
                if (e3 == null) {
                    this.result.addError("Klasse 'AD_PunktCoverage' nicht gefunden");
                } else {
                    Element e4 = this.aaaClasses.get("AD_GitterCoverage");
                    if (e4 == null) {
                        this.result.addError("Klasse 'AD_GitterCoverage' nicht gefunden");
                    } else {
                        for (Attribute a : e1.GetAttributes()) {
                            this.cloneAttribute(a, e3);
                            this.cloneAttribute(a, e4);
                        }
                        for (Attribute a : e2.GetAttributes()) {
                            this.cloneAttribute(a, e3);
                            this.cloneAttribute(a, e4);
                        }
                        this.addGeneralization(e3, this.allClasses.get("CV_DiscretePointCoverage"));
                        this.addGeneralization(e4, this.allClasses.get("CV_DiscreteGridPointCoverage"));
                    }
                }
            }
        }
        this.deleteClass("AA_PMO");
        this.changeTypeAndMultiplicity("AA_Objekt", "modellart", "AA_Modellart", "1", "*");
        this.changeTypeAndMultiplicity("AA_Objekt", "anlass", "AA_Anlassart", "0", "2");
        this.changeTypeAndMultiplicity("AA_Objekt", "zeigtAufExternes", "AA_Fachdatenverbindung", "0", "*");
        this.changeTypeAndMultiplicity("AD_PunktCoverage", "modellart", "AA_Modellart", "1", "*");
        this.changeTypeAndMultiplicity("AD_PunktCoverage", "anlass", "AA_Anlassart", "0", "2");
        this.changeTypeAndMultiplicity("AD_PunktCoverage", "zeigtAufExternes", "AA_Fachdatenverbindung", "0", "*");
        this.changeTypeAndMultiplicity("AD_GitterCoverage", "modellart", "AA_Modellart", "1", "*");
        this.changeTypeAndMultiplicity("AD_GitterCoverage", "anlass", "AA_Anlassart", "0", "2");
        this.changeTypeAndMultiplicity("AD_GitterCoverage", "zeigtAufExternes", "AA_Fachdatenverbindung", "0", "*");
        this.changeType("AX_Phasenzentrumsvariation_Referenzstationspunkt", "zeile", "doubleList");
        this.deleteClass("AX_Phasenzentrumsvariation_Referenzstationspunkt_Zeile");
        if (this.path != null && this.path.length() > 0) {
            this.schemaLocationOfPackage("Web Feature Service Erweiterungen", this.path);
            this.schemaLocationOfPackage("OWS Common", "http://schemas.opengis.net/");
            this.schemaLocationOfPackage("Web Feature Service", this.path);
            this.schemaLocationOfPackage("Web Feature Service Capabilities", this.path);
            this.schemaLocationOfPackage("Filter Encoding Capabilities", this.path);
        }
    }

    private void addGeneralization(Element e1, Element e2) {
        if (e1 != null && e2 != null) {
            e1.GetConnectors().Refresh();
            Connector r = (Connector)e1.GetConnectors().AddNew("", "Generalization");
            if (r == null) {
                this.result.addError("Fehler beim Erzeugen der Generalisierung '" + e1.GetName() + "'-'" + e2.GetName() + "'");
            } else {
                r.SetSupplierID(e2.GetElementID());
                this.result.addDebug("Generalisierung '" + e1.GetName() + "'-'" + e2.GetName() + "' erzeugt");
                if (!r.Update()) {
                    this.result.addError("Fehler bei Erzeugung der Generalisierung '" + e1.GetName() + "'-'" + e2.GetName() + "': " + r.GetLastError());
                }
            }
        }
    }

    private void copyDown(Element e) {
        this.copyDown(e, e);
    }

    private void copyDown(Element e0, Element e) {
        for (Connector r : e.GetConnectors()) {
            Element e2;
            if (!r.GetType().equals("Generalization") || r.GetSupplierID() != e.GetElementID() || (e2 = this.rep.GetElementByID(r.GetClientID())) == null) continue;
            String st = e2.GetStereotype().toLowerCase();
            if (st.equals("type")) {
                this.copyDown(e0, e2);
                continue;
            }
            for (Attribute a : e0.GetAttributes()) {
                this.cloneAttribute(a, e2);
            }
            for (Connector r2 : e0.GetConnectors()) {
                String rt = r2.GetType();
                if (!rt.equals("Association") && !rt.equals("Aggregation")) continue;
                this.cloneAssociation(r2, e0, e2);
            }
        }
    }

    private void cloneAttribute(Attribute a, Element e) {
        String s = a.GetName();
        String s2 = e.GetName();
        Attribute a2 = (Attribute)e.GetAttributes().AddNew(a.GetName(), a.GetType());
        if (!e.Update()) {
            this.result.addError("Fehler beim Clonen von Attribut '" + a.GetName() + "': " + e.GetLastError());
        } else {
            this.result.addDebug("Attribut '" + s + "' geclont (Zielklasse '" + s2 + "').");
        }
        e.GetAttributes().Refresh();
        a2.SetLowerBound(a.GetLowerBound());
        a2.SetUpperBound(a.GetUpperBound());
        a2.SetNotes(a.GetNotes());
        a2.SetStereotype(a.GetStereotype());
        if (!a2.Update()) {
            this.result.addError("Fehler beim Clonen von Attribut '" + s + "': " + a2.GetLastError());
        }
        for (AttributeTag tv : a.GetTaggedValues()) {
            AttributeTag tv2 = (AttributeTag)a2.GetTaggedValues().AddNew(tv.GetName(), tv.GetValue());
            if (!tv2.Update()) {
                this.result.addError("Fehler beim Clonen von Attribut '" + s + "': " + tv.GetLastError());
            }
            a2.GetTaggedValues().Refresh();
        }
    }

    private void cloneAssociation(Connector r1, Element e1, Element e2) {
        RoleTag tv2;
        Connector r2;
        Element e3;
        if (r1.GetClientID() == e1.GetElementID()) {
            e3 = this.rep.GetElementByID(r1.GetSupplierID());
            e2.GetConnectors().Refresh();
            r2 = (Connector)e2.GetConnectors().AddNew("", r1.GetType());
            if (r2 == null) {
                this.result.addError("Fehler beim Clonen von Relation '" + e1.GetName() + "'/'" + e2.GetName() + "'-'" + e3.GetName() + "'");
                return;
            }
            r2.SetSupplierID(e3.GetElementID());
        } else {
            e3 = this.rep.GetElementByID(r1.GetClientID());
            e3.GetConnectors().Refresh();
            r2 = (Connector)e3.GetConnectors().AddNew("", r1.GetType());
            if (r2 == null) {
                this.result.addError("Fehler beim Clonen von Relation '" + e1.GetName() + "'/'" + e2.GetName() + "'-'" + e3.GetName() + "'");
                return;
            }
            r2.SetSupplierID(e2.GetElementID());
        }
        r2.SetDirection("Bi-Directional");
        ConnectorEnd r1c = r1.GetClientEnd();
        ConnectorEnd r1s = r1.GetSupplierEnd();
        ConnectorEnd r2c = r2.GetClientEnd();
        ConnectorEnd r2s = r2.GetSupplierEnd();
        r2c.SetIsNavigable(r1c.GetIsNavigable());
        String s = r1c.GetCardinality();
        if (s.startsWith("1")) {
            s = "0" + s.substring(1);
        }
        r2c.SetCardinality(s);
        r2c.SetRoleNote(r1c.GetRoleNote());
        r2c.SetStereotype(r1c.GetStereotype());
        if (r1.GetClientID() == e1.GetElementID()) {
            r2c.SetRole(r1c.GetRole() + "_" + e2.GetName());
        } else {
            r2c.SetRole(r1c.GetRole());
        }
        r2s.SetIsNavigable(r1s.GetIsNavigable());
        s = r1s.GetCardinality();
        if (s.startsWith("1")) {
            s = "0" + s.substring(1);
        }
        r2s.SetCardinality(s);
        if (r1.GetClientID() == e1.GetElementID()) {
            r2s.SetRole(r1s.GetRole());
        } else {
            r2s.SetRole(r1s.GetRole() + "_" + e2.GetName());
        }
        r2s.SetRoleNote(r1s.GetRoleNote());
        r2s.SetStereotype(r1s.GetStereotype());
        this.result.addDebug("Relation '" + e1.GetName() + "'/'" + e2.GetName() + "'-'" + e3.GetName() + "' geclont");
        if (!r2.Update()) {
            this.result.addError("Fehler beim Clonen von Relation '" + e1.GetName() + "'/'" + e2.GetName() + "'-'" + e3.GetName() + "': " + r2.GetLastError());
        }
        for (RoleTag tv : r1c.GetTaggedValues()) {
            tv2 = (RoleTag)r2c.GetTaggedValues().AddNew(tv.GetTag(), tv.GetValue());
            if (!tv2.Update()) {
                this.result.addError("Fehler beim Clonen von Relation '" + e1.GetName() + "'/'" + e2.GetName() + "'-'" + e3.GetName() + "': " + tv.GetLastError());
            }
            r2c.GetTaggedValues().Refresh();
        }
        for (RoleTag tv : r1s.GetTaggedValues()) {
            tv2 = (RoleTag)r2s.GetTaggedValues().AddNew(tv.GetTag(), tv.GetValue());
            if (!tv2.Update()) {
                this.result.addError("Fehler beim Clonen von Relation '" + e1.GetName() + "'/'" + e2.GetName() + "'-'" + e3.GetName() + "': " + tv.GetLastError());
            }
            r2s.GetTaggedValues().Refresh();
        }
        if (r1.GetClientID() == e1.GetElementID()) {
            this.setTaggedValueRole((Collection<RoleTag>)r2c.GetTaggedValues(), "sequenceNumber", new Integer(this.SeqNo++).toString(), true);
            this.setTaggedValueRole((Collection<RoleTag>)r2s.GetTaggedValues(), "sequenceNumber", new Integer(this.SeqNo++).toString(), false);
        } else {
            this.setTaggedValueRole((Collection<RoleTag>)r2c.GetTaggedValues(), "sequenceNumber", new Integer(this.SeqNo++).toString(), false);
            this.setTaggedValueRole((Collection<RoleTag>)r2s.GetTaggedValues(), "sequenceNumber", new Integer(this.SeqNo++).toString(), true);
        }
    }

    private void schemaLocationOfPackage(String name, String locprefix) {
        Package p = this.allPackages.get(name);
        if (p != null) {
            Element e = p.GetElement();
            Collection cTV = e.GetTaggedValues();
            TaggedValue tv = (TaggedValue)cTV.GetByName("xsdDocument");
            if (tv == null) {
                this.result.addError("TaggedValue 'xsdDocument' nicht vorhanden bei Paket '" + e.GetName() + "'");
            } else {
                String v2 = tv.GetValue();
                tv.SetValue(locprefix + v2);
                if (!tv.Update()) {
                    this.result.addError("Fehler beim Setzen von TaggedValue 'xsdDocument'-'" + locprefix + v2 + "': " + tv.GetLastError());
                } else {
                    this.result.addDebug("Setzen von TaggedValue 'xsdDocument'-'" + locprefix + v2 + "' (alter Wert: '" + v2 + "')");
                }
            }
        } else {
            this.result.addError("Package '" + name + "' nicht gefunden.");
        }
    }

    private void deletePackage(String name) {
        Package e = this.allPackages.get(name);
        if (e != null) {
            Package parent = this.rep.GetPackageByID(e.GetParentID());
            Collection c = parent.GetPackages();
            for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                Package ei = (Package)c.GetAt(i);
                if (ei.GetPackageID() != e.GetPackageID()) continue;
                c.Delete(i);
                if (!parent.Update()) {
                    this.result.addError("Fehler beim L\u00f6schen von Package '" + name + "': " + parent.GetLastError());
                } else {
                    this.result.addDebug("Package '" + name + "' gel\u00f6scht.");
                }
                c.Refresh();
                break;
            }
        } else {
            this.result.addError("Package '" + name + "' nicht gefunden.");
        }
    }

    private void setTaggedValue(Collection<TaggedValue> cTV, String n, String v) {
        TaggedValue tv = (TaggedValue)cTV.GetByName(n);
        if (tv == null) {
            tv = (TaggedValue)cTV.AddNew(n, v);
            if (!tv.Update()) {
                this.result.addError("Fehler beim Setzen von TaggedValue '" + n + "'-'" + v + "': " + tv.GetLastError());
            } else {
                this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v + "'");
            }
            cTV.Refresh();
        } else {
            String v2 = tv.GetValue();
            if (v2.equals(v)) {
                this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v + "' (bestehender Wert)");
            } else {
                tv.SetValue(v);
                if (!tv.Update()) {
                    this.result.addError("Fehler beim Setzen von TaggedValue '" + n + "'-'" + v + "'/'" + v2 + "': " + tv.GetLastError());
                } else {
                    this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v + "' (alter Wert: '" + v2 + "')");
                }
            }
        }
    }

    private void setTaggedValueRole(Collection<RoleTag> cTV, String n, String v, boolean force) {
        RoleTag tv = null;
        for (RoleTag tv2 : cTV) {
            if (!tv2.GetTag().equals(n)) continue;
            tv = tv2;
            break;
        }
        if (tv == null) {
            tv = (RoleTag)cTV.AddNew(n, v);
            if (!tv.Update()) {
                this.result.addError("Fehler beim Setzen von TaggedValue '" + n + "'-'" + v + "': " + tv.GetLastError());
            } else {
                this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v + "'");
            }
            cTV.Refresh();
        } else {
            String v2 = tv.GetValue();
            if (v2.equals(v)) {
                this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v + "' (bestehender Wert)");
            } else if (!force) {
                this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v2 + "' (alter Wert wird nicht ge\u00e4ndert durch '" + v + "')");
            } else {
                tv.SetValue(v);
                if (!tv.Update()) {
                    this.result.addError("Fehler beim Setzen von TaggedValue '" + n + "'-'" + v + "'/'" + v2 + "': " + tv.GetLastError());
                } else {
                    this.result.addDebug("Setzen von TaggedValue '" + n + "'-'" + v + "' (alter Wert: '" + v2 + "')");
                }
            }
        }
    }

    private void deleteClass(String name) {
        Element e = this.allClasses.get(name);
        if (e != null) {
            Package parent = this.rep.GetPackageByID(e.GetPackageID());
            Collection c = parent.GetElements();
            for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                Element ei = (Element)c.GetAt(i);
                if (ei.GetElementID() != e.GetElementID()) continue;
                c.Delete(i);
                if (!parent.Update()) {
                    this.result.addError("Fehler beim L\u00f6schen von Klasse '" + name + "': " + parent.GetLastError());
                } else {
                    this.result.addDebug("Klasse '" + name + "' gel\u00f6scht.");
                }
                c.Refresh();
                break;
            }
        } else {
            this.result.addError("Klasse '" + name + "' nicht gefunden.");
        }
    }

    private void deleteMethods(Element e) {
        while (e.GetMethods().GetCount() > 0) {
            e.GetMethods().Delete((short)0);
            if (!e.Update()) {
                this.result.addError("Fehler beim L\u00f6schen der Methoden von Klasse '" + e.GetName() + "': " + e.GetLastError());
            } else {
                this.result.addDebug("Methode von Klasse '" + e.GetName() + "' gel\u00f6scht.");
            }
            e.GetMethods().Refresh();
        }
    }

    private void moveClass(String name, String pname) {
        Element e = this.allClasses.get(name);
        if (e != null) {
            Package p = this.allPackages.get(pname);
            if (p != null) {
                e.SetPackageID(p.GetPackageID());
                if (!e.Update()) {
                    this.result.addError("Fehler beim Verschieben von Klasse '" + name + "': " + e.GetLastError());
                } else {
                    this.result.addDebug("Klasse '" + name + "' verschoben.");
                }
            } else {
                this.result.addError("Package '" + pname + "' nicht gefunden.");
            }
        } else {
            this.result.addError("Klasse '" + name + "' nicht gefunden.");
        }
    }

    private void setStereotypeClass(String name, String st) {
        Element e = this.allClasses.get(name);
        if (e != null) {
            e.SetStereotype(st);
            if (!e.Update()) {
                this.result.addError("Fehler beim Setzen des Stereotyps von Klasse '" + name + "': " + e.GetLastError());
            } else {
                this.result.addDebug("Stereotyp von Klasse '" + name + "' gesetzt.");
            }
        } else {
            this.result.addError("Klasse '" + name + "' nicht gefunden.");
        }
    }

    private void addAttribute(String cname, String name, String type) {
        Element e = this.allClasses.get(cname);
        if (e != null) {
            Attribute a = (Attribute)e.GetAttributes().AddNew(name, type);
            if (!a.Update()) {
                this.result.addError("Fehler beim Erg\u00e4nzen von Attribut '" + cname + "." + name + "': " + a.GetLastError());
            } else {
                this.result.addDebug("Attribut '" + cname + "." + name + "' erg\u00e4nzt.");
            }
            e.GetAttributes().Refresh();
        } else {
            this.result.addError("Klasse '" + cname + "' nicht gefunden.");
        }
    }

    private void deleteAttribute(String cname, String name) {
        Element e = this.allClasses.get(cname);
        if (e != null) {
            Collection c = e.GetAttributes();
            for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                Attribute ei = (Attribute)c.GetAt(i);
                if (!ei.GetName().equals(name)) continue;
                c.Delete(i);
                if (!e.Update()) {
                    this.result.addError("Fehler beim L\u00f6schen von Attribut '" + cname + "." + name + "': " + e.GetLastError());
                } else {
                    this.result.addDebug("Attribut '" + cname + "." + name + "' gel\u00f6scht.");
                }
                c.Refresh();
                break;
            }
        } else {
            this.result.addError("Klasse '" + cname + "' nicht gefunden.");
        }
    }

    private void changeTypeAndMultiplicity(String cname, String name, String tname, String lower, String upper) {
        Element e = this.allClasses.get(cname);
        if (e != null) {
            Collection c = e.GetAttributes();
            for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                Attribute ei = (Attribute)c.GetAt(i);
                if (!ei.GetName().equals(name)) continue;
                ei.SetType(tname);
                ei.SetLowerBound(lower);
                ei.SetUpperBound(upper);
                if (!ei.Update()) {
                    this.result.addError("Fehler beim Setzen der Multiplizit\u00e4t von Attribut '" + cname + "." + name + "': " + ei.GetLastError());
                } else {
                    this.result.addDebug("Multiplizit\u00e4t von Attribut '" + cname + "." + name + "' ge\u00e4ndert.");
                }
                c.Refresh();
                break;
            }
        } else {
            this.result.addError("Klasse '" + cname + "' nicht gefunden.");
        }
    }

    private void changeType(String cname, String name, String tname) {
        Element e = this.allClasses.get(cname);
        if (e != null) {
            Collection c = e.GetAttributes();
            for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                Attribute ei = (Attribute)c.GetAt(i);
                if (!ei.GetName().equals(name)) continue;
                ei.SetType(tname);
                if (!ei.Update()) {
                    this.result.addError("Fehler beim Setzen des Typs von Attribut '" + cname + "." + name + "': " + ei.GetLastError());
                } else {
                    this.result.addDebug("Typ von Attribut '" + cname + "." + name + "' ge\u00e4ndert.");
                }
                c.Refresh();
                break;
            }
        } else {
            this.result.addError("Klasse '" + cname + "' nicht gefunden.");
        }
    }

    private void deleteRole(String cname, String name) {
        Element e = this.allClasses.get(cname);
        if (e != null) {
            Collection c = e.GetConnectors();
            for (short i = 0; i < c.GetCount(); i = (short)(i + 1)) {
                Connector ei = (Connector)c.GetAt(i);
                if (!ei.GetClientEnd().GetRole().equals(name) && !ei.GetSupplierEnd().GetRole().equals(name)) continue;
                c.Delete(i);
                if (!e.Update()) {
                    this.result.addError("Fehler beim L\u00f6schen von Rolle '" + cname + "." + name + "': " + e.GetLastError());
                } else {
                    this.result.addDebug("Rolle '" + cname + "." + name + "' gel\u00f6scht.");
                }
                c.Refresh();
                break;
            }
        } else {
            this.result.addError("Klasse '" + cname + "' nicht gefunden.");
        }
    }

    private void prepareModel() throws ShapeChangeAbortException {
        for (Package p : this.rep.GetModels()) {
            this.preparePackage(p, false);
        }
    }

    private void preparePackage(Package p, boolean aaa) throws ShapeChangeAbortException {
        try {
            if (p.VersionControlGetStatus() != 0) {
                p.VersionControlRemove();
                if (!p.Update()) {
                    this.result.addFatalError("EA-Fehler: " + p.GetLastError());
                    throw new ShapeChangeAbortException();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.result.addFatalError("EA-Fehler: " + this.rep.GetLastError());
            throw new ShapeChangeAbortException();
        }
        if (p.GetName().equals("AFIS-ALKIS-ATKIS Anwendungsschema")) {
            aaa = true;
            TaggedValue tv = (TaggedValue)p.GetElement().GetTaggedValues().GetByName("version");
            if (tv != null) {
                this.aaaVersion = tv.GetValue();
            }
        }
        for (Package p2 : p.GetPackages()) {
            this.preparePackage(p2, aaa);
        }
        while (p.GetDiagrams().GetCount() > 0) {
            p.GetDiagrams().Delete((short)0);
            if (!p.Update()) {
                this.result.addFatalError("EA-Fehler: " + p.GetLastError());
                throw new ShapeChangeAbortException();
            }
            p.GetDiagrams().Refresh();
        }
        String s = p.GetName();
        if (this.allPackages.containsKey(s)) {
            this.result.addDebug("Information: Paket '" + s + "' mehrfach vorhanden.");
        } else {
            this.allPackages.put(s, p);
        }
        Collection c = p.GetElements();
        c.Refresh();
        for (Element e : c) {
            if (!e.GetType().equals("Class")) continue;
            s = e.GetName();
            if (this.allClasses.containsKey(s)) {
                this.result.addDebug("Information: Klasse '" + s + "' mehrfach vorhanden.");
            } else {
                this.allClasses.put(s, e);
            }
            if (!aaa) continue;
            this.aaaClasses.put(s, e);
        }
    }
}

