/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.OclConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.TextConstraintEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.sparx.Attribute;
import org.sparx.AttributeConstraint;
import org.sparx.AttributeTag;
import org.sparx.Collection;
import org.sparx.ConnectorEnd;
import org.sparx.RoleTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfoEA
extends PropertyInfoImpl
implements PropertyInfo {
    protected EADocument document = null;
    protected ClassInfoEA classInfo = null;
    protected String eaPropertyId = null;
    protected String eaName = null;
    protected Type typeInfo = new Type();
    protected ClassInfoEA typeClassInfo = null;
    protected Attribute eaAttribute = null;
    AssociationInfoEA associationInfo = null;
    boolean reversedAssoc = false;
    ConnectorEnd eaConnectorEnd = null;
    protected StructuredNumber sequenceNumber = new StructuredNumber(Integer.MIN_VALUE);
    protected Multiplicity multiplicity = new Multiplicity();
    protected String initialValueCache = null;
    protected Boolean isDerivedCache = null;
    protected Boolean isNavigableCache = null;
    protected String aggregationTypeCache = null;
    protected Boolean isOrderedCache = null;
    protected HashSet<String> stereotypesCache = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected Vector<Constraint> constraintsCache = null;
    private boolean metadata = false;
    private boolean nilReasonAllowed = false;
    protected boolean restriction = false;

    public PropertyInfoEA(EADocument doc, ClassInfoEA ci, Attribute attr) {
        String s;
        this.document = doc;
        this.classInfo = ci;
        this.eaAttribute = attr;
        this.eaPropertyId = ci.id();
        this.eaPropertyId = String.valueOf(this.eaPropertyId) + "_";
        this.eaPropertyId = String.valueOf(this.eaPropertyId) + new Integer(this.eaAttribute.GetAttributeID()).toString();
        this.eaName = this.eaAttribute.GetName();
        if (this.eaName != null) {
            this.eaName = this.eaName.trim();
        }
        if ((s = this.taggedValue("sequenceNumber")) != null) {
            this.sequenceNumber = new StructuredNumber(s);
        } else {
            int pos = this.eaAttribute.GetPos();
            PropertyInfo piTemp = this.classInfo.properties().get(new StructuredNumber(Integer.MIN_VALUE + pos));
            this.sequenceNumber = piTemp != null ? new StructuredNumber(this.document.globalSequenceNumber++ + -1073741824) : new StructuredNumber(Integer.MIN_VALUE + pos);
        }
        int typeid = this.eaAttribute.GetClassifierID();
        this.typeInfo.id = new Integer(typeid).toString();
        this.typeInfo.name = this.eaAttribute.GetType().trim();
        this.typeClassInfo = this.document.fClassById.get(this.typeInfo.id);
        if ((this.typeInfo.name == null || this.typeInfo.name.length() == 0) && this.typeClassInfo != null) {
            this.typeInfo.name = this.typeClassInfo.name();
        }
        String[] bounds = new String[]{this.eaAttribute.GetLowerBound().trim(), this.eaAttribute.GetUpperBound().trim()};
        int[] mult = new int[2];
        int i = 0;
        while (i < 2) {
            if (bounds[i].length() == 0) {
                mult[i] = 1;
            } else if (bounds[i].equals("*")) {
                mult[i] = i == 0 ? 0 : Integer.MAX_VALUE;
            } else {
                try {
                    mult[i] = Integer.parseInt(bounds[i]);
                }
                catch (NumberFormatException e) {
                    this.document.result.addWarning(1003, bounds[i]);
                    mult[i] = 1;
                }
            }
            ++i;
        }
        this.multiplicity.minOccurs = mult[0];
        this.multiplicity.maxOccurs = mult[1];
        this.document.result.addDebug(10013, "property", this.id(), this.name());
    }

    public PropertyInfoEA(EADocument doc, ClassInfoEA ci, AssociationInfoEA ai, boolean reversed, ConnectorEnd eaCE, ClassInfoEA tci) {
        this.document = doc;
        this.classInfo = ci;
        this.associationInfo = ai;
        this.reversedAssoc = reversed;
        this.eaConnectorEnd = eaCE;
        this.eaPropertyId = String.valueOf(reversed ? "S" : "T") + new Integer(ai.eaConnectorId).toString();
        this.eaName = eaCE.GetRole();
        if (this.eaName == null || this.eaName.length() == 0) {
            this.eaName = "role_" + this.eaPropertyId;
        }
        this.eaName = this.eaName.trim();
        this.typeClassInfo = tci;
        this.typeInfo.id = tci.id();
        this.typeInfo.name = tci.name();
        String s = this.taggedValue("sequenceNumber");
        this.sequenceNumber = s != null ? new StructuredNumber(s) : new StructuredNumber(this.document.globalSequenceNumber++);
        String card = this.eaConnectorEnd.GetCardinality();
        String[] ranges = card.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        int i = 0;
        while (i < ranges.length) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Integer.parseInt(minmax[0]);
                if (minmax[1].equals("*") || minmax[1].length() == 0) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(minmax[1]);
                    }
                    catch (NumberFormatException e) {
                        this.document.result.addWarning(1003, minmax[1]);
                        upper = Integer.MAX_VALUE;
                    }
                }
            } else if (ranges[i].length() == 0 || ranges[i].equals("*")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                try {
                    upper = lower = Integer.parseInt(ranges[i]);
                }
                catch (NumberFormatException e) {
                    this.document.result.addWarning(1003, ranges[i]);
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                }
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper > maxv) {
                maxv = upper;
            }
            ++i;
        }
        this.multiplicity.minOccurs = minv;
        this.multiplicity.maxOccurs = maxv;
        this.document.result.addDebug(10013, "property", this.id(), this.name());
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public Multiplicity cardinality() {
        return this.multiplicity;
    }

    @Override
    public String defaultCodeSpace() {
        String s = this.taggedValue("defaultCodeSpace");
        return s != null ? s : "";
    }

    @Override
    public boolean implementedByNilReason() {
        String s = this.taggedValue("gmlImplementedByNilReason");
        return s != null && s.toLowerCase().equals("true") && this.document.options.gmlVersion.equals("3.2");
    }

    @Override
    public ClassInfo inClass() {
        return this.classInfo;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.classInfo = (ClassInfoEA)ci;
    }

    @Override
    public String initialValue() {
        if (this.initialValueCache == null && this.isAttribute()) {
            this.initialValueCache = this.eaAttribute.GetDefault();
            if (this.initialValueCache.equals("")) {
                this.initialValueCache = null;
            }
            if (this.initialValueCache != null) {
                this.initialValueCache = this.initialValueCache.trim();
                String iv = this.initialValueCache.toLowerCase();
                if (iv.equals("true")) {
                    this.initialValueCache = "true";
                }
                if (iv.equals("false")) {
                    this.initialValueCache = "false";
                }
            }
        }
        return this.initialValueCache;
    }

    @Override
    public String inlineOrByReference() {
        String s = this.taggedValue("inlineOrByReference");
        if (s == null) {
            s = "";
        }
        if (s.equals("") && !this.isAttribute() && this.isNavigable()) {
            s = "byreference";
        }
        if (s.length() == 0) {
            String cont = null;
            cont = this.isAttribute() ? this.eaAttribute.GetContainment() : this.eaConnectorEnd.GetContainment();
            if (cont != null) {
                if (cont.equals("By Reference")) {
                    s = "byreference";
                } else if (cont.equals("By Value")) {
                    s = "inline";
                }
            }
        }
        return s.toLowerCase();
    }

    private void validateAggregationType() {
        if (this.aggregationTypeCache == null) {
            int cat;
            int n = cat = this.typeClassInfo == null ? 6 : this.typeClassInfo.category();
            if (cat == 1 || cat == 6) {
                if (this.isAttribute()) {
                    this.aggregationTypeCache = "composite";
                } else {
                    ConnectorEnd otherEnd = ((PropertyInfoEA)this.reverseProperty()).eaConnectorEnd;
                    int agt = otherEnd.GetAggregation();
                    if (agt == 1) {
                        this.aggregationTypeCache = "shared";
                    } else if (agt == 2) {
                        this.aggregationTypeCache = "composite";
                    }
                }
            }
            if (this.aggregationTypeCache == null) {
                this.aggregationTypeCache = "none";
            }
        }
    }

    @Override
    public boolean isAggregation() {
        this.validateAggregationType();
        return this.aggregationTypeCache.equals("shared");
    }

    @Override
    public boolean isAttribute() {
        return this.eaAttribute != null;
    }

    @Override
    public boolean isComposition() {
        this.validateAggregationType();
        return this.aggregationTypeCache.equals("composite");
    }

    @Override
    public boolean isDerived() {
        if (this.isDerivedCache == null) {
            this.isDerivedCache = new Boolean(this.isAttribute() ? this.eaAttribute.GetIsDerived() : this.eaConnectorEnd.GetDerived());
        }
        return this.isDerivedCache;
    }

    @Override
    public boolean isMetadata() {
        if (this.metadata) {
            return true;
        }
        String s = this.taggedValue("isMetadata");
        return s != null && s.toLowerCase().equals("true");
    }

    @Override
    public void isMetadata(boolean b) {
        this.metadata = b;
    }

    @Override
    public boolean isNavigable() {
        if (this.isNavigableCache == null) {
            this.isNavigableCache = new Boolean(true);
            if (!this.isAttribute()) {
                boolean nav = this.eaConnectorEnd.GetIsNavigable();
                if (!nav) {
                    boolean bl = nav = this.associationInfo.navigability == 0;
                }
                if (this.eaName == null || this.eaName.substring(0, this.eaName.length() < 5 ? this.eaName.length() : 5).compareTo("role_") == 0) {
                    nav = false;
                }
                this.isNavigableCache = nav;
            }
        }
        return this.isNavigableCache;
    }

    @Override
    public boolean isOrdered() {
        if (this.isOrderedCache == null) {
            this.isOrderedCache = new Boolean(false);
            if (this.isAttribute()) {
                this.isOrderedCache = this.eaAttribute.GetIsOrdered();
            } else {
                int ordering = this.eaConnectorEnd.GetOrdering();
                if (ordering != 0) {
                    this.isOrderedCache = true;
                }
            }
        }
        return this.isOrderedCache;
    }

    @Override
    public boolean nilReasonAllowed() {
        String s = this.taggedValue("nilReasonAllowed");
        if (s != null && s.toLowerCase().equals("true") && this.options().gmlVersion.equals("3.2")) {
            return true;
        }
        return this.nilReasonAllowed;
    }

    @Override
    public void nilReasonAllowed(boolean b) {
        this.nilReasonAllowed = b;
    }

    @Override
    public String qname() {
        return String.valueOf(this.inClass().pkg().xmlns()) + ":" + this.name();
    }

    @Override
    public boolean restriction() {
        return this.restriction;
    }

    @Override
    public void restriction(boolean r) {
        this.restriction = r;
    }

    @Override
    public PropertyInfo reverseProperty() {
        if (this.isAttribute()) {
            return null;
        }
        return this.associationInfo.properties[this.reversedAssoc ? 1 : 0];
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.isAttribute() ? this.eaAttribute.GetStereotypeEx() : this.eaConnectorEnd.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            String[] stringArray = stereotypes;
            int n = stereotypes.length;
            int n2 = 0;
            while (n2 < n) {
                String stereotype = stringArray[n2];
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st != null) {
                    String[] stringArray2 = Options.propertyStereotypes;
                    int n3 = Options.propertyStereotypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray2[n4];
                        if (st.toLowerCase().equals(s)) {
                            this.stereotypesCache.add(s);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> iterator = this.stereotypesCache.iterator();
        if (iterator.hasNext()) {
            String st = iterator.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    private void validateTaggedValuesCache() {
        block4: {
            if (this.taggedValuesCache != null) break block4;
            if (this.isAttribute()) {
                Collection tvs = this.eaAttribute.GetTaggedValues();
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = new HashMap(ntvs);
                for (AttributeTag tv : tvs) {
                    String t = tv.GetName();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    this.taggedValuesCache.put(t, v);
                }
            } else {
                Collection tvs = this.eaConnectorEnd.GetTaggedValues();
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = new HashMap(ntvs);
                for (RoleTag tv : tvs) {
                    String t = tv.GetTag();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    this.taggedValuesCache.put(t, v);
                }
            }
        }
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public Type typeInfo() {
        return this.typeInfo;
    }

    @Override
    public boolean voidable() {
        this.validateStereotypesCache();
        return this.stereotypesCache.contains("voidable");
    }

    @Override
    public String documentation() {
        String s = super.documentation();
        if (s == null || s.length() == 0) {
            s = this.isAttribute() ? this.eaAttribute.GetNotes() : this.eaConnectorEnd.GetRoleNote();
        }
        return s != null ? s : "";
    }

    @Override
    public String encodingRule(String platform) {
        String s = this.taggedValue(String.valueOf(platform) + "EncodingRule");
        if (s == null) {
            s = this.inClass().encodingRule(platform);
        }
        return s;
    }

    @Override
    public String id() {
        return this.eaPropertyId;
    }

    @Override
    public String name() {
        String s = this.eaName;
        if (s == null || s.equals("")) {
            if (this.classInfo == null || this.classInfo.category() != 2 && this.classInfo.category() != 3) {
                s = this.id();
                this.document.result.addWarning(100, "property", s);
            } else {
                this.document.result.addWarning(136, this.id(), this.classInfo.name());
            }
        }
        return s;
    }

    @Override
    public String aliasName() {
        String a = super.aliasName();
        if (a == null || a.length() == 0) {
            a = this.isAttribute() ? this.eaAttribute.GetStyle() : this.eaConnectorEnd.GetAlias();
        }
        return a;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v != null) {
                res.put(t, v);
            }
            ++n2;
        }
        return res;
    }

    private void validateConstraintsCache() {
        if (this.constraintsCache == null) {
            this.constraintsCache = new Vector();
            if (this.isAttribute()) {
                Collection constrs = this.eaAttribute.GetConstraints();
                for (AttributeConstraint constr : constrs) {
                    String type = constr.GetType();
                    Constraint oc = type == "OCL" ? new OclConstraintEA(this.document, this, constr) : new TextConstraintEA(this.document, this, constr);
                    this.constraintsCache.add(oc);
                }
            }
        }
    }

    @Override
    public Vector<Constraint> constraints() {
        this.validateConstraintsCache();
        return this.constraintsCache;
    }
}

