/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraintImpl;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.TempNode;
import de.interactive_instruments.ShapeChange.Ocl.TempParser;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.sparx.AttributeConstraint;
import org.sparx.Constraint;

public class OclConstraintEA
extends OclConstraintImpl
implements OclConstraint {
    protected EADocument document = null;
    protected Constraint eaConstraintClass;
    protected AttributeConstraint eaConstraintAttribute;

    public OclConstraintEA(EADocument doc, ClassInfoEA ci, Constraint constr) {
        this.document = doc;
        this.contextClass = ci;
        this.contextModelElmtType = OclConstraint.ModelElmtContextType.CLASS;
        this.contextModelElmt = ci;
        this.eaConstraintClass = constr;
        this.constraintName = constr.GetName();
        this.constraintStatus = constr.GetStatus();
        this.constraintText = constr.GetNotes();
        StringReader instream = new StringReader(this.constraintText);
        MessageCollection messages = new MessageCollection();
        TempParser parse = new TempParser(instream, messages);
        this.document.result.addDebug(10006, ci.name(), this.constraintName);
        TempNode.Expression expr = parse.parseExpression();
        if (this.document.options.parameter("reportLevel").equals("DEBUG")) {
            String[] comments;
            StringWriter str = new StringWriter();
            PrintWriter write = new PrintWriter(str);
            expr.debugPrint(write);
            this.document.result.addDebug(10024, str.toString());
            String[] stringArray = comments = parse.getComments();
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                this.document.result.addDebug(10025, c);
                ++n2;
            }
        }
        if (messages.getNumberOfMessages() > 0) {
            MessageCollection.Message[] msg;
            this.document.result.addError(133, ci.name(), this.constraintName);
            MessageCollection.Message[] messageArray = msg = messages.getMessages();
            int n = msg.length;
            int n3 = 0;
            while (n3 < n) {
                MessageCollection.Message m = messageArray[n3];
                String[] del = new String[]{"/", "-", ","};
                String sr = m.getFormattedSourceReferences(1, 1, del);
                String ms = m.getMessageText();
                this.document.result.addError(134, sr, ms);
                ++n3;
            }
        }
    }

    public OclConstraintEA(EADocument doc, PropertyInfoEA pi, AttributeConstraint constr) {
        this.document = doc;
        this.contextClass = pi.inClass();
        this.contextModelElmtType = OclConstraint.ModelElmtContextType.ATTRIBUTE;
        this.contextModelElmt = pi;
        this.eaConstraintAttribute = constr;
        this.constraintName = constr.GetName().trim();
        int ib = this.constraintName.indexOf("[");
        int ie = this.constraintName.indexOf("]", ib);
        this.constraintStatus = "";
        if (ib != -1 && ie != -1) {
            this.constraintStatus = this.constraintName.substring(ib + 1, ie - 1).trim();
            this.constraintName = this.constraintName.substring(0, ib);
        }
        this.constraintText = constr.GetNotes();
    }
}

