<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Gebaeude: AX_Gebaeude oder AX_Turm -->
	<xsl:variable name="gebaeude">
		<xsl:choose>
			<xsl:when test="count(document('E1.xml')//adv:AX_Gebaeude)=1">
				<xsl:value-of select="document('E1.xml')//adv:AX_Gebaeude"/>
			</xsl:when>
			<xsl:when test="count(document('E1.xml')//adv:AX_Turm)=1">
				<xsl:value-of select="document('E1.xml')//adv:AX_Turm"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="gebaeude_typ">
		<xsl:choose>
			<xsl:when test="count(document('E1.xml')//adv:AX_Gebaeude)=1">
				<xsl:value-of select="'G'"/>
			</xsl:when>
			<xsl:when test="count(document('E1.xml')//adv:AX_Turm)=1">
				<xsl:value-of select="'T'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Gebaeudenachweis xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<xsl:if test="count(document('E1.xml')//adv:AX_LagebezeichnungMitHausnummer/adv:lagebezeichnung/adv:AX_Lagebezeichnung) > 0 or 
						  count(document('E1.xml')//adv:AX_LagebezeichnungMitPseudonummer/adv:lagebezeichnung/adv:AX_Lagebezeichnung) > 0)">
				<!-- Hausnummernkennzeichen -->
				<xsl:for-each select="document('E1.xml')//adv:AX_LagebezeichnungMitHausnummer/adv:lagebezeichnung/adv:AX_Lagebezeichnung">
					<lagebezeichnung>
						<AX_Lagebezeichnung_K_GEBAEUDE>
							<lagebezeichnung>
								<xsl:value-of select="adv:unverschluesselt"/>
							</lagebezeichnung>
							<nummer>
								<xsl:value-of select="adv:hausnummer"/>
							</nummer>
							<ortsteil>
								<xsl:value-of select="adv:ortsteil"/>
							</ortsteil>
						</AX_Lagebezeichnung_K_GEBAEUDE>
					</lagebezeichnung>
				</xsl:for-each>
				<!-- Pseudonummernkennzeichen -->
				<xsl:for-each select="document('E1.xml')//adv:AX_LagebezeichnungMitPseudonummer/adv:lagebezeichnung/adv:AX_Lagebezeichnung">
					<lagebezeichnung>
						<AX_Lagebezeichnung_K_GEBAEUDE>
							<lagebezeichnung>
								<xsl:value-of select="adv:unverschluesselt"/>
							</lagebezeichnung>
							<nummer>
								<xsl:value-of select="adv:pseudonummer"/>
							</nummer>
							<laufendeNummer>
								<xsl:value-of select="adv:laufendeNummer"/>
							</laufendeNummer>
							<ortsteil>
								<xsl:value-of select="adv:ortsteil"/>
							</ortsteil>
						</AX_Lagebezeichnung_K_GEBAEUDE>
			    	</lagebezeichnung>
				</xsl:for-each>
			</xsl:if>
			<gebaeudefunktion>
				<xsl:choose>
					<xsl:when test="$gebaeude_typ = 'G'">
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_Gebaeudefunktion</xsl:with-param> 
							<xsl:with-param name="code" select="$gebaeude/adv:gebaudefunktion" /> 
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$gebaeude_typ = 'T'">
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_Bauwerksfunktion_Turm</xsl:with-param> 
							<xsl:with-param name="code" select="$gebaeude/adv:bauwerksfunktion" /> 
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</gebaeudefunktion>
			<xsl:if test="$gebaeude_typ = 'G' and count($gebaeude/adv:weitereGebaudefunktion) > 0">
			    <xsl:for-each select="$gebaeude/adv:weitereGebaeudefunktion">
					<weitereGebaeudefunktion>
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_Weitere_Gebaeudefunktion</xsl:with-param> 
							<xsl:with-param name="code" select="." />
						</xsl:call-template>
					</weitereGebaeudefunktion>
			    </xsl:for-each>
			</xsl:if>
			<xsl:if test="count($gebaeude/adv:name) > 0">
				<xsl:for-each select="$gebaeude/adv:name">
					<name><xsl:value-of select="."/></name>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="$gebaeude_typ = 'G'">
				<xsl:if test="count($gebaeude/adv:nutzung) > 0">
					<nutzung>
						<xsl:for-each select="$gebaeude/adv:nutzung">
							<AX_Nutzung_Gebaeude>
								<anteil>
									<xsl:value-of select="adv:anteil"/>
								</anteil>
								<nutzung>
									<!-- statt dem Code sollte eine CharacterString verwendet werden über;
										<xsl:call-template name="entschluesseln">
											<xsl:with-param name="codelist">AX_Nutzung</xsl:with-param> 
											<xsl:with-param name="code" select="adv:nutzung" /> 
										</xsl:call-template>
									-->
									<AX_Nutzung>
										<xsl:value-of select="adv:nutzung"/>
									</AX_Nutzung>
								</nutzung>
							</AX_Nutzung_Gebaeude>
						</xsl:for-each>
					</nutzung>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:bauweise)=1">
					<bauweise>
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_Bauweise_Gebaeude</xsl:with-param> 
							<xsl:with-param name="code" select="$gebaeude/adv:bauweise" /> 
						</xsl:call-template>
					</bauweise>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:anzahlDerOberirdischenGeschosse)=1">
					<anzahlDerOberirdischenGeschosse>
						<xsl:value-of select="$gebaeude/adv:anzahlDerOberirdischenGeschosse"/>
					</anzahlDerOberirdischenGeschosse>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:anzahlDerUnterirdischenGeschosse)=1">
					<anzahlDerUnterirdischenGeschosse>
						<xsl:value-of select="$gebaeude/adv:anzahlDerUnterirdischenGeschosse"/>
					</anzahlDerUnterirdischenGeschosse>
				</xsl:if>
				<xsl:if test="$gebaeude/adv:hochhaus = true">
					<hochhaus>Hochhaus</hochhaus>
				</xsl:if>
			</xsl:if>
			<xsl:if test="count($gebaeude/adv:objekthoehe)=1">
				<objekthoehe><xsl:value-of select="$gebaeude/adv:objekthoehe"/></objekthoehe>
			</xsl:if>
			<xsl:if test="$gebaeude_typ = 'G'">
				<xsl:if test="count($gebaeude/adv:dachform)=1">
					<dachform>
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_Dachform</xsl:with-param> 
							<xsl:with-param name="code" select="$gebaeude/adv:dachform" /> 
						</xsl:call-template>
					</dachform>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:dachart)=1">
					<dachart>
						<xsl:value-of select="$gebaeude/adv:dachart"/>
					</dachart>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:dachgeschossausbau)=1">
					<dachgeschossausbau>
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_Dachgeschossausbau_Gebaeude</xsl:with-param> 
							<xsl:with-param name="code" select="$gebaeude/adv:dachgeschossausbau" /> 
						</xsl:call-template>
					</dachgeschossausbau>
				</xsl:if>
			</xsl:if>
			<xsl:if test="count($gebaeude/adv:zustand)=1">
				<zustand>
					<xsl:choose>
						<xsl:when test="$gebaeude_typ = 'G'">
							<xsl:call-template name="entschluesseln">
								<xsl:with-param name="codelist">AX_Zustand_Gebaeude</xsl:with-param> 
								<xsl:with-param name="code" select="$gebaeude/adv:zustand" /> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$gebaeude_typ = 'T'">
							<xsl:call-template name="entschluesseln">
								<xsl:with-param name="codelist">AX_Zustand_Turm</xsl:with-param> 
								<xsl:with-param name="code" select="$gebaeude/adv:zustand" /> 
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</zustand>
			</xsl:if>
			<xsl:if test="$gebaeude_typ = 'G'">
				<xsl:if test="count($gebaeude/adv:geschossflaeche)=1">
					<geschossflaeche>
						<xsl:value-of select="$gebaeude/adv:geschossflaeche"/>
					</geschossflaeche>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:grundflaeche)=1">
					<grundflaeche>
						<xsl:value-of select="$gebaeude/adv:grundflaeche"/>
					</grundflaeche>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:umbauterRaum)=1">
					<umbauterRaum>
						<xsl:value-of select="$gebaeude/adv:umbauterRaum"/>
					</umbauterRaum>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:baujahr) > 0">
					<xsl:for-each select="$gebaeude/adv:baujahr">
						<baujahr>
							<xsl:value-of select="."/>
						</baujahr>
				   	</xsl:for-each>
				</xsl:if>
				<xsl:if test="count($gebaeude/adv:lageZurErdoberflaeche)=1">
					<lageZurErdoberflaeche>
						<xsl:call-template name="entschluesseln">
							<xsl:with-param name="codelist">AX_LageZurErdoberflaeche_Gebaeude</xsl:with-param> 
							<xsl:with-param name="code" select="$gebaeude/adv:lageZurErdoberflaeche" /> 
						</xsl:call-template>
					</lageZurErdoberflaeche>
				</xsl:if>
			</xsl:if>
			<xsl:for-each select="document('E2.xml')//adv:AX_Flurstueck">
				<flurstueck>
					<AX_K_LBH>
						<kopf>
							<AX_Kopf_Flurstueck>
								<gemarkungsname>
								  <xsl:variable name="land" select="adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land" /> 
								  <xsl:variable name="gemnr" select="adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer" /> 
								  <xsl:variable name="gemarkung" select="document('E2.xml')//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]" />
								  <xsl:value-of select="$gemarkung/adv:bezeichnung"/> 
								</gemarkungsname>
								<flurstuecksnummer>
									<xsl:copy-of select="./adv:flurstuecksnummer/AX_Flurstuecksnummer"/>
								</flurstuecksnummer>
								<flurnummer>
									<xsl:value-of select="adv:flurnummer"/>
								</flurnummer>
							</AX_Kopf_Flurstueck>
						</kopf>
						<lagebezeichnung>
							<!-- Hausnummernkennzeichen -->
							<xsl:for-each select="document('E1.xml')//adv:AX_LagebezeichnungMitHausnummer[@gml:id=substring-after(./adv:weistAuf/@xlink:href,'urn:adv:oid:')]/adv:lagebezeichnung/adv:AX_Lagebezeichnung">
								<AX_K_LBEZ_Lagebezeichnung>
									<lagebezeichnung>
										<xsl:value-of select="adv:unverschluesselt"/>
									</lagebezeichnung>
									<hausnummer>
										<xsl:value-of select="adv:hausnummer"/>
									</hausnummer>
									<xsl:if test="count(adv:ortsteil) > 0">
										<ortsteil>
											<xsl:value-of select="adv:ortsteil"/>
									 	</ortsteil>
									</xsl:if>
								</AX_K_LBEZ_Lagebezeichnung>
							</xsl:for-each>
							<!-- Pseudonummernkennzeichen -->
							<xsl:for-each select="document('E1.xml')//adv:AX_LagebezeichnungMitPseudonummer[@gml:id=substring-after($gebaeude/adv:hat/@xlink:href,'urn:adv:oid:')]/adv:lagebezeichnung/adv:AX_Lagebezeichnung">
								<AX_K_LBEZ_Lagebezeichnung>
									<lagebezeichnung>
										<xsl:value-of select="adv:unverschluesselt"/>
									</lagebezeichnung>
									<xsl:if test="count(adv:ortsteil) > 0">
										<ortsteil>
											<xsl:value-of select="adv:ortsteil"/>
										</ortsteil>
									</xsl:if>
								</AX_K_LBEZ_Lagebezeichnung>
							</xsl:for-each>
						</lagebezeichnung>
						<xsl:for-each select="document('E2.xml')//adv:AX_Baublock/adv:baublockbezeichnung[1]">
							<baublockbezeichnung>
								<xsl:value-of select="."/>
							</baublockbezeichnung>
						</xsl:for-each>
					</AX_K_LBH>
				 </flurstueck>
			</xsl:for-each>
		</AX_Gebaeudenachweis>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
