/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CodelistRegister
implements Target {
    public static final int TARGET_CLREGISTER = 0;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean diagnosticsOnly = false;
    private boolean printed = false;
    private boolean enums = true;
    private boolean initialised = false;
    private String baseURI = "http://example.com/fixme/";
    private String identifier = "name";
    private String names = "alias,initialValue";
    private final HashMap<String, Document> documentMap = new HashMap();
    private Document rootDocument = null;

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        if (!this.initialised) {
            this.initialised = true;
            String s = this.options.parameter(this.getClass().getName(), "enumerations");
            if (s != null && s.equalsIgnoreCase("false")) {
                this.enums = false;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "baseURI")) != null && !s.isEmpty()) {
                this.baseURI = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "identifier")) != null && !s.isEmpty()) {
                this.identifier = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "names")) != null && !s.isEmpty()) {
                this.names = s;
            }
            this.rootDocument = this.createDocument();
            Element ec = this.rootDocument.createElementNS(this.options.GML_NS, "Dictionary");
            this.rootDocument.appendChild(ec);
            this.addAttribute(this.rootDocument, ec, "xmlns:gml", this.options.GML_NS);
            this.addAttribute(this.rootDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.addAttribute(this.rootDocument, ec, "xsi:schemaLocation", this.options.GML_NS + " " + this.options.schemaLocationOfNamespace(this.options.GML_NS));
            this.addAttribute(this.rootDocument, ec, "gml:id", "root");
            s = this.options.parameter(this.getClass().getName(), "description");
            if (s != null && !s.isEmpty()) {
                Element e1 = this.rootDocument.createElementNS(this.options.GML_NS, "description");
                e1.appendChild(this.rootDocument.createTextNode(s));
                ec.appendChild(e1);
            }
        }
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    public void process(ClassInfo ci) {
        Element e1;
        String[] sa;
        int cat = ci.category();
        if (!(cat == 2 || this.enums && cat == 3)) {
            return;
        }
        Document cDocument = this.createDocument();
        Element ec = cDocument.createElementNS(this.options.GML_NS, "Dictionary");
        cDocument.appendChild(ec);
        this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addAttribute(cDocument, ec, "xsi:schemaLocation", this.options.GML_NS + " " + this.options.schemaLocationOfNamespace(this.options.GML_NS));
        this.addAttribute(cDocument, ec, "gml:id", ci.qname().replace(":", ""));
        this.documentMap.put(ci.id(), cDocument);
        String s = ci.documentation();
        if (s != null) {
            Element e12 = cDocument.createElementNS(this.options.GML_NS, "description");
            e12.appendChild(cDocument.createTextNode(s));
            ec.appendChild(e12);
        }
        for (String s0 : sa = this.identifier.split(",")) {
            s = this.getValue(ci, s0.trim());
            if (s == null || s.isEmpty()) continue;
            if (this.options.gmlVersion.equals("3.2")) {
                e1 = cDocument.createElementNS(this.options.GML_NS, "identifier");
                this.addAttribute(cDocument, e1, "codeSpace", this.baseURI);
                e1.appendChild(cDocument.createTextNode(this.baseURI + "/" + s));
                ec.appendChild(e1);
                break;
            }
            if (!this.options.gmlVersion.equals("3.1")) break;
            e1 = cDocument.createElementNS(this.options.GML_NS, "name");
            e1.appendChild(cDocument.createTextNode(this.baseURI + "/" + s));
            ec.appendChild(e1);
            break;
        }
        for (String s0 : sa = this.names.split(",")) {
            s = this.getValue(ci, s0);
            if (s == null || s.isEmpty()) continue;
            e1 = cDocument.createElementNS(this.options.GML_NS, "name");
            e1.appendChild(cDocument.createTextNode(s));
            ec.appendChild(e1);
        }
        for (PropertyInfo propi : ci.properties().values()) {
            Element e13 = this.createEntry(cDocument, ci, propi, true);
            if (e13 == null) continue;
            ec.appendChild(e13);
        }
        HashSet<String> ts = ci.supertypes();
        Iterator<String> i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.model.classById(i.next());
            if (cix == null) continue;
            for (PropertyInfo propi : cix.properties().values()) {
                Element e14 = this.createEntry(cDocument, ci, propi, true);
                if (e14 == null) continue;
                ec.appendChild(e14);
            }
        }
    }

    private Element createEntry(Document lDocument, ClassInfo ci, PropertyInfo propi, boolean local) {
        String[] sa;
        Element e2;
        Element e = lDocument.createElementNS(this.options.GML_NS, "dictionaryEntry");
        Element e3 = lDocument.createElementNS(this.options.GML_NS, "Definition");
        this.addAttribute(lDocument, e3, "gml:id", "_" + propi.id());
        e.appendChild(e3);
        String s = propi.documentation();
        if (s != null) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "description");
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
        }
        e2 = this.options.gmlVersion.equals("3.2") ? lDocument.createElementNS(this.options.GML_NS, "identifier") : lDocument.createElementNS(this.options.GML_NS, "name");
        String codeSpace = ci.taggedValue("codeList");
        if (codeSpace == null) {
            codeSpace = ci.taggedValue("infoURL");
        }
        if (codeSpace == null) {
            codeSpace = ci.pkg().targetNamespace() + "/" + ci.name();
        }
        this.addAttribute(lDocument, e2, "codeSpace", codeSpace);
        for (String s0 : sa = this.identifier.split(",")) {
            s = this.getValue(propi, s0.trim());
            if (s == null || s.isEmpty()) continue;
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
            break;
        }
        for (String s0 : sa = this.names.split(",")) {
            s = this.getValue(propi, s0);
            if (s == null || s.isEmpty()) continue;
            Element e1 = lDocument.createElementNS(this.options.GML_NS, "name");
            e1.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e1);
        }
        return e;
    }

    private String getValue(Info i, String source) {
        String s = null;
        if (source.equalsIgnoreCase("name")) {
            s = i.name();
        } else if (source.equalsIgnoreCase("alias")) {
            s = i.aliasName();
        } else if (source.equalsIgnoreCase("id")) {
            s = i.id();
        } else if (source.equalsIgnoreCase("initialValue") && i instanceof PropertyInfo) {
            s = ((PropertyInfo)i).initialValue();
        } else if (source.startsWith("@")) {
            s = i.taggedValue(source.substring(1));
        }
        if (s != null && s.isEmpty()) {
            s = null;
        }
        return s;
    }

    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        try {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (ClassInfo ci : this.model.classes(this.pi)) {
                File outDir;
                Document cDocument = this.documentMap.get(ci.id());
                if (cDocument == null) continue;
                String dir = this.options.parameter(this.getClass().getName(), "outputDirectory");
                if (dir == null) {
                    dir = this.options.parameter("outputDirectory");
                }
                if (dir == null) {
                    dir = this.options.parameter(".");
                }
                if (!(outDir = new File(dir)).exists()) {
                    outDir.mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(dir + "/" + ci.name() + ".xml");
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)cDocument);
                outputXML.close();
                this.result.addResult(this.getTargetID(), dir, ci.name() + ".xml", ci.qname());
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    public int getTargetID() {
        return 0;
    }
}

