/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.OclConstraint;
import de.interactive_instruments.ShapeChange.OclParser;
import de.interactive_instruments.ShapeChange.OperationInfo;
import de.interactive_instruments.ShapeChange.OperationInfoXmi10;
import de.interactive_instruments.ShapeChange.PackageInfo;
import de.interactive_instruments.ShapeChange.PropertyInfo;
import de.interactive_instruments.ShapeChange.PropertyInfoXmi10;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeIgnoreClassException;
import de.interactive_instruments.ShapeChange.Xmi10Document;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import org.w3c.dom.Element;

public class ClassInfoXmi10
implements ClassInfo {
    protected String id;
    protected Element cla;
    protected Xmi10Document doc;
    protected UUID uuid;
    protected int category = -1;
    protected int processed = 0;
    protected TreeMap<Integer, PropertyInfo> properties = null;
    protected boolean processedRestrictions = false;
    protected boolean hasNilReason = false;
    public TreeMap<Integer, OperationInfo> operations;
    private boolean createdConstraints = false;
    private final Vector<OclConstraint> constraints = new Vector();

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String[] parts;
        String s = this.doc.textOfProperty(this.cla, "Foundation.Core.ModelElement.name");
        if (s == null) {
            s = this.id();
            this.doc.result.addWarning(102, s);
        } else {
            s = s.trim();
        }
        if (s.indexOf("[") > 0 && (s.endsWith("]") || s.endsWith("}"))) {
            parts = s.split("\\[");
            s = parts[0].trim();
        }
        if (s.indexOf("{") > 0 && s.endsWith("}")) {
            parts = s.split("\\{");
            s = parts[0].trim();
        }
        return s;
    }

    protected Multiplicity roseHiddenCardinality() {
        String s = this.doc.textOfProperty(this.cla, "Foundation.Core.ModelElement.name");
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).indexOf("[") > 0 && s.indexOf("]") > 0) {
            String[] parts = s.split("\\[");
            s = parts[1].trim();
            String[] parts2 = s.split("\\]");
            s = parts2[0].trim();
            return this.doc.cardinalityFromString(s);
        }
        return null;
    }

    protected String roseHiddenLabels() {
        String s = this.doc.textOfProperty(this.cla, "Foundation.Core.ModelElement.name");
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).indexOf("{") > 0 && s.endsWith("}")) {
            String[] parts = s.split("\\{");
            s = parts[1].substring(0, parts[1].length() - 1).trim();
            return s;
        }
        return null;
    }

    @Override
    public String qname() {
        return String.valueOf(this.pkg().xmlns()) + ":" + this.name();
    }

    public String nsabr() {
        return this.pkg().xmlns();
    }

    public String ns() {
        return this.pkg().targetNamespace();
    }

    @Override
    public String documentation() {
        return this.doc.taggedValue(this.id, "documentation");
    }

    @Override
    public String encodingRule(String platform) {
        String s = this.doc.taggedValue(this.id, String.valueOf(platform) + "EncodingRule");
        if (s == null) {
            s = this.pkg().encodingRule(platform);
        }
        return s;
    }

    @Override
    public String xmlSchemaType() {
        return this.doc.taggedValue(this.id, "xmlSchemaType");
    }

    @Override
    public boolean includePropertyType() {
        String s = this.doc.taggedValue(this.id, "noPropertyType");
        return s == null || !s.toLowerCase().equals("true");
    }

    @Override
    public boolean includeByValuePropertyType() {
        String s = this.doc.taggedValue(this.id, "byValuePropertyType");
        return s != null && s.toLowerCase().equals("true");
    }

    @Override
    public boolean isCollection() {
        String s = this.doc.taggedValue(this.id, "isCollection");
        return s != null && s.toLowerCase().equals("true");
    }

    @Override
    public boolean asDictionary() {
        String s = this.doc.taggedValue(this.id, "asDictionary");
        return s != null && s.toLowerCase().equals("true");
    }

    @Override
    public boolean asGroup() {
        String s = this.doc.taggedValue(this.id, "gmlAsGroup");
        return s != null && s.toLowerCase().equals("true");
    }

    @Override
    public boolean noGMLType() {
        String s = this.doc.taggedValue(this.id, "noGMLType");
        if (s != null && s.toLowerCase().equals("true")) {
            return true;
        }
        if (s != null && s.toLowerCase().equals("false")) {
            return false;
        }
        return this.doc.options.noGMLtypeDefault;
    }

    @Override
    public boolean isAbstract() {
        return this.doc.attributeOfProperty(this.cla, "Foundation.Core.GeneralizableElement.isAbstract", "xmi.value").equals("true");
    }

    @Override
    public boolean isLeaf() {
        return this.doc.attributeOfProperty(this.cla, "Foundation.Core.GeneralizableElement.isLeaf", "xmi.value").equals("true");
    }

    @Override
    public PackageInfo pkg() {
        PackageInfo pkg;
        String propId = this.doc.idOfProperty(this.cla, "Foundation.Core.ModelElement.namespace");
        if (propId.length() == 0) {
            propId = this.doc.getOwnerIdAsString(this.cla);
        }
        if ((pkg = this.doc.fPackages.get(propId)) == null) {
            this.doc.result.addInfo("Class " + this.name() + " with ID " + this.id + " cannot be identified as being part of any package. The package is probably ignored, for example, because it carries an unsupported stereotype. The ID of the missing package is: " + propId);
        }
        return pkg;
    }

    @Override
    public String stereotype() {
        String s;
        String stereotype = this.doc.fStereotypes.get(this.id);
        if (stereotype == null) {
            stereotype = "";
        }
        if ((s = this.doc.options.stereotypeAlias(stereotype)) != null) {
            stereotype = s;
        }
        return stereotype;
    }

    @Override
    public HashSet<String> supertypes() {
        return this.doc.fSupertypes.get(this.id);
    }

    @Override
    public HashSet<String> subtypes() {
        return this.doc.fSubtypes.get(this.id);
    }

    @Override
    public int category() {
        return this.category;
    }

    @Override
    public void category(int c) {
        this.category = c;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] tags = tagList.split("\\,");
        int i = 0;
        while (i < tags.length) {
            String s = this.doc.taggedValue(this.id(), tags[i].trim());
            if (s != null) {
                ret.put(tags[i].trim(), s);
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean hasNilReason() {
        return this.hasNilReason;
    }

    @Override
    public boolean checkSupertypes(int cat) {
        boolean res = true;
        HashSet<String> ts = this.supertypes();
        if (ts == null) {
            this.doc.result.addDebug("Checked class " + this.name() + ", category " + cat + ", result " + res);
            return res;
        }
        Iterator<String> i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.doc.classById(i.next());
            if (cix == null) continue;
            this.doc.result.addDebug("  ... " + cix.name() + ", cat " + cix.category());
            if (cix.category() == -1) {
                res = res && cix.checkSupertypes(cat);
            } else if (cix.category() != 4 && cix.category() != cat) {
                res = false;
            }
            if (res) continue;
            this.doc.result.addDebug("Checked class " + this.name() + ", category " + cat + ", result " + res);
            return res;
        }
        this.doc.result.addDebug("Checked class " + this.name() + ", category " + cat + ", result " + res);
        return res;
    }

    @Override
    public void fixIfCategoryIsUnknown() {
        if (this.category() == -1) {
            if (this.isAbstract() && this.checkSupertypes(4)) {
                this.category(4);
            } else if (this.checkSupertypes(6)) {
                this.category(6);
            } else if (this.checkSupertypes(1)) {
                this.category(1);
            } else if (this.checkSupertypes(5)) {
                this.category(5);
            } else {
                this.doc.result.addError("The supertypes of class " + this.name() + " are of different categories. This is not supported, the class is ignored.");
            }
        }
    }

    protected void checkOverloading(ClassInfo cicurr) {
        HashSet<String> st;
        if (cicurr == null) {
            return;
        }
        this.doc.result.addDebug("Checking overloading. Class = " + this.name() + "; current class = " + cicurr.name() + ".");
        if (cicurr != this && (cicurr.category() == 1 || cicurr.category() == 6 || cicurr.category() == 5 || cicurr.category() == 8 && !cicurr.asGroup())) {
            for (PropertyInfo aicurr : cicurr.properties().values()) {
                for (PropertyInfo ai : this.properties().values()) {
                    if (aicurr == null || ai == null || !ai.name().equals(aicurr.name())) continue;
                    if (ai.cardinality().minOccurs < aicurr.cardinality().minOccurs) {
                        this.doc.result.addError("The restriction of UML attribute " + ai.name() + " in class " + this.name() + " is not legal. The lower multiplicity limit is smaller than in the supertype " + cicurr.name() + ".");
                    }
                    if (ai.cardinality().maxOccurs > aicurr.cardinality().maxOccurs) {
                        this.doc.result.addError("The restriction of UML attribute " + ai.name() + " in class " + this.name() + " is not legal. The upper multiplicity limit is higher than in the supertype " + cicurr.name() + ".");
                    }
                    ai.restriction(true);
                    this.doc.result.addInfo("Restriction of property " + ai.name() + " in class " + this.name() + " from supertype " + cicurr.name() + ".");
                }
            }
        }
        if ((st = cicurr.supertypes()) != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                this.checkOverloading(this.doc.classById(i.next()));
            }
        }
    }

    protected void identifyRestrictions() {
        if (this.processedRestrictions) {
            return;
        }
        if (this.category() == 1 || this.category() == 6 || this.category() == 5 || this.category() == 8 && !this.asGroup()) {
            this.checkOverloading(this);
        }
        this.processedRestrictions = true;
    }

    @Override
    public TreeMap<Integer, PropertyInfo> properties() {
        return this.properties;
    }

    @Override
    public PropertyInfo property(String name) {
        for (PropertyInfo pi : this.properties.values()) {
            if (pi == null || !pi.name().equals(name)) continue;
            return pi;
        }
        HashSet<String> st = this.supertypes();
        if (st != null) {
            Iterator<String> j = st.iterator();
            while (j.hasNext()) {
                PropertyInfo pi;
                ClassInfo ci = this.doc.classById(j.next());
                if (ci == null || (pi = ci.property(name)) == null) continue;
                return pi;
            }
        }
        return null;
    }

    public ClassInfoXmi10(Xmi10Document d, Element e) throws ShapeChangeAbortException, ShapeChangeIgnoreClassException {
        PropertyInfo piTemp;
        String s;
        this.cla = e;
        this.doc = d;
        this.id = this.cla.getAttribute("xmi.id");
        this.uuid = UUID.randomUUID();
        if (this.cla.getNodeName().equals("Foundation.Core.DataType")) {
            this.category = this.doc.isOwnerOfEnumeration(this.cla) ? 3 : 5;
        } else if (this.cla.getNodeName().equals("Foundation.Core.Interface")) {
            this.category = 10;
        } else if (this.cla.getNodeName().equals("Foundation.Core.Class")) {
            s = this.stereotype().toLowerCase();
            if (s.equals("enumeration")) {
                this.category = 3;
            } else if (s.equals("codelist")) {
                this.category = 2;
            } else if (s.equals("datatype")) {
                this.category = 5;
            } else if (s.equals("union")) {
                this.category = 8;
            } else if (s.equals("interface")) {
                this.category = 10;
            } else if (s.equals("basictype")) {
                this.category = 7;
            } else if (s.equals("featuretype")) {
                this.category = 1;
            } else if (s.equals("objecttype") || s.equals("")) {
                this.category = 6;
            }
        } else {
            s = this.stereotype().toLowerCase();
            if (!s.equals("") && !s.equals("type")) {
                this.doc.result.addFatalError("System error. Stereotype of class " + this.name() + " is not an allowed value: " + this.stereotype());
                throw new ShapeChangeAbortException();
            }
            this.category = !this.isAbstract() ? 6 : -1;
        }
        this.properties = new TreeMap();
        Vector<String> attids = this.doc.idsOfProperty(this.cla, "Foundation.Core.Classifier.feature");
        attids.addAll(this.doc.idsOfProperty(this.cla, "Foundation.Core.Enumeration.literal"));
        Iterator<String> i = attids.iterator();
        while (i.hasNext()) {
            Element att = this.doc.getElementById(i.next());
            if (!att.getNodeName().equals("Foundation.Core.Attribute") && !att.getNodeName().equals("Foundation.Core.EnumerationLiteral") || !this.doc.visible(att) || !this.doc.notAReference(att)) continue;
            PropertyInfoXmi10 atti = new PropertyInfoXmi10(this.doc, att, true);
            atti.inClass(this);
            piTemp = this.properties.get(atti.sequenceNumber());
            if (piTemp != null) {
                this.doc.result.addError("The attribute " + atti.name() + " has a sequence number that is already in use for another attribute or association role (" + piTemp.name() + "). That property will be overwritten.");
            }
            this.properties.put(atti.sequenceNumber(), atti);
            if (!atti.implementedByNilReason()) continue;
            this.hasNilReason = true;
        }
        Vector<PropertyInfo> roles = this.doc.fRoles.get(this.id);
        if (roles != null) {
            for (PropertyInfo ri : roles) {
                ((PropertyInfoXmi10)ri).inClass(this);
                piTemp = this.properties.get(ri.sequenceNumber());
                if (piTemp != null) {
                    this.doc.result.addError("The role " + ri.name() + " has a sequence number that is already in use for another attribute or assocation role (" + piTemp.name() + ") which will be overwritten.");
                }
                this.properties.put(ri.sequenceNumber(), ri);
                if (!ri.implementedByNilReason()) continue;
                this.hasNilReason = true;
            }
        }
        Vector<String> opids = this.doc.idsOfProperty(this.cla, "Foundation.Core.Classifier.feature");
        this.operations = new TreeMap();
        Iterator<String> i2 = opids.iterator();
        while (i2.hasNext()) {
            Element e1 = this.doc.getElementById(i2.next());
            if (!e1.getNodeName().equals("Foundation.Core.Operation") || !this.doc.visible(e1) || !this.doc.notAReference(e1)) continue;
            OperationInfoXmi10 opi = new OperationInfoXmi10(this.doc, e1);
            this.operations.put(this.doc.globalSequenceNumber++, opi);
        }
        if (this.category == 8 && this.encodingRule("xsd").equals("iso19136_2007") && this.hasNilReason() && this.properties.size() == 2) {
            this.category = 9;
        }
    }

    @Override
    public ClassInfo baseClass() {
        int stsize = 0;
        ClassInfo cir = null;
        int cat = this.category();
        if (cat == 1 || cat == 6 || cat == 5 || cat == 4 || cat == 8) {
            HashSet<String> st = this.supertypes();
            if (st != null) {
                for (String sid : st) {
                    ClassInfo cix = this.doc.fClasses.get(sid);
                    if (cix != null) {
                        if (cat == cix.category() && cix.category() != 4) {
                            ++stsize;
                            cir = cix;
                            continue;
                        }
                        if (cix.category() == 4) continue;
                        this.doc.result.addError("The class " + this.name() + " is modelled as a feature or data type, but has at least one supertype of a different category. The supertype is ignored.");
                        continue;
                    }
                    ++stsize;
                    cir = cix;
                }
            }
            if (stsize > 1) {
                this.doc.result.addError("The class " + this.name() + " is modelled as a feature or data type, but has more than one supertype of the same kind. All but one (arbitrary) supertypes are ignored.");
            }
        }
        return cir;
    }

    @Override
    public boolean inSchema(PackageInfo pi) {
        String ns1 = this.pkg().targetNamespace();
        String ns2 = pi.targetNamespace();
        if (ns1 == null || ns2 == null) {
            return false;
        }
        return ns1.equals(ns2);
    }

    @Override
    public boolean processed(int t) {
        return (this.processed & t) == t;
    }

    @Override
    public void processed(int t, boolean p) {
        this.processed = p ? (this.processed |= t) : (this.processed &= ~t);
    }

    @Override
    public Vector<OclConstraint> constraints() {
        if (this.createdConstraints) {
            return this.constraints;
        }
        String tv = this.doc.taggedValue(this.id, "oclExpressions");
        if (tv != null) {
            OclParser parser = new OclParser(this.doc, this.doc.result);
            String[] expList = tv.split("inv:");
            int i = 0;
            while (i < expList.length) {
                OclConstraint c;
                String s = expList[i].trim();
                if (s != null && !s.equals("") && (c = parser.constraint(s, this)) != null) {
                    this.constraints.add(c);
                }
                ++i;
            }
        }
        this.createdConstraints = true;
        return this.constraints;
    }
}

