<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1 -->
<!-- Suchbegriffe -->
<!-- Mit Überhakenflurstück testen, ob dies so funktioniert. -->

<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('E1.xml')//adv:AX_Flurstueck/adv:position/*"/><!-- Hier auf E1.xml bezogen statt wie zuvor bezugslos. -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<xsl:choose>
					<xsl:when test="count(document('E1.xml')//adv:AX_Flurstueck/adv:position/*/*)>1"><!-- Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. -->
				<!-- Selektion der relevanten öffentlich-rechtlichen Festlegungen -->
						<wfs:Query typeName="AX_KlassifizierungNachStrassenrecht">
							<ogc:Filter>
								<ogc:Or><!-- Hier or, weil es reicht, daß eine der Teilflächen schneidet. -->
									<xsl:for-each select="$p3/*"> <!-- Mit Überhakenflurstück testen, ob dies so funktioniert. -->
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/><!-- Hier statt value-of copy-of wie auch bei allen weiteren... -->
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_KlassifizierungNachWasserrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Schutzzone">
							<XlinkPropertyPath>istTeilVon</XlinkPropertyPath>
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Denkmalschutzrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_AndereFestlegungNachStrassenrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_BauRaumOderBodenordnungsrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_NaturUmweltOderBodenschutzrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_AndereFestlegungNachWasserrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Forstrecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_SonstigesRecht">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
					</xsl:when>
					<xsl:otherwise>
								<!-- Selektion der relevanten öffentlich-rechtlichen Festlegungen -->
						<wfs:Query typeName="AX_KlassifizierungNachStrassenrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/><!-- Hier statt value-of copy-of wie auch bei allen weiteren... -->
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_KlassifizierungNachWasserrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Schutzzone">
							<XlinkPropertyPath>istTeilVon</XlinkPropertyPath>
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Denkmalschutzrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_AndereFestlegungNachStrassenrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_BauRaumOderBodenordnungsrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_NaturUmweltOderBodenschutzrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_AndereFestlegungNachWasserrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Forstrecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_SonstigesRecht">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
					</xsl:otherwise>
				</xsl:choose>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
