<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->	
	<!-- =========================================================== -->
	<!-- Keys zur Gruppierung über die Klassifizierungen auf RegBez -->
	<xsl:key name="BEWFL_klassifizierungOBG" match="//flaecheOBGRBez/AX_K_BEWFL/klassifizierungOBG" use="."/>
	<xsl:key name="BEWGR_klassifizierungOBG" match="//flaechensummeHGrRBez/AX_K_BEWGR/klassifizierungGr" use="."/>
	<!-- =========================================================== -->
	<!-- Summierung von Flächenwerten für gleichen Klassifizierungswert und Bildung neuer Blöcke -->
	<xsl:template name="flaechensumme">
		<xsl:param name="nodes"/>	
		<xsl:param name="key"/>	
		<xsl:param name="attr"/>
		<xsl:param name="elem1"/>	
		<xsl:param name="elem2"/>	
		<xsl:param name="gebiet"/>	
		<!-- Summenbildung über eindeutige Klassifizierungswerte -->	
		<xsl:variable name="unique" select="$nodes/{$attr}[count(.|key($key,.)[1]) = 1]"/>
		<xsl:for-each select="$unique">
			<xsl:sort select="."/>
			<xsl:element name="$elem1">
				<xsl:element name="$elem2">
					<gebiet>
						<xsl:value-of select="$gebiet"/>
					</gebiet>
					<funktionOA>
						<xsl:value-of select="."/>
					</funktionOA>
					<flaeche>
						<xsl:variable name="val" select="."/>
						<xsl:value-of select="sum($nodes/{$attr}[. = $val]/../adv:flaeche)"/>
					</flaeche>
				</xsl:element>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="naechsteSumme">	
		<!-- Summenbildung für Land über RegBez -->
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaecheOBGRBez/adv:AX_K_BEWFL[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'BEWFL_klassifizierungOBG'"/>
				<xsl:with-param name="attr"   select="'adv:klassifizierungOBG'"/>	
				<xsl:with-param name="elem1"  select="'flaecheOBGLand'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_BEWFL'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaechensummeHGrRBez/adv:AX_K_BEWGR[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'BEWGR_klassifizierungGr'"/>
				<xsl:with-param name="attr"   select="'adv:klassifizierungGr'"/>	
				<xsl:with-param name="elem1"  select="'flaechensummeHGrLand'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_BEWGR'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<flaecheKlassLand>
				<xsl:value-of select="sum(//adv:flaecheKlassRBez/adv:AX_K_FLASU[starts-with(adv:gebiet,$schluessel)]/adv:flaechensumme)"/>
			</flaecheKlassLand>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<gesamtflaecheLand>
				<xsl:value-of select="sum(//adv:gesamtflaecheRBez/adv:AX_K_FLASU[starts-with(adv:gebiet,$schluessel)]/adv:flaechensumme)"/>
			</gesamtflaecheLand>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:choose>
			<xsl:when test="$anlassart = '2210' or $anlassart = '2220' or $anlassart = '2221' or $anlassart = '2230' or $anlassart = '2231' or $anlassart = '2240' or $anlassart = '2241'">
				<!-- nur Regierungsbezirk-, KreisRegion-, Gemeinde- und/oder Gemarkungsstatistik:  somit hat der vorhergehende Schritt das Endergebnis ermittelt -->
				<xsl:copy-of select="document('A6_Statistik_Regierungsbezirk.xml)/."/>
			</xsl:when>
			<xsl:otherwise>
				<!-- sonst: Muss die vorhergehende Statistik (Regierungsbezirk-Statistik) gelöscht werden? -->
				<xsl:variable name="clear">
					<xsl:choose>
						<xsl:when test="$anlassart = '2251'">
							<!-- komplette Statistik: Regierungsbezirk-Statistik nicht löschen -->
							<xsl:value-of select="''"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- nur höchste Statistik: Regierungsbezirk-Statistik löschen -->
							<xsl:value-of select="'flaecheOBGRBez,flaechensummeHGrRBez,flaechenKlasseRBez,gesamtFlaecheRBez'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
					<!-- Teile vom vorhergehenden Ergebnis kopieren, ggf. Regierungsbezirk-Statistik löschen -->
					<xsl:for-each select="document('A6_Statistik_Regierungsbezirk.xml)/*/*">
						<xsl:if test="not(contains($clear,name(.)))">
							<xsl:copy-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<!-- Bundesland-Statistik über Aggregation der Regierungsbezirk-Statistik bilden -->
					<xsl:call-template name="naechsteSumme"/>
				</AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
